/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.vna;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFactory;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class MergeTree {
    public static final boolean DEBUG = SystemProperties.getBoolean("vna.merge.debug");
    private final ValueNumberFactory factory;
    private final Map<ValueNumber, BitSet> outputToInputMap;

    public MergeTree(ValueNumberFactory factory) {
        this.factory = factory;
        this.outputToInputMap = new HashMap<ValueNumber, BitSet>();
    }

    public void mapInputToOutput(ValueNumber input, ValueNumber output) {
        BitSet inputSet = this.getInputSet(output);
        inputSet.set(input.getNumber());
        if (DEBUG) {
            System.out.println(input.getNumber() + "->" + output.getNumber());
            System.out.println("Input set for " + output.getNumber() + " is now " + inputSet);
        }
    }

    public BitSet getInputSet(ValueNumber output) {
        BitSet outputSet = this.outputToInputMap.get(output);
        if (outputSet == null) {
            if (DEBUG) {
                System.out.println("Create new input set for " + output.getNumber());
            }
            outputSet = new BitSet();
            this.outputToInputMap.put(output, outputSet);
        }
        return outputSet;
    }

    public BitSet getTransitiveInputSet(ValueNumber output) {
        BitSet visited = new BitSet();
        BitSet result = new BitSet();
        if (DEBUG) {
            System.out.println("Output: " + output.getNumber());
        }
        LinkedList<ValueNumber> workList = new LinkedList<ValueNumber>();
        workList.addLast(output);
        while (!workList.isEmpty()) {
            ValueNumber valueNumber = (ValueNumber)workList.removeFirst();
            if (DEBUG) {
                System.out.println("Check: " + valueNumber.getNumber());
            }
            visited.set(valueNumber.getNumber());
            BitSet inputSet = this.getInputSet(valueNumber);
            if (DEBUG) {
                System.out.println("\tInput set is " + inputSet);
            }
            result.or(inputSet);
            int i = inputSet.nextSetBit(0);
            while (i >= 0) {
                if (!visited.get(i)) {
                    if (DEBUG) {
                        System.out.println("\tExplore: " + i);
                    }
                    workList.addLast(this.factory.forNumber(i));
                }
                i = inputSet.nextSetBit(i + 1);
            }
        }
        if (DEBUG) {
            System.out.println("Result: " + result);
        }
        return result;
    }

    public BitSet getTransitiveOutputSet(int input) {
        BitSet visited = new BitSet();
        BitSet result = new BitSet();
        LinkedList<Integer> workList = new LinkedList<Integer>();
        workList.addLast(input);
        while (!workList.isEmpty()) {
            Integer valueNumber = (Integer)workList.removeFirst();
            visited.set(valueNumber);
            BitSet outputSet = this.getOutputSet(valueNumber);
            result.or(outputSet);
            int i = outputSet.nextSetBit(0);
            while (i >= 0) {
                if (!visited.get(i)) {
                    workList.addLast(i);
                }
                i = outputSet.nextSetBit(i + 1);
            }
        }
        return result;
    }

    private BitSet getOutputSet(int valueNumber) {
        BitSet result = new BitSet();
        for (Map.Entry<ValueNumber, BitSet> entry : this.outputToInputMap.entrySet()) {
            if (!entry.getValue().get(valueNumber)) continue;
            result.set(entry.getKey().getNumber());
        }
        return result;
    }
}

