/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.obl;

import edu.umd.cs.findbugs.ba.Path;
import edu.umd.cs.findbugs.ba.obl.Obligation;
import edu.umd.cs.findbugs.ba.obl.ObligationAcquiredOrReleasedInLoopException;
import edu.umd.cs.findbugs.ba.obl.ObligationFactory;
import edu.umd.cs.findbugs.ba.obl.ObligationSet;
import edu.umd.cs.findbugs.ba.obl.State;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StateSet {
    private boolean isTop = false;
    private boolean isBottom = false;
    private boolean onExceptionPath;
    private Map<ObligationSet, State> stateMap = new HashMap<ObligationSet, State>();
    private final ObligationFactory factory;

    public boolean isEmpty() {
        return this.stateMap.isEmpty();
    }

    public StateSet(ObligationFactory factory) {
        this.factory = factory;
    }

    public void setTop() {
        this.isTop = true;
        this.isBottom = false;
        this.onExceptionPath = false;
        this.stateMap.clear();
    }

    public boolean isTop() {
        return this.isTop;
    }

    public void setBottom() {
        this.isBottom = true;
        this.isTop = false;
    }

    public boolean isBottom() {
        return this.isBottom;
    }

    public boolean isValid() {
        return !this.isTop && !this.isBottom;
    }

    public boolean isOnExceptionPath() {
        return this.onExceptionPath;
    }

    public void setOnExceptionPath(boolean onExceptionPath) {
        this.onExceptionPath = onExceptionPath;
    }

    public void clear() {
        this.onExceptionPath = false;
        this.isBottom = false;
        this.isTop = false;
        this.stateMap.clear();
    }

    public Iterator<State> stateIterator() {
        return this.stateMap.values().iterator();
    }

    public Set<ObligationSet> getAllObligationSets() {
        return Collections.unmodifiableSet(this.stateMap.keySet());
    }

    public State getStateWithObligationSet(ObligationSet obligationSet) {
        return this.stateMap.get(obligationSet);
    }

    public void copyFrom(StateSet other) {
        this.isTop = other.isTop;
        this.isBottom = other.isBottom;
        this.onExceptionPath = other.onExceptionPath;
        this.stateMap.clear();
        for (State state : other.stateMap.values()) {
            State dup = state.duplicate();
            this.stateMap.put(dup.getObligationSet(), dup);
        }
    }

    public StateSet duplicate() {
        StateSet dup = new StateSet(this.factory);
        dup.copyFrom(this);
        return dup;
    }

    public void addObligation(Obligation obligation, int basicBlockId) throws ObligationAcquiredOrReleasedInLoopException {
        HashMap<ObligationSet, State> updatedStateMap = new HashMap<ObligationSet, State>();
        if (this.stateMap.isEmpty()) {
            State s = new State(this.factory);
            s.getObligationSet().add(obligation);
            updatedStateMap.put(s.getObligationSet(), s);
        } else {
            for (State state : this.stateMap.values()) {
                this.checkCircularity(state, obligation, basicBlockId);
                state.getObligationSet().add(obligation);
                updatedStateMap.put(state.getObligationSet(), state);
            }
        }
        this.replaceMap(updatedStateMap);
    }

    public void deleteObligation(Obligation obligation, int basicBlockId) throws ObligationAcquiredOrReleasedInLoopException {
        HashMap<ObligationSet, State> updatedStateMap = new HashMap<ObligationSet, State>();
        Iterator<State> i = this.stateIterator();
        while (i.hasNext()) {
            State state = i.next();
            this.checkCircularity(state, obligation, basicBlockId);
            ObligationSet obligationSet = state.getObligationSet();
            obligationSet.remove(obligation);
            if (obligationSet.isEmpty()) continue;
            updatedStateMap.put(obligationSet, state);
        }
        this.replaceMap(updatedStateMap);
    }

    private void checkCircularity(State state, Obligation obligation, int basicBlockId) throws ObligationAcquiredOrReleasedInLoopException {
        if (state.getPath().hasComponent(basicBlockId)) {
            throw new ObligationAcquiredOrReleasedInLoopException(obligation);
        }
    }

    public void replaceMap(Map<ObligationSet, State> stateMap) {
        this.stateMap = stateMap;
    }

    public List<State> getPrefixStates(Path path) {
        LinkedList<State> result = new LinkedList<State>();
        for (State state : this.stateMap.values()) {
            if (!state.getPath().isPrefixOf(path)) continue;
            result.add(state);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        StateSet other = (StateSet)o;
        return this.isTop == other.isTop && this.isBottom == other.isBottom && this.onExceptionPath == other.onExceptionPath && this.stateMap.equals(other.stateMap);
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        if (this.isTop) {
            return "TOP";
        }
        if (this.isBottom) {
            return "BOTTOM";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(this.stateMap);
        if (this.onExceptionPath) {
            buf.append(" On exception path");
        }
        return buf.toString();
    }

    public Map<ObligationSet, State> createEmptyMap() {
        return new HashMap<ObligationSet, State>();
    }
}

