/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.ReverseDepthFirstSearch;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.jsr305.BackwardTypeQualifierDataflow;
import edu.umd.cs.findbugs.ba.jsr305.BackwardTypeQualifierDataflowAnalysis;
import edu.umd.cs.findbugs.ba.jsr305.FlowValue;
import edu.umd.cs.findbugs.ba.jsr305.ForwardTypeQualifierDataflow;
import edu.umd.cs.findbugs.ba.jsr305.ForwardTypeQualifierDataflowFactory;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierAnnotation;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierApplications;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierDatabase;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierDataflowFactory;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValue;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValueSet;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysis;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import javax.annotation.meta.When;
import org.apache.bcel.generic.ConstantPoolGen;

public class BackwardTypeQualifierDataflowFactory
extends TypeQualifierDataflowFactory<BackwardTypeQualifierDataflowAnalysis, BackwardTypeQualifierDataflow> {
    public BackwardTypeQualifierDataflowFactory(MethodDescriptor methodDescriptor) {
        super(methodDescriptor);
    }

    @Override
    protected BackwardTypeQualifierDataflow getDataflow(DepthFirstSearch dfs, XMethod xmethod, CFG cfg, ValueNumberDataflow vnaDataflow, ConstantPoolGen cpg, IAnalysisCache analysisCache, MethodDescriptor methodDescriptor, TypeQualifierValue<?> typeQualifierValue) throws CheckedAnalysisException {
        ReverseDepthFirstSearch rdfs = analysisCache.getMethodAnalysis(ReverseDepthFirstSearch.class, methodDescriptor);
        BackwardTypeQualifierDataflowAnalysis analysis = new BackwardTypeQualifierDataflowAnalysis(dfs, rdfs, xmethod, cfg, vnaDataflow, cpg, typeQualifierValue);
        ForwardTypeQualifierDataflowFactory forwardFactory = analysisCache.getMethodAnalysis(ForwardTypeQualifierDataflowFactory.class, methodDescriptor);
        ForwardTypeQualifierDataflow forwardDataflow = (ForwardTypeQualifierDataflow)forwardFactory.getDataflow(typeQualifierValue);
        analysis.setForwardTypeQualifierDataflow(forwardDataflow);
        analysis.registerSourceSinkLocations();
        BackwardTypeQualifierDataflow dataflow = new BackwardTypeQualifierDataflow(cfg, analysis);
        dataflow.execute();
        if (ClassContext.DUMP_DATAFLOW_ANALYSIS) {
            dataflow.dumpDataflow(analysis);
        }
        return dataflow;
    }

    @Override
    protected void populateDatabase(BackwardTypeQualifierDataflow dataflow, ValueNumberDataflow vnaDataflow, XMethod xmethod, TypeQualifierValue<?> tqv) throws CheckedAnalysisException {
        assert (TypeQualifierDatabase.USE_DATABASE);
        if (xmethod.isIdentity()) {
            return;
        }
        BasicBlock entry = dataflow.getCFG().getEntry();
        TypeQualifierValueSet entryFact = (TypeQualifierValueSet)((BackwardTypeQualifierDataflowAnalysis)dataflow.getAnalysis()).getResultFact(entry);
        for (int i = 0; i < xmethod.getNumParams(); ++i) {
            ValueNumber paramVN;
            FlowValue paramFlowValue;
            if (TypeQualifierApplications.getEffectiveTypeQualifierAnnotation(xmethod, i, tqv) != null || (paramFlowValue = entryFact.getValue(paramVN = ((ValueNumberAnalysis)vnaDataflow.getAnalysis()).getEntryValueForParameter(i))) != FlowValue.ALWAYS && paramFlowValue != FlowValue.NEVER) continue;
            TypeQualifierDatabase tqdb = Global.getAnalysisCache().getDatabase(TypeQualifierDatabase.class);
            TypeQualifierAnnotation tqa = TypeQualifierAnnotation.getValue(tqv, paramFlowValue == FlowValue.ALWAYS ? When.ALWAYS : When.NEVER);
            tqdb.setParameter(xmethod.getMethodDescriptor(), i, tqv, tqa);
        }
    }
}

