/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.tree;

public class TreeEvent {
    public final EventType event;
    public final String nodeName;
    public final String nodeValue;

    public boolean isVisit() {
        return this.event == EventType.VISIT;
    }

    public boolean isText() {
        return this.event == EventType.TEXT;
    }

    public boolean isLeave() {
        return this.event == EventType.LEAVE;
    }

    public static TreeEvent newVisitEvent(String string, String string2) {
        return new TreeEvent(EventType.VISIT, string, string2);
    }

    public static TreeEvent newLeaveEvent(String string) {
        return new TreeEvent(EventType.LEAVE, string, null);
    }

    public static TreeEvent newTextEvent(String string, String string2) {
        return new TreeEvent(EventType.TEXT, string, string2);
    }

    public TreeEvent(EventType eventType, String string, String string2) {
        this.event = eventType;
        this.nodeName = string;
        this.nodeValue = string2;
    }

    public String toString() {
        if (this.nodeName != null) {
            if (this.nodeValue != null) {
                return String.format("%5s:%s=%s", new Object[]{this.event, this.nodeName, this.nodeValue});
            }
            return String.format("%5s:%s", new Object[]{this.event, this.nodeName});
        }
        if (this.nodeValue != null) {
            return String.format("%5s:%s", new Object[]{this.event, this.nodeValue});
        }
        return String.format("%5s", new Object[]{this.event});
    }

    public static enum EventType {
        VISIT,
        TEXT,
        LEAVE;

    }
}

