/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.xerial.core.ErrorCode;
import org.xerial.core.XerialErrorCode;
import org.xerial.core.XerialException;
import org.xerial.util.log.Logger;
import org.xerial.util.tree.TreeNode;
import org.xerial.util.tree.TreeVisitor;
import org.xerial.util.tree.TreeWalker;

public class TabSeparatedTextWalker
implements TreeWalker {
    private static Logger _logger = Logger.getLogger(TabSeparatedTextWalker.class);
    private boolean isFirstLineContainsColumnLabel = false;
    private boolean reportLineNumber = false;
    private BufferedReader reader;
    private String rootName = "root";
    private String rowName = "entry";
    private String lineAttributeName = "line";
    private final String separator;
    private int lineCount = -1;
    private ArrayList<String> columnLableList = new ArrayList();

    public TabSeparatedTextWalker(Reader reader) {
        this(reader, "\t");
    }

    public TabSeparatedTextWalker(Reader reader, String string) {
        this.reader = new BufferedReader(reader);
        this.separator = string;
    }

    public void setFirstLineAsColumnLabel(boolean bl) {
        this.isFirstLineContainsColumnLabel = bl;
    }

    public void setRowNodeName(String string) {
        this.rowName = string;
    }

    public String getRowNodeName() {
        return this.rowName;
    }

    public void setColunLabel(List<String> list) {
        this.columnLableList.clear();
        for (String string : list) {
            this.columnLableList.add(string);
        }
    }

    @Override
    public TreeNode getSubTree() throws XerialException {
        throw new UnsupportedOperationException("getSubTree()");
    }

    @Override
    public void skipDescendants() {
        throw new UnsupportedOperationException("skipDescendants()");
    }

    private String readLine() throws IOException {
        String string = this.reader.readLine();
        ++this.lineCount;
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void walk(TreeVisitor treeVisitor) throws XerialException {
        this.lineCount = -1;
        treeVisitor.init(this);
        treeVisitor.visitNode(this.rootName, null, this);
        try {
            Object object;
            if (this.isFirstLineContainsColumnLabel) {
                object = this.splitLine(this.readLine());
                int n = 1;
                for (String string : object) {
                    if (string.length() <= 0) {
                        string = "c" + n;
                        _logger.warn(String.format("column (index=%d) has no column label. Use %s instead.", n, string));
                    }
                    this.columnLableList.add(string);
                    ++n;
                }
            }
            object = this.readLine();
            while (object != null) {
                String[] stringArray = this.splitLine((String)object);
                if (stringArray != null && stringArray.length > 0) {
                    void var4_10;
                    treeVisitor.visitNode(this.rowName, null, this);
                    if (this.reportLineNumber) {
                        String i = Integer.toString(this.lineCount);
                        treeVisitor.visitNode(this.lineAttributeName, i, this);
                        treeVisitor.leaveNode(this.lineAttributeName, this);
                    }
                    boolean bl = false;
                    while (var4_10 < stringArray.length) {
                        String string = this.getColumnLabel((int)var4_10);
                        String string2 = TabSeparatedTextWalker.escapeText(stringArray[var4_10]);
                        treeVisitor.visitNode(string, string2, this);
                        treeVisitor.leaveNode(string, this);
                        ++var4_10;
                    }
                    treeVisitor.leaveNode(this.rowName, this);
                }
                object = this.readLine();
            }
        }
        catch (IOException iOException) {
            throw new XerialException((ErrorCode)XerialErrorCode.READ_ERROR, (Throwable)iOException);
        }
        treeVisitor.leaveNode(this.rootName, this);
        treeVisitor.finish(this);
    }

    public static String escapeText(String string) {
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        string = string.replaceAll("\"", "&quot;");
        string = string.replaceAll("'", "&#39;");
        return string;
    }

    public boolean isReportLineNumber() {
        return this.reportLineNumber;
    }

    public void setReportLineNumber(boolean bl) {
        this.reportLineNumber = bl;
    }

    public String getLineAttributeName() {
        return this.lineAttributeName;
    }

    public void setLineAttributeName(String string) {
        this.lineAttributeName = string;
    }

    private String[] splitLine(String string) {
        if (string.length() <= 0) {
            return null;
        }
        return string.split(this.separator);
    }

    public String getColumnLabel(int n) {
        if (n < this.columnLableList.size()) {
            return this.columnLableList.get(n);
        }
        for (int i = this.columnLableList.size(); i <= n; ++i) {
            this.columnLableList.add("c" + (i + 1));
        }
        return this.getColumnLabel(n);
    }

    public List<String> getColumnLabelList() {
        return this.columnLableList;
    }

    public String getRootName() {
        return this.rootName;
    }

    public void setRootName(String string) {
        this.rootName = string;
    }
}

