/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.lens;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xerial.core.XerialException;
import org.xerial.util.Pair;
import org.xerial.util.ReflectionUtil;
import org.xerial.util.StringUtil;
import org.xerial.util.TypeInfo;
import org.xerial.util.bean.BeanUtil;
import org.xerial.util.lens.impl.ParameterGetter;
import org.xerial.util.lens.impl.ParameterSetter;
import org.xerial.util.lens.impl.RelationSetter;
import org.xerial.util.log.Logger;

public class ObjectLens {
    private static Logger _logger = Logger.getLogger(ObjectLens.class);
    private static HashMap<Class<?>, ObjectLens> cache = new HashMap();
    private final Class<?> targetType;
    private final List<ParameterGetter> getterContainer = new ArrayList<ParameterGetter>();
    private final List<ParameterSetter> setterContainer = new ArrayList<ParameterSetter>();
    private final HashMap<String, ParameterGetter> getterIndex = new HashMap();
    private final HashMap<String, ParameterSetter> setterIndex = new HashMap();
    private final List<RelationSetter> relationSetterContainer = new ArrayList<RelationSetter>();
    private ParameterSetter valueSetter = null;
    private RelationSetter propertySetter = null;
    private ParameterGetter propertyGetter = null;
    private static Pattern propertyNamePattern = Pattern.compile("^(set|get|add|put|append)((\\S)(\\S*))?");
    private static Pattern pairedNamePattern = Pattern.compile("([A-Za-z0-9]*)_([A-Za-z0-9]*)");

    public static ObjectLens getObjectLens(Class<?> clazz) {
        if (cache.containsKey(clazz)) {
            return cache.get(clazz);
        }
        cache.put(clazz, new ObjectLens(clazz));
        return ObjectLens.getObjectLens(clazz);
    }

    public static String getCanonicalParameterName(String string) {
        return StringUtil.varNameToCanonicalName(string);
    }

    public Object getParameter(Object object, String string) throws XerialException {
        ParameterGetter parameterGetter = this.getterIndex.get(ObjectLens.getCanonicalParameterName(string));
        if (parameterGetter == null) {
            return null;
        }
        return parameterGetter.get(object);
    }

    public Object getParameter(Object object, String string, Object object2) throws XerialException {
        ParameterGetter parameterGetter = this.getterIndex.get(ObjectLens.getCanonicalParameterName(string));
        if (parameterGetter == null) {
            return this.getProperty(object, object2 != null ? object2.toString() : null);
        }
        if (parameterGetter.returnsMapType()) {
            return parameterGetter.get(object, object2.toString());
        }
        return parameterGetter.get(object);
    }

    public void setParameter(Object object, String string, Object object2, Object object3) throws XerialException {
        ParameterSetter parameterSetter = this.setterIndex.get(ObjectLens.getCanonicalParameterName(string));
        if (parameterSetter == null) {
            this.setProperty(object, object2, object3);
        } else if (parameterSetter.acceptKeyAndValue()) {
            parameterSetter.bind(object, object2, object3);
        } else {
            parameterSetter.bind(object, object3);
        }
    }

    public void setParameter(Object object, String string, Object object2) throws XerialException {
        ParameterSetter parameterSetter = this.setterIndex.get(ObjectLens.getCanonicalParameterName(string));
        if (parameterSetter == null) {
            return;
        }
        parameterSetter.bind(object, object2);
    }

    public boolean hasPropertySetter() {
        return this.propertySetter != null;
    }

    RelationSetter getPropertySetter() {
        return this.propertySetter;
    }

    public Object getProperty(Object object, String string) throws XerialException {
        if (this.propertyGetter == null) {
            return null;
        }
        return this.propertyGetter.get(object, string);
    }

    public void setProperty(Object object, Object object2, Object object3) throws XerialException {
        if (this.propertySetter == null) {
            return;
        }
        this.propertySetter.bind(object, object2, object3);
    }

    public List<ParameterSetter> getSetterList() {
        return Collections.unmodifiableList(this.setterContainer);
    }

    public List<RelationSetter> getRelationSetterList() {
        return Collections.unmodifiableList(this.relationSetterContainer);
    }

    public List<ParameterGetter> getGetterContainer() {
        return Collections.unmodifiableList(this.getterContainer);
    }

    public ParameterSetter getValueSetter() {
        return this.valueSetter;
    }

    public boolean hasAttributes() {
        return !this.getterContainer.isEmpty();
    }

    public ObjectLens(Class<?> clazz) {
        this.targetType = clazz;
        this.prepareBindRules(clazz);
    }

    public Class<?> getTargetType() {
        return this.targetType;
    }

    public String toString() {
        return String.format("(%s, %s)", this.setterContainer, this.relationSetterContainer);
    }

    private void prepareBindRules(Class<?> clazz) {
        Object object;
        Class<?>[] classArray;
        Pair<String, String> pair;
        Object object2;
        for (Field accessibleObject : clazz.getFields()) {
            int classArray3;
            object2 = accessibleObject.getDeclaringClass();
            if (object2 == Object.class || !Modifier.isPublic(classArray3 = accessibleObject.getModifiers()) || Modifier.isTransient(classArray3) || Modifier.isStatic(classArray3)) continue;
            pair = accessibleObject.getType();
            classArray = accessibleObject.getName();
            if (TypeInfo.isArray(pair)) {
                object = TypeInfo.getArrayElementType(pair);
                if (object == null || Byte.TYPE != object) continue;
                this.getterContainer.add(ParameterGetter.newFieldGetter(accessibleObject, (String)classArray));
                this.setterContainer.add(ParameterSetter.newSetter(pair, classArray, accessibleObject));
                continue;
            }
            if (TypeInfo.isMap(pair)) {
                object = ObjectLens.pickRelationName(accessibleObject.getName());
                if (object == null) {
                    Pair<Class<?>, Class<?>> pair2 = ReflectionUtil.getGenericMapElementClasses(accessibleObject);
                    Class<?> clazz2 = pair2.getFirst();
                    Class<?> clazz3 = pair2.getSecond();
                    object = new Pair<String, String>(clazz2.getSimpleName(), clazz3.getSimpleName());
                    if (ObjectLens.isBasicTypeOrObject(clazz2) && ObjectLens.isBasicTypeOrObject(clazz3)) {
                        this.setterContainer.add(ParameterSetter.newSetter(pair, classArray, accessibleObject));
                        this.getterContainer.add(ParameterGetter.newPropertyFieldGetter(accessibleObject, classArray));
                    }
                } else if (((String)((Pair)object).getFirst()).equals("") && ((String)((Pair)object).getSecond()).equals("")) {
                    this.propertySetter = RelationSetter.newMapSetter("key", "value", accessibleObject);
                    this.getterContainer.add(ParameterGetter.newFieldGetter(accessibleObject, classArray));
                    this.propertyGetter = ParameterGetter.newPropertyFieldGetter(accessibleObject, classArray);
                    continue;
                }
                this.relationSetterContainer.add(RelationSetter.newMapSetter((String)((Pair)object).getFirst(), (String)((Pair)object).getSecond(), accessibleObject));
                continue;
            }
            if (TypeInfo.isCollection(pair)) {
                object = ReflectionUtil.getRawClass(ReflectionUtil.getGenericCollectionElementType(accessibleObject));
                this.setterContainer.add(ParameterSetter.newSetter(object, (String)classArray, accessibleObject));
                this.getterContainer.add(ParameterGetter.newFieldGetter(accessibleObject, classArray));
                continue;
            }
            if (!classArray.equals("value")) {
                this.setterContainer.add(ParameterSetter.newSetter(pair, (String)classArray, accessibleObject));
            } else {
                this.valueSetter = ParameterSetter.newSetter(pair, (String)classArray, accessibleObject);
            }
            this.getterContainer.add(ParameterGetter.newFieldGetter(accessibleObject, classArray));
        }
        for (AccessibleObject accessibleObject : clazz.getMethods()) {
            object2 = ((Method)accessibleObject).getName();
            if (((String)object2).startsWith("add") || ((String)object2).startsWith("set")) {
                Class<?>[] string = ((Method)accessibleObject).getParameterTypes();
                switch (string.length) {
                    case 1: {
                        pair = ObjectLens.pickPropertyName((String)object2);
                        classArray = ((Method)accessibleObject).getDeclaringClass();
                        if ((TypeInfo.isCollection(classArray) || TypeInfo.isMap(classArray)) && ((String)((Object)pair)).equals("all")) break;
                        if (((String)((Object)pair)).length() <= 0 && TypeInfo.isCollection(classArray)) {
                            object = BeanUtil.resolveActualTypeOfCollectionElement(clazz, string[0]);
                            this.setterContainer.add(ParameterSetter.newSetter(object, "entry", (Method)accessibleObject));
                            break;
                        }
                        ObjectLens.addNewSetter(this.setterContainer, pair, (Method)accessibleObject);
                        break;
                    }
                    case 2: {
                        if (TypeInfo.isCollection(((Method)accessibleObject).getDeclaringClass())) break;
                        pair = ObjectLens.pickRelationName(ObjectLens.pickPropertyName((String)object2, false));
                        if (pair == null) {
                            if (TypeInfo.isMap(((Method)accessibleObject).getDeclaringClass())) {
                                classArray = BeanUtil.resolveActualTypeOfMapElement(clazz, ((Method)accessibleObject).getParameterTypes());
                                this.setterContainer.add(ParameterSetter.newMapEntrySetter(classArray[0], classArray[1]));
                                this.setterContainer.add(ParameterSetter.newKeySetter(classArray[0]));
                                this.setterContainer.add(ParameterSetter.newValueSetter(classArray[1]));
                                break;
                            }
                            pair = new Pair<String, String>(ObjectLens.getCanonicalParameterName(string[0].getSimpleName()), ObjectLens.getCanonicalParameterName(string[1].getSimpleName()));
                        }
                        this.relationSetterContainer.add(RelationSetter.newRelationSetter(pair.getFirst(), pair.getSecond(), (Method)accessibleObject));
                        break;
                    }
                }
                continue;
            }
            if (((String)object2).startsWith("put")) {
                Class<?>[] n = ((Method)accessibleObject).getParameterTypes();
                if (n.length != 2 || TypeInfo.isCollection(((Method)accessibleObject).getDeclaringClass())) continue;
                pair = ObjectLens.pickRelationName(ObjectLens.pickPropertyName((String)object2, false));
                if (pair == null) {
                    if (TypeInfo.isMap(((Method)accessibleObject).getDeclaringClass())) {
                        classArray = BeanUtil.resolveActualTypeOfMapElement(clazz, ((Method)accessibleObject).getParameterTypes());
                        if (ObjectLens.isBasicTypeOrObject(classArray[0]) && ObjectLens.isBasicTypeOrObject(classArray[1])) {
                            this.propertySetter = RelationSetter.newRelationSetter("key", "value", (Method)accessibleObject);
                        }
                        this.setterContainer.add(ParameterSetter.newMapEntrySetter(classArray[0], classArray[1]));
                        this.setterContainer.add(ParameterSetter.newKeySetter(classArray[0]));
                        this.setterContainer.add(ParameterSetter.newValueSetter(classArray[1]));
                        continue;
                    }
                    this.propertySetter = RelationSetter.newRelationSetter("key", "value", (Method)accessibleObject);
                    continue;
                }
                this.relationSetterContainer.add(RelationSetter.newRelationSetter(pair.getFirst(), pair.getSecond(), (Method)accessibleObject));
                continue;
            }
            if (((String)object2).startsWith("append")) {
                String string = ObjectLens.pickPropertyName((String)object2);
                ObjectLens.addNewSetter(this.setterContainer, string, (Method)accessibleObject);
                continue;
            }
            if (!((String)object2).startsWith("get")) continue;
            int n = ((Method)accessibleObject).getParameterTypes().length;
            pair = ObjectLens.pickPropertyName((String)object2);
            if (n == 0) {
                if (Object.class == ((Method)accessibleObject).getDeclaringClass()) continue;
                this.getterContainer.add(ParameterGetter.newGetter((Method)accessibleObject, pair));
                continue;
            }
            if (n != 1 || !TypeInfo.isMap(clazz)) continue;
            this.propertyGetter = ParameterGetter.newMapEntryGetter((Method)accessibleObject);
        }
        for (ParameterSetter parameterSetter : this.setterContainer) {
            this.setterIndex.put(parameterSetter.getCanonicalParameterName(), parameterSetter);
        }
        for (ParameterGetter parameterGetter : this.getterContainer) {
            this.getterIndex.put(parameterGetter.getCanonicalParamName(), parameterGetter);
        }
    }

    private static boolean isBasicTypeOrObject(Class<?> clazz) {
        return Object.class == clazz || TypeInfo.isBasicType(clazz);
    }

    private static void addNewSetter(List<ParameterSetter> list, String string, Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 1) {
            return;
        }
        assert (classArray.length == 1);
        String string2 = ObjectLens.getCanonicalParameterName(string);
        if (string2.length() <= 0) {
            string2 = ObjectLens.getCanonicalParameterName(classArray[0].getSimpleName());
        }
        list.add(ParameterSetter.newSetter(classArray[0], string2, method));
    }

    static String pickPropertyName(String string, boolean bl) {
        Matcher matcher = null;
        matcher = propertyNamePattern.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        if (matcher.group(2) != null) {
            return bl ? ObjectLens.getCanonicalParameterName(matcher.group(2)) : matcher.group(2);
        }
        return "";
    }

    static String pickPropertyName(String string) {
        Matcher matcher = null;
        matcher = propertyNamePattern.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        if (matcher.group(2) != null) {
            return matcher.group(2);
        }
        return "";
    }

    static Pair<String, String> pickRelationName(String string) {
        Matcher matcher = null;
        matcher = pairedNamePattern.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        return new Pair<String, String>(ObjectLens.getCanonicalParameterName(matcher.group(1)), ObjectLens.getCanonicalParameterName(matcher.group(2)));
    }
}

