/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.io.SevenZip.Compression.RangeCoder;

import java.io.IOException;
import java.io.OutputStream;

public class Encoder {
    static final int kTopMask = -16777216;
    static final int kNumBitModelTotalBits = 11;
    static final int kBitModelTotal = 2048;
    static final int kNumMoveBits = 5;
    OutputStream Stream;
    long Low;
    int Range;
    int _cacheSize;
    int _cache;
    long _position;
    static final int kNumMoveReducingBits = 2;
    public static final int kNumBitPriceShiftBits = 6;
    private static int[] ProbPrices = new int[512];

    public void SetStream(OutputStream outputStream) {
        this.Stream = outputStream;
    }

    public void ReleaseStream() {
        this.Stream = null;
    }

    public void Init() {
        this._position = 0L;
        this.Low = 0L;
        this.Range = -1;
        this._cacheSize = 1;
        this._cache = 0;
    }

    public void FlushData() throws IOException {
        for (int i = 0; i < 5; ++i) {
            this.ShiftLow();
        }
    }

    public void FlushStream() throws IOException {
        this.Stream.flush();
    }

    public void ShiftLow() throws IOException {
        int n = (int)(this.Low >>> 32);
        if (n != 0 || this.Low < 0xFF000000L) {
            this._position += (long)this._cacheSize;
            int n2 = this._cache;
            do {
                this.Stream.write(n2 + n);
                n2 = 255;
            } while (--this._cacheSize != 0);
            this._cache = (int)this.Low >>> 24;
        }
        ++this._cacheSize;
        this.Low = (this.Low & 0xFFFFFFL) << 8;
    }

    public void EncodeDirectBits(int n, int n2) throws IOException {
        for (int i = n2 - 1; i >= 0; --i) {
            this.Range >>>= 1;
            if ((n >>> i & 1) == 1) {
                this.Low += (long)this.Range;
            }
            if ((this.Range & 0xFF000000) != 0) continue;
            this.Range <<= 8;
            this.ShiftLow();
        }
    }

    public long GetProcessedSizeAdd() {
        return (long)this._cacheSize + this._position + 4L;
    }

    public static void InitBitModels(short[] sArray) {
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = 1024;
        }
    }

    public void Encode(short[] sArray, int n, int n2) throws IOException {
        short s = sArray[n];
        int n3 = (this.Range >>> 11) * s;
        if (n2 == 0) {
            this.Range = n3;
            sArray[n] = (short)(s + (2048 - s >>> 5));
        } else {
            this.Low += (long)n3 & 0xFFFFFFFFL;
            this.Range -= n3;
            sArray[n] = (short)(s - (s >>> 5));
        }
        if ((this.Range & 0xFF000000) == 0) {
            this.Range <<= 8;
            this.ShiftLow();
        }
    }

    public static int GetPrice(int n, int n2) {
        return ProbPrices[((n - n2 ^ -n2) & 0x7FF) >>> 2];
    }

    public static int GetPrice0(int n) {
        return ProbPrices[n >>> 2];
    }

    public static int GetPrice1(int n) {
        return ProbPrices[2048 - n >>> 2];
    }

    static {
        int n = 9;
        for (int i = n - 1; i >= 0; --i) {
            int n2 = 1 << n - i - 1;
            int n3 = 1 << n - i;
            for (int j = n2; j < n3; ++j) {
                Encoder.ProbPrices[j] = (i << 6) + (n3 - j << 6 >>> n - i - 1);
            }
        }
    }
}

