/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.io.SevenZip.Compression.RangeCoder;

import java.io.IOException;
import org.xerial.util.io.SevenZip.Compression.RangeCoder.Decoder;
import org.xerial.util.io.SevenZip.Compression.RangeCoder.Encoder;

public class BitTreeEncoder {
    short[] Models;
    int NumBitLevels;

    public BitTreeEncoder(int n) {
        this.NumBitLevels = n;
        this.Models = new short[1 << n];
    }

    public void Init() {
        Decoder.InitBitModels(this.Models);
    }

    public void Encode(Encoder encoder, int n) throws IOException {
        int n2 = 1;
        int n3 = this.NumBitLevels;
        while (n3 != 0) {
            int n4 = n >>> --n3 & 1;
            encoder.Encode(this.Models, n2, n4);
            n2 = n2 << 1 | n4;
        }
    }

    public void ReverseEncode(Encoder encoder, int n) throws IOException {
        int n2 = 1;
        for (int i = 0; i < this.NumBitLevels; ++i) {
            int n3 = n & 1;
            encoder.Encode(this.Models, n2, n3);
            n2 = n2 << 1 | n3;
            n >>= 1;
        }
    }

    public int GetPrice(int n) {
        int n2 = 0;
        int n3 = 1;
        int n4 = this.NumBitLevels;
        while (n4 != 0) {
            int n5 = n >>> --n4 & 1;
            n2 += Encoder.GetPrice(this.Models[n3], n5);
            n3 = (n3 << 1) + n5;
        }
        return n2;
    }

    public int ReverseGetPrice(int n) {
        int n2 = 0;
        int n3 = 1;
        for (int i = this.NumBitLevels; i != 0; --i) {
            int n4 = n & 1;
            n >>>= 1;
            n2 += Encoder.GetPrice(this.Models[n3], n4);
            n3 = n3 << 1 | n4;
        }
        return n2;
    }

    public static int ReverseGetPrice(short[] sArray, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 1;
        for (int i = n2; i != 0; --i) {
            int n6 = n3 & 1;
            n3 >>>= 1;
            n4 += Encoder.GetPrice(sArray[n + n5], n6);
            n5 = n5 << 1 | n6;
        }
        return n4;
    }

    public static void ReverseEncode(short[] sArray, int n, Encoder encoder, int n2, int n3) throws IOException {
        int n4 = 1;
        for (int i = 0; i < n2; ++i) {
            int n5 = n3 & 1;
            encoder.Encode(sArray, n + n4, n5);
            n4 = n4 << 1 | n5;
            n3 >>= 1;
        }
    }
}

