/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.io;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import org.xerial.core.ErrorCode;
import org.xerial.core.XerialErrorCode;
import org.xerial.core.XerialException;

public class Base64 {
    static final int CHUNK_SIZE = 76;
    static final byte[] CHUNK_SEPARATOR = new byte[]{13, 10};
    private static final byte[] intToBase64 = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte PAD = 61;
    private static final byte[] base64ToInt = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private static final int MASK_6BITS = 63;
    private static final int MASK_8BITS = 255;
    private final int lineLength;
    private final byte[] lineSeparator;
    private final int decodeSize;
    private final int encodeSize;
    private byte[] buf;
    private int pos;
    private int readPos;
    private int currentLinePos;
    private int modulus;
    private boolean eof;
    private int x;

    public Base64() {
        this(76, CHUNK_SEPARATOR);
    }

    public Base64(int n) {
        this(n, CHUNK_SEPARATOR);
    }

    public Base64(int n, byte[] byArray) {
        this.lineLength = n;
        this.lineSeparator = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.lineSeparator, 0, byArray.length);
        this.encodeSize = n > 0 ? 4 + byArray.length : 4;
        this.decodeSize = this.encodeSize - 1;
        if (Base64.containsBase64Byte(byArray)) {
            String string;
            try {
                string = new String(byArray, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string = new String(byArray);
            }
            throw new IllegalArgumentException("lineSeperator must not contain base64 characters: [" + string + "]");
        }
    }

    boolean hasData() {
        return this.buf != null;
    }

    int avail() {
        return this.buf != null ? this.pos - this.readPos : 0;
    }

    private void resizeBuf() {
        if (this.buf == null) {
            this.buf = new byte[8192];
            this.pos = 0;
            this.readPos = 0;
        } else {
            byte[] byArray = new byte[this.buf.length * 2];
            System.arraycopy(this.buf, 0, byArray, 0, this.buf.length);
            this.buf = byArray;
        }
    }

    int readResults(byte[] byArray, int n, int n2) {
        if (this.buf != null) {
            int n3 = Math.min(this.avail(), n2);
            if (this.buf != byArray) {
                System.arraycopy(this.buf, this.readPos, byArray, n, n3);
                this.readPos += n3;
                if (this.readPos >= this.pos) {
                    this.buf = null;
                }
            } else {
                this.buf = null;
            }
            return n3;
        }
        return this.eof ? -1 : 0;
    }

    void setInitialBuffer(byte[] byArray, int n, int n2) {
        if (byArray != null && byArray.length == n2) {
            this.buf = byArray;
            this.pos = n;
            this.readPos = n;
        }
    }

    void encode(byte[] byArray, int n, int n2) {
        if (this.eof) {
            return;
        }
        if (n2 < 0) {
            this.eof = true;
            if (this.buf == null || this.buf.length - this.pos < this.encodeSize) {
                this.resizeBuf();
            }
            switch (this.modulus) {
                case 1: {
                    this.buf[this.pos++] = intToBase64[this.x >> 2 & 0x3F];
                    this.buf[this.pos++] = intToBase64[this.x << 4 & 0x3F];
                    this.buf[this.pos++] = 61;
                    this.buf[this.pos++] = 61;
                    break;
                }
                case 2: {
                    this.buf[this.pos++] = intToBase64[this.x >> 10 & 0x3F];
                    this.buf[this.pos++] = intToBase64[this.x >> 4 & 0x3F];
                    this.buf[this.pos++] = intToBase64[this.x << 2 & 0x3F];
                    this.buf[this.pos++] = 61;
                }
            }
            if (this.lineLength > 0) {
                System.arraycopy(this.lineSeparator, 0, this.buf, this.pos, this.lineSeparator.length);
                this.pos += this.lineSeparator.length;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                int n3;
                if (this.buf == null || this.buf.length - this.pos < this.encodeSize) {
                    this.resizeBuf();
                }
                ++this.modulus;
                this.modulus %= 3;
                if ((n3 = byArray[n++]) < 0) {
                    n3 += 256;
                }
                this.x = (this.x << 8) + n3;
                if (0 != this.modulus) continue;
                this.buf[this.pos++] = intToBase64[this.x >> 18 & 0x3F];
                this.buf[this.pos++] = intToBase64[this.x >> 12 & 0x3F];
                this.buf[this.pos++] = intToBase64[this.x >> 6 & 0x3F];
                this.buf[this.pos++] = intToBase64[this.x & 0x3F];
                this.currentLinePos += 4;
                if (this.lineLength <= 0 || this.lineLength > this.currentLinePos) continue;
                System.arraycopy(this.lineSeparator, 0, this.buf, this.pos, this.lineSeparator.length);
                this.pos += this.lineSeparator.length;
                this.currentLinePos = 0;
            }
        }
    }

    void decode(byte[] byArray, int n, int n2) {
        if (this.eof) {
            return;
        }
        if (n2 < 0) {
            this.eof = true;
        }
        for (int i = 0; i < n2; ++i) {
            byte by;
            byte by2;
            if (this.buf == null || this.buf.length - this.pos < this.decodeSize) {
                this.resizeBuf();
            }
            if ((by2 = byArray[n++]) == 61) {
                this.x <<= 6;
                switch (this.modulus) {
                    case 2: {
                        this.x <<= 6;
                        this.buf[this.pos++] = (byte)(this.x >> 16 & 0xFF);
                        break;
                    }
                    case 3: {
                        this.buf[this.pos++] = (byte)(this.x >> 16 & 0xFF);
                        this.buf[this.pos++] = (byte)(this.x >> 8 & 0xFF);
                    }
                }
                this.eof = true;
                return;
            }
            if (by2 < 0 || by2 >= base64ToInt.length || (by = base64ToInt[by2]) < 0) continue;
            ++this.modulus;
            this.modulus %= 4;
            this.x = (this.x << 6) + by;
            if (this.modulus != 0) continue;
            this.buf[this.pos++] = (byte)(this.x >> 16 & 0xFF);
            this.buf[this.pos++] = (byte)(this.x >> 8 & 0xFF);
            this.buf[this.pos++] = (byte)(this.x & 0xFF);
        }
    }

    public static boolean isBase64(byte by) {
        return by == 61 || by >= 0 && by < base64ToInt.length && base64ToInt[by] != -1;
    }

    public static boolean isArrayByteBase64(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            if (Base64.isBase64(byArray[i]) || Base64.isWhiteSpace(byArray[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean containsBase64Byte(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            if (!Base64.isBase64(byArray[i])) continue;
            return true;
        }
        return false;
    }

    public static byte[] encodeBase64(byte[] byArray) {
        return Base64.encodeBase64(byArray, false);
    }

    public static byte[] encodeBase64Chunked(byte[] byArray) {
        return Base64.encodeBase64(byArray, true);
    }

    public Object decode(Object object) throws XerialException {
        if (!(object instanceof byte[])) {
            throw new XerialException((ErrorCode)XerialErrorCode.DECODE_ERROR, "Parameter supplied to Base64 decode is not a byte[]");
        }
        return this.decode((byte[])object);
    }

    public byte[] decode(byte[] byArray) {
        return Base64.decodeBase64(byArray);
    }

    public static byte[] encodeBase64(byte[] byArray, boolean bl) {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        Base64 base64 = bl ? new Base64() : new Base64(0);
        long l = byArray.length * 4 / 3;
        long l2 = l % 4L;
        if (l2 != 0L) {
            l += 4L - l2;
        }
        if (bl) {
            l += (1L + l / 76L) * (long)CHUNK_SEPARATOR.length;
        }
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Input array too big, output array would be bigger than Integer.MAX_VALUE=2147483647");
        }
        byte[] byArray2 = new byte[(int)l];
        base64.setInitialBuffer(byArray2, 0, byArray2.length);
        base64.encode(byArray, 0, byArray.length);
        base64.encode(byArray, 0, -1);
        if (base64.buf != byArray2) {
            base64.readResults(byArray2, 0, byArray2.length);
        }
        return byArray2;
    }

    public static byte[] decodeBase64(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        Base64 base64 = new Base64();
        long l = byArray.length * 3 / 4;
        byte[] byArray2 = new byte[(int)l];
        base64.setInitialBuffer(byArray2, 0, byArray2.length);
        base64.decode(byArray, 0, byArray.length);
        base64.decode(byArray, 0, -1);
        byte[] byArray3 = new byte[base64.pos];
        base64.readResults(byArray3, 0, byArray3.length);
        return byArray3;
    }

    static byte[] discardWhitespace(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        int n = 0;
        block3: for (int i = 0; i < byArray.length; ++i) {
            switch (byArray[i]) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block3;
                }
                default: {
                    byArray2[n++] = byArray[i];
                }
            }
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 0, byArray3, 0, n);
        return byArray3;
    }

    private static boolean isWhiteSpace(byte by) {
        switch (by) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    static byte[] discardNonBase64(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (!Base64.isBase64(byArray[i])) continue;
            byArray2[n++] = byArray[i];
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 0, byArray3, 0, n);
        return byArray3;
    }

    public Object encode(Object object) throws XerialException {
        if (!(object instanceof byte[])) {
            throw new XerialException((ErrorCode)XerialErrorCode.ENCODE_ERROR, "Parameter supplied to Base64 encode is not a byte[]");
        }
        return this.encode((byte[])object);
    }

    public byte[] encode(byte[] byArray) {
        return Base64.encodeBase64(byArray, false);
    }

    public static BigInteger decodeInteger(byte[] byArray) {
        return new BigInteger(1, Base64.decodeBase64(byArray));
    }

    public static byte[] encodeInteger(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new NullPointerException("encodeInteger called with null parameter");
        }
        return Base64.encodeBase64(Base64.toIntegerBytes(bigInteger), false);
    }

    static byte[] toIntegerBytes(BigInteger bigInteger) {
        int n = bigInteger.bitLength();
        n = n + 7 >> 3 << 3;
        byte[] byArray = bigInteger.toByteArray();
        if (bigInteger.bitLength() % 8 != 0 && bigInteger.bitLength() / 8 + 1 == n / 8) {
            return byArray;
        }
        int n2 = 0;
        int n3 = byArray.length;
        if (bigInteger.bitLength() % 8 == 0) {
            n2 = 1;
            --n3;
        }
        int n4 = n / 8 - n3;
        byte[] byArray2 = new byte[n / 8];
        System.arraycopy(byArray, n2, byArray2, n4, n3);
        return byArray2;
    }
}

