/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.bean;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xerial.core.ErrorCode;
import org.xerial.core.XerialErrorCode;
import org.xerial.core.XerialException;
import org.xerial.util.Pair;
import org.xerial.util.TypeInfo;
import org.xerial.util.bean.BeanBinderSet;
import org.xerial.util.bean.BinderSet;
import org.xerial.util.bean.impl.Appender;
import org.xerial.util.bean.impl.ArraySetter;
import org.xerial.util.bean.impl.BeanUtilImpl;
import org.xerial.util.bean.impl.CollectionAdder;
import org.xerial.util.bean.impl.CollectionSetter;
import org.xerial.util.bean.impl.Getter;
import org.xerial.util.bean.impl.MapPutter;
import org.xerial.util.bean.impl.MapSetter;
import org.xerial.util.bean.impl.Setter;

public class BeanUtil {
    private static HashMap<Class<?>, BinderSet> _beanOutputRuleRegistry = new HashMap();
    private static HashMap<Class<?>, BinderSet> _beanLoadRuleRegistry = new HashMap();
    private static Pattern _setGetAddMethodPattern = Pattern.compile("^(set|get|add|put|append)((\\S)(\\S*))?");

    public static BeanBinderSet getBeanOutputRule(Class<?> clazz) throws XerialException {
        if (_beanOutputRuleRegistry.containsKey(clazz)) {
            return _beanOutputRuleRegistry.get(clazz);
        }
        BinderSet binderSet = BeanUtil.inspectGetters(clazz);
        _beanOutputRuleRegistry.put(clazz, binderSet);
        return binderSet;
    }

    public static BeanBinderSet getBeanLoadRule(Class<?> clazz) throws XerialException {
        if (_beanLoadRuleRegistry.containsKey(clazz)) {
            return _beanLoadRuleRegistry.get(clazz);
        }
        BinderSet binderSet = BeanUtil.inspectSetter(clazz);
        _beanLoadRuleRegistry.put(clazz, binderSet);
        return binderSet;
    }

    private static BinderSet inspectGetters(Class<?> clazz) throws XerialException {
        Method[] methodArray;
        BinderSet binderSet = new BinderSet(clazz);
        for (Method method : methodArray = clazz.getMethods()) {
            Class<?>[] classArray;
            String string;
            String string2;
            if (!Modifier.isPublic(method.getModifiers()) || (string2 = BeanUtil.pickPropertyName(string = method.getName())) == null || string2.length() == 0 || !string.startsWith("get") || string.equals("getClass") || (classArray = method.getParameterTypes()).length != 0) continue;
            binderSet.addRule(new Getter(method, string2));
        }
        return binderSet;
    }

    public static BinderSet inspectSetter(Class<?> clazz) throws XerialException {
        BinderSet binderSet = new BinderSet(clazz);
        for (Method method : clazz.getMethods()) {
            Pair<Class<?>, Class<?>> pair;
            Object object;
            String string = method.getName();
            String string2 = BeanUtil.pickPropertyName(string);
            if (string2 == null || !Modifier.isPublic(method.getModifiers())) continue;
            Class<?>[] classArray = method.getParameterTypes();
            if (string.startsWith("put")) {
                if (classArray.length != 2) continue;
                object = BeanUtil.resolveActualTypeOfMapElement(clazz, classArray);
                if (string2.length() == 0 && TypeInfo.isMap(clazz)) {
                    binderSet.addRule(new MapPutter(method, "elem", object[0], object[1]));
                    continue;
                }
                binderSet.addRule(new MapPutter(method, string2, object[0], object[1]));
                continue;
            }
            if (string.startsWith("add")) {
                if (classArray.length != 1) continue;
                object = BeanUtil.resolveActualTypeOfCollectionElement(clazz, classArray[0]);
                if (string2.length() == 0 && TypeInfo.isCollection(clazz)) {
                    binderSet.addRule(new CollectionAdder(method, "elem", (Class<?>)object));
                    continue;
                }
                binderSet.addRule(new CollectionAdder(method, string2, (Class<?>)object));
                continue;
            }
            if (string.startsWith("append")) {
                if (classArray.length != 1) continue;
                object = BeanUtil.resolveActualTypeOfCollectionElement(clazz, classArray[0]);
                binderSet.addRule(new Appender((Class<?>)object, method, string2));
                continue;
            }
            if (!string.startsWith("set") || classArray.length != 1 || string2.length() == 0) continue;
            object = classArray[0];
            if (((Class)object).isArray()) {
                pair = ((Class)object).getComponentType();
                binderSet.addRule(new ArraySetter(method, string2, (Class<?>)((Object)pair)));
                continue;
            }
            if (TypeInfo.isCollection(object)) {
                Type[] typeArray;
                if (!(method.getGenericParameterTypes()[0] instanceof ParameterizedType) || (typeArray = (pair = (ParameterizedType)method.getGenericParameterTypes()[0]).getActualTypeArguments()).length <= 0) continue;
                Class<?> clazz2 = BeanUtil.resolveRawType(typeArray[0]);
                binderSet.addRule(new CollectionSetter(method, string2, (Class<?>)object, clazz2));
                continue;
            }
            if (TypeInfo.isMap(object)) {
                pair = BeanUtil.getGenericMapTypesOfMethodArgument(method, 0);
                if (pair == null) continue;
                binderSet.addRule(new MapSetter(method, string2, (Class<?>)object, (Class)pair.getFirst(), (Class)pair.getSecond()));
                continue;
            }
            binderSet.addRule(new Setter(method, string2, (Class<?>)object));
        }
        return binderSet;
    }

    public static Pair<Class<?>, Class<?>> getGenericMapTypesOfMethodArgument(Method method, int n) {
        Type[] typeArray;
        ParameterizedType parameterizedType = BeanUtil.getParentParameterizedType(method.getGenericParameterTypes()[n], Map.class);
        if (parameterizedType != null && (typeArray = parameterizedType.getActualTypeArguments()).length >= 2) {
            Class<?> clazz = BeanUtil.resolveRawType(typeArray[0]);
            Class<?> clazz2 = BeanUtil.resolveRawType(typeArray[1]);
            return new Pair(clazz, clazz2);
        }
        return null;
    }

    public static ParameterizedType getParameterizedType(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return parameterizedType;
        }
        if (type instanceof Class) {
            return BeanUtil.getParameterizedType(((Class)type).getGenericSuperclass());
        }
        return null;
    }

    public static ParameterizedType getParentParameterizedType(Type type, Class clazz) {
        Type type2;
        if (type == null) {
            return null;
        }
        if (type instanceof ParameterizedType && clazz.isAssignableFrom((Class)(type2 = (ParameterizedType)type).getRawType())) {
            return type2;
        }
        if (type instanceof Class) {
            type2 = (Class)type;
            return BeanUtil.getParentParameterizedType(((Class)type2).getGenericSuperclass(), clazz);
        }
        return null;
    }

    public static Class<?> resolveActualTypeOfCollectionElement(Type type, Class<?> clazz) {
        Type[] typeArray;
        ParameterizedType parameterizedType = BeanUtil.getParentParameterizedType(type, Collection.class);
        if (parameterizedType != null && (typeArray = parameterizedType.getActualTypeArguments()).length > 0) {
            return BeanUtil.resolveRawType(typeArray[0], clazz);
        }
        return clazz;
    }

    public static Class<?>[] resolveActualTypeOfMapElement(Type type, Class<?>[] classArray) {
        Type[] typeArray;
        ParameterizedType parameterizedType = BeanUtil.getParentParameterizedType(type, Map.class);
        if (parameterizedType != null && (typeArray = parameterizedType.getActualTypeArguments()).length > 0) {
            return new Class[]{BeanUtil.resolveRawType(typeArray[0], classArray[0]), BeanUtil.resolveRawType(typeArray[1], classArray[1])};
        }
        return classArray;
    }

    private static Class<?> resolveRawType(Type type, Class<?> clazz) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return BeanUtil.resolveRawType(parameterizedType.getRawType(), clazz);
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        return clazz;
    }

    private static Class<?> resolveRawType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return BeanUtil.resolveRawType(parameterizedType.getRawType());
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        return Object.class;
    }

    private BeanUtil() {
    }

    public static String pickPropertyName(String string) {
        Matcher matcher = null;
        matcher = _setGetAddMethodPattern.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        if (matcher.group(2) != null) {
            return matcher.group(3).toLowerCase() + matcher.group(4);
        }
        return "";
    }

    public static String toJSONFromResultSet(ResultSet resultSet) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        stringBuilder.append("{");
        for (int i = 1; i <= n; ++i) {
            if (i >= 2) {
                stringBuilder.append(",");
            }
            Object object = resultSet.getObject(i);
            stringBuilder.append("\"");
            stringBuilder.append(resultSetMetaData.getColumnName(i));
            stringBuilder.append("\":");
            if (object != null) {
                stringBuilder.append("\"");
                stringBuilder.append(object.toString());
                stringBuilder.append("\"");
                continue;
            }
            stringBuilder.append("null");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private static boolean hasGetter(Class<?> clazz) throws XerialException {
        BeanBinderSet beanBinderSet = BeanUtil.getBeanOutputRule(clazz);
        return beanBinderSet.getBindRules().size() > 0;
    }

    private static Object invokeGetterMethod(Method method, Object object) throws XerialException {
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new XerialException((ErrorCode)XerialErrorCode.IllegalArgument, (Throwable)illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new XerialException((ErrorCode)XerialErrorCode.IllegalAccess, (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new XerialException((ErrorCode)XerialErrorCode.InvocationTargetException, (Throwable)invocationTargetException);
        }
    }

    public static void populateBeanWithMap(Object object, Map<?, ?> map) throws XerialException {
        BeanUtilImpl.populateBeanWithMap(object, map);
    }

    public static Object createInstance(Class<?> clazz) throws XerialException {
        return TypeInfo.createInstance(clazz);
    }
}

