/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util;

public class Pair<X, Y> {
    private final X first;
    private final Y second;

    public Pair(X x, Y y) {
        if (x == null || y == null) {
            throw new NullPointerException();
        }
        this.first = x;
        this.second = y;
    }

    public X getFirst() {
        return this.first;
    }

    public Y getSecond() {
        return this.second;
    }

    public static <X, Y> Pair<X, Y> newPair(X x, Y y) {
        return new Pair<X, Y>(x, y);
    }

    public String toString() {
        return String.format("(%s, %s)", this.first, this.second);
    }

    public boolean equals(Object object) {
        if (object instanceof Pair) {
            Pair pair = (Pair)object;
            return this.first.equals(pair.first) && this.second.equals(pair.second);
        }
        return false;
    }

    public int hashCode() {
        return (this.first.hashCode() * 127 + this.second.hashCode() * 127) % 1987;
    }
}

