/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.json;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xerial.json.JSONBoolean;
import org.xerial.json.JSONDouble;
import org.xerial.json.JSONErrorCode;
import org.xerial.json.JSONEvent;
import org.xerial.json.JSONException;
import org.xerial.json.JSONInteger;
import org.xerial.json.JSONNull;
import org.xerial.json.JSONNumber;
import org.xerial.json.JSONObject;
import org.xerial.json.JSONPullParser;
import org.xerial.json.JSONString;
import org.xerial.json.JSONValue;
import org.xerial.json.JSONValueBase;
import org.xerial.json.JSONValueType;

public class JSONArray
extends JSONValueBase
implements Iterable<JSONValue> {
    private final ArrayList<JSONValue> _array = new ArrayList();

    public JSONArray() {
    }

    public JSONArray(List<JSONValue> list) {
        this._array.ensureCapacity(list.size());
        for (JSONValue jSONValue : list) {
            this._array.add(jSONValue);
        }
    }

    JSONArray(JSONPullParser jSONPullParser) throws JSONException {
        JSONEvent jSONEvent = jSONPullParser.next();
        if (jSONEvent != JSONEvent.StartArray) {
            throw new JSONException(JSONErrorCode.ParseError, "expected [, but " + (Object)((Object)jSONEvent));
        }
        JSONArray.parseArray(this, jSONPullParser);
    }

    private static JSONArray parseArray(JSONArray jSONArray, JSONPullParser jSONPullParser) throws JSONException {
        JSONEvent jSONEvent;
        while ((jSONEvent = jSONPullParser.next()) != JSONEvent.EndJSON) {
            switch (jSONEvent) {
                case Integer: 
                case Double: 
                case Null: 
                case True: 
                case False: 
                case String: {
                    jSONArray.add(jSONPullParser.getValue());
                    break;
                }
                case StartObject: {
                    jSONArray.add(JSONArray.parseObject(jSONPullParser));
                    break;
                }
                case EndObject: {
                    break;
                }
                case StartArray: {
                    jSONArray.add(JSONArray.parseArray(new JSONArray(), jSONPullParser));
                    break;
                }
                case EndArray: {
                    return jSONArray;
                }
            }
        }
        return jSONArray;
    }

    private static JSONObject parseObject(JSONPullParser jSONPullParser) throws JSONException {
        JSONEvent jSONEvent = jSONPullParser.next();
        JSONObject jSONObject = new JSONObject();
        while ((jSONEvent = jSONPullParser.next()) != JSONEvent.EndJSON) {
            switch (jSONEvent) {
                case Integer: 
                case Double: 
                case Null: 
                case True: 
                case False: 
                case String: {
                    String string = jSONPullParser.getKeyName();
                    if (string == null) break;
                    jSONObject.put(string, jSONPullParser.getValue());
                    break;
                }
                case StartObject: {
                    jSONObject.put(jSONPullParser.getKeyName(), JSONArray.parseObject(jSONPullParser));
                    break;
                }
                case EndObject: {
                    return jSONObject;
                }
                case StartArray: {
                    jSONObject.put(jSONPullParser.getKeyName(), JSONArray.parseArray(new JSONArray(), jSONPullParser));
                    break;
                }
            }
        }
        return jSONObject;
    }

    public JSONArray(String string) throws JSONException {
        new JSONPullParser(string).populateJSONArray(this);
    }

    public void add(JSONValue jSONValue) {
        this._array.add(jSONValue);
    }

    public void add(Object object) throws JSONException {
        this._array.add(this.translateAsJSONValue(object));
    }

    public void add(String string) {
        this._array.add(new JSONString(string));
    }

    public int size() {
        return this._array.size();
    }

    public JSONValue get(int n) {
        return this._array.get(n);
    }

    public JSONNumber getJSONNubmer(int n) {
        return this._array.get(n).getJSONNumber();
    }

    public JSONInteger getJSONInteger(int n) {
        JSONNumber jSONNumber = this._array.get(n).getJSONNumber();
        if (jSONNumber != null && jSONNumber instanceof JSONInteger) {
            return (JSONInteger)jSONNumber;
        }
        return null;
    }

    public JSONDouble getJSONDouble(int n) {
        JSONNumber jSONNumber = this._array.get(n).getJSONNumber();
        if (jSONNumber != null && jSONNumber instanceof JSONDouble) {
            return (JSONDouble)jSONNumber;
        }
        return null;
    }

    public JSONObject getJSONObject(int n) {
        return this._array.get(n).getJSONObject();
    }

    @Override
    public JSONArray getJSONArray() {
        return this;
    }

    public JSONArray getJSONArray(int n) {
        JSONValue jSONValue = this.get(n);
        if (jSONValue instanceof JSONArray) {
            return (JSONArray)jSONValue;
        }
        return null;
    }

    public JSONBoolean getJSONBoolean(int n) {
        return this._array.get(n).getJSONBoolean();
    }

    public JSONNull getJSONNull(int n) {
        return this._array.get(n).getJSONNull();
    }

    @Override
    public Iterator<JSONValue> iterator() {
        return this._array.iterator();
    }

    public String toString() {
        return this.toJSONString();
    }

    @Override
    public String toJSONString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (JSONValue jSONValue : this._array) {
            arrayList.add(jSONValue.toJSONString());
        }
        stringBuilder.append(JSONArray.join(arrayList, ","));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public String getString(int n) {
        return this.get(n).toString();
    }

    @Override
    public JSONValueType getValueType() {
        return JSONValueType.Array;
    }
}

