/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import org.postgresql.pljava.internal.ExecutionPlan;
import org.postgresql.pljava.internal.Portal;
import org.postgresql.pljava.internal.SPI;
import org.postgresql.pljava.internal.SPIException;
import org.postgresql.pljava.jdbc.SPIConnection;
import org.postgresql.pljava.jdbc.SPIResultSet;
import org.postgresql.pljava.jdbc.StatementClosedException;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public class SPIStatement
implements Statement {
    private final SPIConnection m_connection;
    private String m_cursorName = null;
    private int m_fetchSize = 1000;
    private int m_maxRows = 0;
    private ResultSet m_resultSet = null;
    private int m_updateCount = 0;
    private ArrayList m_batch = null;
    private boolean m_closed = false;

    public SPIStatement(SPIConnection conn) {
        this.m_connection = conn;
    }

    @Override
    public void addBatch(String statement) throws SQLException {
        this.internalAddBatch(statement);
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public void clearBatch() throws SQLException {
        this.m_batch = null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    private void clear() throws SQLException {
        if (this.m_resultSet != null) {
            this.m_resultSet.close();
        }
        this.m_updateCount = -1;
        this.m_cursorName = null;
        this.m_batch = null;
    }

    @Override
    public void close() throws SQLException {
        this.clear();
        this.m_closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String statement) throws SQLException {
        this.clear();
        ExecutionPlan plan = ExecutionPlan.prepare(this.m_connection.nativeSQL(statement), null);
        int result = SPI.getResult();
        if (plan == null) {
            throw new SPIException(result);
        }
        try {
            boolean bl = this.executePlan(plan, null);
            return bl;
        }
        finally {
            try {
                plan.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executePlan(ExecutionPlan plan, Object[] paramValues) throws SQLException {
        this.m_updateCount = -1;
        this.m_resultSet = null;
        boolean isResultSet = plan.isCursorPlan();
        if (isResultSet) {
            Portal portal = plan.cursorOpen(this.m_cursorName, paramValues);
            this.m_resultSet = new SPIResultSet(this, portal, this.m_maxRows);
        } else {
            try {
                plan.execute(paramValues, this.m_maxRows);
                this.m_updateCount = SPI.getProcessed();
            }
            finally {
                SPI.freeTupTable();
            }
        }
        return isResultSet;
    }

    @Override
    public boolean execute(String statement, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedFeatureException("Statement.execute(String,int)");
    }

    @Override
    public boolean execute(String statement, int[] columnIndexes) throws SQLException {
        throw new UnsupportedFeatureException("Statement.execute(String,int[])");
    }

    @Override
    public boolean execute(String statement, String[] columnNames) throws SQLException {
        throw new UnsupportedFeatureException("Statement.execute(String,String[])");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int numBatches = this.m_batch == null ? 0 : this.m_batch.size();
        int[] result = new int[numBatches];
        for (int idx = 0; idx < numBatches; ++idx) {
            result[idx] = this.executeBatchEntry(this.m_batch.get(idx));
        }
        return result;
    }

    @Override
    public ResultSet executeQuery(String statement) throws SQLException {
        this.execute(statement);
        return this.getResultSet();
    }

    @Override
    public int executeUpdate(String statement) throws SQLException {
        this.execute(statement);
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String statement, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedFeatureException("Auto generated key support not yet implemented");
    }

    @Override
    public int executeUpdate(String statement, int[] columnIndexes) throws SQLException {
        throw new UnsupportedFeatureException("Auto generated key support not yet implemented");
    }

    @Override
    public int executeUpdate(String statement, String[] columnNames) throws SQLException {
        throw new UnsupportedFeatureException("Auto generated key support not yet implemented");
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.m_connection == null) {
            throw new StatementClosedException();
        }
        return this.m_connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.m_fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException("JDK 1.4 functionality not yet implemented");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.m_maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.m_resultSet;
    }

    @Override
    public int getResultSetConcurrency() {
        return 1007;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLException("JDK 1.4 functionality not yet implemented");
    }

    @Override
    public int getResultSetType() {
        return 1003;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.m_updateCount;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.m_closed) {
            throw new SQLException("getWarnings: Statement is closed");
        }
        return null;
    }

    @Override
    public void setCursorName(String cursorName) throws SQLException {
        this.m_cursorName = cursorName;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new UnsupportedFeatureException("Statement.setEscapeProcessing");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new UnsupportedFeatureException("Non forward fetch direction");
        }
    }

    @Override
    public void setFetchSize(int size) throws SQLException {
        this.m_fetchSize = size;
    }

    @Override
    public void setMaxFieldSize(int size) throws SQLException {
        throw new UnsupportedFeatureException("Statement.setMaxFieldSize");
    }

    @Override
    public void setMaxRows(int rows) throws SQLException {
        this.m_maxRows = rows;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        throw new UnsupportedFeatureException("Statement.setQueryTimeout");
    }

    protected void internalAddBatch(Object batch) throws SQLException {
        if (this.m_batch == null) {
            this.m_batch = new ArrayList();
        }
        this.m_batch.add(batch);
    }

    protected int executeBatchEntry(Object batchEntry) throws SQLException {
        int ret = -2;
        if (this.execute(this.m_connection.nativeSQL((String)batchEntry))) {
            this.getResultSet().close();
        } else if (this.m_updateCount >= 0) {
            ret = this.m_updateCount;
        }
        return ret;
    }

    void resultSetClosed(ResultSet rs) {
        if (rs == this.m_resultSet) {
            this.m_resultSet = null;
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".setPoolable( boolean ) not implemented yet.", "0A000");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".isPoolable() not implemented yet.", "0A000");
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".isClosed() not implemented yet.", "0A000");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".isWrapperFor( Class<?> ) not implemented yet.", "0A000");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".unwrapClass( Class<T> ) not implemented yet.", "0A000");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".closeOneCompletion() not implemented yet.", "0A000");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }
}

