/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Logger;
import org.postgresql.pljava.ResultSetProvider;

public class MetaDataStrings
implements ResultSetProvider {
    String[] methodNames;
    String[] methodResults;

    public static ResultSetProvider getDatabaseMetaDataStrings() throws SQLException {
        try {
            return new MetaDataStrings();
        }
        catch (SQLException e) {
            throw new SQLException("Error reading DatabaseMetaData", e.getMessage());
        }
    }

    public MetaDataStrings() throws SQLException {
        Logger log = Logger.getAnonymousLogger();
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        DatabaseMetaData md = conn.getMetaData();
        Method[] m = DatabaseMetaData.class.getMethods();
        class MethodComparator
        implements Comparator<Method> {
            MethodComparator() {
            }

            @Override
            public int compare(Method a, Method b) {
                return a.getName().compareTo(b.getName());
            }
        }
        Arrays.sort(m, new MethodComparator());
        Object[] args = new Object[]{};
        String result = null;
        ArrayList<String> mn = new ArrayList<String>();
        ArrayList<String> mr = new ArrayList<String>();
        for (int i = 0; i < m.length; ++i) {
            Class<?> returntype;
            Class<?>[] prototype = m[i].getParameterTypes();
            if (prototype.length > 0 || !(returntype = m[i].getReturnType()).equals(String.class)) continue;
            try {
                result = (String)m[i].invoke((Object)md, args);
                log.info("Method: " + m[i].getName() + " => Success");
            }
            catch (Exception e) {
                log.info("Method: " + m[i].getName() + " => " + e.getMessage());
            }
            mn.add(m[i].getName());
            mr.add(result);
        }
        this.methodNames = mn.toArray(new String[0]);
        this.methodResults = mr.toArray(new String[0]);
    }

    public boolean assignRowValues(ResultSet receiver, int currentRow) throws SQLException {
        if (currentRow < this.methodNames.length) {
            receiver.updateString(1, this.methodNames[currentRow]);
            receiver.updateString(2, this.methodResults[currentRow]);
            return true;
        }
        return false;
    }

    public void close() {
    }
}

