/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.mbeanserver.WeakIdentityHashMap;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.InvalidObjectException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.openmbean.OpenDataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MXBeanLookup {
    private static final ThreadLocal<MXBeanLookup> currentLookup = new ThreadLocal();
    final MBeanServerConnection mbsc;

    private MXBeanLookup(MBeanServerConnection mBeanServerConnection) {
        this.mbsc = mBeanServerConnection;
    }

    static MXBeanLookup lookupFor(MBeanServerConnection mBeanServerConnection, String string) {
        if (string == null) {
            return Plain.lookupFor(mBeanServerConnection);
        }
        return new Prefix(mBeanServerConnection, string);
    }

    abstract <T> T objectNameToMXBean(ObjectName var1, Class<T> var2) throws InvalidObjectException;

    abstract ObjectName mxbeanToObjectName(Object var1) throws OpenDataException;

    ObjectName proxyToObjectName(Object object) {
        MBeanServerInvocationHandler mBeanServerInvocationHandler;
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(object);
        if (invocationHandler instanceof MBeanServerInvocationHandler && (mBeanServerInvocationHandler = (MBeanServerInvocationHandler)invocationHandler).getMBeanServerConnection().equals(this.mbsc)) {
            return mBeanServerInvocationHandler.getObjectName();
        }
        return null;
    }

    static MXBeanLookup getLookup() {
        return currentLookup.get();
    }

    static void setLookup(MXBeanLookup mXBeanLookup) {
        currentLookup.set(mXBeanLookup);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Prefix
    extends MXBeanLookup {
        private final String prefix;

        Prefix(MBeanServerConnection mBeanServerConnection, String string) {
            super(mBeanServerConnection);
            this.prefix = string;
        }

        @Override
        <T> T objectNameToMXBean(ObjectName objectName, Class<T> clazz) throws InvalidObjectException {
            String string = this.prefix + objectName.getDomain();
            try {
                objectName = objectName.withDomain(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw EnvHelp.initCause(new InvalidObjectException(illegalArgumentException.getMessage()), illegalArgumentException);
            }
            return JMX.newMXBeanProxy(this.mbsc, objectName, clazz);
        }

        @Override
        ObjectName mxbeanToObjectName(Object object) throws OpenDataException {
            ObjectName objectName = this.proxyToObjectName(object);
            String string = objectName.getDomain();
            if (!string.startsWith(this.prefix)) {
                throw new OpenDataException("Proxy's name does not start with " + this.prefix + ": " + objectName);
            }
            try {
                objectName = objectName.withDomain(string.substring(this.prefix.length()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw EnvHelp.initCause(new OpenDataException(illegalArgumentException.getMessage()), illegalArgumentException);
            }
            return objectName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Plain
    extends MXBeanLookup {
        private final WeakIdentityHashMap<Object, ObjectName> mxbeanToObjectName = WeakIdentityHashMap.make();
        private final Map<ObjectName, WeakReference<Object>> objectNameToProxy = Util.newMap();
        private static WeakIdentityHashMap<MBeanServerConnection, WeakReference<Plain>> mbscToLookup = WeakIdentityHashMap.make();

        Plain(MBeanServerConnection mBeanServerConnection) {
            super(mBeanServerConnection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Plain lookupFor(MBeanServerConnection mBeanServerConnection) {
            WeakIdentityHashMap<MBeanServerConnection, WeakReference<Plain>> weakIdentityHashMap = mbscToLookup;
            synchronized (weakIdentityHashMap) {
                Plain plain2;
                WeakReference<Plain> weakReference = mbscToLookup.get(mBeanServerConnection);
                Plain plain3 = plain2 = weakReference == null ? null : (Plain)weakReference.get();
                if (plain2 == null) {
                    plain2 = new Plain(mBeanServerConnection);
                    mbscToLookup.put(mBeanServerConnection, new WeakReference<Plain>(plain2));
                }
                return plain2;
            }
        }

        @Override
        synchronized <T> T objectNameToMXBean(ObjectName objectName, Class<T> clazz) {
            Object t;
            WeakReference<Object> weakReference = this.objectNameToProxy.get(objectName);
            if (weakReference != null && clazz.isInstance(t = weakReference.get())) {
                return clazz.cast(t);
            }
            t = JMX.newMXBeanProxy(this.mbsc, objectName, clazz);
            this.objectNameToProxy.put(objectName, new WeakReference(t));
            return t;
        }

        @Override
        synchronized ObjectName mxbeanToObjectName(Object object) throws OpenDataException {
            String string;
            Object object2;
            if (object instanceof Proxy) {
                object2 = Proxy.getInvocationHandler(object);
                if (object2 instanceof MBeanServerInvocationHandler) {
                    MBeanServerInvocationHandler mBeanServerInvocationHandler = (MBeanServerInvocationHandler)object2;
                    if (mBeanServerInvocationHandler.getMBeanServerConnection().equals(this.mbsc)) {
                        return mBeanServerInvocationHandler.getObjectName();
                    }
                    string = "proxy for a different MBeanServer";
                } else {
                    string = "not a JMX proxy";
                }
            } else {
                object2 = this.mxbeanToObjectName.get(object);
                if (object2 != null) {
                    return object2;
                }
                string = "not an MXBean registered in this MBeanServer";
            }
            object2 = object == null ? "null" : "object of type " + object.getClass().getName();
            throw new OpenDataException("Could not convert " + (String)object2 + " to an ObjectName: " + string);
        }

        synchronized void addReference(ObjectName objectName, Object object) throws InstanceAlreadyExistsException {
            String string;
            ObjectName objectName2 = this.mxbeanToObjectName.get(object);
            if (objectName2 != null && !"true".equalsIgnoreCase(string = AccessController.doPrivileged(new GetPropertyAction("jmx.mxbean.multiname")))) {
                throw new InstanceAlreadyExistsException("MXBean already registered with name " + objectName2);
            }
            this.mxbeanToObjectName.put(object, objectName);
        }

        synchronized boolean removeReference(ObjectName objectName, Object object) {
            if (objectName.equals(this.mxbeanToObjectName.get(object))) {
                this.mxbeanToObjectName.remove(object);
                return true;
            }
            return false;
        }
    }
}

