/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.AbstractLog;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.CharBuffer;
import java.util.Map;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagnosticSource {
    protected JavaFileObject fileObject;
    protected Map<JCTree, Integer> endPosTable;
    protected SoftReference<char[]> refBuf;
    protected char[] buf;
    protected int bufLen;
    protected int lineStart;
    protected int line;
    protected AbstractLog log;

    public DiagnosticSource(JavaFileObject javaFileObject, AbstractLog abstractLog) {
        this.fileObject = javaFileObject;
        this.log = abstractLog;
    }

    public JavaFileObject getFile() {
        return this.fileObject;
    }

    public CharSequence getName() {
        return JavacFileManager.getJavacBaseFileName(this.fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineNumber(int n) {
        block3: {
            try {
                if (!this.findLine(n)) break block3;
                int n2 = this.line;
                Object var4_4 = null;
                this.buf = null;
                return n2;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.buf = null;
                throw throwable;
            }
        }
        int n3 = 0;
        Object var4_5 = null;
        this.buf = null;
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getColumnNumber(int n, boolean bl) {
        int n2;
        try {
            if (this.findLine(n)) {
                int n3;
                int n4 = 0;
                for (n3 = this.lineStart; n3 < n; ++n3) {
                    if (n3 >= this.bufLen) {
                        int n5 = 0;
                        Object var7_7 = null;
                        this.buf = null;
                        return n5;
                    }
                    if (this.buf[n3] == '\t' && bl) {
                        n4 = n4 / 8 * 8 + 8;
                        continue;
                    }
                    ++n4;
                }
                n3 = n4 + 1;
                Object var7_8 = null;
                this.buf = null;
                return n3;
            }
            n2 = 0;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.buf = null;
            throw throwable;
        }
        Object var7_9 = null;
        this.buf = null;
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLine(int n) {
        int n2;
        block6: {
            block5: {
                if (this.findLine(n)) break block5;
                String string = null;
                Object var5_4 = null;
                this.buf = null;
                return string;
            }
            try {
                for (n2 = this.lineStart; n2 < this.bufLen && this.buf[n2] != '\r' && this.buf[n2] != '\n'; ++n2) {
                }
                if (n2 - this.lineStart != 0) break block6;
                String string = null;
                Object var5_5 = null;
                this.buf = null;
                return string;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.buf = null;
                throw throwable;
            }
        }
        String string = new String(this.buf, this.lineStart, n2 - this.lineStart);
        Object var5_6 = null;
        this.buf = null;
        return string;
    }

    public Map<JCTree, Integer> getEndPosTable() {
        return this.endPosTable;
    }

    public void setEndPosTable(Map<JCTree, Integer> map) {
        if (this.endPosTable != null && this.endPosTable != map) {
            throw new IllegalStateException("endPosTable already set");
        }
        this.endPosTable = map;
    }

    private boolean findLine(int n) {
        if (n == -1) {
            return false;
        }
        try {
            if (this.buf == null && this.refBuf != null) {
                this.buf = this.refBuf.get();
            }
            if (this.buf == null) {
                this.buf = this.initBuf(this.fileObject);
                this.lineStart = 0;
                this.line = 1;
            } else if (this.lineStart > n) {
                this.lineStart = 0;
                this.line = 1;
            }
            int n2 = this.lineStart;
            while (n2 < this.bufLen && n2 < n) {
                switch (this.buf[n2++]) {
                    case '\r': {
                        if (n2 >= this.bufLen || this.buf[n2] == '\n') {
                            // empty if block
                        }
                        ++this.line;
                        this.lineStart = ++n2;
                        break;
                    }
                    case '\n': {
                        ++this.line;
                        this.lineStart = n2;
                    }
                }
            }
            return n2 <= this.bufLen;
        }
        catch (IOException iOException) {
            this.log.directError("source.unavailable", new Object[0]);
            this.buf = new char[0];
            return false;
        }
    }

    protected char[] initBuf(JavaFileObject javaFileObject) throws IOException {
        char[] cArray;
        CharSequence charSequence = javaFileObject.getCharContent(true);
        if (charSequence instanceof CharBuffer) {
            CharBuffer charBuffer = (CharBuffer)charSequence;
            cArray = JavacFileManager.toArray(charBuffer);
            this.bufLen = charBuffer.limit();
        } else {
            cArray = ((Object)charSequence).toString().toCharArray();
            this.bufLen = cArray.length;
        }
        this.refBuf = new SoftReference<char[]>(cArray);
        return cArray;
    }
}

