/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.util;

import com.sun.tools.internal.ws.util.ToolBase;
import com.sun.xml.internal.ws.util.localization.Localizable;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class JavaCompilerHelper
extends ToolBase {
    protected OutputStream out;
    protected static final Class[] compile141MethodSignature = new Class[2];
    protected static final Class[] constructorSignature;
    protected static final Class[] compileMethodSignature;

    public JavaCompilerHelper(OutputStream outputStream) {
        super(outputStream, " ");
        this.out = outputStream;
    }

    public boolean compile(String[] stringArray) {
        return this.internalCompile(stringArray);
    }

    protected String getResourceBundleName() {
        return "com.sun.tools.internal.ws.resources.javacompiler";
    }

    protected boolean internalCompile(String[] stringArray) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass("com.sun.tools.javac.Main");
            try {
                Method method = clazz.getMethod("compile", compile141MethodSignature);
                try {
                    Object object = method.invoke(null, stringArray, new PrintWriter(this.out));
                    if (!(object instanceof Integer)) {
                        return false;
                    }
                    return (Integer)object == 0;
                }
                catch (IllegalAccessException illegalAccessException) {
                    return false;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
                catch (InvocationTargetException invocationTargetException) {
                    return false;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return this.internalCompilePre141(stringArray);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.onError(this.getMessage("javacompiler.classpath.error", "com.sun.tools.javac.Main"));
            return false;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    protected boolean internalCompilePre141(String[] stringArray) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass("sun.tools.javac.Main");
            try {
                Constructor<?> constructor = clazz.getConstructor(constructorSignature);
                try {
                    Object obj = constructor.newInstance(this.out, "javac");
                    Method method = clazz.getMethod("compile", compileMethodSignature);
                    Object object = method.invoke(obj, new Object[]{stringArray});
                    if (!(object instanceof Boolean)) {
                        return false;
                    }
                    return (Boolean)object;
                }
                catch (InstantiationException instantiationException) {
                    return false;
                }
                catch (IllegalAccessException illegalAccessException) {
                    return false;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
                catch (InvocationTargetException invocationTargetException) {
                    return false;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.onError(this.getMessage("javacompiler.nosuchmethod.error", "getMethod(\"compile\", compileMethodSignature)"));
                return false;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    protected String getGenericErrorMessage() {
        return "javacompiler.error";
    }

    protected void run() {
    }

    protected boolean parseArguments(String[] stringArray) {
        return false;
    }

    public void onError(Localizable localizable) {
        this.report(this.getMessage("javacompiler.error", this.localizer.localize(localizable)));
    }

    static {
        JavaCompilerHelper.compile141MethodSignature[0] = new String[0].getClass();
        JavaCompilerHelper.compile141MethodSignature[1] = PrintWriter.class;
        constructorSignature = new Class[2];
        JavaCompilerHelper.constructorSignature[0] = OutputStream.class;
        JavaCompilerHelper.constructorSignature[1] = String.class;
        compileMethodSignature = new Class[1];
        JavaCompilerHelper.compileMethodSignature[0] = compile141MethodSignature[0];
    }
}

