/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.util;

import com.sun.tools.internal.xjc.util.StringCutter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimeTypeRange {
    public final String majorType;
    public final String subType;
    public final Map<String, String> parameters = new HashMap<String, String>();
    public final float q;
    public static final MimeTypeRange ALL = MimeTypeRange.create("*/*");

    public static List<MimeTypeRange> parseRanges(String string) throws ParseException {
        StringCutter stringCutter = new StringCutter(string, true);
        ArrayList<MimeTypeRange> arrayList = new ArrayList<MimeTypeRange>();
        while (stringCutter.length() > 0) {
            arrayList.add(new MimeTypeRange(stringCutter));
        }
        return arrayList;
    }

    public MimeTypeRange(String string) throws ParseException {
        this(new StringCutter(string, true));
    }

    private static MimeTypeRange create(String string) {
        try {
            return new MimeTypeRange(string);
        }
        catch (ParseException parseException) {
            throw new Error(parseException);
        }
    }

    private MimeTypeRange(StringCutter stringCutter) throws ParseException {
        String string;
        this.majorType = stringCutter.until("/");
        stringCutter.next("/");
        this.subType = stringCutter.until("[;,]");
        float f = 1.0f;
        while (stringCutter.length() > 0 && !(string = stringCutter.next("[;,]")).equals(",")) {
            String string2;
            String string3 = stringCutter.until("=");
            stringCutter.next("=");
            char c = stringCutter.peek();
            if (c == '\"') {
                stringCutter.next("\"");
                string2 = stringCutter.until("\"");
                stringCutter.next("\"");
            } else {
                string2 = stringCutter.until("[;,]");
            }
            if (string3.equals("q")) {
                f = Float.parseFloat(string2);
                continue;
            }
            this.parameters.put(string3, string2);
        }
        this.q = f;
    }

    public MimeType toMimeType() throws MimeTypeParseException {
        return new MimeType(this.toString());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.majorType + '/' + this.subType);
        if (this.q != 1.0f) {
            stringBuilder.append("; q=").append(this.q);
        }
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            stringBuilder.append("; ").append(entry.getKey()).append('=').append(entry.getValue());
        }
        return stringBuilder.toString();
    }

    public static MimeTypeRange merge(Collection<MimeTypeRange> collection) {
        if (collection.size() == 0) {
            throw new IllegalArgumentException();
        }
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        String string = null;
        for (MimeTypeRange mimeTypeRange : collection) {
            if (string == null) {
                string = mimeTypeRange.majorType;
            }
            if (string.equals(mimeTypeRange.majorType)) continue;
            return ALL;
        }
        return MimeTypeRange.create(string + "/*");
    }

    public static void main(String[] stringArray) throws ParseException {
        for (MimeTypeRange mimeTypeRange : MimeTypeRange.parseRanges(stringArray[0])) {
            System.out.println(mimeTypeRange.toString());
        }
    }
}

