/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.internal.toolkit.AnnotationTypeWriter;
import com.sun.tools.doclets.internal.toolkit.ClassWriter;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.MemberSummaryWriter;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractMemberBuilder;
import com.sun.tools.doclets.internal.toolkit.util.DocFinder;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import com.sun.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MemberSummaryBuilder
extends AbstractMemberBuilder {
    public static final String NAME = "MemberSummary";
    private VisibleMemberMap[] visibleMemberMaps;
    private MemberSummaryWriter[] memberSummaryWriters;
    private ClassDoc classDoc;

    private MemberSummaryBuilder(Configuration configuration) {
        super(configuration);
    }

    public static MemberSummaryBuilder getInstance(ClassWriter classWriter, Configuration configuration) throws Exception {
        MemberSummaryBuilder memberSummaryBuilder = new MemberSummaryBuilder(configuration);
        memberSummaryBuilder.classDoc = classWriter.getClassDoc();
        memberSummaryBuilder.init(classWriter);
        return memberSummaryBuilder;
    }

    public static MemberSummaryBuilder getInstance(AnnotationTypeWriter annotationTypeWriter, Configuration configuration) throws Exception {
        MemberSummaryBuilder memberSummaryBuilder = new MemberSummaryBuilder(configuration);
        memberSummaryBuilder.classDoc = annotationTypeWriter.getAnnotationTypeDoc();
        memberSummaryBuilder.init(annotationTypeWriter);
        return memberSummaryBuilder;
    }

    private void init(Object object) throws Exception {
        int n;
        this.visibleMemberMaps = new VisibleMemberMap[7];
        for (n = 0; n < 7; ++n) {
            this.visibleMemberMaps[n] = new VisibleMemberMap(this.classDoc, n, this.configuration.nodeprecated);
        }
        this.memberSummaryWriters = new MemberSummaryWriter[7];
        for (n = 0; n < 7; ++n) {
            this.memberSummaryWriters[n] = this.classDoc.isAnnotationType() ? (this.visibleMemberMaps[n].noVisibleMembers() ? null : this.configuration.getWriterFactory().getMemberSummaryWriter((AnnotationTypeWriter)object, n)) : (this.visibleMemberMaps[n].noVisibleMembers() ? null : this.configuration.getWriterFactory().getMemberSummaryWriter((ClassWriter)object, n));
        }
    }

    public String getName() {
        return NAME;
    }

    public VisibleMemberMap getVisibleMemberMap(int n) {
        return this.visibleMemberMaps[n];
    }

    public MemberSummaryWriter getMemberSummaryWriter(int n) {
        return this.memberSummaryWriters[n];
    }

    public List members(int n) {
        return this.visibleMemberMaps[n].getLeafClassMembers(this.configuration);
    }

    public void invokeMethod(String string, Class[] classArray, Object[] objectArray) throws Exception {
        Method method = this.getClass().getMethod(string, classArray);
        method.invoke((Object)this, objectArray);
    }

    public boolean hasMembersToDocument() {
        if (this.classDoc instanceof AnnotationTypeDoc) {
            return ((AnnotationTypeDoc)this.classDoc).elements().length > 0;
        }
        for (int i = 0; i < 7; ++i) {
            VisibleMemberMap visibleMemberMap = this.visibleMemberMaps[i];
            if (visibleMemberMap.noVisibleMembers()) continue;
            return true;
        }
        return false;
    }

    public void buildEnumConstantsSummary() {
        this.buildSummary(this.memberSummaryWriters[1], this.visibleMemberMaps[1]);
    }

    public void buildAnnotationTypeOptionalMemberSummary() {
        this.buildSummary(this.memberSummaryWriters[5], this.visibleMemberMaps[5]);
    }

    public void buildAnnotationTypeRequiredMemberSummary() {
        this.buildSummary(this.memberSummaryWriters[6], this.visibleMemberMaps[6]);
    }

    public void buildFieldsSummary() {
        this.buildSummary(this.memberSummaryWriters[2], this.visibleMemberMaps[2]);
    }

    public void buildFieldsInheritedSummary() {
        this.buildInheritedSummary(this.memberSummaryWriters[2], this.visibleMemberMaps[2]);
    }

    public void buildNestedClassesSummary() {
        this.buildSummary(this.memberSummaryWriters[0], this.visibleMemberMaps[0]);
    }

    public void buildNestedClassesInheritedSummary() {
        this.buildInheritedSummary(this.memberSummaryWriters[0], this.visibleMemberMaps[0]);
    }

    public void buildMethodsSummary() {
        this.buildSummary(this.memberSummaryWriters[4], this.visibleMemberMaps[4]);
    }

    public void buildMethodsInheritedSummary() {
        this.buildInheritedSummary(this.memberSummaryWriters[4], this.visibleMemberMaps[4]);
    }

    public void buildConstructorsSummary() {
        this.buildSummary(this.memberSummaryWriters[3], this.visibleMemberMaps[3]);
    }

    private void buildSummary(MemberSummaryWriter memberSummaryWriter, VisibleMemberMap visibleMemberMap) {
        ArrayList<ProgramElementDoc> arrayList = new ArrayList<ProgramElementDoc>(visibleMemberMap.getLeafClassMembers(this.configuration));
        if (arrayList.size() > 0) {
            Collections.sort(arrayList);
            memberSummaryWriter.writeMemberSummaryHeader(this.classDoc);
            for (int i = 0; i < arrayList.size(); ++i) {
                ProgramElementDoc programElementDoc = (ProgramElementDoc)arrayList.get(i);
                Tag[] tagArray = programElementDoc.firstSentenceTags();
                if (programElementDoc instanceof MethodDoc && tagArray.length == 0) {
                    DocFinder.Output output = DocFinder.search(new DocFinder.Input((MethodDoc)programElementDoc));
                    if (output.holder != null && output.holder.firstSentenceTags().length > 0) {
                        tagArray = output.holder.firstSentenceTags();
                    }
                }
                memberSummaryWriter.writeMemberSummary(this.classDoc, programElementDoc, tagArray, i == 0, i == arrayList.size() - 1);
            }
            memberSummaryWriter.writeMemberSummaryFooter(this.classDoc);
        }
    }

    private void buildInheritedSummary(MemberSummaryWriter memberSummaryWriter, VisibleMemberMap visibleMemberMap) {
        for (ClassDoc classDoc : visibleMemberMap.getVisibleClassesList()) {
            List<ProgramElementDoc> list;
            if (!classDoc.isPublic() && !Util.isLinkable(classDoc, this.configuration) || classDoc == this.classDoc || (list = visibleMemberMap.getMembersFor(classDoc)).size() <= 0) continue;
            Collections.sort(list);
            memberSummaryWriter.writeInheritedMemberSummaryHeader(classDoc);
            for (int i = 0; i < list.size(); ++i) {
                memberSummaryWriter.writeInheritedMemberSummary(classDoc.isPackagePrivate() && !Util.isLinkable(classDoc, this.configuration) ? this.classDoc : classDoc, list.get(i), i == 0, i == list.size() - 1);
            }
            memberSummaryWriter.writeInheritedMemberSummaryFooter(classDoc);
        }
    }
}

