/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.IllegalComponentStateException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.DisplayChangedListener;

public class SunDisplayChanger {
    private static final Logger log = Logger.getLogger("sun.awt.multiscreen.SunDisplayChanger");
    private Map listeners = Collections.synchronizedMap(new WeakHashMap(1));

    public void add(DisplayChangedListener displayChangedListener) {
        if (log.isLoggable(Level.FINE) && displayChangedListener == null) {
            log.log(Level.FINE, "Assertion (theListener != null) failed");
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Adding listener: " + displayChangedListener);
        }
        this.listeners.put(displayChangedListener, null);
    }

    public void remove(DisplayChangedListener displayChangedListener) {
        if (log.isLoggable(Level.FINE) && displayChangedListener == null) {
            log.log(Level.FINE, "Assertion (theListener != null) failed");
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Removing listener: " + displayChangedListener);
        }
        this.listeners.remove(displayChangedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners() {
        HashMap hashMap;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "notifyListeners");
        }
        Map map = this.listeners;
        synchronized (map) {
            hashMap = new HashMap(this.listeners);
        }
        Set set = hashMap.keySet();
        for (DisplayChangedListener displayChangedListener : set) {
            try {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "displayChanged for listener: " + displayChangedListener);
                }
                displayChangedListener.displayChanged();
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                this.listeners.remove(displayChangedListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPaletteChanged() {
        HashMap hashMap;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("notifyPaletteChanged");
        }
        Map map = this.listeners;
        synchronized (map) {
            hashMap = new HashMap(this.listeners);
        }
        Set set = hashMap.keySet();
        for (DisplayChangedListener displayChangedListener : set) {
            try {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "paletteChanged for listener: " + displayChangedListener);
                }
                displayChangedListener.paletteChanged();
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                this.listeners.remove(displayChangedListener);
            }
        }
    }
}

