/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class DefaultTableCellRenderer
extends JLabel
implements TableCellRenderer,
Serializable {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private Color unselectedForeground;
    private Color unselectedBackground;

    public DefaultTableCellRenderer() {
        this.setOpaque(true);
        this.setBorder(DefaultTableCellRenderer.getNoFocusBorder());
    }

    private static Border getNoFocusBorder() {
        if (System.getSecurityManager() != null) {
            return SAFE_NO_FOCUS_BORDER;
        }
        return noFocusBorder;
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.unselectedForeground = color;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.unselectedBackground = color;
    }

    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Color color = null;
        Color color2 = null;
        JTable.DropLocation dropLocation = jTable.getDropLocation();
        if (dropLocation != null && !dropLocation.isInsertRow() && !dropLocation.isInsertColumn() && dropLocation.getRow() == n && dropLocation.getColumn() == n2) {
            color = UIManager.getColor("Table.dropCellForeground");
            color2 = UIManager.getColor("Table.dropCellBackground");
            bl = true;
        }
        if (bl) {
            super.setForeground(color == null ? jTable.getSelectionForeground() : color);
            super.setBackground(color2 == null ? jTable.getSelectionBackground() : color2);
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : jTable.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : jTable.getBackground());
        }
        this.setFont(jTable.getFont());
        if (bl2) {
            Border border = null;
            if (bl) {
                border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            this.setBorder(border);
            if (!bl && jTable.isCellEditable(n, n2)) {
                Color color3 = UIManager.getColor("Table.focusCellForeground");
                if (color3 != null) {
                    super.setForeground(color3);
                }
                if ((color3 = UIManager.getColor("Table.focusCellBackground")) != null) {
                    super.setBackground(color3);
                }
            }
        } else {
            this.setBorder(DefaultTableCellRenderer.getNoFocusBorder());
        }
        this.setValue(object);
        return this;
    }

    public boolean isOpaque() {
        Color color = this.getBackground();
        Container container = this.getParent();
        if (container != null) {
            container = container.getParent();
        }
        boolean bl = color != null && container != null && color.equals(container.getBackground()) && container.isOpaque();
        return !bl && super.isOpaque();
    }

    public void invalidate() {
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    public void repaint() {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string == "text" || string == "labelFor" || string == "displayedMnemonic" || (string == "font" || string == "foreground") && object != object2 && this.getClientProperty("html") != null) {
            super.firePropertyChange(string, object, object2);
        }
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    protected void setValue(Object object) {
        this.setText(object == null ? "" : object.toString());
    }

    public static class UIResource
    extends DefaultTableCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

