/*	$NetBSD: main.c,v 1.13 2004/01/05 23:23:37 jmmv Exp $	*/

/*
 * Copyright (c) 1983, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Edward Wang at The University of California, Berkeley.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/cdefs.h>

#ifndef lint
__COPYRIGHT("@(#) Copyright (c) 1983, 1993\n\
	The Regents of the University of California.  All rights reserved.\n");
#endif /* not lint */

#ifndef lint
__RCSID("$NetBSD: main.c,v 1.13 2004/01/05 23:23:37 jmmv Exp $");
#endif /* not lint */

#include <err.h>
#include <paths.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "defs.h"
#include "char.h"
#include "local.h"
#include "ww.h"

static void
usage(void)
{
	(void) fprintf(stderr,
	    "usage: %s [-e escape-char] [-c command] [-t] [-f] [-d]\n",
	    getprogname());
	exit(EXIT_FAILURE);
}

int
main(int argc, char **argv)
{
	winvars_t	winvars;
	char *p;
	char fflag = 0;
	char dflag = 0;
	char xflag = 0;
	char *cmd = 0;
	char tflag = 0;
	int ch;

	(void) memset(&winvars, 0x0, sizeof(winvars));
	save_winvars(&winvars);
	winvars.escapec = ESCAPEC;	
	winvars.literalc = LITERALC;	
	winvars.debug = 0;
	while ((ch = getopt(argc, argv, "fc:e:tdDx")) != -1) {
		switch (ch) {
		case 'f':
			fflag++;
			break;
		case 'c':
			if (cmd != 0) {
				warnx("Only one -c allowed");
				usage();
			}
			cmd = optarg;
			break;
		case 'e':
			setescape(&winvars, optarg);
			break;
		case 't':
			tflag++;
			break;
		case 'd':
			dflag++;
			break;
		case 'D':
			winvars.debug += 1;
			break;
		case 'x':
			xflag++;
			break;
		default:
			usage();
		}
	}
	if ((p = getenv("SHELL")) == 0)
		p = strdup(_PATH_BSHELL);
	if ((winvars.default_shellfile = strdup(p)) == 0)
		errx(EXIT_FAILURE, "Out of memory.");
	if ((p = strrchr(winvars.default_shellfile, '/')) == NULL) {
		p = winvars.default_shellfile;
	} else {
		p++;
	}
	winvars.default_shell[0] = p;
	winvars.default_shell[1] = 0;
	winvars.default_nline = NLINE;
	winvars.default_smooth = 1;
	(void) gettimeofday(&winvars.starttime, NULL);
	if (wwinit(&winvars) < 0)
		errx(EXIT_FAILURE, "%s", wwerror(&winvars));

#ifdef OLD_TTY
	if (winvars.debug)
		winvars.wwnewtty.ww_tchars.t_quitc = winvars.wwoldtty.ww_tchars.t_quitc;
	if (xflag) {
		winvars.wwnewtty.ww_tchars.t_stopc = winvars.wwoldtty.ww_tchars.t_stopc;
		winvars.wwnewtty.ww_tchars.t_startc = winvars.wwoldtty.ww_tchars.t_startc;
	}
#else
	if (winvars.debug) {
		winvars.wwnewtty.ww_termios.c_cc[VQUIT] =
			winvars.wwoldtty.ww_termios.c_cc[VQUIT];
		winvars.wwnewtty.ww_termios.c_lflag |= ISIG;
	}
	if (xflag) {
		winvars.wwnewtty.ww_termios.c_cc[VSTOP] =
			winvars.wwoldtty.ww_termios.c_cc[VSTOP];
		winvars.wwnewtty.ww_termios.c_cc[VSTART] =
			winvars.wwoldtty.ww_termios.c_cc[VSTART];
		winvars.wwnewtty.ww_termios.c_iflag |= IXON;
	}
#endif
	if (winvars.debug || xflag)
		(void) wwsettty(&winvars, 0, &winvars.wwnewtty);

	if ((winvars.cmdwin = wwopen(&winvars, WWT_INTERNAL, WWO_REVERSE, 1,
			     winvars.wwncol, 0, 0, 0)) == 0) {
		wwflush(&winvars);
		warnx("%s.\r", wwerror(&winvars));
		goto bad;
	}
	SET(winvars.cmdwin->windowflags,
	    WWW_MAPNL | WWW_NOINTR | WWW_NOUPDATE | WWW_UNCTRL);
	if ((winvars.framewin = wwopen(&winvars, WWT_INTERNAL, WWO_GLASS|WWO_FRAME, winvars.wwnrow,
			       winvars.wwncol, 0, 0, 0)) == 0) {
		wwflush(&winvars);
		warnx("%s.\r", wwerror(&winvars));
		goto bad;
	}
	wwadd(&winvars, winvars.framewin, &winvars.wwhead);
	if ((winvars.boxwin = wwopen(&winvars, WWT_INTERNAL, WWO_GLASS, winvars.wwnrow, winvars.wwncol, 0, 0, 0))
	    == 0) {
		wwflush(&winvars);
		warnx("%s.\r", wwerror(&winvars));
		goto bad;
	}
	winvars.fgwin = winvars.framewin;

	WWUPDATE(&winvars);
	wwflush(&winvars);
	setvars(&winvars);

	setterse(&winvars, tflag);
	setcmd(&winvars, 1);
	if (cmd != 0)
		(void) dolongcmd(cmd, NULL, 0);
	if (!fflag)
		if (dflag || doconfig() < 0)
			dodefault(&winvars);
	if (winvars.selwin != NULL)
		setcmd(&winvars, 0);

	mloop(&winvars);

bad:
	wwend(1);
	return EXIT_SUCCESS;
}
