#ifndef CRITBIT_H_
#define CRITBIT_H_

#ifndef __BEGIN_DECLS
#  if defined(__cplusplus)
#  define __BEGIN_DECLS           extern "C" {
#  define __END_DECLS             }
#  else
#  define __BEGIN_DECLS
#  define __END_DECLS
#  endif
#endif

/* critbit tree structure used for everything */
typedef struct critbit_t {
	void	*root;	/* pointer to root node of tree */
} critbit_t;

__BEGIN_DECLS

int critbit_contains(critbit_t */*tree*/, const void */*key*/, size_t /*namelen*/);
int critbit_insert(critbit_t */*tree*/, const void */*key*/, size_t /*namelen*/);
int critbit_delete(critbit_t */*tree*/, const void */*key*/, size_t /*namelen*/);
void critbit_clear(critbit_t */*tree*/);
int critbit_allprefixed(critbit_t */*tree*/, const void */*prefix*/, size_t /*namelen*/,
			 int (*func)(const char *, void *, size_t), void */*arg*/);
int critbit_length(critbit_t */*tree*/);

__END_DECLS

#endif  /* CRITBIT_H_ */
