/* $Id: constants.h,v 1.1.1.1 2008/09/10 09:32:57 agcrooks Exp $ */

/*
 * Copyright (c) 2005 Manuel Freire.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _BPG_CONSTANTS_H_
#define _BPG_CONSTANTS_H_

#include "packet.h"

/* Public Key Algorithms. */
enum {
	PKA_RSA_ES = 1,
	PKA_RSA_E = 2,
	PKA_RSA_S = 3,
	PKA_ELGAMAL_E = 16, 
	PKA_DSA = 17,
	PKA_EC = 18,
	PKA_ECDSA = 19,
	PKA_ELGAMAL_ES = 20,
	PKA_DH = 21
};

/* Symmetric Key Algorithms. */
enum {
	SKA_PLAINTEXT = 0,
	SKA_IDEA = 1,
	SKA_TRIPEDES = 2,
	SKA_CAST5 = 3,
	SKA_BLOWFISH = 4,
	SKA_SAFER = 5,
	SKA_DES_SK = 6,
	SKA_AES128 = 7,
	SKA_AES192 = 8,
	SKA_AES256 = 9
};

/* Compression Algorithms. */
enum {
	CA_UNCOMPRESSED = 0,
	CA_ZIP = 1,
	CA_ZLIB = 2
};

/* Hash Algorithms. */
enum {
	HA_MD5 = 1,
	HA_SHA1 = 2,
	HA_RIPEMD160 = 3,
	HA_SHA_DW = 4,
	HA_MD2 = 5,
	HA_TIGER192 = 6,
	HA_HAVAL_5_160 = 7
};

/* Additional information: symmetric algorithms key size. */
#define CAST5_KEYSIZE 16
/* ... */

/* Additional information: hash algorithms output size. */
#define SHA1_SIZE 20
/* ... */

/* Algorithms defaults. */
enum {
	BPG_DEFAULT_CIPHER = SKA_CAST5,
	BPG_DEFAULT_PKA = PKA_DSA,
	BPG_DEFAULT_HASH = HA_SHA1,
	BPG_DEFAULT_PKTV = PKTFORMAT_OLD,
	BPG_DEFAULT_SIGV = SIGVERSION_3,
	BPG_DEFAULT_KEYV = KEYVERSION_4
};

#endif /* !_BPG_CONSTANTS_H_ */

