/* $NetBSD$ */

/*
 * Copyright (c) 2003 Dennis I. Chernoivanov
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "paneld.h"

static struct {
	const char *nm;
	struct lcd_dev* (* getops)(void);
} device_cf[] = {
	{ "cons",	get_console },
#if defined(_USE_HD44780)
	{ "hd44780",	get_hd44780 },
#endif
	{ NULL,		NULL        }
};

/*
 * Find device by name and initialize it
 */
struct lcd_dev*
device_attach(const char *type, const char *node)
{
	int i;
	struct lcd_dev *dev;
	if ((type != NULL) && (node != NULL)) {
		for (i = 0; device_cf[i].nm != NULL; i++) {
			if (!strcmp(device_cf[i].nm, type)) {
				dev = device_cf[i].getops();
				if ((dev != NULL) && (dev->open(node) == E_OK))
					return dev;
				break;
			}
		}
	}
	return NULL;
}

/*
 * Close device
 */
void
device_detach(struct lcd_dev *dev)
{
	dev->close();
}
