/*	$NetBSD: w_asin.c,v 1.12 2024/06/09 13:35:38 riastradh Exp $	*/

/* @(#)w_asin.c 5.1 93/09/24 */
/*
 * ====================================================
 * Copyright (C) 1993 by Sun Microsystems, Inc. All rights reserved.
 *
 * Developed at SunPro, a Sun Microsystems, Inc. business.
 * Permission to use, copy, modify, and distribute this
 * software is freely granted, provided that this notice
 * is preserved.
 * ====================================================
 */

#include <sys/cdefs.h>
#if defined(LIBM_SCCS) && !defined(lint)
__RCSID("$NetBSD: w_asin.c,v 1.12 2024/06/09 13:35:38 riastradh Exp $");
#endif

/*
 * wrapper asin(x)
 */

#include "namespace.h"

#include "math.h"
#include "math_private.h"

#ifndef __HAVE_LONG_DOUBLE
__weak_alias(asinl, _asinl)
__strong_alias(_asinl, _asin)
#endif

__weak_alias(asin, _asin)

double
asin(double x)		/* wrapper asin */
{
#ifdef _IEEE_LIBM
	return __ieee754_asin(x);
#else
	double z;
	z = __ieee754_asin(x);
	if(_LIB_VERSION == _IEEE_ || isnan(x)) return z;
	if(fabs(x)>1.0) {
	        return __kernel_standard(x,x,2); /* asin(|x|>1) */
	} else
	    return z;
#endif
}
