//===----------------------- View.h -----------------------------*- C++ -*-===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//
/// \file
///
/// This file defines the main interface for Views. Each view contributes a
/// portion of the final report generated by the tool.
///
//===----------------------------------------------------------------------===//

#ifndef LLVM_TOOLS_LLVM_MCA_VIEW_H
#define LLVM_TOOLS_LLVM_MCA_VIEW_H

#include "llvm/MC/MCInstPrinter.h"
#include "llvm/MCA/HWEventListener.h"
#include "llvm/Support/raw_ostream.h"
#include "llvm/Support/JSON.h"

namespace llvm {
namespace mca {

class View : public HWEventListener {
public:
  enum OutputKind { OK_READABLE, OK_JSON };

  void printView(OutputKind OutputKind, llvm::raw_ostream &OS) {
    if (OutputKind == OK_JSON)
      printViewJSON(OS);
    else
      printView(OS);
  }

  virtual void printView(llvm::raw_ostream &OS) const = 0;
  virtual void printViewJSON(llvm::raw_ostream &OS) {
    json::Object JO;
    JO.try_emplace(getNameAsString().str(), toJSON());
    OS << formatv("{0:2}", json::Value(std::move(JO))) << "\n";
  }
  virtual ~View() = default;
  virtual StringRef getNameAsString() const = 0;
  virtual json::Value toJSON() const { return "not implemented"; }
  void anchor() override;
};
} // namespace mca
} // namespace llvm

#endif
