/*	$NetBSD: fileread_ustarfs.c,v 1.3 2008/04/28 20:23:18 martin Exp $	*/

/*-
 * Copyright (c) 2004 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by UCHIYAMA Yasushi.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifdef _STANDALONE
#include <lib/libsa/stand.h>
#include <lib/libkern/libkern.h>
#endif

#include <sys/types.h>
#include <sys/param.h>
#include "bootxx.h"

#include <machine/sector.h>
#include <machine/sbd.h>

int ustar_size(const char *);

int
fileread(const char *fname, size_t *size)
{
	uint8_t *p = (void *)SDBOOT_PDINFOADDR;

	if (dk_read(16, 1, p) != 0)
		return BERR_TARHDR;

	if (((*(uint32_t *)(p + 256)) & 0xffffff) != 0x757374)
		return BERR_TARMAGIC;

	*size = ustar_size((const char *)(p + 124));
	if (dk_read(17, ROUND_SECTOR(*size) >> DEV_BSHIFT,
	    (void *)SDBOOT_SCRATCHADDR) != 0)
		return BERR_RDFILE;

	return 0;
}

int
ustar_size(const char *p)
{
	int i, j, k;

	for (i = 0, j = 0, k = 1, p += 10; i < 11; i++, p--, k *= 8)
		j += (*p - '0') * k;

	return j;
}
