/* $NetBSD: systrace_args.c,v 1.32 2018/08/10 21:47:16 pgoyette Exp $ */

/*
 * System call argument to DTrace register array converstion.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * This file is part of the DTrace syscall provider.
 */

static void
systrace_args(register_t sysnum, const void *params, uintptr_t *uarg, size_t *n_args)
{
	intptr_t *iarg  = (intptr_t *)uarg;
	switch (sysnum) {
	/* sys_syscall */
	case 0: {
		const struct sys_syscall_args *p = params;
		iarg[0] = SCARG(p, code); /* int */
		iarg[1] = SCARG(p, args[SYS_MAXSYSARGS]); /* register_t */
		*n_args = 2;
		break;
	}
	/* sys_exit */
	case 1: {
		const struct sys_exit_args *p = params;
		iarg[0] = SCARG(p, rval); /* int */
		*n_args = 1;
		break;
	}
	/* sys_fork */
	case 2: {
		*n_args = 0;
		break;
	}
	/* sys_read */
	case 3: {
		const struct sys_read_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf); /* void * */
		uarg[2] = SCARG(p, nbyte); /* size_t */
		*n_args = 3;
		break;
	}
	/* sys_write */
	case 4: {
		const struct sys_write_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf); /* const void * */
		uarg[2] = SCARG(p, nbyte); /* size_t */
		*n_args = 3;
		break;
	}
	/* sys_open */
	case 5: {
		const struct sys_open_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, flags); /* int */
		iarg[2] = SCARG(p, mode); /* mode_t */
		*n_args = 3;
		break;
	}
	/* sys_close */
	case 6: {
		const struct sys_close_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* sys_wait4 */
	case 7: {
		const struct compat_50_sys_wait4_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		uarg[1] = (intptr_t) SCARG(p, status); /* int * */
		iarg[2] = SCARG(p, options); /* int */
		uarg[3] = (intptr_t) SCARG(p, rusage); /* struct rusage50 * */
		*n_args = 4;
		break;
	}
	/* sys_creat */
	case 8: {
		const struct compat_43_sys_creat_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, mode); /* mode_t */
		*n_args = 2;
		break;
	}
	/* sys_link */
	case 9: {
		const struct sys_link_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, link); /* const char * */
		*n_args = 2;
		break;
	}
	/* sys_unlink */
	case 10: {
		const struct sys_unlink_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		*n_args = 1;
		break;
	}
	/* sys_chdir */
	case 12: {
		const struct sys_chdir_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		*n_args = 1;
		break;
	}
	/* sys_fchdir */
	case 13: {
		const struct sys_fchdir_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* sys_mknod */
	case 14: {
		const struct compat_50_sys_mknod_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, mode); /* mode_t */
		uarg[2] = SCARG(p, dev); /* uint32_t */
		*n_args = 3;
		break;
	}
	/* sys_chmod */
	case 15: {
		const struct sys_chmod_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, mode); /* mode_t */
		*n_args = 2;
		break;
	}
	/* sys_chown */
	case 16: {
		const struct sys_chown_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = SCARG(p, uid); /* uid_t */
		iarg[2] = SCARG(p, gid); /* gid_t */
		*n_args = 3;
		break;
	}
	/* sys_obreak */
	case 17: {
		const struct sys_obreak_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, nsize); /* char * */
		*n_args = 1;
		break;
	}
	/* sys_getfsstat */
	case 18: {
		const struct compat_20_sys_getfsstat_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, buf); /* struct statfs12 * */
		iarg[1] = SCARG(p, bufsize); /* long */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* sys_lseek */
	case 19: {
		const struct compat_43_sys_lseek_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, offset); /* long */
		iarg[2] = SCARG(p, whence); /* int */
		*n_args = 3;
		break;
	}
	/* sys_getpid_with_ppid */
	case 20: {
		*n_args = 0;
		break;
	}
	/* sys_mount */
	case 21: {
		const struct compat_40_sys_mount_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, type); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[2] = SCARG(p, flags); /* int */
		uarg[3] = (intptr_t) SCARG(p, data); /* void * */
		*n_args = 4;
		break;
	}
	/* sys_unmount */
	case 22: {
		const struct sys_unmount_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, flags); /* int */
		*n_args = 2;
		break;
	}
	/* sys_setuid */
	case 23: {
		const struct sys_setuid_args *p = params;
		uarg[0] = SCARG(p, uid); /* uid_t */
		*n_args = 1;
		break;
	}
	/* sys_getuid_with_euid */
	case 24: {
		*n_args = 0;
		break;
	}
	/* sys_geteuid */
	case 25: {
		*n_args = 0;
		break;
	}
	/* sys_ptrace */
	case 26: {
		const struct sys_ptrace_args *p = params;
		iarg[0] = SCARG(p, req); /* int */
		iarg[1] = SCARG(p, pid); /* pid_t */
		uarg[2] = (intptr_t) SCARG(p, addr); /* void * */
		iarg[3] = SCARG(p, data); /* int */
		*n_args = 4;
		break;
	}
	/* sys_recvmsg */
	case 27: {
		const struct sys_recvmsg_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, msg); /* struct msghdr * */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* sys_sendmsg */
	case 28: {
		const struct sys_sendmsg_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, msg); /* const struct msghdr * */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* sys_recvfrom */
	case 29: {
		const struct sys_recvfrom_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf); /* void * */
		uarg[2] = SCARG(p, len); /* size_t */
		iarg[3] = SCARG(p, flags); /* int */
		uarg[4] = (intptr_t) SCARG(p, from); /* struct sockaddr * */
		uarg[5] = (intptr_t) SCARG(p, fromlenaddr); /* socklen_t * */
		*n_args = 6;
		break;
	}
	/* sys_accept */
	case 30: {
		const struct sys_accept_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, name); /* struct sockaddr * */
		uarg[2] = (intptr_t) SCARG(p, anamelen); /* socklen_t * */
		*n_args = 3;
		break;
	}
	/* sys_getpeername */
	case 31: {
		const struct sys_getpeername_args *p = params;
		iarg[0] = SCARG(p, fdes); /* int */
		uarg[1] = (intptr_t) SCARG(p, asa); /* struct sockaddr * */
		uarg[2] = (intptr_t) SCARG(p, alen); /* socklen_t * */
		*n_args = 3;
		break;
	}
	/* sys_getsockname */
	case 32: {
		const struct sys_getsockname_args *p = params;
		iarg[0] = SCARG(p, fdes); /* int */
		uarg[1] = (intptr_t) SCARG(p, asa); /* struct sockaddr * */
		uarg[2] = (intptr_t) SCARG(p, alen); /* socklen_t * */
		*n_args = 3;
		break;
	}
	/* sys_access */
	case 33: {
		const struct sys_access_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, flags); /* int */
		*n_args = 2;
		break;
	}
	/* sys_chflags */
	case 34: {
		const struct sys_chflags_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = SCARG(p, flags); /* u_long */
		*n_args = 2;
		break;
	}
	/* sys_fchflags */
	case 35: {
		const struct sys_fchflags_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = SCARG(p, flags); /* u_long */
		*n_args = 2;
		break;
	}
	/* sys_sync */
	case 36: {
		*n_args = 0;
		break;
	}
	/* sys_kill */
	case 37: {
		const struct sys_kill_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		iarg[1] = SCARG(p, signum); /* int */
		*n_args = 2;
		break;
	}
	/* sys_stat */
	case 38: {
		const struct compat_43_sys_stat_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, ub); /* struct stat43 * */
		*n_args = 2;
		break;
	}
	/* sys_getppid */
	case 39: {
		*n_args = 0;
		break;
	}
	/* sys_lstat */
	case 40: {
		const struct compat_43_sys_lstat_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, ub); /* struct stat43 * */
		*n_args = 2;
		break;
	}
	/* sys_dup */
	case 41: {
		const struct sys_dup_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* sys_pipe */
	case 42: {
		*n_args = 0;
		break;
	}
	/* sys_getegid */
	case 43: {
		*n_args = 0;
		break;
	}
	/* sys_profil */
	case 44: {
		const struct sys_profil_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, samples); /* char * */
		uarg[1] = SCARG(p, size); /* size_t */
		uarg[2] = SCARG(p, offset); /* u_long */
		uarg[3] = SCARG(p, scale); /* u_int */
		*n_args = 4;
		break;
	}
	/* sys_ktrace */
	case 45: {
		const struct sys_ktrace_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fname); /* const char * */
		iarg[1] = SCARG(p, ops); /* int */
		iarg[2] = SCARG(p, facs); /* int */
		iarg[3] = SCARG(p, pid); /* pid_t */
		*n_args = 4;
		break;
	}
	/* sys_sigaction */
	case 46: {
		const struct compat_13_sys_sigaction_args *p = params;
		iarg[0] = SCARG(p, signum); /* int */
		uarg[1] = (intptr_t) SCARG(p, nsa); /* const struct sigaction13 * */
		uarg[2] = (intptr_t) SCARG(p, osa); /* struct sigaction13 * */
		*n_args = 3;
		break;
	}
	/* sys_getgid_with_egid */
	case 47: {
		*n_args = 0;
		break;
	}
	/* sys_sigprocmask */
	case 48: {
		const struct compat_13_sys_sigprocmask_args *p = params;
		iarg[0] = SCARG(p, how); /* int */
		iarg[1] = SCARG(p, mask); /* int */
		*n_args = 2;
		break;
	}
	/* sys___getlogin */
	case 49: {
		const struct sys___getlogin_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, namebuf); /* char * */
		uarg[1] = SCARG(p, namelen); /* size_t */
		*n_args = 2;
		break;
	}
	/* sys___setlogin */
	case 50: {
		const struct sys___setlogin_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, namebuf); /* const char * */
		*n_args = 1;
		break;
	}
	/* sys_acct */
	case 51: {
		const struct sys_acct_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		*n_args = 1;
		break;
	}
	/* sys_sigpending */
	case 52: {
		*n_args = 0;
		break;
	}
	/* sys_sigaltstack */
	case 53: {
		const struct compat_13_sys_sigaltstack_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, nss); /* const struct sigaltstack13 * */
		uarg[1] = (intptr_t) SCARG(p, oss); /* struct sigaltstack13 * */
		*n_args = 2;
		break;
	}
	/* sys_ioctl */
	case 54: {
		const struct sys_ioctl_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = SCARG(p, com); /* u_long */
		uarg[2] = (intptr_t) SCARG(p, data); /* void * */
		*n_args = 3;
		break;
	}
	/* sys_reboot */
	case 55: {
		const struct compat_12_sys_reboot_args *p = params;
		iarg[0] = SCARG(p, opt); /* int */
		*n_args = 1;
		break;
	}
	/* sys_revoke */
	case 56: {
		const struct sys_revoke_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		*n_args = 1;
		break;
	}
	/* sys_symlink */
	case 57: {
		const struct sys_symlink_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, link); /* const char * */
		*n_args = 2;
		break;
	}
	/* sys_readlink */
	case 58: {
		const struct sys_readlink_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, buf); /* char * */
		uarg[2] = SCARG(p, count); /* size_t */
		*n_args = 3;
		break;
	}
	/* sys_execve */
	case 59: {
		const struct sys_execve_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, argp); /* char *const * */
		uarg[2] = (intptr_t) SCARG(p, envp); /* char *const * */
		*n_args = 3;
		break;
	}
	/* sys_umask */
	case 60: {
		const struct sys_umask_args *p = params;
		iarg[0] = SCARG(p, newmask); /* mode_t */
		*n_args = 1;
		break;
	}
	/* sys_chroot */
	case 61: {
		const struct sys_chroot_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		*n_args = 1;
		break;
	}
	/* sys_fstat */
	case 62: {
		const struct compat_43_sys_fstat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, sb); /* struct stat43 * */
		*n_args = 2;
		break;
	}
	/* sys_getkerninfo */
	case 63: {
		const struct compat_43_sys_getkerninfo_args *p = params;
		iarg[0] = SCARG(p, op); /* int */
		uarg[1] = (intptr_t) SCARG(p, where); /* char * */
		uarg[2] = (intptr_t) SCARG(p, size); /* int * */
		iarg[3] = SCARG(p, arg); /* int */
		*n_args = 4;
		break;
	}
	/* sys_getpagesize */
	case 64: {
		*n_args = 0;
		break;
	}
	/* sys_msync */
	case 65: {
		const struct compat_12_sys_msync_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr); /* void * */
		uarg[1] = SCARG(p, len); /* size_t */
		*n_args = 2;
		break;
	}
	/* sys_vfork */
	case 66: {
		*n_args = 0;
		break;
	}
	/* sys_mmap */
	case 71: {
		const struct compat_43_sys_mmap_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr); /* void * */
		uarg[1] = SCARG(p, len); /* size_t */
		iarg[2] = SCARG(p, prot); /* int */
		iarg[3] = SCARG(p, flags); /* int */
		iarg[4] = SCARG(p, fd); /* int */
		iarg[5] = SCARG(p, pos); /* long */
		*n_args = 6;
		break;
	}
	/* sys_ovadvise */
	case 72: {
		const struct sys_ovadvise_args *p = params;
		iarg[0] = SCARG(p, anom); /* int */
		*n_args = 1;
		break;
	}
	/* sys_munmap */
	case 73: {
		const struct sys_munmap_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr); /* void * */
		uarg[1] = SCARG(p, len); /* size_t */
		*n_args = 2;
		break;
	}
	/* sys_mprotect */
	case 74: {
		const struct sys_mprotect_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr); /* void * */
		uarg[1] = SCARG(p, len); /* size_t */
		iarg[2] = SCARG(p, prot); /* int */
		*n_args = 3;
		break;
	}
	/* sys_madvise */
	case 75: {
		const struct sys_madvise_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr); /* void * */
		uarg[1] = SCARG(p, len); /* size_t */
		iarg[2] = SCARG(p, behav); /* int */
		*n_args = 3;
		break;
	}
	/* sys_mincore */
	case 78: {
		const struct sys_mincore_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr); /* void * */
		uarg[1] = SCARG(p, len); /* size_t */
		uarg[2] = (intptr_t) SCARG(p, vec); /* char * */
		*n_args = 3;
		break;
	}
	/* sys_getgroups */
	case 79: {
		const struct sys_getgroups_args *p = params;
		iarg[0] = SCARG(p, gidsetsize); /* int */
		uarg[1] = (intptr_t) SCARG(p, gidset); /* gid_t * */
		*n_args = 2;
		break;
	}
	/* sys_setgroups */
	case 80: {
		const struct sys_setgroups_args *p = params;
		iarg[0] = SCARG(p, gidsetsize); /* int */
		uarg[1] = (intptr_t) SCARG(p, gidset); /* const gid_t * */
		*n_args = 2;
		break;
	}
	/* sys_getpgrp */
	case 81: {
		*n_args = 0;
		break;
	}
	/* sys_setpgid */
	case 82: {
		const struct sys_setpgid_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		iarg[1] = SCARG(p, pgid); /* pid_t */
		*n_args = 2;
		break;
	}
	/* sys_setitimer */
	case 83: {
		const struct compat_50_sys_setitimer_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		uarg[1] = (intptr_t) SCARG(p, itv); /* const struct itimerval50 * */
		uarg[2] = (intptr_t) SCARG(p, oitv); /* struct itimerval50 * */
		*n_args = 3;
		break;
	}
	/* sys_wait */
	case 84: {
		*n_args = 0;
		break;
	}
	/* sys_swapon */
	case 85: {
		const struct compat_12_sys_swapon_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, name); /* const char * */
		*n_args = 1;
		break;
	}
	/* sys_getitimer */
	case 86: {
		const struct compat_50_sys_getitimer_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		uarg[1] = (intptr_t) SCARG(p, itv); /* struct itimerval50 * */
		*n_args = 2;
		break;
	}
	/* sys_gethostname */
	case 87: {
		const struct compat_43_sys_gethostname_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, hostname); /* char * */
		uarg[1] = SCARG(p, len); /* u_int */
		*n_args = 2;
		break;
	}
	/* sys_sethostname */
	case 88: {
		const struct compat_43_sys_sethostname_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, hostname); /* char * */
		uarg[1] = SCARG(p, len); /* u_int */
		*n_args = 2;
		break;
	}
	/* sys_getdtablesize */
	case 89: {
		*n_args = 0;
		break;
	}
	/* sys_dup2 */
	case 90: {
		const struct sys_dup2_args *p = params;
		iarg[0] = SCARG(p, from); /* int */
		iarg[1] = SCARG(p, to); /* int */
		*n_args = 2;
		break;
	}
	/* sys_fcntl */
	case 92: {
		const struct sys_fcntl_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, cmd); /* int */
		uarg[2] = (intptr_t) SCARG(p, arg); /* void * */
		*n_args = 3;
		break;
	}
	/* sys_select */
	case 93: {
		const struct compat_50_sys_select_args *p = params;
		iarg[0] = SCARG(p, nd); /* int */
		uarg[1] = (intptr_t) SCARG(p, in); /* fd_set * */
		uarg[2] = (intptr_t) SCARG(p, ou); /* fd_set * */
		uarg[3] = (intptr_t) SCARG(p, ex); /* fd_set * */
		uarg[4] = (intptr_t) SCARG(p, tv); /* struct timeval50 * */
		*n_args = 5;
		break;
	}
	/* sys_fsync */
	case 95: {
		const struct sys_fsync_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* sys_setpriority */
	case 96: {
		const struct sys_setpriority_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		iarg[1] = SCARG(p, who); /* id_t */
		iarg[2] = SCARG(p, prio); /* int */
		*n_args = 3;
		break;
	}
	/* sys_socket */
	case 97: {
		const struct compat_30_sys_socket_args *p = params;
		iarg[0] = SCARG(p, domain); /* int */
		iarg[1] = SCARG(p, type); /* int */
		iarg[2] = SCARG(p, protocol); /* int */
		*n_args = 3;
		break;
	}
	/* sys_connect */
	case 98: {
		const struct sys_connect_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, name); /* const struct sockaddr * */
		iarg[2] = SCARG(p, namelen); /* socklen_t */
		*n_args = 3;
		break;
	}
	/* sys_accept */
	case 99: {
		const struct compat_43_sys_accept_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, name); /* void * */
		uarg[2] = (intptr_t) SCARG(p, anamelen); /* socklen_t * */
		*n_args = 3;
		break;
	}
	/* sys_getpriority */
	case 100: {
		const struct sys_getpriority_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		iarg[1] = SCARG(p, who); /* id_t */
		*n_args = 2;
		break;
	}
	/* sys_send */
	case 101: {
		const struct compat_43_sys_send_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf); /* void * */
		iarg[2] = SCARG(p, len); /* int */
		iarg[3] = SCARG(p, flags); /* int */
		*n_args = 4;
		break;
	}
	/* sys_recv */
	case 102: {
		const struct compat_43_sys_recv_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf); /* void * */
		iarg[2] = SCARG(p, len); /* int */
		iarg[3] = SCARG(p, flags); /* int */
		*n_args = 4;
		break;
	}
	/* sys_sigreturn */
	case 103: {
		const struct compat_13_sys_sigreturn_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, sigcntxp); /* struct sigcontext13 * */
		*n_args = 1;
		break;
	}
	/* sys_bind */
	case 104: {
		const struct sys_bind_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, name); /* const struct sockaddr * */
		iarg[2] = SCARG(p, namelen); /* socklen_t */
		*n_args = 3;
		break;
	}
	/* sys_setsockopt */
	case 105: {
		const struct sys_setsockopt_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		iarg[1] = SCARG(p, level); /* int */
		iarg[2] = SCARG(p, name); /* int */
		uarg[3] = (intptr_t) SCARG(p, val); /* const void * */
		iarg[4] = SCARG(p, valsize); /* socklen_t */
		*n_args = 5;
		break;
	}
	/* sys_listen */
	case 106: {
		const struct sys_listen_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		iarg[1] = SCARG(p, backlog); /* int */
		*n_args = 2;
		break;
	}
	/* sys_sigvec */
	case 108: {
		const struct compat_43_sys_sigvec_args *p = params;
		iarg[0] = SCARG(p, signum); /* int */
		uarg[1] = (intptr_t) SCARG(p, nsv); /* struct sigvec * */
		uarg[2] = (intptr_t) SCARG(p, osv); /* struct sigvec * */
		*n_args = 3;
		break;
	}
	/* sys_sigblock */
	case 109: {
		const struct compat_43_sys_sigblock_args *p = params;
		iarg[0] = SCARG(p, mask); /* int */
		*n_args = 1;
		break;
	}
	/* sys_sigsetmask */
	case 110: {
		const struct compat_43_sys_sigsetmask_args *p = params;
		iarg[0] = SCARG(p, mask); /* int */
		*n_args = 1;
		break;
	}
	/* sys_sigsuspend */
	case 111: {
		const struct compat_13_sys_sigsuspend_args *p = params;
		iarg[0] = SCARG(p, mask); /* int */
		*n_args = 1;
		break;
	}
	/* sys_sigstack */
	case 112: {
		const struct compat_43_sys_sigstack_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, nss); /* struct sigstack * */
		uarg[1] = (intptr_t) SCARG(p, oss); /* struct sigstack * */
		*n_args = 2;
		break;
	}
	/* sys_recvmsg */
	case 113: {
		const struct compat_43_sys_recvmsg_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, msg); /* struct omsghdr * */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* sys_sendmsg */
	case 114: {
		const struct compat_43_sys_sendmsg_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, msg); /* void * */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* sys_gettimeofday */
	case 116: {
		const struct compat_50_sys_gettimeofday_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, tp); /* struct timeval50 * */
		uarg[1] = (intptr_t) SCARG(p, tzp); /* void * */
		*n_args = 2;
		break;
	}
	/* sys_getrusage */
	case 117: {
		const struct compat_50_sys_getrusage_args *p = params;
		iarg[0] = SCARG(p, who); /* int */
		uarg[1] = (intptr_t) SCARG(p, rusage); /* struct rusage50 * */
		*n_args = 2;
		break;
	}
	/* sys_getsockopt */
	case 118: {
		const struct sys_getsockopt_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		iarg[1] = SCARG(p, level); /* int */
		iarg[2] = SCARG(p, name); /* int */
		uarg[3] = (intptr_t) SCARG(p, val); /* void * */
		uarg[4] = (intptr_t) SCARG(p, avalsize); /* socklen_t * */
		*n_args = 5;
		break;
	}
	/* sys_readv */
	case 120: {
		const struct sys_readv_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, iovp); /* const struct iovec * */
		iarg[2] = SCARG(p, iovcnt); /* int */
		*n_args = 3;
		break;
	}
	/* sys_writev */
	case 121: {
		const struct sys_writev_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, iovp); /* const struct iovec * */
		iarg[2] = SCARG(p, iovcnt); /* int */
		*n_args = 3;
		break;
	}
	/* sys_settimeofday */
	case 122: {
		const struct compat_50_sys_settimeofday_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, tv); /* const struct timeval50 * */
		uarg[1] = (intptr_t) SCARG(p, tzp); /* const void * */
		*n_args = 2;
		break;
	}
	/* sys_fchown */
	case 123: {
		const struct sys_fchown_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = SCARG(p, uid); /* uid_t */
		iarg[2] = SCARG(p, gid); /* gid_t */
		*n_args = 3;
		break;
	}
	/* sys_fchmod */
	case 124: {
		const struct sys_fchmod_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, mode); /* mode_t */
		*n_args = 2;
		break;
	}
	/* sys_recvfrom */
	case 125: {
		const struct compat_43_sys_recvfrom_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf); /* void * */
		uarg[2] = SCARG(p, len); /* size_t */
		iarg[3] = SCARG(p, flags); /* int */
		uarg[4] = (intptr_t) SCARG(p, from); /* void * */
		uarg[5] = (intptr_t) SCARG(p, fromlenaddr); /* socklen_t * */
		*n_args = 6;
		break;
	}
	/* sys_setreuid */
	case 126: {
		const struct sys_setreuid_args *p = params;
		uarg[0] = SCARG(p, ruid); /* uid_t */
		uarg[1] = SCARG(p, euid); /* uid_t */
		*n_args = 2;
		break;
	}
	/* sys_setregid */
	case 127: {
		const struct sys_setregid_args *p = params;
		iarg[0] = SCARG(p, rgid); /* gid_t */
		iarg[1] = SCARG(p, egid); /* gid_t */
		*n_args = 2;
		break;
	}
	/* sys_rename */
	case 128: {
		const struct sys_rename_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, from); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, to); /* const char * */
		*n_args = 2;
		break;
	}
	/* sys_truncate */
	case 129: {
		const struct compat_43_sys_truncate_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, length); /* long */
		*n_args = 2;
		break;
	}
	/* sys_ftruncate */
	case 130: {
		const struct compat_43_sys_ftruncate_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, length); /* long */
		*n_args = 2;
		break;
	}
	/* sys_flock */
	case 131: {
		const struct sys_flock_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, how); /* int */
		*n_args = 2;
		break;
	}
	/* sys_mkfifo */
	case 132: {
		const struct sys_mkfifo_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, mode); /* mode_t */
		*n_args = 2;
		break;
	}
	/* sys_sendto */
	case 133: {
		const struct sys_sendto_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf); /* const void * */
		uarg[2] = SCARG(p, len); /* size_t */
		iarg[3] = SCARG(p, flags); /* int */
		uarg[4] = (intptr_t) SCARG(p, to); /* const struct sockaddr * */
		iarg[5] = SCARG(p, tolen); /* socklen_t */
		*n_args = 6;
		break;
	}
	/* sys_shutdown */
	case 134: {
		const struct sys_shutdown_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		iarg[1] = SCARG(p, how); /* int */
		*n_args = 2;
		break;
	}
	/* sys_socketpair */
	case 135: {
		const struct sys_socketpair_args *p = params;
		iarg[0] = SCARG(p, domain); /* int */
		iarg[1] = SCARG(p, type); /* int */
		iarg[2] = SCARG(p, protocol); /* int */
		uarg[3] = (intptr_t) SCARG(p, rsv); /* int * */
		*n_args = 4;
		break;
	}
	/* sys_mkdir */
	case 136: {
		const struct sys_mkdir_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, mode); /* mode_t */
		*n_args = 2;
		break;
	}
	/* sys_rmdir */
	case 137: {
		const struct sys_rmdir_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		*n_args = 1;
		break;
	}
	/* sys_utimes */
	case 138: {
		const struct compat_50_sys_utimes_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, tptr); /* const struct timeval50 * */
		*n_args = 2;
		break;
	}
	/* sys_adjtime */
	case 140: {
		const struct compat_50_sys_adjtime_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, delta); /* const struct timeval50 * */
		uarg[1] = (intptr_t) SCARG(p, olddelta); /* struct timeval50 * */
		*n_args = 2;
		break;
	}
	/* sys_getpeername */
	case 141: {
		const struct compat_43_sys_getpeername_args *p = params;
		iarg[0] = SCARG(p, fdes); /* int */
		uarg[1] = (intptr_t) SCARG(p, asa); /* void * */
		uarg[2] = (intptr_t) SCARG(p, alen); /* socklen_t * */
		*n_args = 3;
		break;
	}
	/* sys_gethostid */
	case 142: {
		*n_args = 0;
		break;
	}
	/* sys_sethostid */
	case 143: {
		const struct compat_43_sys_sethostid_args *p = params;
		iarg[0] = SCARG(p, hostid); /* int32_t */
		*n_args = 1;
		break;
	}
	/* sys_getrlimit */
	case 144: {
		const struct compat_43_sys_getrlimit_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		uarg[1] = (intptr_t) SCARG(p, rlp); /* struct orlimit * */
		*n_args = 2;
		break;
	}
	/* sys_setrlimit */
	case 145: {
		const struct compat_43_sys_setrlimit_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		uarg[1] = (intptr_t) SCARG(p, rlp); /* const struct orlimit * */
		*n_args = 2;
		break;
	}
	/* sys_killpg */
	case 146: {
		const struct compat_43_sys_killpg_args *p = params;
		iarg[0] = SCARG(p, pgid); /* int */
		iarg[1] = SCARG(p, signum); /* int */
		*n_args = 2;
		break;
	}
	/* sys_setsid */
	case 147: {
		*n_args = 0;
		break;
	}
	/* sys_quotactl */
	case 148: {
		const struct compat_50_sys_quotactl_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, cmd); /* int */
		iarg[2] = SCARG(p, uid); /* int */
		uarg[3] = (intptr_t) SCARG(p, arg); /* void * */
		*n_args = 4;
		break;
	}
	/* sys_quota */
	case 149: {
		*n_args = 0;
		break;
	}
	/* sys_getsockname */
	case 150: {
		const struct compat_43_sys_getsockname_args *p = params;
		iarg[0] = SCARG(p, fdec); /* int */
		uarg[1] = (intptr_t) SCARG(p, asa); /* void * */
		uarg[2] = (intptr_t) SCARG(p, alen); /* socklen_t * */
		*n_args = 3;
		break;
	}
	/* sys_nfssvc */
	case 155: {
		const struct sys_nfssvc_args *p = params;
		iarg[0] = SCARG(p, flag); /* int */
		uarg[1] = (intptr_t) SCARG(p, argp); /* void * */
		*n_args = 2;
		break;
	}
	/* sys_getdirentries */
	case 156: {
		const struct compat_43_sys_getdirentries_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf); /* char * */
		uarg[2] = SCARG(p, count); /* u_int */
		uarg[3] = (intptr_t) SCARG(p, basep); /* long * */
		*n_args = 4;
		break;
	}
	/* sys_statfs */
	case 157: {
		const struct compat_20_sys_statfs_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, buf); /* struct statfs12 * */
		*n_args = 2;
		break;
	}
	/* sys_fstatfs */
	case 158: {
		const struct compat_20_sys_fstatfs_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf); /* struct statfs12 * */
		*n_args = 2;
		break;
	}
	/* sys_getfh */
	case 161: {
		const struct compat_30_sys_getfh_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fname); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, fhp); /* struct compat_30_fhandle * */
		*n_args = 2;
		break;
	}
	/* sys_getdomainname */
	case 162: {
		const struct compat_09_sys_getdomainname_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, domainname); /* char * */
		iarg[1] = SCARG(p, len); /* int */
		*n_args = 2;
		break;
	}
	/* sys_setdomainname */
	case 163: {
		const struct compat_09_sys_setdomainname_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, domainname); /* char * */
		iarg[1] = SCARG(p, len); /* int */
		*n_args = 2;
		break;
	}
	/* sys_uname */
	case 164: {
		const struct compat_09_sys_uname_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, name); /* struct outsname * */
		*n_args = 1;
		break;
	}
	/* sys_sysarch */
	case 165: {
		const struct sys_sysarch_args *p = params;
		iarg[0] = SCARG(p, op); /* int */
		uarg[1] = (intptr_t) SCARG(p, parms); /* void * */
		*n_args = 2;
		break;
	}
#if !defined(_LP64)
	/* sys_semsys */
	case 169: {
		const struct compat_10_sys_semsys_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		iarg[1] = SCARG(p, a2); /* int */
		iarg[2] = SCARG(p, a3); /* int */
		iarg[3] = SCARG(p, a4); /* int */
		iarg[4] = SCARG(p, a5); /* int */
		*n_args = 5;
		break;
	}
#else
#endif
#if !defined(_LP64)
	/* sys_msgsys */
	case 170: {
		const struct compat_10_sys_msgsys_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		iarg[1] = SCARG(p, a2); /* int */
		iarg[2] = SCARG(p, a3); /* int */
		iarg[3] = SCARG(p, a4); /* int */
		iarg[4] = SCARG(p, a5); /* int */
		iarg[5] = SCARG(p, a6); /* int */
		*n_args = 6;
		break;
	}
#else
#endif
#if !defined(_LP64)
	/* sys_shmsys */
	case 171: {
		const struct compat_10_sys_shmsys_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		iarg[1] = SCARG(p, a2); /* int */
		iarg[2] = SCARG(p, a3); /* int */
		iarg[3] = SCARG(p, a4); /* int */
		*n_args = 4;
		break;
	}
#else
#endif
	/* sys_pread */
	case 173: {
		const struct sys_pread_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf); /* void * */
		uarg[2] = SCARG(p, nbyte); /* size_t */
		iarg[3] = SCARG(p, PAD); /* int */
		iarg[4] = SCARG(p, offset); /* off_t */
		*n_args = 5;
		break;
	}
	/* sys_pwrite */
	case 174: {
		const struct sys_pwrite_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf); /* const void * */
		uarg[2] = SCARG(p, nbyte); /* size_t */
		iarg[3] = SCARG(p, PAD); /* int */
		iarg[4] = SCARG(p, offset); /* off_t */
		*n_args = 5;
		break;
	}
	/* sys_ntp_gettime */
	case 175: {
		const struct compat_30_sys_ntp_gettime_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, ntvp); /* struct ntptimeval30 * */
		*n_args = 1;
		break;
	}
#if defined(NTP) || !defined(_KERNEL_OPT)
	/* sys_ntp_adjtime */
	case 176: {
		const struct sys_ntp_adjtime_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, tp); /* struct timex * */
		*n_args = 1;
		break;
	}
#else
#endif
	/* sys_setgid */
	case 181: {
		const struct sys_setgid_args *p = params;
		iarg[0] = SCARG(p, gid); /* gid_t */
		*n_args = 1;
		break;
	}
	/* sys_setegid */
	case 182: {
		const struct sys_setegid_args *p = params;
		iarg[0] = SCARG(p, egid); /* gid_t */
		*n_args = 1;
		break;
	}
	/* sys_seteuid */
	case 183: {
		const struct sys_seteuid_args *p = params;
		uarg[0] = SCARG(p, euid); /* uid_t */
		*n_args = 1;
		break;
	}
	/* sys_lfs_bmapv */
	case 184: {
		const struct sys_lfs_bmapv_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fsidp); /* fsid_t * */
		uarg[1] = (intptr_t) SCARG(p, blkiov); /* struct block_info * */
		iarg[2] = SCARG(p, blkcnt); /* int */
		*n_args = 3;
		break;
	}
	/* sys_lfs_markv */
	case 185: {
		const struct sys_lfs_markv_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fsidp); /* fsid_t * */
		uarg[1] = (intptr_t) SCARG(p, blkiov); /* struct block_info * */
		iarg[2] = SCARG(p, blkcnt); /* int */
		*n_args = 3;
		break;
	}
	/* sys_lfs_segclean */
	case 186: {
		const struct sys_lfs_segclean_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fsidp); /* fsid_t * */
		uarg[1] = SCARG(p, segment); /* u_long */
		*n_args = 2;
		break;
	}
	/* sys_lfs_segwait */
	case 187: {
		const struct compat_50_sys_lfs_segwait_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fsidp); /* fsid_t * */
		uarg[1] = (intptr_t) SCARG(p, tv); /* struct timeval50 * */
		*n_args = 2;
		break;
	}
	/* sys_stat */
	case 188: {
		const struct compat_12_sys_stat_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, ub); /* struct stat12 * */
		*n_args = 2;
		break;
	}
	/* sys_fstat */
	case 189: {
		const struct compat_12_sys_fstat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, sb); /* struct stat12 * */
		*n_args = 2;
		break;
	}
	/* sys_lstat */
	case 190: {
		const struct compat_12_sys_lstat_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, ub); /* struct stat12 * */
		*n_args = 2;
		break;
	}
	/* sys_pathconf */
	case 191: {
		const struct sys_pathconf_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, name); /* int */
		*n_args = 2;
		break;
	}
	/* sys_fpathconf */
	case 192: {
		const struct sys_fpathconf_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, name); /* int */
		*n_args = 2;
		break;
	}
	/* sys_getsockopt2 */
	case 193: {
		const struct sys_getsockopt2_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		iarg[1] = SCARG(p, level); /* int */
		iarg[2] = SCARG(p, name); /* int */
		uarg[3] = (intptr_t) SCARG(p, val); /* void * */
		uarg[4] = (intptr_t) SCARG(p, avalsize); /* socklen_t * */
		*n_args = 5;
		break;
	}
	/* sys_getrlimit */
	case 194: {
		const struct sys_getrlimit_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		uarg[1] = (intptr_t) SCARG(p, rlp); /* struct rlimit * */
		*n_args = 2;
		break;
	}
	/* sys_setrlimit */
	case 195: {
		const struct sys_setrlimit_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		uarg[1] = (intptr_t) SCARG(p, rlp); /* const struct rlimit * */
		*n_args = 2;
		break;
	}
	/* sys_getdirentries */
	case 196: {
		const struct compat_12_sys_getdirentries_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf); /* char * */
		uarg[2] = SCARG(p, count); /* u_int */
		uarg[3] = (intptr_t) SCARG(p, basep); /* long * */
		*n_args = 4;
		break;
	}
	/* sys_mmap */
	case 197: {
		const struct sys_mmap_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr); /* void * */
		uarg[1] = SCARG(p, len); /* size_t */
		iarg[2] = SCARG(p, prot); /* int */
		iarg[3] = SCARG(p, flags); /* int */
		iarg[4] = SCARG(p, fd); /* int */
		iarg[5] = SCARG(p, PAD); /* long */
		iarg[6] = SCARG(p, pos); /* off_t */
		*n_args = 7;
		break;
	}
	/* sys___syscall */
	case 198: {
		const struct sys___syscall_args *p = params;
		iarg[0] = SCARG(p, code); /* quad_t */
		iarg[1] = SCARG(p, args[SYS_MAXSYSARGS]); /* register_t */
		*n_args = 2;
		break;
	}
	/* sys_lseek */
	case 199: {
		const struct sys_lseek_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, PAD); /* int */
		iarg[2] = SCARG(p, offset); /* off_t */
		iarg[3] = SCARG(p, whence); /* int */
		*n_args = 4;
		break;
	}
	/* sys_truncate */
	case 200: {
		const struct sys_truncate_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, PAD); /* int */
		iarg[2] = SCARG(p, length); /* off_t */
		*n_args = 3;
		break;
	}
	/* sys_ftruncate */
	case 201: {
		const struct sys_ftruncate_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, PAD); /* int */
		iarg[2] = SCARG(p, length); /* off_t */
		*n_args = 3;
		break;
	}
	/* sys___sysctl */
	case 202: {
		const struct sys___sysctl_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, name); /* const int * */
		uarg[1] = SCARG(p, namelen); /* u_int */
		uarg[2] = (intptr_t) SCARG(p, oldv); /* void * */
		uarg[3] = (intptr_t) SCARG(p, oldlenp); /* size_t * */
		uarg[4] = (intptr_t) SCARG(p, newv); /* const void * */
		uarg[5] = SCARG(p, newlen); /* size_t */
		*n_args = 6;
		break;
	}
	/* sys_mlock */
	case 203: {
		const struct sys_mlock_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr); /* const void * */
		uarg[1] = SCARG(p, len); /* size_t */
		*n_args = 2;
		break;
	}
	/* sys_munlock */
	case 204: {
		const struct sys_munlock_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr); /* const void * */
		uarg[1] = SCARG(p, len); /* size_t */
		*n_args = 2;
		break;
	}
	/* sys_undelete */
	case 205: {
		const struct sys_undelete_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		*n_args = 1;
		break;
	}
	/* sys_futimes */
	case 206: {
		const struct compat_50_sys_futimes_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, tptr); /* const struct timeval50 * */
		*n_args = 2;
		break;
	}
	/* sys_getpgid */
	case 207: {
		const struct sys_getpgid_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		*n_args = 1;
		break;
	}
	/* sys_reboot */
	case 208: {
		const struct sys_reboot_args *p = params;
		iarg[0] = SCARG(p, opt); /* int */
		uarg[1] = (intptr_t) SCARG(p, bootstr); /* char * */
		*n_args = 2;
		break;
	}
	/* sys_poll */
	case 209: {
		const struct sys_poll_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fds); /* struct pollfd * */
		uarg[1] = SCARG(p, nfds); /* u_int */
		iarg[2] = SCARG(p, timeout); /* int */
		*n_args = 3;
		break;
	}
	/* sys_afssys */
	case 210: {
		const struct sys_afssys_args *p = params;
		iarg[0] = SCARG(p, id); /* long */
		iarg[1] = SCARG(p, a1); /* long */
		iarg[2] = SCARG(p, a2); /* long */
		iarg[3] = SCARG(p, a3); /* long */
		iarg[4] = SCARG(p, a4); /* long */
		iarg[5] = SCARG(p, a5); /* long */
		iarg[6] = SCARG(p, a6); /* long */
		*n_args = 7;
		break;
	}
	/* sys___semctl */
	case 220: {
		const struct compat_14_sys___semctl_args *p = params;
		iarg[0] = SCARG(p, semid); /* int */
		iarg[1] = SCARG(p, semnum); /* int */
		iarg[2] = SCARG(p, cmd); /* int */
		uarg[3] = (intptr_t) SCARG(p, arg); /* union __semun * */
		*n_args = 4;
		break;
	}
	/* sys_semget */
	case 221: {
		const struct sys_semget_args *p = params;
		iarg[0] = SCARG(p, key); /* key_t */
		iarg[1] = SCARG(p, nsems); /* int */
		iarg[2] = SCARG(p, semflg); /* int */
		*n_args = 3;
		break;
	}
	/* sys_semop */
	case 222: {
		const struct sys_semop_args *p = params;
		iarg[0] = SCARG(p, semid); /* int */
		uarg[1] = (intptr_t) SCARG(p, sops); /* struct sembuf * */
		uarg[2] = SCARG(p, nsops); /* size_t */
		*n_args = 3;
		break;
	}
	/* sys_semconfig */
	case 223: {
		const struct sys_semconfig_args *p = params;
		iarg[0] = SCARG(p, flag); /* int */
		*n_args = 1;
		break;
	}
	/* sys_msgctl */
	case 224: {
		const struct compat_14_sys_msgctl_args *p = params;
		iarg[0] = SCARG(p, msqid); /* int */
		iarg[1] = SCARG(p, cmd); /* int */
		uarg[2] = (intptr_t) SCARG(p, buf); /* struct msqid_ds14 * */
		*n_args = 3;
		break;
	}
	/* sys_msgget */
	case 225: {
		const struct sys_msgget_args *p = params;
		iarg[0] = SCARG(p, key); /* key_t */
		iarg[1] = SCARG(p, msgflg); /* int */
		*n_args = 2;
		break;
	}
	/* sys_msgsnd */
	case 226: {
		const struct sys_msgsnd_args *p = params;
		iarg[0] = SCARG(p, msqid); /* int */
		uarg[1] = (intptr_t) SCARG(p, msgp); /* const void * */
		uarg[2] = SCARG(p, msgsz); /* size_t */
		iarg[3] = SCARG(p, msgflg); /* int */
		*n_args = 4;
		break;
	}
	/* sys_msgrcv */
	case 227: {
		const struct sys_msgrcv_args *p = params;
		iarg[0] = SCARG(p, msqid); /* int */
		uarg[1] = (intptr_t) SCARG(p, msgp); /* void * */
		uarg[2] = SCARG(p, msgsz); /* size_t */
		iarg[3] = SCARG(p, msgtyp); /* long */
		iarg[4] = SCARG(p, msgflg); /* int */
		*n_args = 5;
		break;
	}
	/* sys_shmat */
	case 228: {
		const struct sys_shmat_args *p = params;
		iarg[0] = SCARG(p, shmid); /* int */
		uarg[1] = (intptr_t) SCARG(p, shmaddr); /* const void * */
		iarg[2] = SCARG(p, shmflg); /* int */
		*n_args = 3;
		break;
	}
	/* sys_shmctl */
	case 229: {
		const struct compat_14_sys_shmctl_args *p = params;
		iarg[0] = SCARG(p, shmid); /* int */
		iarg[1] = SCARG(p, cmd); /* int */
		uarg[2] = (intptr_t) SCARG(p, buf); /* struct shmid_ds14 * */
		*n_args = 3;
		break;
	}
	/* sys_shmdt */
	case 230: {
		const struct sys_shmdt_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, shmaddr); /* const void * */
		*n_args = 1;
		break;
	}
	/* sys_shmget */
	case 231: {
		const struct sys_shmget_args *p = params;
		iarg[0] = SCARG(p, key); /* key_t */
		uarg[1] = SCARG(p, size); /* size_t */
		iarg[2] = SCARG(p, shmflg); /* int */
		*n_args = 3;
		break;
	}
	/* sys_clock_gettime */
	case 232: {
		const struct compat_50_sys_clock_gettime_args *p = params;
		iarg[0] = SCARG(p, clock_id); /* clockid_t */
		uarg[1] = (intptr_t) SCARG(p, tp); /* struct timespec50 * */
		*n_args = 2;
		break;
	}
	/* sys_clock_settime */
	case 233: {
		const struct compat_50_sys_clock_settime_args *p = params;
		iarg[0] = SCARG(p, clock_id); /* clockid_t */
		uarg[1] = (intptr_t) SCARG(p, tp); /* const struct timespec50 * */
		*n_args = 2;
		break;
	}
	/* sys_clock_getres */
	case 234: {
		const struct compat_50_sys_clock_getres_args *p = params;
		iarg[0] = SCARG(p, clock_id); /* clockid_t */
		uarg[1] = (intptr_t) SCARG(p, tp); /* struct timespec50 * */
		*n_args = 2;
		break;
	}
	/* sys_timer_create */
	case 235: {
		const struct sys_timer_create_args *p = params;
		iarg[0] = SCARG(p, clock_id); /* clockid_t */
		uarg[1] = (intptr_t) SCARG(p, evp); /* struct sigevent * */
		uarg[2] = (intptr_t) SCARG(p, timerid); /* timer_t * */
		*n_args = 3;
		break;
	}
	/* sys_timer_delete */
	case 236: {
		const struct sys_timer_delete_args *p = params;
		iarg[0] = SCARG(p, timerid); /* timer_t */
		*n_args = 1;
		break;
	}
	/* sys_timer_settime */
	case 237: {
		const struct compat_50_sys_timer_settime_args *p = params;
		iarg[0] = SCARG(p, timerid); /* timer_t */
		iarg[1] = SCARG(p, flags); /* int */
		uarg[2] = (intptr_t) SCARG(p, value); /* const struct itimerspec50 * */
		uarg[3] = (intptr_t) SCARG(p, ovalue); /* struct itimerspec50 * */
		*n_args = 4;
		break;
	}
	/* sys_timer_gettime */
	case 238: {
		const struct compat_50_sys_timer_gettime_args *p = params;
		iarg[0] = SCARG(p, timerid); /* timer_t */
		uarg[1] = (intptr_t) SCARG(p, value); /* struct itimerspec50 * */
		*n_args = 2;
		break;
	}
	/* sys_timer_getoverrun */
	case 239: {
		const struct sys_timer_getoverrun_args *p = params;
		iarg[0] = SCARG(p, timerid); /* timer_t */
		*n_args = 1;
		break;
	}
	/* sys_nanosleep */
	case 240: {
		const struct compat_50_sys_nanosleep_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, rqtp); /* const struct timespec50 * */
		uarg[1] = (intptr_t) SCARG(p, rmtp); /* struct timespec50 * */
		*n_args = 2;
		break;
	}
	/* sys_fdatasync */
	case 241: {
		const struct sys_fdatasync_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* sys_mlockall */
	case 242: {
		const struct sys_mlockall_args *p = params;
		iarg[0] = SCARG(p, flags); /* int */
		*n_args = 1;
		break;
	}
	/* sys_munlockall */
	case 243: {
		*n_args = 0;
		break;
	}
	/* sys___sigtimedwait */
	case 244: {
		const struct compat_50_sys___sigtimedwait_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, set); /* const sigset_t * */
		uarg[1] = (intptr_t) SCARG(p, info); /* siginfo_t * */
		uarg[2] = (intptr_t) SCARG(p, timeout); /* struct timespec50 * */
		*n_args = 3;
		break;
	}
	/* sys_sigqueueinfo */
	case 245: {
		const struct sys_sigqueueinfo_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		uarg[1] = (intptr_t) SCARG(p, info); /* const siginfo_t * */
		*n_args = 2;
		break;
	}
	/* sys_modctl */
	case 246: {
		const struct sys_modctl_args *p = params;
		iarg[0] = SCARG(p, cmd); /* int */
		uarg[1] = (intptr_t) SCARG(p, arg); /* void * */
		*n_args = 2;
		break;
	}
	/* sys__ksem_init */
	case 247: {
		const struct sys__ksem_init_args *p = params;
		uarg[0] = SCARG(p, value); /* unsigned int */
		uarg[1] = (intptr_t) SCARG(p, idp); /* intptr_t * */
		*n_args = 2;
		break;
	}
	/* sys__ksem_open */
	case 248: {
		const struct sys__ksem_open_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, name); /* const char * */
		iarg[1] = SCARG(p, oflag); /* int */
		iarg[2] = SCARG(p, mode); /* mode_t */
		uarg[3] = SCARG(p, value); /* unsigned int */
		uarg[4] = (intptr_t) SCARG(p, idp); /* intptr_t * */
		*n_args = 5;
		break;
	}
	/* sys__ksem_unlink */
	case 249: {
		const struct sys__ksem_unlink_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, name); /* const char * */
		*n_args = 1;
		break;
	}
	/* sys__ksem_close */
	case 250: {
		const struct sys__ksem_close_args *p = params;
		iarg[0] = SCARG(p, id); /* intptr_t */
		*n_args = 1;
		break;
	}
	/* sys__ksem_post */
	case 251: {
		const struct sys__ksem_post_args *p = params;
		iarg[0] = SCARG(p, id); /* intptr_t */
		*n_args = 1;
		break;
	}
	/* sys__ksem_wait */
	case 252: {
		const struct sys__ksem_wait_args *p = params;
		iarg[0] = SCARG(p, id); /* intptr_t */
		*n_args = 1;
		break;
	}
	/* sys__ksem_trywait */
	case 253: {
		const struct sys__ksem_trywait_args *p = params;
		iarg[0] = SCARG(p, id); /* intptr_t */
		*n_args = 1;
		break;
	}
	/* sys__ksem_getvalue */
	case 254: {
		const struct sys__ksem_getvalue_args *p = params;
		iarg[0] = SCARG(p, id); /* intptr_t */
		uarg[1] = (intptr_t) SCARG(p, value); /* unsigned int * */
		*n_args = 2;
		break;
	}
	/* sys__ksem_destroy */
	case 255: {
		const struct sys__ksem_destroy_args *p = params;
		iarg[0] = SCARG(p, id); /* intptr_t */
		*n_args = 1;
		break;
	}
	/* sys__ksem_timedwait */
	case 256: {
		const struct sys__ksem_timedwait_args *p = params;
		iarg[0] = SCARG(p, id); /* intptr_t */
		uarg[1] = (intptr_t) SCARG(p, abstime); /* const struct timespec * */
		*n_args = 2;
		break;
	}
	/* sys_mq_open */
	case 257: {
		const struct sys_mq_open_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, name); /* const char * */
		iarg[1] = SCARG(p, oflag); /* int */
		iarg[2] = SCARG(p, mode); /* mode_t */
		uarg[3] = (intptr_t) SCARG(p, attr); /* struct mq_attr * */
		*n_args = 4;
		break;
	}
	/* sys_mq_close */
	case 258: {
		const struct sys_mq_close_args *p = params;
		iarg[0] = SCARG(p, mqdes); /* mqd_t */
		*n_args = 1;
		break;
	}
	/* sys_mq_unlink */
	case 259: {
		const struct sys_mq_unlink_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, name); /* const char * */
		*n_args = 1;
		break;
	}
	/* sys_mq_getattr */
	case 260: {
		const struct sys_mq_getattr_args *p = params;
		iarg[0] = SCARG(p, mqdes); /* mqd_t */
		uarg[1] = (intptr_t) SCARG(p, mqstat); /* struct mq_attr * */
		*n_args = 2;
		break;
	}
	/* sys_mq_setattr */
	case 261: {
		const struct sys_mq_setattr_args *p = params;
		iarg[0] = SCARG(p, mqdes); /* mqd_t */
		uarg[1] = (intptr_t) SCARG(p, mqstat); /* const struct mq_attr * */
		uarg[2] = (intptr_t) SCARG(p, omqstat); /* struct mq_attr * */
		*n_args = 3;
		break;
	}
	/* sys_mq_notify */
	case 262: {
		const struct sys_mq_notify_args *p = params;
		iarg[0] = SCARG(p, mqdes); /* mqd_t */
		uarg[1] = (intptr_t) SCARG(p, notification); /* const struct sigevent * */
		*n_args = 2;
		break;
	}
	/* sys_mq_send */
	case 263: {
		const struct sys_mq_send_args *p = params;
		iarg[0] = SCARG(p, mqdes); /* mqd_t */
		uarg[1] = (intptr_t) SCARG(p, msg_ptr); /* const char * */
		uarg[2] = SCARG(p, msg_len); /* size_t */
		uarg[3] = SCARG(p, msg_prio); /* unsigned */
		*n_args = 4;
		break;
	}
	/* sys_mq_receive */
	case 264: {
		const struct sys_mq_receive_args *p = params;
		iarg[0] = SCARG(p, mqdes); /* mqd_t */
		uarg[1] = (intptr_t) SCARG(p, msg_ptr); /* char * */
		uarg[2] = SCARG(p, msg_len); /* size_t */
		uarg[3] = (intptr_t) SCARG(p, msg_prio); /* unsigned * */
		*n_args = 4;
		break;
	}
	/* sys_mq_timedsend */
	case 265: {
		const struct compat_50_sys_mq_timedsend_args *p = params;
		iarg[0] = SCARG(p, mqdes); /* mqd_t */
		uarg[1] = (intptr_t) SCARG(p, msg_ptr); /* const char * */
		uarg[2] = SCARG(p, msg_len); /* size_t */
		uarg[3] = SCARG(p, msg_prio); /* unsigned */
		uarg[4] = (intptr_t) SCARG(p, abs_timeout); /* const struct timespec50 * */
		*n_args = 5;
		break;
	}
	/* sys_mq_timedreceive */
	case 266: {
		const struct compat_50_sys_mq_timedreceive_args *p = params;
		iarg[0] = SCARG(p, mqdes); /* mqd_t */
		uarg[1] = (intptr_t) SCARG(p, msg_ptr); /* char * */
		uarg[2] = SCARG(p, msg_len); /* size_t */
		uarg[3] = (intptr_t) SCARG(p, msg_prio); /* unsigned * */
		uarg[4] = (intptr_t) SCARG(p, abs_timeout); /* const struct timespec50 * */
		*n_args = 5;
		break;
	}
	/* sys___posix_rename */
	case 270: {
		const struct sys___posix_rename_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, from); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, to); /* const char * */
		*n_args = 2;
		break;
	}
	/* sys_swapctl */
	case 271: {
		const struct sys_swapctl_args *p = params;
		iarg[0] = SCARG(p, cmd); /* int */
		uarg[1] = (intptr_t) SCARG(p, arg); /* void * */
		iarg[2] = SCARG(p, misc); /* int */
		*n_args = 3;
		break;
	}
	/* sys_getdents */
	case 272: {
		const struct compat_30_sys_getdents_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf); /* char * */
		uarg[2] = SCARG(p, count); /* size_t */
		*n_args = 3;
		break;
	}
	/* sys_minherit */
	case 273: {
		const struct sys_minherit_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr); /* void * */
		uarg[1] = SCARG(p, len); /* size_t */
		iarg[2] = SCARG(p, inherit); /* int */
		*n_args = 3;
		break;
	}
	/* sys_lchmod */
	case 274: {
		const struct sys_lchmod_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, mode); /* mode_t */
		*n_args = 2;
		break;
	}
	/* sys_lchown */
	case 275: {
		const struct sys_lchown_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = SCARG(p, uid); /* uid_t */
		iarg[2] = SCARG(p, gid); /* gid_t */
		*n_args = 3;
		break;
	}
	/* sys_lutimes */
	case 276: {
		const struct compat_50_sys_lutimes_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, tptr); /* const struct timeval50 * */
		*n_args = 2;
		break;
	}
	/* sys___msync13 */
	case 277: {
		const struct sys___msync13_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr); /* void * */
		uarg[1] = SCARG(p, len); /* size_t */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* sys___stat13 */
	case 278: {
		const struct compat_30_sys___stat13_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, ub); /* struct stat13 * */
		*n_args = 2;
		break;
	}
	/* sys___fstat13 */
	case 279: {
		const struct compat_30_sys___fstat13_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, sb); /* struct stat13 * */
		*n_args = 2;
		break;
	}
	/* sys___lstat13 */
	case 280: {
		const struct compat_30_sys___lstat13_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, ub); /* struct stat13 * */
		*n_args = 2;
		break;
	}
	/* sys___sigaltstack14 */
	case 281: {
		const struct sys___sigaltstack14_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, nss); /* const struct sigaltstack * */
		uarg[1] = (intptr_t) SCARG(p, oss); /* struct sigaltstack * */
		*n_args = 2;
		break;
	}
	/* sys___vfork14 */
	case 282: {
		*n_args = 0;
		break;
	}
	/* sys___posix_chown */
	case 283: {
		const struct sys___posix_chown_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = SCARG(p, uid); /* uid_t */
		iarg[2] = SCARG(p, gid); /* gid_t */
		*n_args = 3;
		break;
	}
	/* sys___posix_fchown */
	case 284: {
		const struct sys___posix_fchown_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = SCARG(p, uid); /* uid_t */
		iarg[2] = SCARG(p, gid); /* gid_t */
		*n_args = 3;
		break;
	}
	/* sys___posix_lchown */
	case 285: {
		const struct sys___posix_lchown_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = SCARG(p, uid); /* uid_t */
		iarg[2] = SCARG(p, gid); /* gid_t */
		*n_args = 3;
		break;
	}
	/* sys_getsid */
	case 286: {
		const struct sys_getsid_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		*n_args = 1;
		break;
	}
	/* sys___clone */
	case 287: {
		const struct sys___clone_args *p = params;
		iarg[0] = SCARG(p, flags); /* int */
		uarg[1] = (intptr_t) SCARG(p, stack); /* void * */
		*n_args = 2;
		break;
	}
	/* sys_fktrace */
	case 288: {
		const struct sys_fktrace_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, ops); /* int */
		iarg[2] = SCARG(p, facs); /* int */
		iarg[3] = SCARG(p, pid); /* pid_t */
		*n_args = 4;
		break;
	}
	/* sys_preadv */
	case 289: {
		const struct sys_preadv_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, iovp); /* const struct iovec * */
		iarg[2] = SCARG(p, iovcnt); /* int */
		iarg[3] = SCARG(p, PAD); /* int */
		iarg[4] = SCARG(p, offset); /* off_t */
		*n_args = 5;
		break;
	}
	/* sys_pwritev */
	case 290: {
		const struct sys_pwritev_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, iovp); /* const struct iovec * */
		iarg[2] = SCARG(p, iovcnt); /* int */
		iarg[3] = SCARG(p, PAD); /* int */
		iarg[4] = SCARG(p, offset); /* off_t */
		*n_args = 5;
		break;
	}
	/* sys___sigaction14 */
	case 291: {
		const struct compat_16_sys___sigaction14_args *p = params;
		iarg[0] = SCARG(p, signum); /* int */
		uarg[1] = (intptr_t) SCARG(p, nsa); /* const struct sigaction * */
		uarg[2] = (intptr_t) SCARG(p, osa); /* struct sigaction * */
		*n_args = 3;
		break;
	}
	/* sys___sigpending14 */
	case 292: {
		const struct sys___sigpending14_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, set); /* sigset_t * */
		*n_args = 1;
		break;
	}
	/* sys___sigprocmask14 */
	case 293: {
		const struct sys___sigprocmask14_args *p = params;
		iarg[0] = SCARG(p, how); /* int */
		uarg[1] = (intptr_t) SCARG(p, set); /* const sigset_t * */
		uarg[2] = (intptr_t) SCARG(p, oset); /* sigset_t * */
		*n_args = 3;
		break;
	}
	/* sys___sigsuspend14 */
	case 294: {
		const struct sys___sigsuspend14_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, set); /* const sigset_t * */
		*n_args = 1;
		break;
	}
	/* sys___sigreturn14 */
	case 295: {
		const struct compat_16_sys___sigreturn14_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, sigcntxp); /* struct sigcontext * */
		*n_args = 1;
		break;
	}
	/* sys___getcwd */
	case 296: {
		const struct sys___getcwd_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, bufp); /* char * */
		uarg[1] = SCARG(p, length); /* size_t */
		*n_args = 2;
		break;
	}
	/* sys_fchroot */
	case 297: {
		const struct sys_fchroot_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* sys_fhopen */
	case 298: {
		const struct compat_30_sys_fhopen_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fhp); /* const struct compat_30_fhandle * */
		iarg[1] = SCARG(p, flags); /* int */
		*n_args = 2;
		break;
	}
	/* sys_fhstat */
	case 299: {
		const struct compat_30_sys_fhstat_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fhp); /* const struct compat_30_fhandle * */
		uarg[1] = (intptr_t) SCARG(p, sb); /* struct stat13 * */
		*n_args = 2;
		break;
	}
	/* sys_fhstatfs */
	case 300: {
		const struct compat_20_sys_fhstatfs_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fhp); /* const struct compat_30_fhandle * */
		uarg[1] = (intptr_t) SCARG(p, buf); /* struct statfs12 * */
		*n_args = 2;
		break;
	}
	/* sys_____semctl13 */
	case 301: {
		const struct compat_50_sys_____semctl13_args *p = params;
		iarg[0] = SCARG(p, semid); /* int */
		iarg[1] = SCARG(p, semnum); /* int */
		iarg[2] = SCARG(p, cmd); /* int */
		uarg[3] = (intptr_t) SCARG(p, arg); /* union __semun * */
		*n_args = 4;
		break;
	}
	/* sys___msgctl13 */
	case 302: {
		const struct compat_50_sys___msgctl13_args *p = params;
		iarg[0] = SCARG(p, msqid); /* int */
		iarg[1] = SCARG(p, cmd); /* int */
		uarg[2] = (intptr_t) SCARG(p, buf); /* struct msqid_ds * */
		*n_args = 3;
		break;
	}
	/* sys___shmctl13 */
	case 303: {
		const struct compat_50_sys___shmctl13_args *p = params;
		iarg[0] = SCARG(p, shmid); /* int */
		iarg[1] = SCARG(p, cmd); /* int */
		uarg[2] = (intptr_t) SCARG(p, buf); /* struct shmid_ds13 * */
		*n_args = 3;
		break;
	}
	/* sys_lchflags */
	case 304: {
		const struct sys_lchflags_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = SCARG(p, flags); /* u_long */
		*n_args = 2;
		break;
	}
	/* sys_issetugid */
	case 305: {
		*n_args = 0;
		break;
	}
	/* sys_utrace */
	case 306: {
		const struct sys_utrace_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, label); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, addr); /* void * */
		uarg[2] = SCARG(p, len); /* size_t */
		*n_args = 3;
		break;
	}
	/* sys_getcontext */
	case 307: {
		const struct sys_getcontext_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, ucp); /* struct __ucontext * */
		*n_args = 1;
		break;
	}
	/* sys_setcontext */
	case 308: {
		const struct sys_setcontext_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, ucp); /* const struct __ucontext * */
		*n_args = 1;
		break;
	}
	/* sys__lwp_create */
	case 309: {
		const struct sys__lwp_create_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, ucp); /* const struct __ucontext * */
		uarg[1] = SCARG(p, flags); /* u_long */
		uarg[2] = (intptr_t) SCARG(p, new_lwp); /* lwpid_t * */
		*n_args = 3;
		break;
	}
	/* sys__lwp_exit */
	case 310: {
		*n_args = 0;
		break;
	}
	/* sys__lwp_self */
	case 311: {
		*n_args = 0;
		break;
	}
	/* sys__lwp_wait */
	case 312: {
		const struct sys__lwp_wait_args *p = params;
		iarg[0] = SCARG(p, wait_for); /* lwpid_t */
		uarg[1] = (intptr_t) SCARG(p, departed); /* lwpid_t * */
		*n_args = 2;
		break;
	}
	/* sys__lwp_suspend */
	case 313: {
		const struct sys__lwp_suspend_args *p = params;
		iarg[0] = SCARG(p, target); /* lwpid_t */
		*n_args = 1;
		break;
	}
	/* sys__lwp_continue */
	case 314: {
		const struct sys__lwp_continue_args *p = params;
		iarg[0] = SCARG(p, target); /* lwpid_t */
		*n_args = 1;
		break;
	}
	/* sys__lwp_wakeup */
	case 315: {
		const struct sys__lwp_wakeup_args *p = params;
		iarg[0] = SCARG(p, target); /* lwpid_t */
		*n_args = 1;
		break;
	}
	/* sys__lwp_getprivate */
	case 316: {
		*n_args = 0;
		break;
	}
	/* sys__lwp_setprivate */
	case 317: {
		const struct sys__lwp_setprivate_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, ptr); /* void * */
		*n_args = 1;
		break;
	}
	/* sys__lwp_kill */
	case 318: {
		const struct sys__lwp_kill_args *p = params;
		iarg[0] = SCARG(p, target); /* lwpid_t */
		iarg[1] = SCARG(p, signo); /* int */
		*n_args = 2;
		break;
	}
	/* sys__lwp_detach */
	case 319: {
		const struct sys__lwp_detach_args *p = params;
		iarg[0] = SCARG(p, target); /* lwpid_t */
		*n_args = 1;
		break;
	}
	/* sys__lwp_park */
	case 320: {
		const struct compat_50_sys__lwp_park_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, ts); /* const struct timespec50 * */
		iarg[1] = SCARG(p, unpark); /* lwpid_t */
		uarg[2] = (intptr_t) SCARG(p, hint); /* const void * */
		uarg[3] = (intptr_t) SCARG(p, unparkhint); /* const void * */
		*n_args = 4;
		break;
	}
	/* sys__lwp_unpark */
	case 321: {
		const struct sys__lwp_unpark_args *p = params;
		iarg[0] = SCARG(p, target); /* lwpid_t */
		uarg[1] = (intptr_t) SCARG(p, hint); /* const void * */
		*n_args = 2;
		break;
	}
	/* sys__lwp_unpark_all */
	case 322: {
		const struct sys__lwp_unpark_all_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, targets); /* const lwpid_t * */
		uarg[1] = SCARG(p, ntargets); /* size_t */
		uarg[2] = (intptr_t) SCARG(p, hint); /* const void * */
		*n_args = 3;
		break;
	}
	/* sys__lwp_setname */
	case 323: {
		const struct sys__lwp_setname_args *p = params;
		iarg[0] = SCARG(p, target); /* lwpid_t */
		uarg[1] = (intptr_t) SCARG(p, name); /* const char * */
		*n_args = 2;
		break;
	}
	/* sys__lwp_getname */
	case 324: {
		const struct sys__lwp_getname_args *p = params;
		iarg[0] = SCARG(p, target); /* lwpid_t */
		uarg[1] = (intptr_t) SCARG(p, name); /* char * */
		uarg[2] = SCARG(p, len); /* size_t */
		*n_args = 3;
		break;
	}
	/* sys__lwp_ctl */
	case 325: {
		const struct sys__lwp_ctl_args *p = params;
		iarg[0] = SCARG(p, features); /* int */
		uarg[1] = (intptr_t) SCARG(p, address); /* struct lwpctl ** */
		*n_args = 2;
		break;
	}
	/* sys_sa_register */
	case 330: {
		const struct compat_60_sys_sa_register_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, newv); /* void * */
		uarg[1] = (intptr_t) SCARG(p, oldv); /* void ** */
		iarg[2] = SCARG(p, flags); /* int */
		iarg[3] = SCARG(p, stackinfo_offset); /* ssize_t */
		*n_args = 4;
		break;
	}
	/* sys_sa_stacks */
	case 331: {
		const struct compat_60_sys_sa_stacks_args *p = params;
		iarg[0] = SCARG(p, num); /* int */
		uarg[1] = (intptr_t) SCARG(p, stacks); /* stack_t * */
		*n_args = 2;
		break;
	}
	/* sys_sa_enable */
	case 332: {
		*n_args = 0;
		break;
	}
	/* sys_sa_setconcurrency */
	case 333: {
		const struct compat_60_sys_sa_setconcurrency_args *p = params;
		iarg[0] = SCARG(p, concurrency); /* int */
		*n_args = 1;
		break;
	}
	/* sys_sa_yield */
	case 334: {
		*n_args = 0;
		break;
	}
	/* sys_sa_preempt */
	case 335: {
		const struct compat_60_sys_sa_preempt_args *p = params;
		iarg[0] = SCARG(p, sa_id); /* int */
		*n_args = 1;
		break;
	}
	/* sys___sigaction_sigtramp */
	case 340: {
		const struct sys___sigaction_sigtramp_args *p = params;
		iarg[0] = SCARG(p, signum); /* int */
		uarg[1] = (intptr_t) SCARG(p, nsa); /* const struct sigaction * */
		uarg[2] = (intptr_t) SCARG(p, osa); /* struct sigaction * */
		uarg[3] = (intptr_t) SCARG(p, tramp); /* const void * */
		iarg[4] = SCARG(p, vers); /* int */
		*n_args = 5;
		break;
	}
	/* sys_rasctl */
	case 343: {
		const struct sys_rasctl_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr); /* void * */
		uarg[1] = SCARG(p, len); /* size_t */
		iarg[2] = SCARG(p, op); /* int */
		*n_args = 3;
		break;
	}
	/* sys_kqueue */
	case 344: {
		*n_args = 0;
		break;
	}
	/* sys_kevent */
	case 345: {
		const struct compat_50_sys_kevent_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, changelist); /* const struct kevent * */
		uarg[2] = SCARG(p, nchanges); /* size_t */
		uarg[3] = (intptr_t) SCARG(p, eventlist); /* struct kevent * */
		uarg[4] = SCARG(p, nevents); /* size_t */
		uarg[5] = (intptr_t) SCARG(p, timeout); /* const struct timespec50 * */
		*n_args = 6;
		break;
	}
	/* sys__sched_setparam */
	case 346: {
		const struct sys__sched_setparam_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		iarg[1] = SCARG(p, lid); /* lwpid_t */
		iarg[2] = SCARG(p, policy); /* int */
		uarg[3] = (intptr_t) SCARG(p, params); /* const struct sched_param * */
		*n_args = 4;
		break;
	}
	/* sys__sched_getparam */
	case 347: {
		const struct sys__sched_getparam_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		iarg[1] = SCARG(p, lid); /* lwpid_t */
		uarg[2] = (intptr_t) SCARG(p, policy); /* int * */
		uarg[3] = (intptr_t) SCARG(p, params); /* struct sched_param * */
		*n_args = 4;
		break;
	}
	/* sys__sched_setaffinity */
	case 348: {
		const struct sys__sched_setaffinity_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		iarg[1] = SCARG(p, lid); /* lwpid_t */
		uarg[2] = SCARG(p, size); /* size_t */
		uarg[3] = (intptr_t) SCARG(p, cpuset); /* const cpuset_t * */
		*n_args = 4;
		break;
	}
	/* sys__sched_getaffinity */
	case 349: {
		const struct sys__sched_getaffinity_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		iarg[1] = SCARG(p, lid); /* lwpid_t */
		uarg[2] = SCARG(p, size); /* size_t */
		uarg[3] = (intptr_t) SCARG(p, cpuset); /* cpuset_t * */
		*n_args = 4;
		break;
	}
	/* sys_sched_yield */
	case 350: {
		*n_args = 0;
		break;
	}
	/* sys__sched_protect */
	case 351: {
		const struct sys__sched_protect_args *p = params;
		iarg[0] = SCARG(p, priority); /* int */
		*n_args = 1;
		break;
	}
	/* sys_fsync_range */
	case 354: {
		const struct sys_fsync_range_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, flags); /* int */
		iarg[2] = SCARG(p, start); /* off_t */
		iarg[3] = SCARG(p, length); /* off_t */
		*n_args = 4;
		break;
	}
	/* sys_uuidgen */
	case 355: {
		const struct sys_uuidgen_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, store); /* struct uuid * */
		iarg[1] = SCARG(p, count); /* int */
		*n_args = 2;
		break;
	}
	/* sys_getvfsstat */
	case 356: {
		const struct sys_getvfsstat_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, buf); /* struct statvfs * */
		uarg[1] = SCARG(p, bufsize); /* size_t */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* sys_statvfs1 */
	case 357: {
		const struct sys_statvfs1_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, buf); /* struct statvfs * */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* sys_fstatvfs1 */
	case 358: {
		const struct sys_fstatvfs1_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf); /* struct statvfs * */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* sys_fhstatvfs1 */
	case 359: {
		const struct compat_30_sys_fhstatvfs1_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fhp); /* const struct compat_30_fhandle * */
		uarg[1] = (intptr_t) SCARG(p, buf); /* struct statvfs * */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* sys_extattrctl */
	case 360: {
		const struct sys_extattrctl_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, cmd); /* int */
		uarg[2] = (intptr_t) SCARG(p, filename); /* const char * */
		iarg[3] = SCARG(p, attrnamespace); /* int */
		uarg[4] = (intptr_t) SCARG(p, attrname); /* const char * */
		*n_args = 5;
		break;
	}
	/* sys_extattr_set_file */
	case 361: {
		const struct sys_extattr_set_file_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, attrnamespace); /* int */
		uarg[2] = (intptr_t) SCARG(p, attrname); /* const char * */
		uarg[3] = (intptr_t) SCARG(p, data); /* const void * */
		uarg[4] = SCARG(p, nbytes); /* size_t */
		*n_args = 5;
		break;
	}
	/* sys_extattr_get_file */
	case 362: {
		const struct sys_extattr_get_file_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, attrnamespace); /* int */
		uarg[2] = (intptr_t) SCARG(p, attrname); /* const char * */
		uarg[3] = (intptr_t) SCARG(p, data); /* void * */
		uarg[4] = SCARG(p, nbytes); /* size_t */
		*n_args = 5;
		break;
	}
	/* sys_extattr_delete_file */
	case 363: {
		const struct sys_extattr_delete_file_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, attrnamespace); /* int */
		uarg[2] = (intptr_t) SCARG(p, attrname); /* const char * */
		*n_args = 3;
		break;
	}
	/* sys_extattr_set_fd */
	case 364: {
		const struct sys_extattr_set_fd_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, attrnamespace); /* int */
		uarg[2] = (intptr_t) SCARG(p, attrname); /* const char * */
		uarg[3] = (intptr_t) SCARG(p, data); /* const void * */
		uarg[4] = SCARG(p, nbytes); /* size_t */
		*n_args = 5;
		break;
	}
	/* sys_extattr_get_fd */
	case 365: {
		const struct sys_extattr_get_fd_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, attrnamespace); /* int */
		uarg[2] = (intptr_t) SCARG(p, attrname); /* const char * */
		uarg[3] = (intptr_t) SCARG(p, data); /* void * */
		uarg[4] = SCARG(p, nbytes); /* size_t */
		*n_args = 5;
		break;
	}
	/* sys_extattr_delete_fd */
	case 366: {
		const struct sys_extattr_delete_fd_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, attrnamespace); /* int */
		uarg[2] = (intptr_t) SCARG(p, attrname); /* const char * */
		*n_args = 3;
		break;
	}
	/* sys_extattr_set_link */
	case 367: {
		const struct sys_extattr_set_link_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, attrnamespace); /* int */
		uarg[2] = (intptr_t) SCARG(p, attrname); /* const char * */
		uarg[3] = (intptr_t) SCARG(p, data); /* const void * */
		uarg[4] = SCARG(p, nbytes); /* size_t */
		*n_args = 5;
		break;
	}
	/* sys_extattr_get_link */
	case 368: {
		const struct sys_extattr_get_link_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, attrnamespace); /* int */
		uarg[2] = (intptr_t) SCARG(p, attrname); /* const char * */
		uarg[3] = (intptr_t) SCARG(p, data); /* void * */
		uarg[4] = SCARG(p, nbytes); /* size_t */
		*n_args = 5;
		break;
	}
	/* sys_extattr_delete_link */
	case 369: {
		const struct sys_extattr_delete_link_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, attrnamespace); /* int */
		uarg[2] = (intptr_t) SCARG(p, attrname); /* const char * */
		*n_args = 3;
		break;
	}
	/* sys_extattr_list_fd */
	case 370: {
		const struct sys_extattr_list_fd_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, attrnamespace); /* int */
		uarg[2] = (intptr_t) SCARG(p, data); /* void * */
		uarg[3] = SCARG(p, nbytes); /* size_t */
		*n_args = 4;
		break;
	}
	/* sys_extattr_list_file */
	case 371: {
		const struct sys_extattr_list_file_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, attrnamespace); /* int */
		uarg[2] = (intptr_t) SCARG(p, data); /* void * */
		uarg[3] = SCARG(p, nbytes); /* size_t */
		*n_args = 4;
		break;
	}
	/* sys_extattr_list_link */
	case 372: {
		const struct sys_extattr_list_link_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, attrnamespace); /* int */
		uarg[2] = (intptr_t) SCARG(p, data); /* void * */
		uarg[3] = SCARG(p, nbytes); /* size_t */
		*n_args = 4;
		break;
	}
	/* sys_pselect */
	case 373: {
		const struct compat_50_sys_pselect_args *p = params;
		iarg[0] = SCARG(p, nd); /* int */
		uarg[1] = (intptr_t) SCARG(p, in); /* fd_set * */
		uarg[2] = (intptr_t) SCARG(p, ou); /* fd_set * */
		uarg[3] = (intptr_t) SCARG(p, ex); /* fd_set * */
		uarg[4] = (intptr_t) SCARG(p, ts); /* const struct timespec50 * */
		uarg[5] = (intptr_t) SCARG(p, mask); /* const sigset_t * */
		*n_args = 6;
		break;
	}
	/* sys_pollts */
	case 374: {
		const struct compat_50_sys_pollts_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fds); /* struct pollfd * */
		uarg[1] = SCARG(p, nfds); /* u_int */
		uarg[2] = (intptr_t) SCARG(p, ts); /* const struct timespec50 * */
		uarg[3] = (intptr_t) SCARG(p, mask); /* const sigset_t * */
		*n_args = 4;
		break;
	}
	/* sys_setxattr */
	case 375: {
		const struct sys_setxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, name); /* const char * */
		uarg[2] = (intptr_t) SCARG(p, value); /* const void * */
		uarg[3] = SCARG(p, size); /* size_t */
		iarg[4] = SCARG(p, flags); /* int */
		*n_args = 5;
		break;
	}
	/* sys_lsetxattr */
	case 376: {
		const struct sys_lsetxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, name); /* const char * */
		uarg[2] = (intptr_t) SCARG(p, value); /* const void * */
		uarg[3] = SCARG(p, size); /* size_t */
		iarg[4] = SCARG(p, flags); /* int */
		*n_args = 5;
		break;
	}
	/* sys_fsetxattr */
	case 377: {
		const struct sys_fsetxattr_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, name); /* const char * */
		uarg[2] = (intptr_t) SCARG(p, value); /* const void * */
		uarg[3] = SCARG(p, size); /* size_t */
		iarg[4] = SCARG(p, flags); /* int */
		*n_args = 5;
		break;
	}
	/* sys_getxattr */
	case 378: {
		const struct sys_getxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, name); /* const char * */
		uarg[2] = (intptr_t) SCARG(p, value); /* void * */
		uarg[3] = SCARG(p, size); /* size_t */
		*n_args = 4;
		break;
	}
	/* sys_lgetxattr */
	case 379: {
		const struct sys_lgetxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, name); /* const char * */
		uarg[2] = (intptr_t) SCARG(p, value); /* void * */
		uarg[3] = SCARG(p, size); /* size_t */
		*n_args = 4;
		break;
	}
	/* sys_fgetxattr */
	case 380: {
		const struct sys_fgetxattr_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, name); /* const char * */
		uarg[2] = (intptr_t) SCARG(p, value); /* void * */
		uarg[3] = SCARG(p, size); /* size_t */
		*n_args = 4;
		break;
	}
	/* sys_listxattr */
	case 381: {
		const struct sys_listxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, list); /* char * */
		uarg[2] = SCARG(p, size); /* size_t */
		*n_args = 3;
		break;
	}
	/* sys_llistxattr */
	case 382: {
		const struct sys_llistxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, list); /* char * */
		uarg[2] = SCARG(p, size); /* size_t */
		*n_args = 3;
		break;
	}
	/* sys_flistxattr */
	case 383: {
		const struct sys_flistxattr_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, list); /* char * */
		uarg[2] = SCARG(p, size); /* size_t */
		*n_args = 3;
		break;
	}
	/* sys_removexattr */
	case 384: {
		const struct sys_removexattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, name); /* const char * */
		*n_args = 2;
		break;
	}
	/* sys_lremovexattr */
	case 385: {
		const struct sys_lremovexattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, name); /* const char * */
		*n_args = 2;
		break;
	}
	/* sys_fremovexattr */
	case 386: {
		const struct sys_fremovexattr_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, name); /* const char * */
		*n_args = 2;
		break;
	}
	/* sys___stat30 */
	case 387: {
		const struct compat_50_sys___stat30_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, ub); /* struct stat30 * */
		*n_args = 2;
		break;
	}
	/* sys___fstat30 */
	case 388: {
		const struct compat_50_sys___fstat30_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, sb); /* struct stat30 * */
		*n_args = 2;
		break;
	}
	/* sys___lstat30 */
	case 389: {
		const struct compat_50_sys___lstat30_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, ub); /* struct stat30 * */
		*n_args = 2;
		break;
	}
	/* sys___getdents30 */
	case 390: {
		const struct sys___getdents30_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf); /* char * */
		uarg[2] = SCARG(p, count); /* size_t */
		*n_args = 3;
		break;
	}
	/* sys___fhstat30 */
	case 392: {
		const struct compat_30_sys___fhstat30_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fhp); /* const struct compat_30_fhandle * */
		uarg[1] = (intptr_t) SCARG(p, sb); /* struct stat30 * */
		*n_args = 2;
		break;
	}
	/* sys___ntp_gettime30 */
	case 393: {
		const struct compat_50_sys___ntp_gettime30_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, ntvp); /* struct ntptimeval50 * */
		*n_args = 1;
		break;
	}
	/* sys___socket30 */
	case 394: {
		const struct sys___socket30_args *p = params;
		iarg[0] = SCARG(p, domain); /* int */
		iarg[1] = SCARG(p, type); /* int */
		iarg[2] = SCARG(p, protocol); /* int */
		*n_args = 3;
		break;
	}
	/* sys___getfh30 */
	case 395: {
		const struct sys___getfh30_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fname); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, fhp); /* void * */
		uarg[2] = (intptr_t) SCARG(p, fh_size); /* size_t * */
		*n_args = 3;
		break;
	}
	/* sys___fhopen40 */
	case 396: {
		const struct sys___fhopen40_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fhp); /* const void * */
		uarg[1] = SCARG(p, fh_size); /* size_t */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* sys___fhstatvfs140 */
	case 397: {
		const struct sys___fhstatvfs140_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fhp); /* const void * */
		uarg[1] = SCARG(p, fh_size); /* size_t */
		uarg[2] = (intptr_t) SCARG(p, buf); /* struct statvfs * */
		iarg[3] = SCARG(p, flags); /* int */
		*n_args = 4;
		break;
	}
	/* sys___fhstat40 */
	case 398: {
		const struct compat_50_sys___fhstat40_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fhp); /* const void * */
		uarg[1] = SCARG(p, fh_size); /* size_t */
		uarg[2] = (intptr_t) SCARG(p, sb); /* struct stat30 * */
		*n_args = 3;
		break;
	}
	/* sys_aio_cancel */
	case 399: {
		const struct sys_aio_cancel_args *p = params;
		iarg[0] = SCARG(p, fildes); /* int */
		uarg[1] = (intptr_t) SCARG(p, aiocbp); /* struct aiocb * */
		*n_args = 2;
		break;
	}
	/* sys_aio_error */
	case 400: {
		const struct sys_aio_error_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, aiocbp); /* const struct aiocb * */
		*n_args = 1;
		break;
	}
	/* sys_aio_fsync */
	case 401: {
		const struct sys_aio_fsync_args *p = params;
		iarg[0] = SCARG(p, op); /* int */
		uarg[1] = (intptr_t) SCARG(p, aiocbp); /* struct aiocb * */
		*n_args = 2;
		break;
	}
	/* sys_aio_read */
	case 402: {
		const struct sys_aio_read_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, aiocbp); /* struct aiocb * */
		*n_args = 1;
		break;
	}
	/* sys_aio_return */
	case 403: {
		const struct sys_aio_return_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, aiocbp); /* struct aiocb * */
		*n_args = 1;
		break;
	}
	/* sys_aio_suspend */
	case 404: {
		const struct compat_50_sys_aio_suspend_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, list); /* const struct aiocb *const * */
		iarg[1] = SCARG(p, nent); /* int */
		uarg[2] = (intptr_t) SCARG(p, timeout); /* const struct timespec50 * */
		*n_args = 3;
		break;
	}
	/* sys_aio_write */
	case 405: {
		const struct sys_aio_write_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, aiocbp); /* struct aiocb * */
		*n_args = 1;
		break;
	}
	/* sys_lio_listio */
	case 406: {
		const struct sys_lio_listio_args *p = params;
		iarg[0] = SCARG(p, mode); /* int */
		uarg[1] = (intptr_t) SCARG(p, list); /* struct aiocb *const * */
		iarg[2] = SCARG(p, nent); /* int */
		uarg[3] = (intptr_t) SCARG(p, sig); /* struct sigevent * */
		*n_args = 4;
		break;
	}
	/* sys___mount50 */
	case 410: {
		const struct sys___mount50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, type); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[2] = SCARG(p, flags); /* int */
		uarg[3] = (intptr_t) SCARG(p, data); /* void * */
		uarg[4] = SCARG(p, data_len); /* size_t */
		*n_args = 5;
		break;
	}
	/* sys_mremap */
	case 411: {
		const struct sys_mremap_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, old_address); /* void * */
		uarg[1] = SCARG(p, old_size); /* size_t */
		uarg[2] = (intptr_t) SCARG(p, new_address); /* void * */
		uarg[3] = SCARG(p, new_size); /* size_t */
		iarg[4] = SCARG(p, flags); /* int */
		*n_args = 5;
		break;
	}
	/* sys_pset_create */
	case 412: {
		const struct sys_pset_create_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, psid); /* psetid_t * */
		*n_args = 1;
		break;
	}
	/* sys_pset_destroy */
	case 413: {
		const struct sys_pset_destroy_args *p = params;
		iarg[0] = SCARG(p, psid); /* psetid_t */
		*n_args = 1;
		break;
	}
	/* sys_pset_assign */
	case 414: {
		const struct sys_pset_assign_args *p = params;
		iarg[0] = SCARG(p, psid); /* psetid_t */
		iarg[1] = SCARG(p, cpuid); /* cpuid_t */
		uarg[2] = (intptr_t) SCARG(p, opsid); /* psetid_t * */
		*n_args = 3;
		break;
	}
	/* sys__pset_bind */
	case 415: {
		const struct sys__pset_bind_args *p = params;
		iarg[0] = SCARG(p, idtype); /* idtype_t */
		iarg[1] = SCARG(p, first_id); /* id_t */
		iarg[2] = SCARG(p, second_id); /* id_t */
		iarg[3] = SCARG(p, psid); /* psetid_t */
		uarg[4] = (intptr_t) SCARG(p, opsid); /* psetid_t * */
		*n_args = 5;
		break;
	}
	/* sys___posix_fadvise50 */
	case 416: {
		const struct sys___posix_fadvise50_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, PAD); /* int */
		iarg[2] = SCARG(p, offset); /* off_t */
		iarg[3] = SCARG(p, len); /* off_t */
		iarg[4] = SCARG(p, advice); /* int */
		*n_args = 5;
		break;
	}
	/* sys___select50 */
	case 417: {
		const struct sys___select50_args *p = params;
		iarg[0] = SCARG(p, nd); /* int */
		uarg[1] = (intptr_t) SCARG(p, in); /* fd_set * */
		uarg[2] = (intptr_t) SCARG(p, ou); /* fd_set * */
		uarg[3] = (intptr_t) SCARG(p, ex); /* fd_set * */
		uarg[4] = (intptr_t) SCARG(p, tv); /* struct timeval * */
		*n_args = 5;
		break;
	}
	/* sys___gettimeofday50 */
	case 418: {
		const struct sys___gettimeofday50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, tp); /* struct timeval * */
		uarg[1] = (intptr_t) SCARG(p, tzp); /* void * */
		*n_args = 2;
		break;
	}
	/* sys___settimeofday50 */
	case 419: {
		const struct sys___settimeofday50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, tv); /* const struct timeval * */
		uarg[1] = (intptr_t) SCARG(p, tzp); /* const void * */
		*n_args = 2;
		break;
	}
	/* sys___utimes50 */
	case 420: {
		const struct sys___utimes50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, tptr); /* const struct timeval * */
		*n_args = 2;
		break;
	}
	/* sys___adjtime50 */
	case 421: {
		const struct sys___adjtime50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, delta); /* const struct timeval * */
		uarg[1] = (intptr_t) SCARG(p, olddelta); /* struct timeval * */
		*n_args = 2;
		break;
	}
	/* sys___lfs_segwait50 */
	case 422: {
		const struct sys___lfs_segwait50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fsidp); /* fsid_t * */
		uarg[1] = (intptr_t) SCARG(p, tv); /* struct timeval * */
		*n_args = 2;
		break;
	}
	/* sys___futimes50 */
	case 423: {
		const struct sys___futimes50_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, tptr); /* const struct timeval * */
		*n_args = 2;
		break;
	}
	/* sys___lutimes50 */
	case 424: {
		const struct sys___lutimes50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, tptr); /* const struct timeval * */
		*n_args = 2;
		break;
	}
	/* sys___setitimer50 */
	case 425: {
		const struct sys___setitimer50_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		uarg[1] = (intptr_t) SCARG(p, itv); /* const struct itimerval * */
		uarg[2] = (intptr_t) SCARG(p, oitv); /* struct itimerval * */
		*n_args = 3;
		break;
	}
	/* sys___getitimer50 */
	case 426: {
		const struct sys___getitimer50_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		uarg[1] = (intptr_t) SCARG(p, itv); /* struct itimerval * */
		*n_args = 2;
		break;
	}
	/* sys___clock_gettime50 */
	case 427: {
		const struct sys___clock_gettime50_args *p = params;
		iarg[0] = SCARG(p, clock_id); /* clockid_t */
		uarg[1] = (intptr_t) SCARG(p, tp); /* struct timespec * */
		*n_args = 2;
		break;
	}
	/* sys___clock_settime50 */
	case 428: {
		const struct sys___clock_settime50_args *p = params;
		iarg[0] = SCARG(p, clock_id); /* clockid_t */
		uarg[1] = (intptr_t) SCARG(p, tp); /* const struct timespec * */
		*n_args = 2;
		break;
	}
	/* sys___clock_getres50 */
	case 429: {
		const struct sys___clock_getres50_args *p = params;
		iarg[0] = SCARG(p, clock_id); /* clockid_t */
		uarg[1] = (intptr_t) SCARG(p, tp); /* struct timespec * */
		*n_args = 2;
		break;
	}
	/* sys___nanosleep50 */
	case 430: {
		const struct sys___nanosleep50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, rqtp); /* const struct timespec * */
		uarg[1] = (intptr_t) SCARG(p, rmtp); /* struct timespec * */
		*n_args = 2;
		break;
	}
	/* sys_____sigtimedwait50 */
	case 431: {
		const struct sys_____sigtimedwait50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, set); /* const sigset_t * */
		uarg[1] = (intptr_t) SCARG(p, info); /* siginfo_t * */
		uarg[2] = (intptr_t) SCARG(p, timeout); /* struct timespec * */
		*n_args = 3;
		break;
	}
	/* sys___mq_timedsend50 */
	case 432: {
		const struct sys___mq_timedsend50_args *p = params;
		iarg[0] = SCARG(p, mqdes); /* mqd_t */
		uarg[1] = (intptr_t) SCARG(p, msg_ptr); /* const char * */
		uarg[2] = SCARG(p, msg_len); /* size_t */
		uarg[3] = SCARG(p, msg_prio); /* unsigned */
		uarg[4] = (intptr_t) SCARG(p, abs_timeout); /* const struct timespec * */
		*n_args = 5;
		break;
	}
	/* sys___mq_timedreceive50 */
	case 433: {
		const struct sys___mq_timedreceive50_args *p = params;
		iarg[0] = SCARG(p, mqdes); /* mqd_t */
		uarg[1] = (intptr_t) SCARG(p, msg_ptr); /* char * */
		uarg[2] = SCARG(p, msg_len); /* size_t */
		uarg[3] = (intptr_t) SCARG(p, msg_prio); /* unsigned * */
		uarg[4] = (intptr_t) SCARG(p, abs_timeout); /* const struct timespec * */
		*n_args = 5;
		break;
	}
	/* sys__lwp_park */
	case 434: {
		const struct compat_60_sys__lwp_park_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, ts); /* const struct timespec * */
		iarg[1] = SCARG(p, unpark); /* lwpid_t */
		uarg[2] = (intptr_t) SCARG(p, hint); /* const void * */
		uarg[3] = (intptr_t) SCARG(p, unparkhint); /* const void * */
		*n_args = 4;
		break;
	}
	/* sys___kevent50 */
	case 435: {
		const struct sys___kevent50_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, changelist); /* const struct kevent * */
		uarg[2] = SCARG(p, nchanges); /* size_t */
		uarg[3] = (intptr_t) SCARG(p, eventlist); /* struct kevent * */
		uarg[4] = SCARG(p, nevents); /* size_t */
		uarg[5] = (intptr_t) SCARG(p, timeout); /* const struct timespec * */
		*n_args = 6;
		break;
	}
	/* sys___pselect50 */
	case 436: {
		const struct sys___pselect50_args *p = params;
		iarg[0] = SCARG(p, nd); /* int */
		uarg[1] = (intptr_t) SCARG(p, in); /* fd_set * */
		uarg[2] = (intptr_t) SCARG(p, ou); /* fd_set * */
		uarg[3] = (intptr_t) SCARG(p, ex); /* fd_set * */
		uarg[4] = (intptr_t) SCARG(p, ts); /* const struct timespec * */
		uarg[5] = (intptr_t) SCARG(p, mask); /* const sigset_t * */
		*n_args = 6;
		break;
	}
	/* sys___pollts50 */
	case 437: {
		const struct sys___pollts50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fds); /* struct pollfd * */
		uarg[1] = SCARG(p, nfds); /* u_int */
		uarg[2] = (intptr_t) SCARG(p, ts); /* const struct timespec * */
		uarg[3] = (intptr_t) SCARG(p, mask); /* const sigset_t * */
		*n_args = 4;
		break;
	}
	/* sys___aio_suspend50 */
	case 438: {
		const struct sys___aio_suspend50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, list); /* const struct aiocb *const * */
		iarg[1] = SCARG(p, nent); /* int */
		uarg[2] = (intptr_t) SCARG(p, timeout); /* const struct timespec * */
		*n_args = 3;
		break;
	}
	/* sys___stat50 */
	case 439: {
		const struct sys___stat50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, ub); /* struct stat * */
		*n_args = 2;
		break;
	}
	/* sys___fstat50 */
	case 440: {
		const struct sys___fstat50_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, sb); /* struct stat * */
		*n_args = 2;
		break;
	}
	/* sys___lstat50 */
	case 441: {
		const struct sys___lstat50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, ub); /* struct stat * */
		*n_args = 2;
		break;
	}
	/* sys_____semctl50 */
	case 442: {
		const struct sys_____semctl50_args *p = params;
		iarg[0] = SCARG(p, semid); /* int */
		iarg[1] = SCARG(p, semnum); /* int */
		iarg[2] = SCARG(p, cmd); /* int */
		uarg[3] = (intptr_t) SCARG(p, arg); /* union __semun * */
		*n_args = 4;
		break;
	}
	/* sys___shmctl50 */
	case 443: {
		const struct sys___shmctl50_args *p = params;
		iarg[0] = SCARG(p, shmid); /* int */
		iarg[1] = SCARG(p, cmd); /* int */
		uarg[2] = (intptr_t) SCARG(p, buf); /* struct shmid_ds * */
		*n_args = 3;
		break;
	}
	/* sys___msgctl50 */
	case 444: {
		const struct sys___msgctl50_args *p = params;
		iarg[0] = SCARG(p, msqid); /* int */
		iarg[1] = SCARG(p, cmd); /* int */
		uarg[2] = (intptr_t) SCARG(p, buf); /* struct msqid_ds * */
		*n_args = 3;
		break;
	}
	/* sys___getrusage50 */
	case 445: {
		const struct sys___getrusage50_args *p = params;
		iarg[0] = SCARG(p, who); /* int */
		uarg[1] = (intptr_t) SCARG(p, rusage); /* struct rusage * */
		*n_args = 2;
		break;
	}
	/* sys___timer_settime50 */
	case 446: {
		const struct sys___timer_settime50_args *p = params;
		iarg[0] = SCARG(p, timerid); /* timer_t */
		iarg[1] = SCARG(p, flags); /* int */
		uarg[2] = (intptr_t) SCARG(p, value); /* const struct itimerspec * */
		uarg[3] = (intptr_t) SCARG(p, ovalue); /* struct itimerspec * */
		*n_args = 4;
		break;
	}
	/* sys___timer_gettime50 */
	case 447: {
		const struct sys___timer_gettime50_args *p = params;
		iarg[0] = SCARG(p, timerid); /* timer_t */
		uarg[1] = (intptr_t) SCARG(p, value); /* struct itimerspec * */
		*n_args = 2;
		break;
	}
#if defined(NTP) || !defined(_KERNEL_OPT)
	/* sys___ntp_gettime50 */
	case 448: {
		const struct sys___ntp_gettime50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, ntvp); /* struct ntptimeval * */
		*n_args = 1;
		break;
	}
#else
#endif
	/* sys___wait450 */
	case 449: {
		const struct sys___wait450_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		uarg[1] = (intptr_t) SCARG(p, status); /* int * */
		iarg[2] = SCARG(p, options); /* int */
		uarg[3] = (intptr_t) SCARG(p, rusage); /* struct rusage * */
		*n_args = 4;
		break;
	}
	/* sys___mknod50 */
	case 450: {
		const struct sys___mknod50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, mode); /* mode_t */
		iarg[2] = SCARG(p, dev); /* dev_t */
		*n_args = 3;
		break;
	}
	/* sys___fhstat50 */
	case 451: {
		const struct sys___fhstat50_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fhp); /* const void * */
		uarg[1] = SCARG(p, fh_size); /* size_t */
		uarg[2] = (intptr_t) SCARG(p, sb); /* struct stat * */
		*n_args = 3;
		break;
	}
	/* sys_pipe2 */
	case 453: {
		const struct sys_pipe2_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fildes); /* int * */
		iarg[1] = SCARG(p, flags); /* int */
		*n_args = 2;
		break;
	}
	/* sys_dup3 */
	case 454: {
		const struct sys_dup3_args *p = params;
		iarg[0] = SCARG(p, from); /* int */
		iarg[1] = SCARG(p, to); /* int */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* sys_kqueue1 */
	case 455: {
		const struct sys_kqueue1_args *p = params;
		iarg[0] = SCARG(p, flags); /* int */
		*n_args = 1;
		break;
	}
	/* sys_paccept */
	case 456: {
		const struct sys_paccept_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, name); /* struct sockaddr * */
		uarg[2] = (intptr_t) SCARG(p, anamelen); /* socklen_t * */
		uarg[3] = (intptr_t) SCARG(p, mask); /* const sigset_t * */
		iarg[4] = SCARG(p, flags); /* int */
		*n_args = 5;
		break;
	}
	/* sys_linkat */
	case 457: {
		const struct sys_linkat_args *p = params;
		iarg[0] = SCARG(p, fd1); /* int */
		uarg[1] = (intptr_t) SCARG(p, name1); /* const char * */
		iarg[2] = SCARG(p, fd2); /* int */
		uarg[3] = (intptr_t) SCARG(p, name2); /* const char * */
		iarg[4] = SCARG(p, flags); /* int */
		*n_args = 5;
		break;
	}
	/* sys_renameat */
	case 458: {
		const struct sys_renameat_args *p = params;
		iarg[0] = SCARG(p, fromfd); /* int */
		uarg[1] = (intptr_t) SCARG(p, from); /* const char * */
		iarg[2] = SCARG(p, tofd); /* int */
		uarg[3] = (intptr_t) SCARG(p, to); /* const char * */
		*n_args = 4;
		break;
	}
	/* sys_mkfifoat */
	case 459: {
		const struct sys_mkfifoat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[2] = SCARG(p, mode); /* mode_t */
		*n_args = 3;
		break;
	}
	/* sys_mknodat */
	case 460: {
		const struct sys_mknodat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[2] = SCARG(p, mode); /* mode_t */
		iarg[3] = SCARG(p, PAD); /* int */
		iarg[4] = SCARG(p, dev); /* dev_t */
		*n_args = 5;
		break;
	}
	/* sys_mkdirat */
	case 461: {
		const struct sys_mkdirat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[2] = SCARG(p, mode); /* mode_t */
		*n_args = 3;
		break;
	}
	/* sys_faccessat */
	case 462: {
		const struct sys_faccessat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[2] = SCARG(p, amode); /* int */
		iarg[3] = SCARG(p, flag); /* int */
		*n_args = 4;
		break;
	}
	/* sys_fchmodat */
	case 463: {
		const struct sys_fchmodat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[2] = SCARG(p, mode); /* mode_t */
		iarg[3] = SCARG(p, flag); /* int */
		*n_args = 4;
		break;
	}
	/* sys_fchownat */
	case 464: {
		const struct sys_fchownat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[2] = SCARG(p, owner); /* uid_t */
		iarg[3] = SCARG(p, group); /* gid_t */
		iarg[4] = SCARG(p, flag); /* int */
		*n_args = 5;
		break;
	}
	/* sys_fexecve */
	case 465: {
		const struct sys_fexecve_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, argp); /* char *const * */
		uarg[2] = (intptr_t) SCARG(p, envp); /* char *const * */
		*n_args = 3;
		break;
	}
	/* sys_fstatat */
	case 466: {
		const struct sys_fstatat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[2] = (intptr_t) SCARG(p, buf); /* struct stat * */
		iarg[3] = SCARG(p, flag); /* int */
		*n_args = 4;
		break;
	}
	/* sys_utimensat */
	case 467: {
		const struct sys_utimensat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[2] = (intptr_t) SCARG(p, tptr); /* const struct timespec * */
		iarg[3] = SCARG(p, flag); /* int */
		*n_args = 4;
		break;
	}
	/* sys_openat */
	case 468: {
		const struct sys_openat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[2] = SCARG(p, oflags); /* int */
		iarg[3] = SCARG(p, mode); /* mode_t */
		*n_args = 4;
		break;
	}
	/* sys_readlinkat */
	case 469: {
		const struct sys_readlinkat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[2] = (intptr_t) SCARG(p, buf); /* char * */
		uarg[3] = SCARG(p, bufsize); /* size_t */
		*n_args = 4;
		break;
	}
	/* sys_symlinkat */
	case 470: {
		const struct sys_symlinkat_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path1); /* const char * */
		iarg[1] = SCARG(p, fd); /* int */
		uarg[2] = (intptr_t) SCARG(p, path2); /* const char * */
		*n_args = 3;
		break;
	}
	/* sys_unlinkat */
	case 471: {
		const struct sys_unlinkat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[2] = SCARG(p, flag); /* int */
		*n_args = 3;
		break;
	}
	/* sys_futimens */
	case 472: {
		const struct sys_futimens_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, tptr); /* const struct timespec * */
		*n_args = 2;
		break;
	}
	/* sys___quotactl */
	case 473: {
		const struct sys___quotactl_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, args); /* struct quotactl_args * */
		*n_args = 2;
		break;
	}
	/* sys_posix_spawn */
	case 474: {
		const struct sys_posix_spawn_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, pid); /* pid_t * */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[2] = (intptr_t) SCARG(p, file_actions); /* const struct posix_spawn_file_actions * */
		uarg[3] = (intptr_t) SCARG(p, attrp); /* const struct posix_spawnattr * */
		uarg[4] = (intptr_t) SCARG(p, argv); /* char *const * */
		uarg[5] = (intptr_t) SCARG(p, envp); /* char *const * */
		*n_args = 6;
		break;
	}
	/* sys_recvmmsg */
	case 475: {
		const struct sys_recvmmsg_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, mmsg); /* struct mmsghdr * */
		uarg[2] = SCARG(p, vlen); /* unsigned int */
		uarg[3] = SCARG(p, flags); /* unsigned int */
		uarg[4] = (intptr_t) SCARG(p, timeout); /* struct timespec * */
		*n_args = 5;
		break;
	}
	/* sys_sendmmsg */
	case 476: {
		const struct sys_sendmmsg_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, mmsg); /* struct mmsghdr * */
		uarg[2] = SCARG(p, vlen); /* unsigned int */
		uarg[3] = SCARG(p, flags); /* unsigned int */
		*n_args = 4;
		break;
	}
	/* sys_clock_nanosleep */
	case 477: {
		const struct sys_clock_nanosleep_args *p = params;
		iarg[0] = SCARG(p, clock_id); /* clockid_t */
		iarg[1] = SCARG(p, flags); /* int */
		uarg[2] = (intptr_t) SCARG(p, rqtp); /* const struct timespec * */
		uarg[3] = (intptr_t) SCARG(p, rmtp); /* struct timespec * */
		*n_args = 4;
		break;
	}
	/* sys____lwp_park60 */
	case 478: {
		const struct sys____lwp_park60_args *p = params;
		iarg[0] = SCARG(p, clock_id); /* clockid_t */
		iarg[1] = SCARG(p, flags); /* int */
		uarg[2] = (intptr_t) SCARG(p, ts); /* struct timespec * */
		iarg[3] = SCARG(p, unpark); /* lwpid_t */
		uarg[4] = (intptr_t) SCARG(p, hint); /* const void * */
		uarg[5] = (intptr_t) SCARG(p, unparkhint); /* const void * */
		*n_args = 6;
		break;
	}
	/* sys_posix_fallocate */
	case 479: {
		const struct sys_posix_fallocate_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, PAD); /* int */
		iarg[2] = SCARG(p, pos); /* off_t */
		iarg[3] = SCARG(p, len); /* off_t */
		*n_args = 4;
		break;
	}
	/* sys_fdiscard */
	case 480: {
		const struct sys_fdiscard_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, PAD); /* int */
		iarg[2] = SCARG(p, pos); /* off_t */
		iarg[3] = SCARG(p, len); /* off_t */
		*n_args = 4;
		break;
	}
	/* sys_wait6 */
	case 481: {
		const struct sys_wait6_args *p = params;
		iarg[0] = SCARG(p, idtype); /* idtype_t */
		iarg[1] = SCARG(p, id); /* id_t */
		uarg[2] = (intptr_t) SCARG(p, status); /* int * */
		iarg[3] = SCARG(p, options); /* int */
		uarg[4] = (intptr_t) SCARG(p, wru); /* struct wrusage * */
		uarg[5] = (intptr_t) SCARG(p, info); /* siginfo_t * */
		*n_args = 6;
		break;
	}
	/* sys_clock_getcpuclockid2 */
	case 482: {
		const struct sys_clock_getcpuclockid2_args *p = params;
		iarg[0] = SCARG(p, idtype); /* idtype_t */
		iarg[1] = SCARG(p, id); /* id_t */
		uarg[2] = (intptr_t) SCARG(p, clock_id); /* clockid_t * */
		*n_args = 3;
		break;
	}
	default:
		*n_args = 0;
		break;
	};
}
static void
systrace_entry_setargdesc(int sysnum, int ndx, char *desc, size_t descsz)
{
	const char *p = NULL;
	switch (sysnum) {
	/* sys_syscall */
	case 0:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "register_t";
			break;
		default:
			break;
		};
		break;
	/* sys_exit */
	case 1:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_fork */
	case 2:
		break;
	/* sys_read */
	case 3:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_write */
	case 4:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const void *";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_open */
	case 5:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "mode_t";
			break;
		default:
			break;
		};
		break;
	/* sys_close */
	case 6:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_wait4 */
	case 7:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "int *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "struct rusage50 *";
			break;
		default:
			break;
		};
		break;
	/* sys_creat */
	case 8:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "mode_t";
			break;
		default:
			break;
		};
		break;
	/* sys_link */
	case 9:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_unlink */
	case 10:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_chdir */
	case 12:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_fchdir */
	case 13:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_mknod */
	case 14:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "mode_t";
			break;
		case 2:
			p = "uint32_t";
			break;
		default:
			break;
		};
		break;
	/* sys_chmod */
	case 15:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "mode_t";
			break;
		default:
			break;
		};
		break;
	/* sys_chown */
	case 16:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "uid_t";
			break;
		case 2:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_obreak */
	case 17:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* sys_getfsstat */
	case 18:
		switch(ndx) {
		case 0:
			p = "struct statfs12 *";
			break;
		case 1:
			p = "long";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_lseek */
	case 19:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "long";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_getpid_with_ppid */
	case 20:
		break;
	/* sys_mount */
	case 21:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* sys_unmount */
	case 22:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_setuid */
	case 23:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_getuid_with_euid */
	case 24:
		break;
	/* sys_geteuid */
	case 25:
		break;
	/* sys_ptrace */
	case 26:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "pid_t";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_recvmsg */
	case 27:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct msghdr *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_sendmsg */
	case 28:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct msghdr *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_recvfrom */
	case 29:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "struct sockaddr *";
			break;
		case 5:
			p = "socklen_t *";
			break;
		default:
			break;
		};
		break;
	/* sys_accept */
	case 30:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct sockaddr *";
			break;
		case 2:
			p = "socklen_t *";
			break;
		default:
			break;
		};
		break;
	/* sys_getpeername */
	case 31:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct sockaddr *";
			break;
		case 2:
			p = "socklen_t *";
			break;
		default:
			break;
		};
		break;
	/* sys_getsockname */
	case 32:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct sockaddr *";
			break;
		case 2:
			p = "socklen_t *";
			break;
		default:
			break;
		};
		break;
	/* sys_access */
	case 33:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_chflags */
	case 34:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "u_long";
			break;
		default:
			break;
		};
		break;
	/* sys_fchflags */
	case 35:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "u_long";
			break;
		default:
			break;
		};
		break;
	/* sys_sync */
	case 36:
		break;
	/* sys_kill */
	case 37:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_stat */
	case 38:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "struct stat43 *";
			break;
		default:
			break;
		};
		break;
	/* sys_getppid */
	case 39:
		break;
	/* sys_lstat */
	case 40:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "struct stat43 *";
			break;
		default:
			break;
		};
		break;
	/* sys_dup */
	case 41:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_pipe */
	case 42:
		break;
	/* sys_getegid */
	case 43:
		break;
	/* sys_profil */
	case 44:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "u_long";
			break;
		case 3:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* sys_ktrace */
	case 45:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "pid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_sigaction */
	case 46:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct sigaction13 *";
			break;
		case 2:
			p = "struct sigaction13 *";
			break;
		default:
			break;
		};
		break;
	/* sys_getgid_with_egid */
	case 47:
		break;
	/* sys_sigprocmask */
	case 48:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys___getlogin */
	case 49:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys___setlogin */
	case 50:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_acct */
	case 51:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_sigpending */
	case 52:
		break;
	/* sys_sigaltstack */
	case 53:
		switch(ndx) {
		case 0:
			p = "const struct sigaltstack13 *";
			break;
		case 1:
			p = "struct sigaltstack13 *";
			break;
		default:
			break;
		};
		break;
	/* sys_ioctl */
	case 54:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "u_long";
			break;
		case 2:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* sys_reboot */
	case 55:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_revoke */
	case 56:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_symlink */
	case 57:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_readlink */
	case 58:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_execve */
	case 59:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "char *const *";
			break;
		case 2:
			p = "char *const *";
			break;
		default:
			break;
		};
		break;
	/* sys_umask */
	case 60:
		switch(ndx) {
		case 0:
			p = "mode_t";
			break;
		default:
			break;
		};
		break;
	/* sys_chroot */
	case 61:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_fstat */
	case 62:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct stat43 *";
			break;
		default:
			break;
		};
		break;
	/* sys_getkerninfo */
	case 63:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "int *";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_getpagesize */
	case 64:
		break;
	/* sys_msync */
	case 65:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_vfork */
	case 66:
		break;
	/* sys_mmap */
	case 71:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "int";
			break;
		case 5:
			p = "long";
			break;
		default:
			break;
		};
		break;
	/* sys_ovadvise */
	case 72:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_munmap */
	case 73:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_mprotect */
	case 74:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_madvise */
	case 75:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_mincore */
	case 78:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* sys_getgroups */
	case 79:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "gid_t *";
			break;
		default:
			break;
		};
		break;
	/* sys_setgroups */
	case 80:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const gid_t *";
			break;
		default:
			break;
		};
		break;
	/* sys_getpgrp */
	case 81:
		break;
	/* sys_setpgid */
	case 82:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "pid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_setitimer */
	case 83:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct itimerval50 *";
			break;
		case 2:
			p = "struct itimerval50 *";
			break;
		default:
			break;
		};
		break;
	/* sys_wait */
	case 84:
		break;
	/* sys_swapon */
	case 85:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_getitimer */
	case 86:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct itimerval50 *";
			break;
		default:
			break;
		};
		break;
	/* sys_gethostname */
	case 87:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* sys_sethostname */
	case 88:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* sys_getdtablesize */
	case 89:
		break;
	/* sys_dup2 */
	case 90:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_fcntl */
	case 92:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* sys_select */
	case 93:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "fd_set *";
			break;
		case 2:
			p = "fd_set *";
			break;
		case 3:
			p = "fd_set *";
			break;
		case 4:
			p = "struct timeval50 *";
			break;
		default:
			break;
		};
		break;
	/* sys_fsync */
	case 95:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_setpriority */
	case 96:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "id_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_socket */
	case 97:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_connect */
	case 98:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct sockaddr *";
			break;
		case 2:
			p = "socklen_t";
			break;
		default:
			break;
		};
		break;
	/* sys_accept */
	case 99:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "socklen_t *";
			break;
		default:
			break;
		};
		break;
	/* sys_getpriority */
	case 100:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "id_t";
			break;
		default:
			break;
		};
		break;
	/* sys_send */
	case 101:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_recv */
	case 102:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_sigreturn */
	case 103:
		switch(ndx) {
		case 0:
			p = "struct sigcontext13 *";
			break;
		default:
			break;
		};
		break;
	/* sys_bind */
	case 104:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct sockaddr *";
			break;
		case 2:
			p = "socklen_t";
			break;
		default:
			break;
		};
		break;
	/* sys_setsockopt */
	case 105:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "const void *";
			break;
		case 4:
			p = "socklen_t";
			break;
		default:
			break;
		};
		break;
	/* sys_listen */
	case 106:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_sigvec */
	case 108:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct sigvec *";
			break;
		case 2:
			p = "struct sigvec *";
			break;
		default:
			break;
		};
		break;
	/* sys_sigblock */
	case 109:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_sigsetmask */
	case 110:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_sigsuspend */
	case 111:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_sigstack */
	case 112:
		switch(ndx) {
		case 0:
			p = "struct sigstack *";
			break;
		case 1:
			p = "struct sigstack *";
			break;
		default:
			break;
		};
		break;
	/* sys_recvmsg */
	case 113:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct omsghdr *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_sendmsg */
	case 114:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_gettimeofday */
	case 116:
		switch(ndx) {
		case 0:
			p = "struct timeval50 *";
			break;
		case 1:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* sys_getrusage */
	case 117:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct rusage50 *";
			break;
		default:
			break;
		};
		break;
	/* sys_getsockopt */
	case 118:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "void *";
			break;
		case 4:
			p = "socklen_t *";
			break;
		default:
			break;
		};
		break;
	/* sys_readv */
	case 120:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct iovec *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_writev */
	case 121:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct iovec *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_settimeofday */
	case 122:
		switch(ndx) {
		case 0:
			p = "const struct timeval50 *";
			break;
		case 1:
			p = "const void *";
			break;
		default:
			break;
		};
		break;
	/* sys_fchown */
	case 123:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "uid_t";
			break;
		case 2:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_fchmod */
	case 124:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "mode_t";
			break;
		default:
			break;
		};
		break;
	/* sys_recvfrom */
	case 125:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "void *";
			break;
		case 5:
			p = "socklen_t *";
			break;
		default:
			break;
		};
		break;
	/* sys_setreuid */
	case 126:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		case 1:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_setregid */
	case 127:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		case 1:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_rename */
	case 128:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_truncate */
	case 129:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "long";
			break;
		default:
			break;
		};
		break;
	/* sys_ftruncate */
	case 130:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "long";
			break;
		default:
			break;
		};
		break;
	/* sys_flock */
	case 131:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_mkfifo */
	case 132:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "mode_t";
			break;
		default:
			break;
		};
		break;
	/* sys_sendto */
	case 133:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const void *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "const struct sockaddr *";
			break;
		case 5:
			p = "socklen_t";
			break;
		default:
			break;
		};
		break;
	/* sys_shutdown */
	case 134:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_socketpair */
	case 135:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int *";
			break;
		default:
			break;
		};
		break;
	/* sys_mkdir */
	case 136:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "mode_t";
			break;
		default:
			break;
		};
		break;
	/* sys_rmdir */
	case 137:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_utimes */
	case 138:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "const struct timeval50 *";
			break;
		default:
			break;
		};
		break;
	/* sys_adjtime */
	case 140:
		switch(ndx) {
		case 0:
			p = "const struct timeval50 *";
			break;
		case 1:
			p = "struct timeval50 *";
			break;
		default:
			break;
		};
		break;
	/* sys_getpeername */
	case 141:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "socklen_t *";
			break;
		default:
			break;
		};
		break;
	/* sys_gethostid */
	case 142:
		break;
	/* sys_sethostid */
	case 143:
		switch(ndx) {
		case 0:
			p = "int32_t";
			break;
		default:
			break;
		};
		break;
	/* sys_getrlimit */
	case 144:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct orlimit *";
			break;
		default:
			break;
		};
		break;
	/* sys_setrlimit */
	case 145:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct orlimit *";
			break;
		default:
			break;
		};
		break;
	/* sys_killpg */
	case 146:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_setsid */
	case 147:
		break;
	/* sys_quotactl */
	case 148:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* sys_quota */
	case 149:
		break;
	/* sys_getsockname */
	case 150:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "socklen_t *";
			break;
		default:
			break;
		};
		break;
	/* sys_nfssvc */
	case 155:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* sys_getdirentries */
	case 156:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "u_int";
			break;
		case 3:
			p = "long *";
			break;
		default:
			break;
		};
		break;
	/* sys_statfs */
	case 157:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "struct statfs12 *";
			break;
		default:
			break;
		};
		break;
	/* sys_fstatfs */
	case 158:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct statfs12 *";
			break;
		default:
			break;
		};
		break;
	/* sys_getfh */
	case 161:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "struct compat_30_fhandle *";
			break;
		default:
			break;
		};
		break;
	/* sys_getdomainname */
	case 162:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_setdomainname */
	case 163:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_uname */
	case 164:
		switch(ndx) {
		case 0:
			p = "struct outsname *";
			break;
		default:
			break;
		};
		break;
	/* sys_sysarch */
	case 165:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		default:
			break;
		};
		break;
#if !defined(_LP64)
	/* sys_semsys */
	case 169:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
#else
#endif
#if !defined(_LP64)
	/* sys_msgsys */
	case 170:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "int";
			break;
		case 5:
			p = "int";
			break;
		default:
			break;
		};
		break;
#else
#endif
#if !defined(_LP64)
	/* sys_shmsys */
	case 171:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
#else
#endif
	/* sys_pread */
	case 173:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "off_t";
			break;
		default:
			break;
		};
		break;
	/* sys_pwrite */
	case 174:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const void *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "off_t";
			break;
		default:
			break;
		};
		break;
	/* sys_ntp_gettime */
	case 175:
		switch(ndx) {
		case 0:
			p = "struct ntptimeval30 *";
			break;
		default:
			break;
		};
		break;
#if defined(NTP) || !defined(_KERNEL_OPT)
	/* sys_ntp_adjtime */
	case 176:
		switch(ndx) {
		case 0:
			p = "struct timex *";
			break;
		default:
			break;
		};
		break;
#else
#endif
	/* sys_setgid */
	case 181:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_setegid */
	case 182:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_seteuid */
	case 183:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_lfs_bmapv */
	case 184:
		switch(ndx) {
		case 0:
			p = "fsid_t *";
			break;
		case 1:
			p = "struct block_info *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_lfs_markv */
	case 185:
		switch(ndx) {
		case 0:
			p = "fsid_t *";
			break;
		case 1:
			p = "struct block_info *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_lfs_segclean */
	case 186:
		switch(ndx) {
		case 0:
			p = "fsid_t *";
			break;
		case 1:
			p = "u_long";
			break;
		default:
			break;
		};
		break;
	/* sys_lfs_segwait */
	case 187:
		switch(ndx) {
		case 0:
			p = "fsid_t *";
			break;
		case 1:
			p = "struct timeval50 *";
			break;
		default:
			break;
		};
		break;
	/* sys_stat */
	case 188:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "struct stat12 *";
			break;
		default:
			break;
		};
		break;
	/* sys_fstat */
	case 189:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct stat12 *";
			break;
		default:
			break;
		};
		break;
	/* sys_lstat */
	case 190:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "struct stat12 *";
			break;
		default:
			break;
		};
		break;
	/* sys_pathconf */
	case 191:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_fpathconf */
	case 192:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_getsockopt2 */
	case 193:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "void *";
			break;
		case 4:
			p = "socklen_t *";
			break;
		default:
			break;
		};
		break;
	/* sys_getrlimit */
	case 194:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct rlimit *";
			break;
		default:
			break;
		};
		break;
	/* sys_setrlimit */
	case 195:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct rlimit *";
			break;
		default:
			break;
		};
		break;
	/* sys_getdirentries */
	case 196:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "u_int";
			break;
		case 3:
			p = "long *";
			break;
		default:
			break;
		};
		break;
	/* sys_mmap */
	case 197:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "int";
			break;
		case 5:
			p = "long";
			break;
		case 6:
			p = "off_t";
			break;
		default:
			break;
		};
		break;
	/* sys___syscall */
	case 198:
		switch(ndx) {
		case 0:
			p = "quad_t";
			break;
		case 1:
			p = "register_t";
			break;
		default:
			break;
		};
		break;
	/* sys_lseek */
	case 199:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "off_t";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_truncate */
	case 200:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "off_t";
			break;
		default:
			break;
		};
		break;
	/* sys_ftruncate */
	case 201:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "off_t";
			break;
		default:
			break;
		};
		break;
	/* sys___sysctl */
	case 202:
		switch(ndx) {
		case 0:
			p = "const int *";
			break;
		case 1:
			p = "u_int";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t *";
			break;
		case 4:
			p = "const void *";
			break;
		case 5:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_mlock */
	case 203:
		switch(ndx) {
		case 0:
			p = "const void *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_munlock */
	case 204:
		switch(ndx) {
		case 0:
			p = "const void *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_undelete */
	case 205:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_futimes */
	case 206:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct timeval50 *";
			break;
		default:
			break;
		};
		break;
	/* sys_getpgid */
	case 207:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_reboot */
	case 208:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* sys_poll */
	case 209:
		switch(ndx) {
		case 0:
			p = "struct pollfd *";
			break;
		case 1:
			p = "u_int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_afssys */
	case 210:
		switch(ndx) {
		case 0:
			p = "long";
			break;
		case 1:
			p = "long";
			break;
		case 2:
			p = "long";
			break;
		case 3:
			p = "long";
			break;
		case 4:
			p = "long";
			break;
		case 5:
			p = "long";
			break;
		case 6:
			p = "long";
			break;
		default:
			break;
		};
		break;
	/* sys___semctl */
	case 220:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "union __semun *";
			break;
		default:
			break;
		};
		break;
	/* sys_semget */
	case 221:
		switch(ndx) {
		case 0:
			p = "key_t";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_semop */
	case 222:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct sembuf *";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_semconfig */
	case 223:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_msgctl */
	case 224:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "struct msqid_ds14 *";
			break;
		default:
			break;
		};
		break;
	/* sys_msgget */
	case 225:
		switch(ndx) {
		case 0:
			p = "key_t";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_msgsnd */
	case 226:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const void *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_msgrcv */
	case 227:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "long";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_shmat */
	case 228:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const void *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_shmctl */
	case 229:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "struct shmid_ds14 *";
			break;
		default:
			break;
		};
		break;
	/* sys_shmdt */
	case 230:
		switch(ndx) {
		case 0:
			p = "const void *";
			break;
		default:
			break;
		};
		break;
	/* sys_shmget */
	case 231:
		switch(ndx) {
		case 0:
			p = "key_t";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_clock_gettime */
	case 232:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "struct timespec50 *";
			break;
		default:
			break;
		};
		break;
	/* sys_clock_settime */
	case 233:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "const struct timespec50 *";
			break;
		default:
			break;
		};
		break;
	/* sys_clock_getres */
	case 234:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "struct timespec50 *";
			break;
		default:
			break;
		};
		break;
	/* sys_timer_create */
	case 235:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "struct sigevent *";
			break;
		case 2:
			p = "timer_t *";
			break;
		default:
			break;
		};
		break;
	/* sys_timer_delete */
	case 236:
		switch(ndx) {
		case 0:
			p = "timer_t";
			break;
		default:
			break;
		};
		break;
	/* sys_timer_settime */
	case 237:
		switch(ndx) {
		case 0:
			p = "timer_t";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const struct itimerspec50 *";
			break;
		case 3:
			p = "struct itimerspec50 *";
			break;
		default:
			break;
		};
		break;
	/* sys_timer_gettime */
	case 238:
		switch(ndx) {
		case 0:
			p = "timer_t";
			break;
		case 1:
			p = "struct itimerspec50 *";
			break;
		default:
			break;
		};
		break;
	/* sys_timer_getoverrun */
	case 239:
		switch(ndx) {
		case 0:
			p = "timer_t";
			break;
		default:
			break;
		};
		break;
	/* sys_nanosleep */
	case 240:
		switch(ndx) {
		case 0:
			p = "const struct timespec50 *";
			break;
		case 1:
			p = "struct timespec50 *";
			break;
		default:
			break;
		};
		break;
	/* sys_fdatasync */
	case 241:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_mlockall */
	case 242:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_munlockall */
	case 243:
		break;
	/* sys___sigtimedwait */
	case 244:
		switch(ndx) {
		case 0:
			p = "const sigset_t *";
			break;
		case 1:
			p = "siginfo_t *";
			break;
		case 2:
			p = "struct timespec50 *";
			break;
		default:
			break;
		};
		break;
	/* sys_sigqueueinfo */
	case 245:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "const siginfo_t *";
			break;
		default:
			break;
		};
		break;
	/* sys_modctl */
	case 246:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* sys__ksem_init */
	case 247:
		switch(ndx) {
		case 0:
			p = "unsigned int";
			break;
		case 1:
			p = "intptr_t *";
			break;
		default:
			break;
		};
		break;
	/* sys__ksem_open */
	case 248:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "mode_t";
			break;
		case 3:
			p = "unsigned int";
			break;
		case 4:
			p = "intptr_t *";
			break;
		default:
			break;
		};
		break;
	/* sys__ksem_unlink */
	case 249:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys__ksem_close */
	case 250:
		switch(ndx) {
		case 0:
			p = "intptr_t";
			break;
		default:
			break;
		};
		break;
	/* sys__ksem_post */
	case 251:
		switch(ndx) {
		case 0:
			p = "intptr_t";
			break;
		default:
			break;
		};
		break;
	/* sys__ksem_wait */
	case 252:
		switch(ndx) {
		case 0:
			p = "intptr_t";
			break;
		default:
			break;
		};
		break;
	/* sys__ksem_trywait */
	case 253:
		switch(ndx) {
		case 0:
			p = "intptr_t";
			break;
		default:
			break;
		};
		break;
	/* sys__ksem_getvalue */
	case 254:
		switch(ndx) {
		case 0:
			p = "intptr_t";
			break;
		case 1:
			p = "unsigned int *";
			break;
		default:
			break;
		};
		break;
	/* sys__ksem_destroy */
	case 255:
		switch(ndx) {
		case 0:
			p = "intptr_t";
			break;
		default:
			break;
		};
		break;
	/* sys__ksem_timedwait */
	case 256:
		switch(ndx) {
		case 0:
			p = "intptr_t";
			break;
		case 1:
			p = "const struct timespec *";
			break;
		default:
			break;
		};
		break;
	/* sys_mq_open */
	case 257:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "mode_t";
			break;
		case 3:
			p = "struct mq_attr *";
			break;
		default:
			break;
		};
		break;
	/* sys_mq_close */
	case 258:
		switch(ndx) {
		case 0:
			p = "mqd_t";
			break;
		default:
			break;
		};
		break;
	/* sys_mq_unlink */
	case 259:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_mq_getattr */
	case 260:
		switch(ndx) {
		case 0:
			p = "mqd_t";
			break;
		case 1:
			p = "struct mq_attr *";
			break;
		default:
			break;
		};
		break;
	/* sys_mq_setattr */
	case 261:
		switch(ndx) {
		case 0:
			p = "mqd_t";
			break;
		case 1:
			p = "const struct mq_attr *";
			break;
		case 2:
			p = "struct mq_attr *";
			break;
		default:
			break;
		};
		break;
	/* sys_mq_notify */
	case 262:
		switch(ndx) {
		case 0:
			p = "mqd_t";
			break;
		case 1:
			p = "const struct sigevent *";
			break;
		default:
			break;
		};
		break;
	/* sys_mq_send */
	case 263:
		switch(ndx) {
		case 0:
			p = "mqd_t";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "unsigned";
			break;
		default:
			break;
		};
		break;
	/* sys_mq_receive */
	case 264:
		switch(ndx) {
		case 0:
			p = "mqd_t";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "unsigned *";
			break;
		default:
			break;
		};
		break;
	/* sys_mq_timedsend */
	case 265:
		switch(ndx) {
		case 0:
			p = "mqd_t";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "unsigned";
			break;
		case 4:
			p = "const struct timespec50 *";
			break;
		default:
			break;
		};
		break;
	/* sys_mq_timedreceive */
	case 266:
		switch(ndx) {
		case 0:
			p = "mqd_t";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "unsigned *";
			break;
		case 4:
			p = "const struct timespec50 *";
			break;
		default:
			break;
		};
		break;
	/* sys___posix_rename */
	case 270:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_swapctl */
	case 271:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_getdents */
	case 272:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_minherit */
	case 273:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_lchmod */
	case 274:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "mode_t";
			break;
		default:
			break;
		};
		break;
	/* sys_lchown */
	case 275:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "uid_t";
			break;
		case 2:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_lutimes */
	case 276:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "const struct timeval50 *";
			break;
		default:
			break;
		};
		break;
	/* sys___msync13 */
	case 277:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys___stat13 */
	case 278:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "struct stat13 *";
			break;
		default:
			break;
		};
		break;
	/* sys___fstat13 */
	case 279:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct stat13 *";
			break;
		default:
			break;
		};
		break;
	/* sys___lstat13 */
	case 280:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "struct stat13 *";
			break;
		default:
			break;
		};
		break;
	/* sys___sigaltstack14 */
	case 281:
		switch(ndx) {
		case 0:
			p = "const struct sigaltstack *";
			break;
		case 1:
			p = "struct sigaltstack *";
			break;
		default:
			break;
		};
		break;
	/* sys___vfork14 */
	case 282:
		break;
	/* sys___posix_chown */
	case 283:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "uid_t";
			break;
		case 2:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* sys___posix_fchown */
	case 284:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "uid_t";
			break;
		case 2:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* sys___posix_lchown */
	case 285:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "uid_t";
			break;
		case 2:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_getsid */
	case 286:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		default:
			break;
		};
		break;
	/* sys___clone */
	case 287:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* sys_fktrace */
	case 288:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "pid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_preadv */
	case 289:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct iovec *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "off_t";
			break;
		default:
			break;
		};
		break;
	/* sys_pwritev */
	case 290:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct iovec *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "off_t";
			break;
		default:
			break;
		};
		break;
	/* sys___sigaction14 */
	case 291:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct sigaction *";
			break;
		case 2:
			p = "struct sigaction *";
			break;
		default:
			break;
		};
		break;
	/* sys___sigpending14 */
	case 292:
		switch(ndx) {
		case 0:
			p = "sigset_t *";
			break;
		default:
			break;
		};
		break;
	/* sys___sigprocmask14 */
	case 293:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const sigset_t *";
			break;
		case 2:
			p = "sigset_t *";
			break;
		default:
			break;
		};
		break;
	/* sys___sigsuspend14 */
	case 294:
		switch(ndx) {
		case 0:
			p = "const sigset_t *";
			break;
		default:
			break;
		};
		break;
	/* sys___sigreturn14 */
	case 295:
		switch(ndx) {
		case 0:
			p = "struct sigcontext *";
			break;
		default:
			break;
		};
		break;
	/* sys___getcwd */
	case 296:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_fchroot */
	case 297:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_fhopen */
	case 298:
		switch(ndx) {
		case 0:
			p = "const struct compat_30_fhandle *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_fhstat */
	case 299:
		switch(ndx) {
		case 0:
			p = "const struct compat_30_fhandle *";
			break;
		case 1:
			p = "struct stat13 *";
			break;
		default:
			break;
		};
		break;
	/* sys_fhstatfs */
	case 300:
		switch(ndx) {
		case 0:
			p = "const struct compat_30_fhandle *";
			break;
		case 1:
			p = "struct statfs12 *";
			break;
		default:
			break;
		};
		break;
	/* sys_____semctl13 */
	case 301:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "union __semun *";
			break;
		default:
			break;
		};
		break;
	/* sys___msgctl13 */
	case 302:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "struct msqid_ds *";
			break;
		default:
			break;
		};
		break;
	/* sys___shmctl13 */
	case 303:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "struct shmid_ds13 *";
			break;
		default:
			break;
		};
		break;
	/* sys_lchflags */
	case 304:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "u_long";
			break;
		default:
			break;
		};
		break;
	/* sys_issetugid */
	case 305:
		break;
	/* sys_utrace */
	case 306:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_getcontext */
	case 307:
		switch(ndx) {
		case 0:
			p = "struct __ucontext *";
			break;
		default:
			break;
		};
		break;
	/* sys_setcontext */
	case 308:
		switch(ndx) {
		case 0:
			p = "const struct __ucontext *";
			break;
		default:
			break;
		};
		break;
	/* sys__lwp_create */
	case 309:
		switch(ndx) {
		case 0:
			p = "const struct __ucontext *";
			break;
		case 1:
			p = "u_long";
			break;
		case 2:
			p = "lwpid_t *";
			break;
		default:
			break;
		};
		break;
	/* sys__lwp_exit */
	case 310:
		break;
	/* sys__lwp_self */
	case 311:
		break;
	/* sys__lwp_wait */
	case 312:
		switch(ndx) {
		case 0:
			p = "lwpid_t";
			break;
		case 1:
			p = "lwpid_t *";
			break;
		default:
			break;
		};
		break;
	/* sys__lwp_suspend */
	case 313:
		switch(ndx) {
		case 0:
			p = "lwpid_t";
			break;
		default:
			break;
		};
		break;
	/* sys__lwp_continue */
	case 314:
		switch(ndx) {
		case 0:
			p = "lwpid_t";
			break;
		default:
			break;
		};
		break;
	/* sys__lwp_wakeup */
	case 315:
		switch(ndx) {
		case 0:
			p = "lwpid_t";
			break;
		default:
			break;
		};
		break;
	/* sys__lwp_getprivate */
	case 316:
		break;
	/* sys__lwp_setprivate */
	case 317:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* sys__lwp_kill */
	case 318:
		switch(ndx) {
		case 0:
			p = "lwpid_t";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys__lwp_detach */
	case 319:
		switch(ndx) {
		case 0:
			p = "lwpid_t";
			break;
		default:
			break;
		};
		break;
	/* sys__lwp_park */
	case 320:
		switch(ndx) {
		case 0:
			p = "const struct timespec50 *";
			break;
		case 1:
			p = "lwpid_t";
			break;
		case 2:
			p = "const void *";
			break;
		case 3:
			p = "const void *";
			break;
		default:
			break;
		};
		break;
	/* sys__lwp_unpark */
	case 321:
		switch(ndx) {
		case 0:
			p = "lwpid_t";
			break;
		case 1:
			p = "const void *";
			break;
		default:
			break;
		};
		break;
	/* sys__lwp_unpark_all */
	case 322:
		switch(ndx) {
		case 0:
			p = "const lwpid_t *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "const void *";
			break;
		default:
			break;
		};
		break;
	/* sys__lwp_setname */
	case 323:
		switch(ndx) {
		case 0:
			p = "lwpid_t";
			break;
		case 1:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys__lwp_getname */
	case 324:
		switch(ndx) {
		case 0:
			p = "lwpid_t";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys__lwp_ctl */
	case 325:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct lwpctl **";
			break;
		default:
			break;
		};
		break;
	/* sys_sa_register */
	case 330:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "void **";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "ssize_t";
			break;
		default:
			break;
		};
		break;
	/* sys_sa_stacks */
	case 331:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "stack_t *";
			break;
		default:
			break;
		};
		break;
	/* sys_sa_enable */
	case 332:
		break;
	/* sys_sa_setconcurrency */
	case 333:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_sa_yield */
	case 334:
		break;
	/* sys_sa_preempt */
	case 335:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys___sigaction_sigtramp */
	case 340:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct sigaction *";
			break;
		case 2:
			p = "struct sigaction *";
			break;
		case 3:
			p = "const void *";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_rasctl */
	case 343:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_kqueue */
	case 344:
		break;
	/* sys_kevent */
	case 345:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct kevent *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "struct kevent *";
			break;
		case 4:
			p = "size_t";
			break;
		case 5:
			p = "const struct timespec50 *";
			break;
		default:
			break;
		};
		break;
	/* sys__sched_setparam */
	case 346:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "lwpid_t";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "const struct sched_param *";
			break;
		default:
			break;
		};
		break;
	/* sys__sched_getparam */
	case 347:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "lwpid_t";
			break;
		case 2:
			p = "int *";
			break;
		case 3:
			p = "struct sched_param *";
			break;
		default:
			break;
		};
		break;
	/* sys__sched_setaffinity */
	case 348:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "lwpid_t";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "const cpuset_t *";
			break;
		default:
			break;
		};
		break;
	/* sys__sched_getaffinity */
	case 349:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "lwpid_t";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "cpuset_t *";
			break;
		default:
			break;
		};
		break;
	/* sys_sched_yield */
	case 350:
		break;
	/* sys__sched_protect */
	case 351:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_fsync_range */
	case 354:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "off_t";
			break;
		case 3:
			p = "off_t";
			break;
		default:
			break;
		};
		break;
	/* sys_uuidgen */
	case 355:
		switch(ndx) {
		case 0:
			p = "struct uuid *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_getvfsstat */
	case 356:
		switch(ndx) {
		case 0:
			p = "struct statvfs *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_statvfs1 */
	case 357:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "struct statvfs *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_fstatvfs1 */
	case 358:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct statvfs *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_fhstatvfs1 */
	case 359:
		switch(ndx) {
		case 0:
			p = "const struct compat_30_fhandle *";
			break;
		case 1:
			p = "struct statvfs *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_extattrctl */
	case 360:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const char *";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_extattr_set_file */
	case 361:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const char *";
			break;
		case 3:
			p = "const void *";
			break;
		case 4:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_extattr_get_file */
	case 362:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const char *";
			break;
		case 3:
			p = "void *";
			break;
		case 4:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_extattr_delete_file */
	case 363:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_extattr_set_fd */
	case 364:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const char *";
			break;
		case 3:
			p = "const void *";
			break;
		case 4:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_extattr_get_fd */
	case 365:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const char *";
			break;
		case 3:
			p = "void *";
			break;
		case 4:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_extattr_delete_fd */
	case 366:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_extattr_set_link */
	case 367:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const char *";
			break;
		case 3:
			p = "const void *";
			break;
		case 4:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_extattr_get_link */
	case 368:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const char *";
			break;
		case 3:
			p = "void *";
			break;
		case 4:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_extattr_delete_link */
	case 369:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_extattr_list_fd */
	case 370:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_extattr_list_file */
	case 371:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_extattr_list_link */
	case 372:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_pselect */
	case 373:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "fd_set *";
			break;
		case 2:
			p = "fd_set *";
			break;
		case 3:
			p = "fd_set *";
			break;
		case 4:
			p = "const struct timespec50 *";
			break;
		case 5:
			p = "const sigset_t *";
			break;
		default:
			break;
		};
		break;
	/* sys_pollts */
	case 374:
		switch(ndx) {
		case 0:
			p = "struct pollfd *";
			break;
		case 1:
			p = "u_int";
			break;
		case 2:
			p = "const struct timespec50 *";
			break;
		case 3:
			p = "const sigset_t *";
			break;
		default:
			break;
		};
		break;
	/* sys_setxattr */
	case 375:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "const void *";
			break;
		case 3:
			p = "size_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_lsetxattr */
	case 376:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "const void *";
			break;
		case 3:
			p = "size_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_fsetxattr */
	case 377:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "const void *";
			break;
		case 3:
			p = "size_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_getxattr */
	case 378:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_lgetxattr */
	case 379:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_fgetxattr */
	case 380:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_listxattr */
	case 381:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_llistxattr */
	case 382:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_flistxattr */
	case 383:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_removexattr */
	case 384:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_lremovexattr */
	case 385:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_fremovexattr */
	case 386:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys___stat30 */
	case 387:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "struct stat30 *";
			break;
		default:
			break;
		};
		break;
	/* sys___fstat30 */
	case 388:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct stat30 *";
			break;
		default:
			break;
		};
		break;
	/* sys___lstat30 */
	case 389:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "struct stat30 *";
			break;
		default:
			break;
		};
		break;
	/* sys___getdents30 */
	case 390:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys___fhstat30 */
	case 392:
		switch(ndx) {
		case 0:
			p = "const struct compat_30_fhandle *";
			break;
		case 1:
			p = "struct stat30 *";
			break;
		default:
			break;
		};
		break;
	/* sys___ntp_gettime30 */
	case 393:
		switch(ndx) {
		case 0:
			p = "struct ntptimeval50 *";
			break;
		default:
			break;
		};
		break;
	/* sys___socket30 */
	case 394:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys___getfh30 */
	case 395:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "size_t *";
			break;
		default:
			break;
		};
		break;
	/* sys___fhopen40 */
	case 396:
		switch(ndx) {
		case 0:
			p = "const void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys___fhstatvfs140 */
	case 397:
		switch(ndx) {
		case 0:
			p = "const void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "struct statvfs *";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys___fhstat40 */
	case 398:
		switch(ndx) {
		case 0:
			p = "const void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "struct stat30 *";
			break;
		default:
			break;
		};
		break;
	/* sys_aio_cancel */
	case 399:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct aiocb *";
			break;
		default:
			break;
		};
		break;
	/* sys_aio_error */
	case 400:
		switch(ndx) {
		case 0:
			p = "const struct aiocb *";
			break;
		default:
			break;
		};
		break;
	/* sys_aio_fsync */
	case 401:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct aiocb *";
			break;
		default:
			break;
		};
		break;
	/* sys_aio_read */
	case 402:
		switch(ndx) {
		case 0:
			p = "struct aiocb *";
			break;
		default:
			break;
		};
		break;
	/* sys_aio_return */
	case 403:
		switch(ndx) {
		case 0:
			p = "struct aiocb *";
			break;
		default:
			break;
		};
		break;
	/* sys_aio_suspend */
	case 404:
		switch(ndx) {
		case 0:
			p = "const struct aiocb *const *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const struct timespec50 *";
			break;
		default:
			break;
		};
		break;
	/* sys_aio_write */
	case 405:
		switch(ndx) {
		case 0:
			p = "struct aiocb *";
			break;
		default:
			break;
		};
		break;
	/* sys_lio_listio */
	case 406:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct aiocb *const *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "struct sigevent *";
			break;
		default:
			break;
		};
		break;
	/* sys___mount50 */
	case 410:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "void *";
			break;
		case 4:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_mremap */
	case 411:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_pset_create */
	case 412:
		switch(ndx) {
		case 0:
			p = "psetid_t *";
			break;
		default:
			break;
		};
		break;
	/* sys_pset_destroy */
	case 413:
		switch(ndx) {
		case 0:
			p = "psetid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_pset_assign */
	case 414:
		switch(ndx) {
		case 0:
			p = "psetid_t";
			break;
		case 1:
			p = "cpuid_t";
			break;
		case 2:
			p = "psetid_t *";
			break;
		default:
			break;
		};
		break;
	/* sys__pset_bind */
	case 415:
		switch(ndx) {
		case 0:
			p = "idtype_t";
			break;
		case 1:
			p = "id_t";
			break;
		case 2:
			p = "id_t";
			break;
		case 3:
			p = "psetid_t";
			break;
		case 4:
			p = "psetid_t *";
			break;
		default:
			break;
		};
		break;
	/* sys___posix_fadvise50 */
	case 416:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "off_t";
			break;
		case 3:
			p = "off_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys___select50 */
	case 417:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "fd_set *";
			break;
		case 2:
			p = "fd_set *";
			break;
		case 3:
			p = "fd_set *";
			break;
		case 4:
			p = "struct timeval *";
			break;
		default:
			break;
		};
		break;
	/* sys___gettimeofday50 */
	case 418:
		switch(ndx) {
		case 0:
			p = "struct timeval *";
			break;
		case 1:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* sys___settimeofday50 */
	case 419:
		switch(ndx) {
		case 0:
			p = "const struct timeval *";
			break;
		case 1:
			p = "const void *";
			break;
		default:
			break;
		};
		break;
	/* sys___utimes50 */
	case 420:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "const struct timeval *";
			break;
		default:
			break;
		};
		break;
	/* sys___adjtime50 */
	case 421:
		switch(ndx) {
		case 0:
			p = "const struct timeval *";
			break;
		case 1:
			p = "struct timeval *";
			break;
		default:
			break;
		};
		break;
	/* sys___lfs_segwait50 */
	case 422:
		switch(ndx) {
		case 0:
			p = "fsid_t *";
			break;
		case 1:
			p = "struct timeval *";
			break;
		default:
			break;
		};
		break;
	/* sys___futimes50 */
	case 423:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct timeval *";
			break;
		default:
			break;
		};
		break;
	/* sys___lutimes50 */
	case 424:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "const struct timeval *";
			break;
		default:
			break;
		};
		break;
	/* sys___setitimer50 */
	case 425:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct itimerval *";
			break;
		case 2:
			p = "struct itimerval *";
			break;
		default:
			break;
		};
		break;
	/* sys___getitimer50 */
	case 426:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct itimerval *";
			break;
		default:
			break;
		};
		break;
	/* sys___clock_gettime50 */
	case 427:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "struct timespec *";
			break;
		default:
			break;
		};
		break;
	/* sys___clock_settime50 */
	case 428:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "const struct timespec *";
			break;
		default:
			break;
		};
		break;
	/* sys___clock_getres50 */
	case 429:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "struct timespec *";
			break;
		default:
			break;
		};
		break;
	/* sys___nanosleep50 */
	case 430:
		switch(ndx) {
		case 0:
			p = "const struct timespec *";
			break;
		case 1:
			p = "struct timespec *";
			break;
		default:
			break;
		};
		break;
	/* sys_____sigtimedwait50 */
	case 431:
		switch(ndx) {
		case 0:
			p = "const sigset_t *";
			break;
		case 1:
			p = "siginfo_t *";
			break;
		case 2:
			p = "struct timespec *";
			break;
		default:
			break;
		};
		break;
	/* sys___mq_timedsend50 */
	case 432:
		switch(ndx) {
		case 0:
			p = "mqd_t";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "unsigned";
			break;
		case 4:
			p = "const struct timespec *";
			break;
		default:
			break;
		};
		break;
	/* sys___mq_timedreceive50 */
	case 433:
		switch(ndx) {
		case 0:
			p = "mqd_t";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "unsigned *";
			break;
		case 4:
			p = "const struct timespec *";
			break;
		default:
			break;
		};
		break;
	/* sys__lwp_park */
	case 434:
		switch(ndx) {
		case 0:
			p = "const struct timespec *";
			break;
		case 1:
			p = "lwpid_t";
			break;
		case 2:
			p = "const void *";
			break;
		case 3:
			p = "const void *";
			break;
		default:
			break;
		};
		break;
	/* sys___kevent50 */
	case 435:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct kevent *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "struct kevent *";
			break;
		case 4:
			p = "size_t";
			break;
		case 5:
			p = "const struct timespec *";
			break;
		default:
			break;
		};
		break;
	/* sys___pselect50 */
	case 436:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "fd_set *";
			break;
		case 2:
			p = "fd_set *";
			break;
		case 3:
			p = "fd_set *";
			break;
		case 4:
			p = "const struct timespec *";
			break;
		case 5:
			p = "const sigset_t *";
			break;
		default:
			break;
		};
		break;
	/* sys___pollts50 */
	case 437:
		switch(ndx) {
		case 0:
			p = "struct pollfd *";
			break;
		case 1:
			p = "u_int";
			break;
		case 2:
			p = "const struct timespec *";
			break;
		case 3:
			p = "const sigset_t *";
			break;
		default:
			break;
		};
		break;
	/* sys___aio_suspend50 */
	case 438:
		switch(ndx) {
		case 0:
			p = "const struct aiocb *const *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const struct timespec *";
			break;
		default:
			break;
		};
		break;
	/* sys___stat50 */
	case 439:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "struct stat *";
			break;
		default:
			break;
		};
		break;
	/* sys___fstat50 */
	case 440:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct stat *";
			break;
		default:
			break;
		};
		break;
	/* sys___lstat50 */
	case 441:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "struct stat *";
			break;
		default:
			break;
		};
		break;
	/* sys_____semctl50 */
	case 442:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "union __semun *";
			break;
		default:
			break;
		};
		break;
	/* sys___shmctl50 */
	case 443:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "struct shmid_ds *";
			break;
		default:
			break;
		};
		break;
	/* sys___msgctl50 */
	case 444:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "struct msqid_ds *";
			break;
		default:
			break;
		};
		break;
	/* sys___getrusage50 */
	case 445:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct rusage *";
			break;
		default:
			break;
		};
		break;
	/* sys___timer_settime50 */
	case 446:
		switch(ndx) {
		case 0:
			p = "timer_t";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const struct itimerspec *";
			break;
		case 3:
			p = "struct itimerspec *";
			break;
		default:
			break;
		};
		break;
	/* sys___timer_gettime50 */
	case 447:
		switch(ndx) {
		case 0:
			p = "timer_t";
			break;
		case 1:
			p = "struct itimerspec *";
			break;
		default:
			break;
		};
		break;
#if defined(NTP) || !defined(_KERNEL_OPT)
	/* sys___ntp_gettime50 */
	case 448:
		switch(ndx) {
		case 0:
			p = "struct ntptimeval *";
			break;
		default:
			break;
		};
		break;
#else
#endif
	/* sys___wait450 */
	case 449:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "int *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "struct rusage *";
			break;
		default:
			break;
		};
		break;
	/* sys___mknod50 */
	case 450:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "mode_t";
			break;
		case 2:
			p = "dev_t";
			break;
		default:
			break;
		};
		break;
	/* sys___fhstat50 */
	case 451:
		switch(ndx) {
		case 0:
			p = "const void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "struct stat *";
			break;
		default:
			break;
		};
		break;
	/* sys_pipe2 */
	case 453:
		switch(ndx) {
		case 0:
			p = "int *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_dup3 */
	case 454:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_kqueue1 */
	case 455:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_paccept */
	case 456:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct sockaddr *";
			break;
		case 2:
			p = "socklen_t *";
			break;
		case 3:
			p = "const sigset_t *";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_linkat */
	case 457:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "const char *";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_renameat */
	case 458:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_mkfifoat */
	case 459:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "mode_t";
			break;
		default:
			break;
		};
		break;
	/* sys_mknodat */
	case 460:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "mode_t";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "dev_t";
			break;
		default:
			break;
		};
		break;
	/* sys_mkdirat */
	case 461:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "mode_t";
			break;
		default:
			break;
		};
		break;
	/* sys_faccessat */
	case 462:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_fchmodat */
	case 463:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "mode_t";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_fchownat */
	case 464:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "uid_t";
			break;
		case 3:
			p = "gid_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_fexecve */
	case 465:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *const *";
			break;
		case 2:
			p = "char *const *";
			break;
		default:
			break;
		};
		break;
	/* sys_fstatat */
	case 466:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "struct stat *";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_utimensat */
	case 467:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "const struct timespec *";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_openat */
	case 468:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "mode_t";
			break;
		default:
			break;
		};
		break;
	/* sys_readlinkat */
	case 469:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "char *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_symlinkat */
	case 470:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_unlinkat */
	case 471:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_futimens */
	case 472:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct timespec *";
			break;
		default:
			break;
		};
		break;
	/* sys___quotactl */
	case 473:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "struct quotactl_args *";
			break;
		default:
			break;
		};
		break;
	/* sys_posix_spawn */
	case 474:
		switch(ndx) {
		case 0:
			p = "pid_t *";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "const struct posix_spawn_file_actions *";
			break;
		case 3:
			p = "const struct posix_spawnattr *";
			break;
		case 4:
			p = "char *const *";
			break;
		case 5:
			p = "char *const *";
			break;
		default:
			break;
		};
		break;
	/* sys_recvmmsg */
	case 475:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct mmsghdr *";
			break;
		case 2:
			p = "unsigned int";
			break;
		case 3:
			p = "unsigned int";
			break;
		case 4:
			p = "struct timespec *";
			break;
		default:
			break;
		};
		break;
	/* sys_sendmmsg */
	case 476:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct mmsghdr *";
			break;
		case 2:
			p = "unsigned int";
			break;
		case 3:
			p = "unsigned int";
			break;
		default:
			break;
		};
		break;
	/* sys_clock_nanosleep */
	case 477:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const struct timespec *";
			break;
		case 3:
			p = "struct timespec *";
			break;
		default:
			break;
		};
		break;
	/* sys____lwp_park60 */
	case 478:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "struct timespec *";
			break;
		case 3:
			p = "lwpid_t";
			break;
		case 4:
			p = "const void *";
			break;
		case 5:
			p = "const void *";
			break;
		default:
			break;
		};
		break;
	/* sys_posix_fallocate */
	case 479:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "off_t";
			break;
		case 3:
			p = "off_t";
			break;
		default:
			break;
		};
		break;
	/* sys_fdiscard */
	case 480:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "off_t";
			break;
		case 3:
			p = "off_t";
			break;
		default:
			break;
		};
		break;
	/* sys_wait6 */
	case 481:
		switch(ndx) {
		case 0:
			p = "idtype_t";
			break;
		case 1:
			p = "id_t";
			break;
		case 2:
			p = "int *";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "struct wrusage *";
			break;
		case 5:
			p = "siginfo_t *";
			break;
		default:
			break;
		};
		break;
	/* sys_clock_getcpuclockid2 */
	case 482:
		switch(ndx) {
		case 0:
			p = "idtype_t";
			break;
		case 1:
			p = "id_t";
			break;
		case 2:
			p = "clockid_t *";
			break;
		default:
			break;
		};
		break;
	default:
		break;
	};
	if (p != NULL)
		strlcpy(desc, p, descsz);
}
static void
systrace_return_setargdesc(int sysnum, int ndx, char *desc, size_t descsz)
{
	const char *p = NULL;
	switch (sysnum) {
	/* sys_syscall */
	case 0:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_exit */
	case 1:
		if (ndx == 0 || ndx == 1)
			p = "void";
		break;
	/* sys_fork */
	case 2:
	/* sys_read */
	case 3:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_write */
	case 4:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_open */
	case 5:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_close */
	case 6:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_wait4 */
	case 7:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_creat */
	case 8:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_link */
	case 9:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_unlink */
	case 10:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_chdir */
	case 12:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fchdir */
	case 13:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mknod */
	case 14:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_chmod */
	case 15:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_chown */
	case 16:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_obreak */
	case 17:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getfsstat */
	case 18:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_lseek */
	case 19:
		if (ndx == 0 || ndx == 1)
			p = "long";
		break;
	/* sys_getpid_with_ppid */
	case 20:
	/* sys_mount */
	case 21:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_unmount */
	case 22:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_setuid */
	case 23:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getuid_with_euid */
	case 24:
	/* sys_geteuid */
	case 25:
	/* sys_ptrace */
	case 26:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_recvmsg */
	case 27:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_sendmsg */
	case 28:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_recvfrom */
	case 29:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_accept */
	case 30:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getpeername */
	case 31:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getsockname */
	case 32:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_access */
	case 33:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_chflags */
	case 34:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fchflags */
	case 35:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_sync */
	case 36:
	/* sys_kill */
	case 37:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_stat */
	case 38:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getppid */
	case 39:
	/* sys_lstat */
	case 40:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_dup */
	case 41:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_pipe */
	case 42:
	/* sys_getegid */
	case 43:
	/* sys_profil */
	case 44:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_ktrace */
	case 45:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_sigaction */
	case 46:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getgid_with_egid */
	case 47:
	/* sys_sigprocmask */
	case 48:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___getlogin */
	case 49:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___setlogin */
	case 50:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_acct */
	case 51:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_sigpending */
	case 52:
	/* sys_sigaltstack */
	case 53:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_ioctl */
	case 54:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_reboot */
	case 55:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_revoke */
	case 56:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_symlink */
	case 57:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_readlink */
	case 58:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_execve */
	case 59:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_umask */
	case 60:
		if (ndx == 0 || ndx == 1)
			p = "mode_t";
		break;
	/* sys_chroot */
	case 61:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fstat */
	case 62:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getkerninfo */
	case 63:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getpagesize */
	case 64:
	/* sys_msync */
	case 65:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_vfork */
	case 66:
	/* sys_mmap */
	case 71:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_ovadvise */
	case 72:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_munmap */
	case 73:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mprotect */
	case 74:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_madvise */
	case 75:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mincore */
	case 78:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getgroups */
	case 79:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_setgroups */
	case 80:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getpgrp */
	case 81:
	/* sys_setpgid */
	case 82:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_setitimer */
	case 83:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_wait */
	case 84:
	/* sys_swapon */
	case 85:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getitimer */
	case 86:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_gethostname */
	case 87:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_sethostname */
	case 88:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getdtablesize */
	case 89:
	/* sys_dup2 */
	case 90:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fcntl */
	case 92:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_select */
	case 93:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fsync */
	case 95:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_setpriority */
	case 96:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_socket */
	case 97:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_connect */
	case 98:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_accept */
	case 99:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getpriority */
	case 100:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_send */
	case 101:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_recv */
	case 102:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_sigreturn */
	case 103:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_bind */
	case 104:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_setsockopt */
	case 105:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_listen */
	case 106:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_sigvec */
	case 108:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_sigblock */
	case 109:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_sigsetmask */
	case 110:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_sigsuspend */
	case 111:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_sigstack */
	case 112:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_recvmsg */
	case 113:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_sendmsg */
	case 114:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_gettimeofday */
	case 116:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getrusage */
	case 117:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getsockopt */
	case 118:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_readv */
	case 120:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_writev */
	case 121:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_settimeofday */
	case 122:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fchown */
	case 123:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fchmod */
	case 124:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_recvfrom */
	case 125:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_setreuid */
	case 126:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_setregid */
	case 127:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_rename */
	case 128:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_truncate */
	case 129:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_ftruncate */
	case 130:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_flock */
	case 131:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mkfifo */
	case 132:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_sendto */
	case 133:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_shutdown */
	case 134:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_socketpair */
	case 135:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mkdir */
	case 136:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_rmdir */
	case 137:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_utimes */
	case 138:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_adjtime */
	case 140:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getpeername */
	case 141:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_gethostid */
	case 142:
	/* sys_sethostid */
	case 143:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getrlimit */
	case 144:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_setrlimit */
	case 145:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_killpg */
	case 146:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_setsid */
	case 147:
	/* sys_quotactl */
	case 148:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_quota */
	case 149:
	/* sys_getsockname */
	case 150:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_nfssvc */
	case 155:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getdirentries */
	case 156:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_statfs */
	case 157:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fstatfs */
	case 158:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getfh */
	case 161:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getdomainname */
	case 162:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_setdomainname */
	case 163:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_uname */
	case 164:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_sysarch */
	case 165:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#if !defined(_LP64)
	/* sys_semsys */
	case 169:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#else
#endif
#if !defined(_LP64)
	/* sys_msgsys */
	case 170:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#else
#endif
#if !defined(_LP64)
	/* sys_shmsys */
	case 171:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#else
#endif
	/* sys_pread */
	case 173:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_pwrite */
	case 174:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_ntp_gettime */
	case 175:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#if defined(NTP) || !defined(_KERNEL_OPT)
	/* sys_ntp_adjtime */
	case 176:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#else
#endif
	/* sys_setgid */
	case 181:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_setegid */
	case 182:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_seteuid */
	case 183:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_lfs_bmapv */
	case 184:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_lfs_markv */
	case 185:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_lfs_segclean */
	case 186:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_lfs_segwait */
	case 187:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_stat */
	case 188:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fstat */
	case 189:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_lstat */
	case 190:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_pathconf */
	case 191:
		if (ndx == 0 || ndx == 1)
			p = "long";
		break;
	/* sys_fpathconf */
	case 192:
		if (ndx == 0 || ndx == 1)
			p = "long";
		break;
	/* sys_getsockopt2 */
	case 193:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getrlimit */
	case 194:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_setrlimit */
	case 195:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getdirentries */
	case 196:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mmap */
	case 197:
		if (ndx == 0 || ndx == 1)
			p = "void *";
		break;
	/* sys___syscall */
	case 198:
		if (ndx == 0 || ndx == 1)
			p = "quad_t";
		break;
	/* sys_lseek */
	case 199:
		if (ndx == 0 || ndx == 1)
			p = "off_t";
		break;
	/* sys_truncate */
	case 200:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_ftruncate */
	case 201:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___sysctl */
	case 202:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mlock */
	case 203:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_munlock */
	case 204:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_undelete */
	case 205:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_futimes */
	case 206:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getpgid */
	case 207:
		if (ndx == 0 || ndx == 1)
			p = "pid_t";
		break;
	/* sys_reboot */
	case 208:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_poll */
	case 209:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_afssys */
	case 210:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___semctl */
	case 220:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_semget */
	case 221:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_semop */
	case 222:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_semconfig */
	case 223:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_msgctl */
	case 224:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_msgget */
	case 225:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_msgsnd */
	case 226:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_msgrcv */
	case 227:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_shmat */
	case 228:
		if (ndx == 0 || ndx == 1)
			p = "void *";
		break;
	/* sys_shmctl */
	case 229:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_shmdt */
	case 230:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_shmget */
	case 231:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_clock_gettime */
	case 232:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_clock_settime */
	case 233:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_clock_getres */
	case 234:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_timer_create */
	case 235:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_timer_delete */
	case 236:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_timer_settime */
	case 237:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_timer_gettime */
	case 238:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_timer_getoverrun */
	case 239:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_nanosleep */
	case 240:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fdatasync */
	case 241:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mlockall */
	case 242:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_munlockall */
	case 243:
	/* sys___sigtimedwait */
	case 244:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_sigqueueinfo */
	case 245:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_modctl */
	case 246:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__ksem_init */
	case 247:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__ksem_open */
	case 248:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__ksem_unlink */
	case 249:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__ksem_close */
	case 250:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__ksem_post */
	case 251:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__ksem_wait */
	case 252:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__ksem_trywait */
	case 253:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__ksem_getvalue */
	case 254:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__ksem_destroy */
	case 255:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__ksem_timedwait */
	case 256:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mq_open */
	case 257:
		if (ndx == 0 || ndx == 1)
			p = "mqd_t";
		break;
	/* sys_mq_close */
	case 258:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mq_unlink */
	case 259:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mq_getattr */
	case 260:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mq_setattr */
	case 261:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mq_notify */
	case 262:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mq_send */
	case 263:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mq_receive */
	case 264:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_mq_timedsend */
	case 265:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mq_timedreceive */
	case 266:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys___posix_rename */
	case 270:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_swapctl */
	case 271:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getdents */
	case 272:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_minherit */
	case 273:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_lchmod */
	case 274:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_lchown */
	case 275:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_lutimes */
	case 276:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___msync13 */
	case 277:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___stat13 */
	case 278:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___fstat13 */
	case 279:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___lstat13 */
	case 280:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___sigaltstack14 */
	case 281:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___vfork14 */
	case 282:
	/* sys___posix_chown */
	case 283:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___posix_fchown */
	case 284:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___posix_lchown */
	case 285:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getsid */
	case 286:
		if (ndx == 0 || ndx == 1)
			p = "pid_t";
		break;
	/* sys___clone */
	case 287:
		if (ndx == 0 || ndx == 1)
			p = "pid_t";
		break;
	/* sys_fktrace */
	case 288:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_preadv */
	case 289:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_pwritev */
	case 290:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys___sigaction14 */
	case 291:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___sigpending14 */
	case 292:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___sigprocmask14 */
	case 293:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___sigsuspend14 */
	case 294:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___sigreturn14 */
	case 295:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___getcwd */
	case 296:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fchroot */
	case 297:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fhopen */
	case 298:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fhstat */
	case 299:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fhstatfs */
	case 300:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_____semctl13 */
	case 301:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___msgctl13 */
	case 302:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___shmctl13 */
	case 303:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_lchflags */
	case 304:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_issetugid */
	case 305:
	/* sys_utrace */
	case 306:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getcontext */
	case 307:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_setcontext */
	case 308:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__lwp_create */
	case 309:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__lwp_exit */
	case 310:
	/* sys__lwp_self */
	case 311:
	/* sys__lwp_wait */
	case 312:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__lwp_suspend */
	case 313:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__lwp_continue */
	case 314:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__lwp_wakeup */
	case 315:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__lwp_getprivate */
	case 316:
	/* sys__lwp_setprivate */
	case 317:
		if (ndx == 0 || ndx == 1)
			p = "void";
		break;
	/* sys__lwp_kill */
	case 318:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__lwp_detach */
	case 319:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__lwp_park */
	case 320:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__lwp_unpark */
	case 321:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__lwp_unpark_all */
	case 322:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys__lwp_setname */
	case 323:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__lwp_getname */
	case 324:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__lwp_ctl */
	case 325:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_sa_register */
	case 330:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_sa_stacks */
	case 331:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_sa_enable */
	case 332:
	/* sys_sa_setconcurrency */
	case 333:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_sa_yield */
	case 334:
	/* sys_sa_preempt */
	case 335:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___sigaction_sigtramp */
	case 340:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_rasctl */
	case 343:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_kqueue */
	case 344:
	/* sys_kevent */
	case 345:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__sched_setparam */
	case 346:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__sched_getparam */
	case 347:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__sched_setaffinity */
	case 348:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__sched_getaffinity */
	case 349:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_sched_yield */
	case 350:
	/* sys__sched_protect */
	case 351:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fsync_range */
	case 354:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_uuidgen */
	case 355:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getvfsstat */
	case 356:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_statvfs1 */
	case 357:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fstatvfs1 */
	case 358:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fhstatvfs1 */
	case 359:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_extattrctl */
	case 360:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_extattr_set_file */
	case 361:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_extattr_get_file */
	case 362:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_extattr_delete_file */
	case 363:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_extattr_set_fd */
	case 364:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_extattr_get_fd */
	case 365:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_extattr_delete_fd */
	case 366:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_extattr_set_link */
	case 367:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_extattr_get_link */
	case 368:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_extattr_delete_link */
	case 369:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_extattr_list_fd */
	case 370:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_extattr_list_file */
	case 371:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_extattr_list_link */
	case 372:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_pselect */
	case 373:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_pollts */
	case 374:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_setxattr */
	case 375:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_lsetxattr */
	case 376:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fsetxattr */
	case 377:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getxattr */
	case 378:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_lgetxattr */
	case 379:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fgetxattr */
	case 380:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_listxattr */
	case 381:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_llistxattr */
	case 382:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_flistxattr */
	case 383:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_removexattr */
	case 384:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_lremovexattr */
	case 385:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fremovexattr */
	case 386:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___stat30 */
	case 387:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___fstat30 */
	case 388:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___lstat30 */
	case 389:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___getdents30 */
	case 390:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___fhstat30 */
	case 392:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___ntp_gettime30 */
	case 393:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___socket30 */
	case 394:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___getfh30 */
	case 395:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___fhopen40 */
	case 396:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___fhstatvfs140 */
	case 397:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___fhstat40 */
	case 398:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_aio_cancel */
	case 399:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_aio_error */
	case 400:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_aio_fsync */
	case 401:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_aio_read */
	case 402:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_aio_return */
	case 403:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_aio_suspend */
	case 404:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_aio_write */
	case 405:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_lio_listio */
	case 406:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___mount50 */
	case 410:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mremap */
	case 411:
		if (ndx == 0 || ndx == 1)
			p = "void *";
		break;
	/* sys_pset_create */
	case 412:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_pset_destroy */
	case 413:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_pset_assign */
	case 414:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys__pset_bind */
	case 415:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___posix_fadvise50 */
	case 416:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___select50 */
	case 417:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___gettimeofday50 */
	case 418:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___settimeofday50 */
	case 419:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___utimes50 */
	case 420:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___adjtime50 */
	case 421:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___lfs_segwait50 */
	case 422:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___futimes50 */
	case 423:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___lutimes50 */
	case 424:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___setitimer50 */
	case 425:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___getitimer50 */
	case 426:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___clock_gettime50 */
	case 427:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___clock_settime50 */
	case 428:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___clock_getres50 */
	case 429:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___nanosleep50 */
	case 430:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_____sigtimedwait50 */
	case 431:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___mq_timedsend50 */
	case 432:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___mq_timedreceive50 */
	case 433:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys__lwp_park */
	case 434:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___kevent50 */
	case 435:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___pselect50 */
	case 436:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___pollts50 */
	case 437:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___aio_suspend50 */
	case 438:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___stat50 */
	case 439:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___fstat50 */
	case 440:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___lstat50 */
	case 441:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_____semctl50 */
	case 442:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___shmctl50 */
	case 443:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___msgctl50 */
	case 444:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___getrusage50 */
	case 445:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___timer_settime50 */
	case 446:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___timer_gettime50 */
	case 447:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#if defined(NTP) || !defined(_KERNEL_OPT)
	/* sys___ntp_gettime50 */
	case 448:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#else
#endif
	/* sys___wait450 */
	case 449:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___mknod50 */
	case 450:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___fhstat50 */
	case 451:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_pipe2 */
	case 453:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_dup3 */
	case 454:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_kqueue1 */
	case 455:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_paccept */
	case 456:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_linkat */
	case 457:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_renameat */
	case 458:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mkfifoat */
	case 459:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mknodat */
	case 460:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mkdirat */
	case 461:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_faccessat */
	case 462:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fchmodat */
	case 463:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fchownat */
	case 464:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fexecve */
	case 465:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fstatat */
	case 466:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_utimensat */
	case 467:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_openat */
	case 468:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_readlinkat */
	case 469:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_symlinkat */
	case 470:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_unlinkat */
	case 471:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_futimens */
	case 472:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___quotactl */
	case 473:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_posix_spawn */
	case 474:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_recvmmsg */
	case 475:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_sendmmsg */
	case 476:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_clock_nanosleep */
	case 477:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys____lwp_park60 */
	case 478:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_posix_fallocate */
	case 479:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fdiscard */
	case 480:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_wait6 */
	case 481:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_clock_getcpuclockid2 */
	case 482:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	default:
		break;
	};
	if (p != NULL)
		strlcpy(desc, p, descsz);
}
