/* $OpenBSD: verify.c,v 1.3 2013/12/09 11:03:45 markus Exp $ */

/*
 * Public Domain, Author: Daniel J. Bernstein
 * Copied from nacl-20110221/crypto_verify/32/ref/verify.c
 */
#include "includes.h"
__RCSID("$NetBSD: verify.c,v 1.5 2017/04/18 18:41:46 christos Exp $");

#include "crypto_api.h"

int crypto_verify_32(const unsigned char *x,const unsigned char *y)
{
  unsigned int differentbits = 0;
#define F(i) differentbits |= x[i] ^ y[i];
  F(0)
  F(1)
  F(2)
  F(3)
  F(4)
  F(5)
  F(6)
  F(7)
  F(8)
  F(9)
  F(10)
  F(11)
  F(12)
  F(13)
  F(14)
  F(15)
  F(16)
  F(17)
  F(18)
  F(19)
  F(20)
  F(21)
  F(22)
  F(23)
  F(24)
  F(25)
  F(26)
  F(27)
  F(28)
  F(29)
  F(30)
  F(31)
  return (1 & ((differentbits - 1) >> 8)) - 1;
}
