// This file was generated by gir (https://github.com/gtk-rs/gir)
// from ../ev-girs
// from ../gir-files
// DO NOT EDIT

use crate::ffi;
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "PpsViewPresentation")]
    pub struct ViewPresentation(Object<ffi::PpsViewPresentation, ffi::PpsViewPresentationClass>) @extends gtk::Widget;

    match fn {
        type_ => || ffi::pps_view_presentation_get_type(),
    }
}

impl ViewPresentation {
    #[doc(alias = "pps_view_presentation_new")]
    pub fn new(
        document: &impl IsA<papers_document::Document>,
        current_page: u32,
        rotation: u32,
        inverted_colors: bool,
    ) -> ViewPresentation {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_none(ffi::pps_view_presentation_new(
                document.as_ref().to_glib_none().0,
                current_page,
                rotation,
                inverted_colors.into_glib(),
            ))
        }
    }

    #[doc(alias = "pps_view_presentation_get_current_page")]
    #[doc(alias = "get_current_page")]
    #[doc(alias = "current-page")]
    pub fn current_page(&self) -> u32 {
        unsafe { ffi::pps_view_presentation_get_current_page(self.to_glib_none().0) }
    }

    #[doc(alias = "pps_view_presentation_get_rotation")]
    #[doc(alias = "get_rotation")]
    pub fn rotation(&self) -> u32 {
        unsafe { ffi::pps_view_presentation_get_rotation(self.to_glib_none().0) }
    }

    #[doc(alias = "pps_view_presentation_next_page")]
    pub fn next_page(&self) {
        unsafe {
            ffi::pps_view_presentation_next_page(self.to_glib_none().0);
        }
    }

    #[doc(alias = "pps_view_presentation_previous_page")]
    pub fn previous_page(&self) {
        unsafe {
            ffi::pps_view_presentation_previous_page(self.to_glib_none().0);
        }
    }

    #[doc(alias = "pps_view_presentation_set_rotation")]
    #[doc(alias = "rotation")]
    pub fn set_rotation(&self, rotation: i32) {
        unsafe {
            ffi::pps_view_presentation_set_rotation(self.to_glib_none().0, rotation);
        }
    }

    #[doc(alias = "current-page")]
    pub fn set_current_page(&self, current_page: u32) {
        ObjectExt::set_property(self, "current-page", current_page)
    }

    pub fn set_document<P: IsA<papers_document::Document>>(&self, document: Option<&P>) {
        ObjectExt::set_property(self, "document", document)
    }

    #[doc(alias = "inverted-colors")]
    pub fn set_inverted_colors(&self, inverted_colors: bool) {
        ObjectExt::set_property(self, "inverted-colors", inverted_colors)
    }

    #[doc(alias = "change-page")]
    pub fn connect_change_page<F: Fn(&Self, gtk::ScrollType) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn change_page_trampoline<
            F: Fn(&ViewPresentation, gtk::ScrollType) + 'static,
        >(
            this: *mut ffi::PpsViewPresentation,
            object: gtk::ffi::GtkScrollType,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), from_glib(object))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"change-page\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    change_page_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn emit_change_page(&self, object: gtk::ScrollType) {
        self.emit_by_name::<()>("change-page", &[&object]);
    }

    #[doc(alias = "external-link")]
    pub fn connect_external_link<F: Fn(&Self, &papers_document::LinkAction) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn external_link_trampoline<
            F: Fn(&ViewPresentation, &papers_document::LinkAction) + 'static,
        >(
            this: *mut ffi::PpsViewPresentation,
            object: *mut papers_document::ffi::PpsLinkAction,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(object))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"external-link\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    external_link_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn emit_external_link(&self, object: &papers_document::LinkAction) {
        self.emit_by_name::<()>("external-link", &[&object]);
    }

    #[doc(alias = "finished")]
    pub fn connect_finished<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn finished_trampoline<F: Fn(&ViewPresentation) + 'static>(
            this: *mut ffi::PpsViewPresentation,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"finished\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    finished_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn emit_finished(&self) {
        self.emit_by_name::<()>("finished", &[]);
    }

    #[doc(alias = "current-page")]
    pub fn connect_current_page_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_current_page_trampoline<F: Fn(&ViewPresentation) + 'static>(
            this: *mut ffi::PpsViewPresentation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::current-page\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_current_page_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "document")]
    pub fn connect_document_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_document_trampoline<F: Fn(&ViewPresentation) + 'static>(
            this: *mut ffi::PpsViewPresentation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::document\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_document_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "inverted-colors")]
    pub fn connect_inverted_colors_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_inverted_colors_trampoline<
            F: Fn(&ViewPresentation) + 'static,
        >(
            this: *mut ffi::PpsViewPresentation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::inverted-colors\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_inverted_colors_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "rotation")]
    pub fn connect_rotation_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_rotation_trampoline<F: Fn(&ViewPresentation) + 'static>(
            this: *mut ffi::PpsViewPresentation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::rotation\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_rotation_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}
