/* mg-enums.h
 *
 * Copyright (C) 2003 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __MG_ENUMS__
#define __MG_ENUMS__

typedef enum   _MgActionMode  MgActionMode;

/* enum for the different modes of action */
enum _MgActionMode
{
	/* navigation modes */
	MG_ACTION_NAVIGATION_ARROWS  = 1 << 0,
	MG_ACTION_NAVIGATION_SCROLL  = 1 << 1,

	/* modifications */
	MG_ACTION_MODIF_AUTO_COMMIT  = 1 << 2,
	MG_ACTION_ASK_CONFIRM_UPDATE = 1 << 3,
	MG_ACTION_ASK_CONFIRM_DELETE = 1 << 4,
	MG_ACTION_ASK_CONFIRM_INSERT = 1 << 5,

	/* Error reporting */
	MG_ACTION_REPORT_ERROR       = 1 << 6
};

#endif



