/* packed-treeview.h
 *
 * Copyright (C) 2001 - 2002 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __PACKED_TREEVIEW__
#define __PACKED_TREEVIEW__

#include <gnome.h>
#include <config.h>

G_BEGIN_DECLS

#define PACKED_TREEVIEW_TYPE          (packed_treeview_get_type())
#define PACKED_TREEVIEW(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, packed_treeview_get_type(), PackedTreeView)
#define PACKED_TREEVIEW_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, packed_treeview_get_type (), PackedTreeViewClass)
#define IS_PACKED_TREEVIEW(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, packed_treeview_get_type ())


typedef struct _PackedTreeView PackedTreeView;
typedef struct _PackedTreeViewClass PackedTreeViewClass;
typedef struct _PackedTreeViewPrivate PackedTreeViewPrivate;

/* struct for the object's data */
struct _PackedTreeView
{
	GtkHBox                object;

	PackedTreeViewPrivate *priv;
};

/* struct for the object's class */
struct _PackedTreeViewClass
{
	GtkHBoxClass parent_class;

	void       (*swap_required) (PackedTreeView * treeview, GtkTreeIter *iter1, GtkTreeIter *iter2);
};

/* generic widget's functions */
guint      packed_treeview_get_type    (void);
GtkWidget* packed_treeview_new         (GtkWidget *treeview, gboolean buttons_go_right);

void       packed_treeview_show_arrows (PackedTreeView *ptv, gboolean show);

G_END_DECLS

#endif
