/* mainpagetable.h
 *
 * Copyright (C) 2002 Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __MAIN_PAGE_SQL__
#define __MAIN_PAGE_SQL__

#include "conf-manager.h"

G_BEGIN_DECLS

#define MAIN_PAGE_SQL_TYPE          (main_page_sql_get_type())
#define MAIN_PAGE_SQL(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, main_page_sql_get_type(), MainPageSql)
#define MAIN_PAGE_SQL_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, main_page_sql_get_type (), MainPageSqlClass)
#define IS_MAIN_PAGE_SQL(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, main_page_sql_get_type ())

typedef struct _MainPageSql      MainPageSql;
typedef struct _MainPageSqlClass MainPageSqlClass;

/* struct for the object's data */
struct _MainPageSql {
	GtkVBox object;

	ConfManager *conf;
	GtkWidget *sql_editor;
	GtkWidget *grid;
	GtkWidget *log_list;

	GList *command_history;
};

/* struct for the object's class */
struct _MainPageSqlClass {
	GtkVBoxClass parent_class;
};

/* generic widget's functions */
GType      main_page_sql_get_type (void);
GtkWidget *main_page_sql_new      (ConfManager *conf);

G_END_DECLS

#endif
