/* interface_cb.h
 *
 * Copyright (C) 1999,2000 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <gnome.h>
#include "conf-manager.h"
#include "query.h"
#include "libgnomedb/libgnomedb.h"

/*
 * User Interface actions CBs
 */

/* CB to attach to menu/menubar for the user to open/close the connection */
void sql_conn_open_cb (GtkWidget * widget, ConfManager * conf);
void sql_conn_close_cb (GtkWidget * widget, ConfManager * conf);

/* CB to attach to transaction-related menu items */
void sql_begin_trans_cb (GtkWidget * widget, ConfManager * conf);
void sql_commit_trans_cb (GtkWidget * widget, ConfManager * conf);
void sql_rollback_trans_cb (GtkWidget * widget, ConfManager * conf);

/* CB to attach to connections preferences */
void options_config_cb (GtkWidget * widget, ConfManager * conf);

/* CB to view the global DB relations (user action) */
void sql_show_relations_cb (GObject * obj, ConfManager * conf);

/* CB to view DB system informations */
void sql_data_view_cb (GtkWidget * widget, ConfManager * conf);

/* CB to update the memory representation of the DB */
void sql_mem_update_cb (GtkWidget * widget, ConfManager * conf);

/* CBs for plugins */
void rescan_display_plugins_cb (GObject * obj, ConfManager * conf);
void config_display_plugins_cb (GObject * obj, ConfManager * conf);

/* CBs to configure the DBMS using bonobo controls */
void users_settings_cb (GObject * obj, ConfManager * conf);
void users_access_cb (GObject * obj, ConfManager * conf);
void users_groups_cb (GObject * obj, ConfManager * conf);

/* CBs for the view menu */
void view_tables_tab_cb (GtkWidget * widget, ConfManager * conf);
void view_sequences_tab_cb (GtkWidget * widget, ConfManager * conf);
void view_queries_tab_cb (GtkWidget * widget, ConfManager * conf);
void view_forms_tab_cb (GtkWidget * widget, ConfManager * conf);
void view_sql_tab_cb (GtkWidget * widget, ConfManager * conf);

/* CB for the printer stuff */
void printer_setup_cb (GObject * obj, ConfManager * conf);

/* CBs to set the tab of the notebook to display the right page */
void show_tables_page_cb (GtkWidget * wid, const gchar *label, const gchar *tooltip, ConfManager * conf);
void show_seqs_page_cb (GtkWidget * wid, const gchar *label, const gchar *tooltip, ConfManager * conf);
void show_queries_page_cb (GtkWidget * shortcut, const gchar *label, const gchar *tooltip, ConfManager * conf);
void show_forms_page_cb (GtkWidget * shortcut, const gchar *label, const gchar *tooltip, ConfManager * conf);
void show_sql_page_cb (GtkWidget * shortcut, const gchar *label, const gchar *tooltip, ConfManager * conf);

/* settings stuff */
void run_preferences_cb (GtkWidget * w, ConfManager * conf);
void run_gnomedb_manager_cb (GtkWidget * w, ConfManager * conf);

/* CBs from the FILE menu */
gint set_opened_file (ConfManager * conf, gchar * filetxt);
void file_new_cb (GtkWidget * widget, ConfManager * conf);
void file_open_cb (GtkWidget * widget, ConfManager * conf);
void file_close_cb (GtkWidget * widget, ConfManager * conf);
void file_save_cb (GtkWidget * widget, ConfManager * conf);
void file_save_as_cb (GtkWidget * widget, ConfManager * conf);
void quit_cb (GtkWidget * widget, ConfManager * conf);



/*
 * CBs to signals emitted by Database objects
 */

/* CB to attach to the ServerAccess signals */
void sql_server_conn_open_cb (GObject * wid, ConfManager * conf);
void sql_server_conn_to_close_cb (GObject * wid, ConfManager * conf);
void sql_server_conn_close_cb (GObject * wid, ConfManager * conf);

/* DB to link to the "table_dropped" and "seq_dropped" signals of Database 
   to update the relations */
void wid_db_rel_list_update (GObject * obj, gpointer item,
			     ConfManager * conf);

/* CB to link to the "event_notification" signal of ServerAccess */
void sql_server_event_cb (ServerAccess * srv, GdaConnection *cnc,
			  GdaClientEvent event, GdaParameterList *params,
			  ConfManager * conf);
