// This file was generated by gir (https://github.com/gtk-rs/gir)
// from ..
// from ../gir-files
// DO NOT EDIT

use crate::{FormatOptions};
use glib::{prelude::*,translate::*,GStr};
use std::{fmt};

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GWeatherConditionPhenomenon")]
pub enum ConditionPhenomenon {
    #[doc(alias = "GWEATHER_PHENOMENON_INVALID")]
    Invalid,
    #[doc(alias = "GWEATHER_PHENOMENON_NONE")]
    None,
    #[doc(alias = "GWEATHER_PHENOMENON_DRIZZLE")]
    Drizzle,
    #[doc(alias = "GWEATHER_PHENOMENON_RAIN")]
    Rain,
    #[doc(alias = "GWEATHER_PHENOMENON_SNOW")]
    Snow,
    #[doc(alias = "GWEATHER_PHENOMENON_SNOW_GRAINS")]
    SnowGrains,
    #[doc(alias = "GWEATHER_PHENOMENON_ICE_CRYSTALS")]
    IceCrystals,
    #[doc(alias = "GWEATHER_PHENOMENON_ICE_PELLETS")]
    IcePellets,
    #[doc(alias = "GWEATHER_PHENOMENON_HAIL")]
    Hail,
    #[doc(alias = "GWEATHER_PHENOMENON_SMALL_HAIL")]
    SmallHail,
    #[doc(alias = "GWEATHER_PHENOMENON_UNKNOWN_PRECIPITATION")]
    UnknownPrecipitation,
    #[doc(alias = "GWEATHER_PHENOMENON_MIST")]
    Mist,
    #[doc(alias = "GWEATHER_PHENOMENON_FOG")]
    Fog,
    #[doc(alias = "GWEATHER_PHENOMENON_SMOKE")]
    Smoke,
    #[doc(alias = "GWEATHER_PHENOMENON_VOLCANIC_ASH")]
    VolcanicAsh,
    #[doc(alias = "GWEATHER_PHENOMENON_SAND")]
    Sand,
    #[doc(alias = "GWEATHER_PHENOMENON_HAZE")]
    Haze,
    #[doc(alias = "GWEATHER_PHENOMENON_SPRAY")]
    Spray,
    #[doc(alias = "GWEATHER_PHENOMENON_DUST")]
    Dust,
    #[doc(alias = "GWEATHER_PHENOMENON_SQUALL")]
    Squall,
    #[doc(alias = "GWEATHER_PHENOMENON_SANDSTORM")]
    Sandstorm,
    #[doc(alias = "GWEATHER_PHENOMENON_DUSTSTORM")]
    Duststorm,
    #[doc(alias = "GWEATHER_PHENOMENON_FUNNEL_CLOUD")]
    FunnelCloud,
    #[doc(alias = "GWEATHER_PHENOMENON_TORNADO")]
    Tornado,
    #[doc(alias = "GWEATHER_PHENOMENON_DUST_WHIRLS")]
    DustWhirls,
    #[doc(alias = "GWEATHER_PHENOMENON_LAST")]
    Last,
#[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ConditionPhenomenon {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "ConditionPhenomenon::{}", match *self {
            Self::Invalid => "Invalid",
            Self::None => "None",
            Self::Drizzle => "Drizzle",
            Self::Rain => "Rain",
            Self::Snow => "Snow",
            Self::SnowGrains => "SnowGrains",
            Self::IceCrystals => "IceCrystals",
            Self::IcePellets => "IcePellets",
            Self::Hail => "Hail",
            Self::SmallHail => "SmallHail",
            Self::UnknownPrecipitation => "UnknownPrecipitation",
            Self::Mist => "Mist",
            Self::Fog => "Fog",
            Self::Smoke => "Smoke",
            Self::VolcanicAsh => "VolcanicAsh",
            Self::Sand => "Sand",
            Self::Haze => "Haze",
            Self::Spray => "Spray",
            Self::Dust => "Dust",
            Self::Squall => "Squall",
            Self::Sandstorm => "Sandstorm",
            Self::Duststorm => "Duststorm",
            Self::FunnelCloud => "FunnelCloud",
            Self::Tornado => "Tornado",
            Self::DustWhirls => "DustWhirls",
            Self::Last => "Last",
            _ => "Unknown",
        })
    }
}

#[doc(hidden)]
impl IntoGlib for ConditionPhenomenon {
    type GlibType = ffi::GWeatherConditionPhenomenon;

    fn into_glib(self) -> ffi::GWeatherConditionPhenomenon {
match self {
            Self::Invalid => ffi::GWEATHER_PHENOMENON_INVALID,
            Self::None => ffi::GWEATHER_PHENOMENON_NONE,
            Self::Drizzle => ffi::GWEATHER_PHENOMENON_DRIZZLE,
            Self::Rain => ffi::GWEATHER_PHENOMENON_RAIN,
            Self::Snow => ffi::GWEATHER_PHENOMENON_SNOW,
            Self::SnowGrains => ffi::GWEATHER_PHENOMENON_SNOW_GRAINS,
            Self::IceCrystals => ffi::GWEATHER_PHENOMENON_ICE_CRYSTALS,
            Self::IcePellets => ffi::GWEATHER_PHENOMENON_ICE_PELLETS,
            Self::Hail => ffi::GWEATHER_PHENOMENON_HAIL,
            Self::SmallHail => ffi::GWEATHER_PHENOMENON_SMALL_HAIL,
            Self::UnknownPrecipitation => ffi::GWEATHER_PHENOMENON_UNKNOWN_PRECIPITATION,
            Self::Mist => ffi::GWEATHER_PHENOMENON_MIST,
            Self::Fog => ffi::GWEATHER_PHENOMENON_FOG,
            Self::Smoke => ffi::GWEATHER_PHENOMENON_SMOKE,
            Self::VolcanicAsh => ffi::GWEATHER_PHENOMENON_VOLCANIC_ASH,
            Self::Sand => ffi::GWEATHER_PHENOMENON_SAND,
            Self::Haze => ffi::GWEATHER_PHENOMENON_HAZE,
            Self::Spray => ffi::GWEATHER_PHENOMENON_SPRAY,
            Self::Dust => ffi::GWEATHER_PHENOMENON_DUST,
            Self::Squall => ffi::GWEATHER_PHENOMENON_SQUALL,
            Self::Sandstorm => ffi::GWEATHER_PHENOMENON_SANDSTORM,
            Self::Duststorm => ffi::GWEATHER_PHENOMENON_DUSTSTORM,
            Self::FunnelCloud => ffi::GWEATHER_PHENOMENON_FUNNEL_CLOUD,
            Self::Tornado => ffi::GWEATHER_PHENOMENON_TORNADO,
            Self::DustWhirls => ffi::GWEATHER_PHENOMENON_DUST_WHIRLS,
            Self::Last => ffi::GWEATHER_PHENOMENON_LAST,
            Self::__Unknown(value) => value,
}
}
}

#[doc(hidden)]
impl FromGlib<ffi::GWeatherConditionPhenomenon> for ConditionPhenomenon {
    unsafe fn from_glib(value: ffi::GWeatherConditionPhenomenon) -> Self {
        skip_assert_initialized!();
        
match value {
            ffi::GWEATHER_PHENOMENON_INVALID => Self::Invalid,
            ffi::GWEATHER_PHENOMENON_NONE => Self::None,
            ffi::GWEATHER_PHENOMENON_DRIZZLE => Self::Drizzle,
            ffi::GWEATHER_PHENOMENON_RAIN => Self::Rain,
            ffi::GWEATHER_PHENOMENON_SNOW => Self::Snow,
            ffi::GWEATHER_PHENOMENON_SNOW_GRAINS => Self::SnowGrains,
            ffi::GWEATHER_PHENOMENON_ICE_CRYSTALS => Self::IceCrystals,
            ffi::GWEATHER_PHENOMENON_ICE_PELLETS => Self::IcePellets,
            ffi::GWEATHER_PHENOMENON_HAIL => Self::Hail,
            ffi::GWEATHER_PHENOMENON_SMALL_HAIL => Self::SmallHail,
            ffi::GWEATHER_PHENOMENON_UNKNOWN_PRECIPITATION => Self::UnknownPrecipitation,
            ffi::GWEATHER_PHENOMENON_MIST => Self::Mist,
            ffi::GWEATHER_PHENOMENON_FOG => Self::Fog,
            ffi::GWEATHER_PHENOMENON_SMOKE => Self::Smoke,
            ffi::GWEATHER_PHENOMENON_VOLCANIC_ASH => Self::VolcanicAsh,
            ffi::GWEATHER_PHENOMENON_SAND => Self::Sand,
            ffi::GWEATHER_PHENOMENON_HAZE => Self::Haze,
            ffi::GWEATHER_PHENOMENON_SPRAY => Self::Spray,
            ffi::GWEATHER_PHENOMENON_DUST => Self::Dust,
            ffi::GWEATHER_PHENOMENON_SQUALL => Self::Squall,
            ffi::GWEATHER_PHENOMENON_SANDSTORM => Self::Sandstorm,
            ffi::GWEATHER_PHENOMENON_DUSTSTORM => Self::Duststorm,
            ffi::GWEATHER_PHENOMENON_FUNNEL_CLOUD => Self::FunnelCloud,
            ffi::GWEATHER_PHENOMENON_TORNADO => Self::Tornado,
            ffi::GWEATHER_PHENOMENON_DUST_WHIRLS => Self::DustWhirls,
            ffi::GWEATHER_PHENOMENON_LAST => Self::Last,
            value => Self::__Unknown(value),
}
}
}

impl StaticType for ConditionPhenomenon {
    #[inline]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::gweather_phenomenon_get_type()) }
    }
}

impl glib::HasParamSpec for ConditionPhenomenon {
                type ParamSpec = glib::ParamSpecEnum;
                type SetValue = Self;
                type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;
    
                fn param_spec_builder() -> Self::BuilderFn {
                    |name, default_value| Self::ParamSpec::builder_with_default(name, default_value)
                }
}

impl glib::value::ValueType for ConditionPhenomenon {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for ConditionPhenomenon {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ConditionPhenomenon {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<ConditionPhenomenon> for glib::Value {
    #[inline]
    fn from(v: ConditionPhenomenon) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GWeatherConditionQualifier")]
pub enum ConditionQualifier {
    #[doc(alias = "GWEATHER_QUALIFIER_INVALID")]
    Invalid,
    #[doc(alias = "GWEATHER_QUALIFIER_NONE")]
    None,
    #[doc(alias = "GWEATHER_QUALIFIER_VICINITY")]
    Vicinity,
    #[doc(alias = "GWEATHER_QUALIFIER_LIGHT")]
    Light,
    #[doc(alias = "GWEATHER_QUALIFIER_MODERATE")]
    Moderate,
    #[doc(alias = "GWEATHER_QUALIFIER_HEAVY")]
    Heavy,
    #[doc(alias = "GWEATHER_QUALIFIER_SHALLOW")]
    Shallow,
    #[doc(alias = "GWEATHER_QUALIFIER_PATCHES")]
    Patches,
    #[doc(alias = "GWEATHER_QUALIFIER_PARTIAL")]
    Partial,
    #[doc(alias = "GWEATHER_QUALIFIER_THUNDERSTORM")]
    Thunderstorm,
    #[doc(alias = "GWEATHER_QUALIFIER_BLOWING")]
    Blowing,
    #[doc(alias = "GWEATHER_QUALIFIER_SHOWERS")]
    Showers,
    #[doc(alias = "GWEATHER_QUALIFIER_DRIFTING")]
    Drifting,
    #[doc(alias = "GWEATHER_QUALIFIER_FREEZING")]
    Freezing,
    #[doc(alias = "GWEATHER_QUALIFIER_LAST")]
    Last,
#[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ConditionQualifier {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "ConditionQualifier::{}", match *self {
            Self::Invalid => "Invalid",
            Self::None => "None",
            Self::Vicinity => "Vicinity",
            Self::Light => "Light",
            Self::Moderate => "Moderate",
            Self::Heavy => "Heavy",
            Self::Shallow => "Shallow",
            Self::Patches => "Patches",
            Self::Partial => "Partial",
            Self::Thunderstorm => "Thunderstorm",
            Self::Blowing => "Blowing",
            Self::Showers => "Showers",
            Self::Drifting => "Drifting",
            Self::Freezing => "Freezing",
            Self::Last => "Last",
            _ => "Unknown",
        })
    }
}

#[doc(hidden)]
impl IntoGlib for ConditionQualifier {
    type GlibType = ffi::GWeatherConditionQualifier;

    fn into_glib(self) -> ffi::GWeatherConditionQualifier {
match self {
            Self::Invalid => ffi::GWEATHER_QUALIFIER_INVALID,
            Self::None => ffi::GWEATHER_QUALIFIER_NONE,
            Self::Vicinity => ffi::GWEATHER_QUALIFIER_VICINITY,
            Self::Light => ffi::GWEATHER_QUALIFIER_LIGHT,
            Self::Moderate => ffi::GWEATHER_QUALIFIER_MODERATE,
            Self::Heavy => ffi::GWEATHER_QUALIFIER_HEAVY,
            Self::Shallow => ffi::GWEATHER_QUALIFIER_SHALLOW,
            Self::Patches => ffi::GWEATHER_QUALIFIER_PATCHES,
            Self::Partial => ffi::GWEATHER_QUALIFIER_PARTIAL,
            Self::Thunderstorm => ffi::GWEATHER_QUALIFIER_THUNDERSTORM,
            Self::Blowing => ffi::GWEATHER_QUALIFIER_BLOWING,
            Self::Showers => ffi::GWEATHER_QUALIFIER_SHOWERS,
            Self::Drifting => ffi::GWEATHER_QUALIFIER_DRIFTING,
            Self::Freezing => ffi::GWEATHER_QUALIFIER_FREEZING,
            Self::Last => ffi::GWEATHER_QUALIFIER_LAST,
            Self::__Unknown(value) => value,
}
}
}

#[doc(hidden)]
impl FromGlib<ffi::GWeatherConditionQualifier> for ConditionQualifier {
    unsafe fn from_glib(value: ffi::GWeatherConditionQualifier) -> Self {
        skip_assert_initialized!();
        
match value {
            ffi::GWEATHER_QUALIFIER_INVALID => Self::Invalid,
            ffi::GWEATHER_QUALIFIER_NONE => Self::None,
            ffi::GWEATHER_QUALIFIER_VICINITY => Self::Vicinity,
            ffi::GWEATHER_QUALIFIER_LIGHT => Self::Light,
            ffi::GWEATHER_QUALIFIER_MODERATE => Self::Moderate,
            ffi::GWEATHER_QUALIFIER_HEAVY => Self::Heavy,
            ffi::GWEATHER_QUALIFIER_SHALLOW => Self::Shallow,
            ffi::GWEATHER_QUALIFIER_PATCHES => Self::Patches,
            ffi::GWEATHER_QUALIFIER_PARTIAL => Self::Partial,
            ffi::GWEATHER_QUALIFIER_THUNDERSTORM => Self::Thunderstorm,
            ffi::GWEATHER_QUALIFIER_BLOWING => Self::Blowing,
            ffi::GWEATHER_QUALIFIER_SHOWERS => Self::Showers,
            ffi::GWEATHER_QUALIFIER_DRIFTING => Self::Drifting,
            ffi::GWEATHER_QUALIFIER_FREEZING => Self::Freezing,
            ffi::GWEATHER_QUALIFIER_LAST => Self::Last,
            value => Self::__Unknown(value),
}
}
}

impl StaticType for ConditionQualifier {
    #[inline]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::gweather_qualifier_get_type()) }
    }
}

impl glib::HasParamSpec for ConditionQualifier {
                type ParamSpec = glib::ParamSpecEnum;
                type SetValue = Self;
                type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;
    
                fn param_spec_builder() -> Self::BuilderFn {
                    |name, default_value| Self::ParamSpec::builder_with_default(name, default_value)
                }
}

impl glib::value::ValueType for ConditionQualifier {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for ConditionQualifier {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ConditionQualifier {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<ConditionQualifier> for glib::Value {
    #[inline]
    fn from(v: ConditionQualifier) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GWeatherDistanceUnit")]
pub enum DistanceUnit {
    #[doc(alias = "GWEATHER_DISTANCE_UNIT_INVALID")]
    Invalid,
    #[doc(alias = "GWEATHER_DISTANCE_UNIT_DEFAULT")]
    Default,
    #[doc(alias = "GWEATHER_DISTANCE_UNIT_METERS")]
    Meters,
    #[doc(alias = "GWEATHER_DISTANCE_UNIT_KM")]
    Km,
    #[doc(alias = "GWEATHER_DISTANCE_UNIT_MILES")]
    Miles,
#[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for DistanceUnit {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "DistanceUnit::{}", match *self {
            Self::Invalid => "Invalid",
            Self::Default => "Default",
            Self::Meters => "Meters",
            Self::Km => "Km",
            Self::Miles => "Miles",
            _ => "Unknown",
        })
    }
}

#[doc(hidden)]
impl IntoGlib for DistanceUnit {
    type GlibType = ffi::GWeatherDistanceUnit;

    #[inline]
fn into_glib(self) -> ffi::GWeatherDistanceUnit {
match self {
            Self::Invalid => ffi::GWEATHER_DISTANCE_UNIT_INVALID,
            Self::Default => ffi::GWEATHER_DISTANCE_UNIT_DEFAULT,
            Self::Meters => ffi::GWEATHER_DISTANCE_UNIT_METERS,
            Self::Km => ffi::GWEATHER_DISTANCE_UNIT_KM,
            Self::Miles => ffi::GWEATHER_DISTANCE_UNIT_MILES,
            Self::__Unknown(value) => value,
}
}
}

#[doc(hidden)]
impl FromGlib<ffi::GWeatherDistanceUnit> for DistanceUnit {
    #[inline]
unsafe fn from_glib(value: ffi::GWeatherDistanceUnit) -> Self {
        skip_assert_initialized!();
        
match value {
            ffi::GWEATHER_DISTANCE_UNIT_INVALID => Self::Invalid,
            ffi::GWEATHER_DISTANCE_UNIT_DEFAULT => Self::Default,
            ffi::GWEATHER_DISTANCE_UNIT_METERS => Self::Meters,
            ffi::GWEATHER_DISTANCE_UNIT_KM => Self::Km,
            ffi::GWEATHER_DISTANCE_UNIT_MILES => Self::Miles,
            value => Self::__Unknown(value),
}
}
}

impl StaticType for DistanceUnit {
    #[inline]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::gweather_distance_unit_get_type()) }
    }
}

impl glib::HasParamSpec for DistanceUnit {
                type ParamSpec = glib::ParamSpecEnum;
                type SetValue = Self;
                type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;
    
                fn param_spec_builder() -> Self::BuilderFn {
                    |name, default_value| Self::ParamSpec::builder_with_default(name, default_value)
                }
}

impl glib::value::ValueType for DistanceUnit {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for DistanceUnit {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for DistanceUnit {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<DistanceUnit> for glib::Value {
    #[inline]
    fn from(v: DistanceUnit) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GWeatherLocationLevel")]
pub enum LocationLevel {
    #[doc(alias = "GWEATHER_LOCATION_WORLD")]
    World,
    #[doc(alias = "GWEATHER_LOCATION_REGION")]
    Region,
    #[doc(alias = "GWEATHER_LOCATION_COUNTRY")]
    Country,
    #[doc(alias = "GWEATHER_LOCATION_ADM1")]
    Adm1,
    #[doc(alias = "GWEATHER_LOCATION_CITY")]
    City,
    #[doc(alias = "GWEATHER_LOCATION_WEATHER_STATION")]
    WeatherStation,
    #[doc(alias = "GWEATHER_LOCATION_DETACHED")]
    Detached,
    #[doc(alias = "GWEATHER_LOCATION_NAMED_TIMEZONE")]
    NamedTimezone,
#[doc(hidden)]
    __Unknown(i32),
}

impl LocationLevel {
    pub fn to_str<'a>(self) -> &'a GStr {
        unsafe {
            GStr::from_ptr(
                ffi::gweather_location_level_to_string(self.into_glib())
                    .as_ref()
                    .expect("gweather_location_level_to_string returned NULL"),
            )
        }
    }
}

impl fmt::Display for LocationLevel {
    #[inline]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str(&self.to_str())
    }
}

#[doc(hidden)]
impl IntoGlib for LocationLevel {
    type GlibType = ffi::GWeatherLocationLevel;

    #[inline]
fn into_glib(self) -> ffi::GWeatherLocationLevel {
match self {
            Self::World => ffi::GWEATHER_LOCATION_WORLD,
            Self::Region => ffi::GWEATHER_LOCATION_REGION,
            Self::Country => ffi::GWEATHER_LOCATION_COUNTRY,
            Self::Adm1 => ffi::GWEATHER_LOCATION_ADM1,
            Self::City => ffi::GWEATHER_LOCATION_CITY,
            Self::WeatherStation => ffi::GWEATHER_LOCATION_WEATHER_STATION,
            Self::Detached => ffi::GWEATHER_LOCATION_DETACHED,
            Self::NamedTimezone => ffi::GWEATHER_LOCATION_NAMED_TIMEZONE,
            Self::__Unknown(value) => value,
}
}
}

#[doc(hidden)]
impl FromGlib<ffi::GWeatherLocationLevel> for LocationLevel {
    #[inline]
unsafe fn from_glib(value: ffi::GWeatherLocationLevel) -> Self {
        skip_assert_initialized!();
        
match value {
            ffi::GWEATHER_LOCATION_WORLD => Self::World,
            ffi::GWEATHER_LOCATION_REGION => Self::Region,
            ffi::GWEATHER_LOCATION_COUNTRY => Self::Country,
            ffi::GWEATHER_LOCATION_ADM1 => Self::Adm1,
            ffi::GWEATHER_LOCATION_CITY => Self::City,
            ffi::GWEATHER_LOCATION_WEATHER_STATION => Self::WeatherStation,
            ffi::GWEATHER_LOCATION_DETACHED => Self::Detached,
            ffi::GWEATHER_LOCATION_NAMED_TIMEZONE => Self::NamedTimezone,
            value => Self::__Unknown(value),
}
}
}

impl StaticType for LocationLevel {
    #[inline]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::gweather_location_level_get_type()) }
    }
}

impl glib::HasParamSpec for LocationLevel {
                type ParamSpec = glib::ParamSpecEnum;
                type SetValue = Self;
                type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;
    
                fn param_spec_builder() -> Self::BuilderFn {
                    |name, default_value| Self::ParamSpec::builder_with_default(name, default_value)
                }
}

impl glib::value::ValueType for LocationLevel {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for LocationLevel {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for LocationLevel {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<LocationLevel> for glib::Value {
    #[inline]
    fn from(v: LocationLevel) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GWeatherPressureUnit")]
pub enum PressureUnit {
    #[doc(alias = "GWEATHER_PRESSURE_UNIT_INVALID")]
    Invalid,
    #[doc(alias = "GWEATHER_PRESSURE_UNIT_DEFAULT")]
    Default,
    #[doc(alias = "GWEATHER_PRESSURE_UNIT_KPA")]
    Kpa,
    #[doc(alias = "GWEATHER_PRESSURE_UNIT_HPA")]
    Hpa,
    #[doc(alias = "GWEATHER_PRESSURE_UNIT_MB")]
    Mb,
    #[doc(alias = "GWEATHER_PRESSURE_UNIT_MM_HG")]
    MmHg,
    #[doc(alias = "GWEATHER_PRESSURE_UNIT_INCH_HG")]
    InchHg,
    #[doc(alias = "GWEATHER_PRESSURE_UNIT_ATM")]
    Atm,
#[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PressureUnit {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "PressureUnit::{}", match *self {
            Self::Invalid => "Invalid",
            Self::Default => "Default",
            Self::Kpa => "Kpa",
            Self::Hpa => "Hpa",
            Self::Mb => "Mb",
            Self::MmHg => "MmHg",
            Self::InchHg => "InchHg",
            Self::Atm => "Atm",
            _ => "Unknown",
        })
    }
}

#[doc(hidden)]
impl IntoGlib for PressureUnit {
    type GlibType = ffi::GWeatherPressureUnit;

    #[inline]
fn into_glib(self) -> ffi::GWeatherPressureUnit {
match self {
            Self::Invalid => ffi::GWEATHER_PRESSURE_UNIT_INVALID,
            Self::Default => ffi::GWEATHER_PRESSURE_UNIT_DEFAULT,
            Self::Kpa => ffi::GWEATHER_PRESSURE_UNIT_KPA,
            Self::Hpa => ffi::GWEATHER_PRESSURE_UNIT_HPA,
            Self::Mb => ffi::GWEATHER_PRESSURE_UNIT_MB,
            Self::MmHg => ffi::GWEATHER_PRESSURE_UNIT_MM_HG,
            Self::InchHg => ffi::GWEATHER_PRESSURE_UNIT_INCH_HG,
            Self::Atm => ffi::GWEATHER_PRESSURE_UNIT_ATM,
            Self::__Unknown(value) => value,
}
}
}

#[doc(hidden)]
impl FromGlib<ffi::GWeatherPressureUnit> for PressureUnit {
    #[inline]
unsafe fn from_glib(value: ffi::GWeatherPressureUnit) -> Self {
        skip_assert_initialized!();
        
match value {
            ffi::GWEATHER_PRESSURE_UNIT_INVALID => Self::Invalid,
            ffi::GWEATHER_PRESSURE_UNIT_DEFAULT => Self::Default,
            ffi::GWEATHER_PRESSURE_UNIT_KPA => Self::Kpa,
            ffi::GWEATHER_PRESSURE_UNIT_HPA => Self::Hpa,
            ffi::GWEATHER_PRESSURE_UNIT_MB => Self::Mb,
            ffi::GWEATHER_PRESSURE_UNIT_MM_HG => Self::MmHg,
            ffi::GWEATHER_PRESSURE_UNIT_INCH_HG => Self::InchHg,
            ffi::GWEATHER_PRESSURE_UNIT_ATM => Self::Atm,
            value => Self::__Unknown(value),
}
}
}

impl StaticType for PressureUnit {
    #[inline]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::gweather_pressure_unit_get_type()) }
    }
}

impl glib::HasParamSpec for PressureUnit {
                type ParamSpec = glib::ParamSpecEnum;
                type SetValue = Self;
                type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;
    
                fn param_spec_builder() -> Self::BuilderFn {
                    |name, default_value| Self::ParamSpec::builder_with_default(name, default_value)
                }
}

impl glib::value::ValueType for PressureUnit {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for PressureUnit {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PressureUnit {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<PressureUnit> for glib::Value {
    #[inline]
    fn from(v: PressureUnit) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GWeatherSky")]
pub enum Sky {
    #[doc(alias = "GWEATHER_SKY_INVALID")]
    Invalid,
    #[doc(alias = "GWEATHER_SKY_CLEAR")]
    Clear,
    #[doc(alias = "GWEATHER_SKY_BROKEN")]
    Broken,
    #[doc(alias = "GWEATHER_SKY_SCATTERED")]
    Scattered,
    #[doc(alias = "GWEATHER_SKY_FEW")]
    Few,
    #[doc(alias = "GWEATHER_SKY_OVERCAST")]
    Overcast,
    #[doc(alias = "GWEATHER_SKY_LAST")]
    Last,
#[doc(hidden)]
    __Unknown(i32),
}

impl Sky {
    pub fn to_str<'a>(self) -> &'a GStr {
        unsafe {
            GStr::from_ptr(
                ffi::gweather_sky_to_string(self.into_glib())
                    .as_ref()
                    .expect("gweather_sky_to_string returned NULL"),
            )
        }
    }

    #[doc(alias = "gweather_sky_to_string_full")]
    pub fn to_string_full(self, options: FormatOptions) -> glib::GString {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_none(ffi::gweather_sky_to_string_full(self.into_glib(), options.into_glib()))
        }
    }
}

impl fmt::Display for Sky {
    #[inline]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str(&self.to_str())
    }
}

#[doc(hidden)]
impl IntoGlib for Sky {
    type GlibType = ffi::GWeatherSky;

    #[inline]
fn into_glib(self) -> ffi::GWeatherSky {
match self {
            Self::Invalid => ffi::GWEATHER_SKY_INVALID,
            Self::Clear => ffi::GWEATHER_SKY_CLEAR,
            Self::Broken => ffi::GWEATHER_SKY_BROKEN,
            Self::Scattered => ffi::GWEATHER_SKY_SCATTERED,
            Self::Few => ffi::GWEATHER_SKY_FEW,
            Self::Overcast => ffi::GWEATHER_SKY_OVERCAST,
            Self::Last => ffi::GWEATHER_SKY_LAST,
            Self::__Unknown(value) => value,
}
}
}

#[doc(hidden)]
impl FromGlib<ffi::GWeatherSky> for Sky {
    #[inline]
unsafe fn from_glib(value: ffi::GWeatherSky) -> Self {
        skip_assert_initialized!();
        
match value {
            ffi::GWEATHER_SKY_INVALID => Self::Invalid,
            ffi::GWEATHER_SKY_CLEAR => Self::Clear,
            ffi::GWEATHER_SKY_BROKEN => Self::Broken,
            ffi::GWEATHER_SKY_SCATTERED => Self::Scattered,
            ffi::GWEATHER_SKY_FEW => Self::Few,
            ffi::GWEATHER_SKY_OVERCAST => Self::Overcast,
            ffi::GWEATHER_SKY_LAST => Self::Last,
            value => Self::__Unknown(value),
}
}
}

impl StaticType for Sky {
    #[inline]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::gweather_sky_get_type()) }
    }
}

impl glib::HasParamSpec for Sky {
                type ParamSpec = glib::ParamSpecEnum;
                type SetValue = Self;
                type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;
    
                fn param_spec_builder() -> Self::BuilderFn {
                    |name, default_value| Self::ParamSpec::builder_with_default(name, default_value)
                }
}

impl glib::value::ValueType for Sky {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for Sky {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Sky {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<Sky> for glib::Value {
    #[inline]
    fn from(v: Sky) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GWeatherSpeedUnit")]
pub enum SpeedUnit {
    #[doc(alias = "GWEATHER_SPEED_UNIT_INVALID")]
    Invalid,
    #[doc(alias = "GWEATHER_SPEED_UNIT_DEFAULT")]
    Default,
    #[doc(alias = "GWEATHER_SPEED_UNIT_MS")]
    Ms,
    #[doc(alias = "GWEATHER_SPEED_UNIT_KPH")]
    Kph,
    #[doc(alias = "GWEATHER_SPEED_UNIT_MPH")]
    Mph,
    #[doc(alias = "GWEATHER_SPEED_UNIT_KNOTS")]
    Knots,
    #[doc(alias = "GWEATHER_SPEED_UNIT_BFT")]
    Bft,
#[doc(hidden)]
    __Unknown(i32),
}

impl SpeedUnit {
    pub fn to_str<'a>(self) -> &'a GStr {
        unsafe {
            GStr::from_ptr(
                ffi::gweather_speed_unit_to_string(self.into_glib())
                    .as_ref()
                    .expect("gweather_speed_unit_to_string returned NULL"),
            )
        }
    }
}

impl fmt::Display for SpeedUnit {
    #[inline]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str(&self.to_str())
    }
}

#[doc(hidden)]
impl IntoGlib for SpeedUnit {
    type GlibType = ffi::GWeatherSpeedUnit;

    #[inline]
fn into_glib(self) -> ffi::GWeatherSpeedUnit {
match self {
            Self::Invalid => ffi::GWEATHER_SPEED_UNIT_INVALID,
            Self::Default => ffi::GWEATHER_SPEED_UNIT_DEFAULT,
            Self::Ms => ffi::GWEATHER_SPEED_UNIT_MS,
            Self::Kph => ffi::GWEATHER_SPEED_UNIT_KPH,
            Self::Mph => ffi::GWEATHER_SPEED_UNIT_MPH,
            Self::Knots => ffi::GWEATHER_SPEED_UNIT_KNOTS,
            Self::Bft => ffi::GWEATHER_SPEED_UNIT_BFT,
            Self::__Unknown(value) => value,
}
}
}

#[doc(hidden)]
impl FromGlib<ffi::GWeatherSpeedUnit> for SpeedUnit {
    #[inline]
unsafe fn from_glib(value: ffi::GWeatherSpeedUnit) -> Self {
        skip_assert_initialized!();
        
match value {
            ffi::GWEATHER_SPEED_UNIT_INVALID => Self::Invalid,
            ffi::GWEATHER_SPEED_UNIT_DEFAULT => Self::Default,
            ffi::GWEATHER_SPEED_UNIT_MS => Self::Ms,
            ffi::GWEATHER_SPEED_UNIT_KPH => Self::Kph,
            ffi::GWEATHER_SPEED_UNIT_MPH => Self::Mph,
            ffi::GWEATHER_SPEED_UNIT_KNOTS => Self::Knots,
            ffi::GWEATHER_SPEED_UNIT_BFT => Self::Bft,
            value => Self::__Unknown(value),
}
}
}

impl StaticType for SpeedUnit {
    #[inline]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::gweather_speed_unit_get_type()) }
    }
}

impl glib::HasParamSpec for SpeedUnit {
                type ParamSpec = glib::ParamSpecEnum;
                type SetValue = Self;
                type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;
    
                fn param_spec_builder() -> Self::BuilderFn {
                    |name, default_value| Self::ParamSpec::builder_with_default(name, default_value)
                }
}

impl glib::value::ValueType for SpeedUnit {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for SpeedUnit {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for SpeedUnit {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<SpeedUnit> for glib::Value {
    #[inline]
    fn from(v: SpeedUnit) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GWeatherTemperatureUnit")]
pub enum TemperatureUnit {
    #[doc(alias = "GWEATHER_TEMP_UNIT_INVALID")]
    Invalid,
    #[doc(alias = "GWEATHER_TEMP_UNIT_DEFAULT")]
    Default,
    #[doc(alias = "GWEATHER_TEMP_UNIT_KELVIN")]
    Kelvin,
    #[doc(alias = "GWEATHER_TEMP_UNIT_CENTIGRADE")]
    Centigrade,
    #[doc(alias = "GWEATHER_TEMP_UNIT_FAHRENHEIT")]
    Fahrenheit,
#[doc(hidden)]
    __Unknown(i32),
}

impl TemperatureUnit {
    #[doc(alias = "gweather_temperature_unit_to_real")]
    pub fn to_real(self) -> TemperatureUnit {
        assert_initialized_main_thread!();
        unsafe {
            from_glib(ffi::gweather_temperature_unit_to_real(self.into_glib()))
        }
    }
}

impl fmt::Display for TemperatureUnit {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "TemperatureUnit::{}", match *self {
            Self::Invalid => "Invalid",
            Self::Default => "Default",
            Self::Kelvin => "Kelvin",
            Self::Centigrade => "Centigrade",
            Self::Fahrenheit => "Fahrenheit",
            _ => "Unknown",
        })
    }
}

#[doc(hidden)]
impl IntoGlib for TemperatureUnit {
    type GlibType = ffi::GWeatherTemperatureUnit;

    #[inline]
fn into_glib(self) -> ffi::GWeatherTemperatureUnit {
match self {
            Self::Invalid => ffi::GWEATHER_TEMP_UNIT_INVALID,
            Self::Default => ffi::GWEATHER_TEMP_UNIT_DEFAULT,
            Self::Kelvin => ffi::GWEATHER_TEMP_UNIT_KELVIN,
            Self::Centigrade => ffi::GWEATHER_TEMP_UNIT_CENTIGRADE,
            Self::Fahrenheit => ffi::GWEATHER_TEMP_UNIT_FAHRENHEIT,
            Self::__Unknown(value) => value,
}
}
}

#[doc(hidden)]
impl FromGlib<ffi::GWeatherTemperatureUnit> for TemperatureUnit {
    #[inline]
unsafe fn from_glib(value: ffi::GWeatherTemperatureUnit) -> Self {
        skip_assert_initialized!();
        
match value {
            ffi::GWEATHER_TEMP_UNIT_INVALID => Self::Invalid,
            ffi::GWEATHER_TEMP_UNIT_DEFAULT => Self::Default,
            ffi::GWEATHER_TEMP_UNIT_KELVIN => Self::Kelvin,
            ffi::GWEATHER_TEMP_UNIT_CENTIGRADE => Self::Centigrade,
            ffi::GWEATHER_TEMP_UNIT_FAHRENHEIT => Self::Fahrenheit,
            value => Self::__Unknown(value),
}
}
}

impl StaticType for TemperatureUnit {
    #[inline]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::gweather_temperature_unit_get_type()) }
    }
}

impl glib::HasParamSpec for TemperatureUnit {
                type ParamSpec = glib::ParamSpecEnum;
                type SetValue = Self;
                type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;
    
                fn param_spec_builder() -> Self::BuilderFn {
                    |name, default_value| Self::ParamSpec::builder_with_default(name, default_value)
                }
}

impl glib::value::ValueType for TemperatureUnit {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for TemperatureUnit {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TemperatureUnit {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<TemperatureUnit> for glib::Value {
    #[inline]
    fn from(v: TemperatureUnit) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GWeatherWindDirection")]
pub enum WindDirection {
    #[doc(alias = "GWEATHER_WIND_INVALID")]
    Invalid,
    #[doc(alias = "GWEATHER_WIND_VARIABLE")]
    Variable,
    #[doc(alias = "GWEATHER_WIND_N")]
    N,
    #[doc(alias = "GWEATHER_WIND_NNE")]
    Nne,
    #[doc(alias = "GWEATHER_WIND_NE")]
    Ne,
    #[doc(alias = "GWEATHER_WIND_ENE")]
    Ene,
    #[doc(alias = "GWEATHER_WIND_E")]
    E,
    #[doc(alias = "GWEATHER_WIND_ESE")]
    Ese,
    #[doc(alias = "GWEATHER_WIND_SE")]
    Se,
    #[doc(alias = "GWEATHER_WIND_SSE")]
    Sse,
    #[doc(alias = "GWEATHER_WIND_S")]
    S,
    #[doc(alias = "GWEATHER_WIND_SSW")]
    Ssw,
    #[doc(alias = "GWEATHER_WIND_SW")]
    Sw,
    #[doc(alias = "GWEATHER_WIND_WSW")]
    Wsw,
    #[doc(alias = "GWEATHER_WIND_W")]
    W,
    #[doc(alias = "GWEATHER_WIND_WNW")]
    Wnw,
    #[doc(alias = "GWEATHER_WIND_NW")]
    Nw,
    #[doc(alias = "GWEATHER_WIND_NNW")]
    Nnw,
    #[doc(alias = "GWEATHER_WIND_LAST")]
    Last,
#[doc(hidden)]
    __Unknown(i32),
}

impl WindDirection {
    pub fn to_str<'a>(self) -> &'a GStr {
        unsafe {
            GStr::from_ptr(
                ffi::gweather_wind_direction_to_string(self.into_glib())
                    .as_ref()
                    .expect("gweather_wind_direction_to_string returned NULL"),
            )
        }
    }

    #[doc(alias = "gweather_wind_direction_to_string_full")]
    pub fn to_string_full(self, options: FormatOptions) -> glib::GString {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_none(ffi::gweather_wind_direction_to_string_full(self.into_glib(), options.into_glib()))
        }
    }
}

impl fmt::Display for WindDirection {
    #[inline]
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str(&self.to_str())
    }
}

#[doc(hidden)]
impl IntoGlib for WindDirection {
    type GlibType = ffi::GWeatherWindDirection;

    fn into_glib(self) -> ffi::GWeatherWindDirection {
match self {
            Self::Invalid => ffi::GWEATHER_WIND_INVALID,
            Self::Variable => ffi::GWEATHER_WIND_VARIABLE,
            Self::N => ffi::GWEATHER_WIND_N,
            Self::Nne => ffi::GWEATHER_WIND_NNE,
            Self::Ne => ffi::GWEATHER_WIND_NE,
            Self::Ene => ffi::GWEATHER_WIND_ENE,
            Self::E => ffi::GWEATHER_WIND_E,
            Self::Ese => ffi::GWEATHER_WIND_ESE,
            Self::Se => ffi::GWEATHER_WIND_SE,
            Self::Sse => ffi::GWEATHER_WIND_SSE,
            Self::S => ffi::GWEATHER_WIND_S,
            Self::Ssw => ffi::GWEATHER_WIND_SSW,
            Self::Sw => ffi::GWEATHER_WIND_SW,
            Self::Wsw => ffi::GWEATHER_WIND_WSW,
            Self::W => ffi::GWEATHER_WIND_W,
            Self::Wnw => ffi::GWEATHER_WIND_WNW,
            Self::Nw => ffi::GWEATHER_WIND_NW,
            Self::Nnw => ffi::GWEATHER_WIND_NNW,
            Self::Last => ffi::GWEATHER_WIND_LAST,
            Self::__Unknown(value) => value,
}
}
}

#[doc(hidden)]
impl FromGlib<ffi::GWeatherWindDirection> for WindDirection {
    unsafe fn from_glib(value: ffi::GWeatherWindDirection) -> Self {
        skip_assert_initialized!();
        
match value {
            ffi::GWEATHER_WIND_INVALID => Self::Invalid,
            ffi::GWEATHER_WIND_VARIABLE => Self::Variable,
            ffi::GWEATHER_WIND_N => Self::N,
            ffi::GWEATHER_WIND_NNE => Self::Nne,
            ffi::GWEATHER_WIND_NE => Self::Ne,
            ffi::GWEATHER_WIND_ENE => Self::Ene,
            ffi::GWEATHER_WIND_E => Self::E,
            ffi::GWEATHER_WIND_ESE => Self::Ese,
            ffi::GWEATHER_WIND_SE => Self::Se,
            ffi::GWEATHER_WIND_SSE => Self::Sse,
            ffi::GWEATHER_WIND_S => Self::S,
            ffi::GWEATHER_WIND_SSW => Self::Ssw,
            ffi::GWEATHER_WIND_SW => Self::Sw,
            ffi::GWEATHER_WIND_WSW => Self::Wsw,
            ffi::GWEATHER_WIND_W => Self::W,
            ffi::GWEATHER_WIND_WNW => Self::Wnw,
            ffi::GWEATHER_WIND_NW => Self::Nw,
            ffi::GWEATHER_WIND_NNW => Self::Nnw,
            ffi::GWEATHER_WIND_LAST => Self::Last,
            value => Self::__Unknown(value),
}
}
}

impl StaticType for WindDirection {
    #[inline]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::gweather_wind_direction_get_type()) }
    }
}

impl glib::HasParamSpec for WindDirection {
                type ParamSpec = glib::ParamSpecEnum;
                type SetValue = Self;
                type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;
    
                fn param_spec_builder() -> Self::BuilderFn {
                    |name, default_value| Self::ParamSpec::builder_with_default(name, default_value)
                }
}

impl glib::value::ValueType for WindDirection {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for WindDirection {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for WindDirection {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<WindDirection> for glib::Value {
    #[inline]
    fn from(v: WindDirection) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

