#
# The spec file for gtranslator -- adapted from Nautilus' & Gnumeric's 
#  spec files.
#
# Fatih Demir <kabalak@gtranslator.org>
#
%define version		0.39.1
%define	default_release	1
%define release		%{!?CUSTOM_RELEASE:%default_release}
%define prefix		/usr
%define	sysconfdir	/etc

Name: 		gtranslator
Vendor: 	GNOME Project
Distribution: 	Any
Version: 	%{version}
Release: 	%{release}
Copyright: 	GPL
Group: 		Development/Tools
Source:		http://www.gtranslator.org/download/releases/%{version}/gtranslator-%{version}.tar.gz
URL: 		http://www.gtranslator.org
BuildRoot:	/var/tmp/gtranslator-%{version}
Docdir:		%{_docdir}
Summary:	gtranslator is a comfortable po file editor with many bells and whistles.
Requires:	glib >= 1.2.8, gtk+ >= 1.2.8, gnome-libs >= 1.2.8, imlib, GConf >= 1.0
Requires:	gnome-vfs >= 0.4.1, gal >= 0.10.99, scrollkeeper >= 0.1.4

%description
gtranslator is a comfortable po file editor with many bells and whistles.
It features many useful function which ease the work of translators of po
files immenantly.

%changelog

*  Tue Aug 21 2001 Fatih Demir	<kabalak@gtranslator.org>

- Applied the future-proofness changes suggested by Mike Newman .-)

*  Sat Aug 18 2001 Mike Newman <mike@gtnorthern.demon.co.uk>

- Changed deps to need GConf rather than gconf.
- Added etspecs directory, backends, etc.
- Some general tidying and future-proofing.

*  Wed Aug 08 2001 Fatih Demir	<kabalak@gtranslator.org>

- Removed any nautilus view stuff.

*  Thu Apr 19 2001 Fatih Demir  <kabalak@gtranslator.org>

- Used the _mandir and _docdir macros from RPM instead of locally defining them.

*  Sat Mar 31 2001 Fatih Demir	<kabalak@gtranslator.org>

- Made this first spec.in file for easifying RPM builders' work.

%prep
%setup -q

%build
%ifarch alpha
        MYARCH_FLAGS="--host=alpha-redhat-linux"
%endif

LC_ALL=""
LINGUAS=""
LANG=""
export LC_ALL LINGUAS LANG

if [ ! -f configure ] ; then
	CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh $MYARCH_FLAGS --prefix=%{prefix} \
		--sysconfdir=%{sysconfdir} \
		--with-gconf \
		--enable-mime-bind=yes
else
	CFLAGS="$RPM_OPT_FLAGS" ./configure $MYARCH_FLAGS --prefix=%{prefix} \
		--sysconfdir=%{sysconfdir} \
		--with-gconf \
		--enable-mime-bind=yes
fi

if [ "$SMP" != "" ] ; then
	make -k -j$SMP "MAKE=make -k -j$SMP"
else
	make -k
fi

make check

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT
make -k prefix=$RPM_BUILD_ROOT%{prefix} sysconfdir=$RPM_BUILD_ROOT%{sysconfdir} mandir=$RPM_BUILD_ROOT%{_mandir} install

make -k -C data/gconf DESTDIR=$RPM_BUILD_ROOT install
make -k -C help/C DESTDIR=$RPM_BUILD_ROOT install

[ -f $RPM_BUILD_ROOT/bin/gtranslator ] && \
	strip $RPM_BUILD_ROOT/bin/gtranslator

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig
scrollkeeper-update

%postun -p /sbin/ldconfig
scrollkeeper-update

%files

%defattr(0555, bin, bin)
%{prefix}/bin/gtranslator
%{prefix}/bin/pozilla.sh
%{prefix}/share/gtranslator/scripts/*

%defattr(0444, bin, bin)
%{prefix}/share/gtranslator/colorschemes/*
%{prefix}/share/omf/gtranslator/*

%doc AUTHORS COPYING ChangeLog DEPENDS INSTALL NEWS README THANKS TODO
%{_mandir}/man1/gtranslator*
%{_mandir}/man1/pozilla*
%{prefix}/share/gnome/help/gtranslator/*/*

%defattr(0755, bin, bin)
%{prefix}/lib/gtranslator/backends/*/*.la
%{prefix}/lib/gtranslator/backends/*/*.so

%defattr(-, root, root)
%{sysconfdir}/gconf/schemas/gtranslator.schemas
%{prefix}/lib/gtranslator/backends/*.xml
%{prefix}/share/gtranslator/etspecs/*etspec
%{prefix}/share/gnome/apps/Development/gtranslator*
%{prefix}/share/pixmaps/*.png
%{prefix}/share/pixmaps/gtranslator/*
%{prefix}/share/mime-info/gtranslator.*
%{prefix}/share/locale/*/LC_MESSAGES/gtranslator.mo
