// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use gdk;
use gio;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use glib::Value;
use glib_sys;
use gobject_sys;
use gtk_sys;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use Window;

glib_wrapper! {
    pub struct MountOperation(Object<gtk_sys::GtkMountOperation, gtk_sys::GtkMountOperationClass, MountOperationClass>) @extends gio::MountOperation;

    match fn {
        get_type => || gtk_sys::gtk_mount_operation_get_type(),
    }
}

impl MountOperation {
    pub fn new<P: IsA<Window>>(parent: Option<&P>) -> MountOperation {
        assert_initialized_main_thread!();
        unsafe {
            gio::MountOperation::from_glib_full(gtk_sys::gtk_mount_operation_new(
                parent.map(|p| p.as_ref()).to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }
}

#[derive(Clone, Default)]
pub struct MountOperationBuilder {
    parent: Option<Window>,
    screen: Option<gdk::Screen>,
    anonymous: Option<bool>,
    choice: Option<i32>,
    domain: Option<String>,
    is_tcrypt_hidden_volume: Option<bool>,
    is_tcrypt_system_volume: Option<bool>,
    password: Option<String>,
    //password-save: /*Unknown type*/,
    pim: Option<u32>,
    username: Option<String>,
}

impl MountOperationBuilder {
    pub fn new() -> Self {
        Self::default()
    }

    pub fn build(self) -> MountOperation {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref parent) = self.parent {
            properties.push(("parent", parent));
        }
        if let Some(ref screen) = self.screen {
            properties.push(("screen", screen));
        }
        if let Some(ref anonymous) = self.anonymous {
            properties.push(("anonymous", anonymous));
        }
        if let Some(ref choice) = self.choice {
            properties.push(("choice", choice));
        }
        if let Some(ref domain) = self.domain {
            properties.push(("domain", domain));
        }
        if let Some(ref is_tcrypt_hidden_volume) = self.is_tcrypt_hidden_volume {
            properties.push(("is-tcrypt-hidden-volume", is_tcrypt_hidden_volume));
        }
        if let Some(ref is_tcrypt_system_volume) = self.is_tcrypt_system_volume {
            properties.push(("is-tcrypt-system-volume", is_tcrypt_system_volume));
        }
        if let Some(ref password) = self.password {
            properties.push(("password", password));
        }
        if let Some(ref pim) = self.pim {
            properties.push(("pim", pim));
        }
        if let Some(ref username) = self.username {
            properties.push(("username", username));
        }
        let ret = glib::Object::new(MountOperation::static_type(), &properties)
            .expect("object new")
            .downcast::<MountOperation>()
            .expect("downcast");
        ret
    }

    pub fn parent<P: IsA<Window>>(mut self, parent: &P) -> Self {
        self.parent = Some(parent.clone().upcast());
        self
    }

    pub fn screen(mut self, screen: &gdk::Screen) -> Self {
        self.screen = Some(screen.clone());
        self
    }

    pub fn anonymous(mut self, anonymous: bool) -> Self {
        self.anonymous = Some(anonymous);
        self
    }

    pub fn choice(mut self, choice: i32) -> Self {
        self.choice = Some(choice);
        self
    }

    pub fn domain(mut self, domain: &str) -> Self {
        self.domain = Some(domain.to_string());
        self
    }

    pub fn is_tcrypt_hidden_volume(mut self, is_tcrypt_hidden_volume: bool) -> Self {
        self.is_tcrypt_hidden_volume = Some(is_tcrypt_hidden_volume);
        self
    }

    pub fn is_tcrypt_system_volume(mut self, is_tcrypt_system_volume: bool) -> Self {
        self.is_tcrypt_system_volume = Some(is_tcrypt_system_volume);
        self
    }

    pub fn password(mut self, password: &str) -> Self {
        self.password = Some(password.to_string());
        self
    }

    pub fn pim(mut self, pim: u32) -> Self {
        self.pim = Some(pim);
        self
    }

    pub fn username(mut self, username: &str) -> Self {
        self.username = Some(username.to_string());
        self
    }
}

pub const NONE_MOUNT_OPERATION: Option<&MountOperation> = None;

pub trait MountOperationExt: 'static {
    fn get_parent(&self) -> Option<Window>;

    fn get_screen(&self) -> Option<gdk::Screen>;

    fn is_showing(&self) -> bool;

    fn set_parent<P: IsA<Window>>(&self, parent: Option<&P>);

    fn set_screen(&self, screen: &gdk::Screen);

    fn get_property_is_showing(&self) -> bool;

    fn connect_property_is_showing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_parent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_screen_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<MountOperation>> MountOperationExt for O {
    fn get_parent(&self) -> Option<Window> {
        unsafe {
            from_glib_none(gtk_sys::gtk_mount_operation_get_parent(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_screen(&self) -> Option<gdk::Screen> {
        unsafe {
            from_glib_none(gtk_sys::gtk_mount_operation_get_screen(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_showing(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_mount_operation_is_showing(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn set_parent<P: IsA<Window>>(&self, parent: Option<&P>) {
        unsafe {
            gtk_sys::gtk_mount_operation_set_parent(
                self.as_ref().to_glib_none().0,
                parent.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_screen(&self, screen: &gdk::Screen) {
        unsafe {
            gtk_sys::gtk_mount_operation_set_screen(
                self.as_ref().to_glib_none().0,
                screen.to_glib_none().0,
            );
        }
    }

    fn get_property_is_showing(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"is-showing\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `is-showing` getter")
                .unwrap()
        }
    }

    fn connect_property_is_showing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_is_showing_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkMountOperation,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<MountOperation>,
        {
            let f: &F = &*(f as *const F);
            f(&MountOperation::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::is-showing\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_is_showing_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_parent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_parent_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkMountOperation,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<MountOperation>,
        {
            let f: &F = &*(f as *const F);
            f(&MountOperation::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::parent\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_parent_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_screen_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_screen_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkMountOperation,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<MountOperation>,
        {
            let f: &F = &*(f as *const F);
            f(&MountOperation::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::screen\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_screen_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for MountOperation {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "MountOperation")
    }
}
