/* calls-application.c
 *
 * Copyright (C) 2018 Mohammed Sadiq <sadiq@sadiqpk.org>
 *
 * This file is part of Calls.
 *
 * Calls is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Calls is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Calls.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Mohammed Sadiq <sadiq@sadiqpk.org>
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define CALLS_TYPE_APPLICATION (calls_application_get_type ())

G_DECLARE_FINAL_TYPE (CallsApplication, calls_application, CALLS, APPLICATION, GtkApplication)

CallsApplication   *calls_application_new                               (void);
gboolean            calls_application_get_use_default_origins_setting   (CallsApplication *self);
void                calls_application_set_use_default_origins_setting   (CallsApplication *self,
                                                                         gboolean enabled);
char               *calls_application_get_country_code_setting          (CallsApplication *self);
void                calls_application_set_country_code_setting          (CallsApplication *self,
                                                                         const char       *country_code);

G_END_DECLS
