#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>

#include <stdlib.h>
#include <stdio.h>
#include <glib.h>
#include <errno.h>

#include <libgnomevfs/gnome-vfs.h>
#include <libgnomevfs/gnome-vfs-module.h>

#include <libgnomevfs/gnome-vfs-cancellable-ops.h>

void *xml_open_tag(GMarkupParseContext *, const gchar *, const gchar **, const gchar **, gpointer, GError **);

static const GMarkupParser parseur = {
  (void *)xml_open_tag,
  NULL,
  NULL,
  NULL,
  NULL    
};

struct _meta_infos {
  gchar *author;
  gchar *name;
  gchar *version;
  gchar *description;
  gchar *icon;
  gchar *preview;
  gchar *category;
  gchar *homepage;
  gchar *dependency;
};

GnomeVFSHandle *handle;

int main(int argc, char *argv[])
{
  GMarkupParseContext *parse_context;
  gboolean parseok=FALSE;
  GError *error;
  gchar buffer[200000];
  gint file_fd_out;
  GnomeVFSFileSize size_in, size_preview;
  struct _meta_infos meta_infos;
  gchar *preview_url;
  GnomeVFSResult result;

  if(argc != 3)
    {
      printf("Syntaxe: %s [display_file to parse] [output]\n", argv[0]);
      return -1;
    }

  if (!gnome_vfs_init ())
    {
      printf ("Could not initialize GnomeVFS\n");
      return 0;
    }

  result = gnome_vfs_open (&handle, argv[1], GNOME_VFS_OPEN_READ);
  
  if(result != GNOME_VFS_OK)
    {
      printf ("Could not open URI: %s\n", argv[1]);
      exit(1);
    }
  
  memset(&meta_infos, 0, sizeof(meta_infos));

  result = gnome_vfs_read (handle, buffer, sizeof (buffer) - 1, &size_in);

  if(result != GNOME_VFS_OK)
    {
      printf ("Could not read URI\n");
      exit(1);
    }

  buffer[size_in]='\0';
  
  parse_context = g_markup_parse_context_new(&parseur, 0, &meta_infos, NULL);
  parseok = g_markup_parse_context_parse(parse_context, buffer, size_in, &error);

  if(meta_infos.preview == NULL)
    {
      printf("No preview tag for %s\n", argv[1]);
      exit(1);
    }
  
  if(g_path_is_absolute(meta_infos.preview))
    {
      preview_url = g_strdup(meta_infos.preview);
    }
  else
    {
      if(!strncmp(argv[1], "desklets:///", strlen("desklets:///")))
	{
	  gchar **uri_txt;
	  gchar *dir;
	  
	  (gchar *)uri_txt=g_strdup("full_uri");
	  gnome_vfs_file_control(handle, "preview", uri_txt);
	  
	  dir =  g_path_get_dirname(*uri_txt);
	  preview_url = g_build_path(G_DIR_SEPARATOR_S, dir, meta_infos.preview, NULL);
	}
      else
	{
	  gchar *dir;
	  
	  dir = g_path_get_dirname(argv[1]);
	  preview_url = g_build_path(G_DIR_SEPARATOR_S, dir, meta_infos.preview, NULL);
	}
    }

  result = gnome_vfs_close (handle);

  result = gnome_vfs_open(&handle, preview_url, GNOME_VFS_OPEN_READ);

  if(result != GNOME_VFS_OK)
    {
      perror("Error: can't open the preview file");
      return 0;
    } 
  
  if((file_fd_out = open(argv[2], O_CREAT | O_WRONLY, 0644)) == -1)
    {
      perror("Error: can't open the file out");
      return 0;
    } 

  while (result == GNOME_VFS_OK) {
    result = gnome_vfs_read (handle, buffer, sizeof(buffer)-1, &size_preview);
    buffer[size_preview] = 0;
    write(file_fd_out, buffer, size_preview); 
    if(size_preview == 0)
      break;
  }

  result = gnome_vfs_close (handle);
  close(file_fd_out);
    
  return 0;
}


void *xml_open_tag(GMarkupParseContext *context, const gchar *element_name, const gchar **attribute_names, const gchar **attribute_values, gpointer infos, GError **error){
  if(!strcmp(element_name, "meta"))
  {
    while(*attribute_names != NULL)
      {
	if(!strcmp(*attribute_names, "author"))	
	  ((struct _meta_infos *)infos)->author = g_strdup(*attribute_values);
	else if(!strcmp(*attribute_names, "name"))	
	  ((struct _meta_infos *)infos)->name = g_strdup(*attribute_values);
	else if(!strcmp(*attribute_names, "description"))	
	  ((struct _meta_infos *)infos)->description = g_strdup(*attribute_values);
	else if(!strcmp(*attribute_names, "version"))	
	  ((struct _meta_infos *)infos)->version = g_strdup(*attribute_values);
	else if(!strcmp(*attribute_names, "icon"))	
	  ((struct _meta_infos *)infos)->icon = g_strdup(*attribute_values);
	else if(!strcmp(*attribute_names, "preview"))	
	  ((struct _meta_infos *)infos)->preview = g_strdup(*attribute_values);
	else if(!strcmp(*attribute_names, "category"))	
	  ((struct _meta_infos *)infos)->category = g_strdup(*attribute_values);
	else if(!strcmp(*attribute_names, "homepage"))	
	  ((struct _meta_infos *)infos)->homepage = g_strdup(*attribute_values);
	else if(!strcmp(*attribute_names, "dependency"))	
	  ((struct _meta_infos *)infos)->dependency = g_strdup(*attribute_values);
	
	attribute_names++;
	attribute_values++;
      }
  }

  return infos;
}
