import gtk


#
# Class for sensor menus.
#
# Entry format:
#  [(label: str, active: bool, submenu: list, callback: function, args: list),
#   ...
#  ]
#
class Menu:

    def __init__(self, entries):

        self.__menu = self.__build_menu(entries)



    def __build_menu(self, entries):

        menu = gtk.Menu()

        for e in entries:
            # separator
            if (not e):
                sep = gtk.MenuItem()
                sep.show()
                menu.append(sep)

            # menu item
            else:
                label, active, submenu, callback, args = e
                # handle stock items
                if (label.startswith("gtk-")):
                    item = gtk.ImageMenuItem(label)
                else:
                    item = gtk.MenuItem(label)
                item.show()
                menu.append(item)

                if (not active): item.set_sensitive(gtk.FALSE)

                if (submenu):
                    sub = self.__build_menu(submenu)
                    item.set_submenu(sub)

                else:
                    apply(item.connect, ["activate", callback] + list(args))

            #end for

        return menu


    #
    # Returns the GTK menu.
    #
    def get_menu(self): return self.__menu



    #
    # Pops up this menu.
    #
    def popup(self):

        self.__menu.popup(None, None, None, 3, 0)
