/* rygel-music-item.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-music-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gst/gst.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_ART_STORE (rygel_media_art_store_get_type ())
#define RYGEL_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStore))
#define RYGEL_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))
#define RYGEL_IS_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_IS_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_MEDIA_ART_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))

typedef struct _RygelMediaArtStore RygelMediaArtStore;
typedef struct _RygelMediaArtStoreClass RygelMediaArtStoreClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	char* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const char* property);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	char* date;
	char* mime_type;
	char* dlna_profile;
	gint64 size;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const char* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const char* uri, const char* protocol, const char* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const char* uri, const char* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint n_audio_channels;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelMusicItem {
	RygelAudioItem parent_instance;
	RygelMusicItemPrivate * priv;
	char* artist;
	char* album;
	char* genre;
	gint track_number;
	RygelThumbnail* album_art;
};

struct _RygelMusicItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	char* mime_type;
	char* uri;
	char* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};


static gpointer rygel_music_item_parent_class = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MUSIC_ITEM_DUMMY_PROPERTY
};
#define RYGEL_MUSIC_ITEM_UPNP_CLASS "object.item.audioItem.musicTrack"
RygelMusicItem* rygel_music_item_new (const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class);
RygelMusicItem* rygel_music_item_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class);
RygelAudioItem* rygel_audio_item_new (const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class);
RygelAudioItem* rygel_audio_item_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class);
void rygel_music_item_lookup_album_art (RygelMusicItem* self);
GType rygel_media_art_store_get_type (void) G_GNUC_CONST;
RygelMediaArtStore* rygel_media_art_store_get_default (void);
RygelThumbnail* rygel_media_art_store_find_media_art_any (RygelMediaArtStore* self, RygelMusicItem* item, GError** error);
static void rygel_music_item_real_add_resources (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
void rygel_media_item_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
char* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const char* uri, GError** error);
GUPnPDIDLLiteResource* rygel_thumbnail_add_resource (RygelThumbnail* self, GUPnPDIDLLiteItem* didl_item, const char* protocol);
static gint rygel_music_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const char* property);
gint rygel_media_object_compare_string_props (RygelMediaObject* self, const char* prop1, const char* prop2);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const char* property);
static GUPnPDIDLLiteObject* rygel_music_item_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
static void rygel_music_item_real_add_proxy_resources (RygelMediaItem* base, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
void rygel_media_item_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
gboolean rygel_http_server_need_proxy (RygelHTTPServer* self, const char* uri);
char* rygel_transcode_manager_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const char* transcode_target);
char* rygel_transcode_manager_get_protocol (RygelTranscodeManager* self);
static void rygel_music_item_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



#line 41 "rygel-music-item.vala"
RygelMusicItem* rygel_music_item_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class) {
#line 281 "rygel-music-item.c"
	RygelMusicItem * self;
#line 41 "rygel-music-item.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 41 "rygel-music-item.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 41 "rygel-music-item.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 41 "rygel-music-item.vala"
	g_return_val_if_fail (upnp_class != NULL, NULL);
#line 45 "rygel-music-item.vala"
	self = (RygelMusicItem*) rygel_audio_item_construct (object_type, id, parent, title, upnp_class);
#line 293 "rygel-music-item.c"
	return self;
}


#line 41 "rygel-music-item.vala"
RygelMusicItem* rygel_music_item_new (const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class) {
#line 41 "rygel-music-item.vala"
	return rygel_music_item_construct (RYGEL_TYPE_MUSIC_ITEM, id, parent, title, upnp_class);
#line 302 "rygel-music-item.c"
}


#line 48 "rygel-music-item.vala"
void rygel_music_item_lookup_album_art (RygelMusicItem* self) {
#line 308 "rygel-music-item.c"
	RygelMediaArtStore* media_art_store;
	GError * _inner_error_ = NULL;
#line 48 "rygel-music-item.vala"
	g_return_if_fail (self != NULL);
#line 49 "rygel-music-item.vala"
	g_assert (self->album_art == NULL);
#line 51 "rygel-music-item.vala"
	media_art_store = rygel_media_art_store_get_default ();
#line 52 "rygel-music-item.vala"
	if (media_art_store == NULL) {
#line 319 "rygel-music-item.c"
		_g_object_unref0 (media_art_store);
#line 53 "rygel-music-item.vala"
		return;
#line 323 "rygel-music-item.c"
	}
	{
		RygelThumbnail* _tmp0_;
		RygelThumbnail* _tmp1_;
#line 57 "rygel-music-item.vala"
		_tmp0_ = rygel_media_art_store_find_media_art_any (media_art_store, self, &_inner_error_);
#line 330 "rygel-music-item.c"
		if (_inner_error_ != NULL) {
			goto __catch41_g_error;
		}
#line 57 "rygel-music-item.vala"
		self->album_art = (_tmp1_ = _tmp0_, _rygel_icon_info_unref0 (self->album_art), _tmp1_);
#line 336 "rygel-music-item.c"
	}
	goto __finally41;
	__catch41_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (err);
		}
	}
	__finally41:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (media_art_store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	;
	_g_object_unref0 (media_art_store);
}


#line 61 "rygel-music-item.vala"
static void rygel_music_item_real_add_resources (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error) {
#line 362 "rygel-music-item.c"
	RygelMusicItem * self;
	GError * _inner_error_ = NULL;
	self = (RygelMusicItem*) base;
#line 61 "rygel-music-item.vala"
	g_return_if_fail (didl_item != NULL);
#line 64 "rygel-music-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (rygel_music_item_parent_class)->add_resources ((RygelMediaItem*) RYGEL_AUDIO_ITEM (self), didl_item, allow_internal, &_inner_error_);
#line 370 "rygel-music-item.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
#line 66 "rygel-music-item.vala"
	if (self->album_art != NULL) {
#line 377 "rygel-music-item.c"
		char* protocol;
		gboolean _tmp0_ = FALSE;
#line 67 "rygel-music-item.vala"
		protocol = rygel_media_item_get_protocol_for_uri ((RygelMediaItem*) self, ((RygelIconInfo*) self->album_art)->uri, &_inner_error_);
#line 382 "rygel-music-item.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
#line 69 "rygel-music-item.vala"
		if (allow_internal) {
#line 69 "rygel-music-item.vala"
			_tmp0_ = TRUE;
#line 391 "rygel-music-item.c"
		} else {
#line 69 "rygel-music-item.vala"
			_tmp0_ = _vala_strcmp0 (protocol, "internal") != 0;
#line 395 "rygel-music-item.c"
		}
#line 69 "rygel-music-item.vala"
		if (_tmp0_) {
#line 399 "rygel-music-item.c"
			GUPnPDIDLLiteResource* _tmp1_;
#line 70 "rygel-music-item.vala"
			_tmp1_ = rygel_thumbnail_add_resource (self->album_art, didl_item, protocol);
#line 403 "rygel-music-item.c"
			_g_object_unref0 (_tmp1_);
		}
		_g_free0 (protocol);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 75 "rygel-music-item.vala"
static gint rygel_music_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const char* property) {
#line 418 "rygel-music-item.c"
	RygelMusicItem * self;
	gint result = 0;
	RygelMediaObject* _tmp0_;
	RygelMusicItem* item;
	const char* _tmp1_;
	GQuark _tmp2_;
	static GQuark _tmp2__label0 = 0;
	static GQuark _tmp2__label1 = 0;
	self = (RygelMusicItem*) base;
#line 75 "rygel-music-item.vala"
	g_return_val_if_fail (media_object != NULL, 0);
#line 75 "rygel-music-item.vala"
	g_return_val_if_fail (property != NULL, 0);
#line 77 "rygel-music-item.vala"
	if (!RYGEL_IS_MUSIC_ITEM (media_object)) {
#line 434 "rygel-music-item.c"
		result = 1;
#line 78 "rygel-music-item.vala"
		return result;
#line 438 "rygel-music-item.c"
	}
#line 81 "rygel-music-item.vala"
	item = _g_object_ref0 ((_tmp0_ = media_object, RYGEL_IS_MUSIC_ITEM (_tmp0_) ? ((RygelMusicItem*) _tmp0_) : NULL));
#line 442 "rygel-music-item.c"
	_tmp1_ = property;
	_tmp2_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp2_ == ((0 != _tmp2__label0) ? _tmp2__label0 : (_tmp2__label0 = g_quark_from_static_string ("dc:artist"))))
	switch (0) {
		default:
		{
			result = rygel_media_object_compare_string_props ((RygelMediaObject*) self, self->artist, item->artist);
			_g_object_unref0 (item);
#line 85 "rygel-music-item.vala"
			return result;
#line 453 "rygel-music-item.c"
		}
	} else if (_tmp2_ == ((0 != _tmp2__label1) ? _tmp2__label1 : (_tmp2__label1 = g_quark_from_static_string ("upnp:album"))))
	switch (0) {
		default:
		{
			result = rygel_media_object_compare_string_props ((RygelMediaObject*) self, self->album, item->album);
			_g_object_unref0 (item);
#line 87 "rygel-music-item.vala"
			return result;
#line 463 "rygel-music-item.c"
		}
	} else
	switch (0) {
		default:
		{
			result = RYGEL_MEDIA_OBJECT_CLASS (rygel_music_item_parent_class)->compare_by_property ((RygelMediaObject*) RYGEL_AUDIO_ITEM (self), (RygelMediaObject*) item, property);
			_g_object_unref0 (item);
#line 89 "rygel-music-item.vala"
			return result;
#line 473 "rygel-music-item.c"
		}
	}
	_g_object_unref0 (item);
}


#line 93 "rygel-music-item.vala"
static GUPnPDIDLLiteObject* rygel_music_item_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error) {
#line 482 "rygel-music-item.c"
	RygelMusicItem * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteObject* didl_item;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelMusicItem*) base;
#line 93 "rygel-music-item.vala"
	g_return_val_if_fail (writer != NULL, NULL);
#line 93 "rygel-music-item.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 96 "rygel-music-item.vala"
	didl_item = RYGEL_MEDIA_OBJECT_CLASS (rygel_music_item_parent_class)->serialize ((RygelMediaObject*) RYGEL_AUDIO_ITEM (self), writer, http_server, &_inner_error_);
#line 497 "rygel-music-item.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
#line 98 "rygel-music-item.vala"
	if (self->artist != NULL) {
#line 98 "rygel-music-item.vala"
		_tmp0_ = _vala_strcmp0 (self->artist, "") != 0;
#line 506 "rygel-music-item.c"
	} else {
#line 98 "rygel-music-item.vala"
		_tmp0_ = FALSE;
#line 510 "rygel-music-item.c"
	}
#line 98 "rygel-music-item.vala"
	if (_tmp0_) {
#line 514 "rygel-music-item.c"
		GUPnPDIDLLiteContributor* contributor;
#line 99 "rygel-music-item.vala"
		contributor = gupnp_didl_lite_object_add_artist (didl_item);
#line 100 "rygel-music-item.vala"
		gupnp_didl_lite_contributor_set_name (contributor, self->artist);
#line 520 "rygel-music-item.c"
		_g_object_unref0 (contributor);
	}
#line 103 "rygel-music-item.vala"
	if (self->track_number >= 0) {
#line 104 "rygel-music-item.vala"
		gupnp_didl_lite_object_set_track_number (didl_item, self->track_number);
#line 527 "rygel-music-item.c"
	}
#line 107 "rygel-music-item.vala"
	if (self->album != NULL) {
#line 107 "rygel-music-item.vala"
		_tmp1_ = _vala_strcmp0 (self->album, "") != 0;
#line 533 "rygel-music-item.c"
	} else {
#line 107 "rygel-music-item.vala"
		_tmp1_ = FALSE;
#line 537 "rygel-music-item.c"
	}
#line 107 "rygel-music-item.vala"
	if (_tmp1_) {
#line 108 "rygel-music-item.vala"
		gupnp_didl_lite_object_set_album (didl_item, self->album);
#line 543 "rygel-music-item.c"
	}
#line 111 "rygel-music-item.vala"
	if (self->genre != NULL) {
#line 111 "rygel-music-item.vala"
		_tmp2_ = _vala_strcmp0 (self->genre, "") != 0;
#line 549 "rygel-music-item.c"
	} else {
#line 111 "rygel-music-item.vala"
		_tmp2_ = FALSE;
#line 553 "rygel-music-item.c"
	}
#line 111 "rygel-music-item.vala"
	if (_tmp2_) {
#line 112 "rygel-music-item.vala"
		gupnp_didl_lite_object_set_genre (didl_item, self->genre);
#line 559 "rygel-music-item.c"
	}
	result = didl_item;
#line 115 "rygel-music-item.vala"
	return result;
#line 564 "rygel-music-item.c"
}


#line 118 "rygel-music-item.vala"
static void rygel_music_item_real_add_proxy_resources (RygelMediaItem* base, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error) {
#line 570 "rygel-music-item.c"
	RygelMusicItem * self;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelMusicItem*) base;
#line 118 "rygel-music-item.vala"
	g_return_if_fail (server != NULL);
#line 118 "rygel-music-item.vala"
	g_return_if_fail (didl_item != NULL);
#line 121 "rygel-music-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (rygel_music_item_parent_class)->add_proxy_resources ((RygelMediaItem*) RYGEL_AUDIO_ITEM (self), server, didl_item, &_inner_error_);
#line 581 "rygel-music-item.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
#line 124 "rygel-music-item.vala"
	if (self->album_art != NULL) {
#line 124 "rygel-music-item.vala"
		_tmp0_ = rygel_http_server_need_proxy (server, ((RygelIconInfo*) self->album_art)->uri);
#line 590 "rygel-music-item.c"
	} else {
#line 124 "rygel-music-item.vala"
		_tmp0_ = FALSE;
#line 594 "rygel-music-item.c"
	}
#line 124 "rygel-music-item.vala"
	if (_tmp0_) {
#line 598 "rygel-music-item.c"
		char* uri;
		char* _tmp1_;
		char* _tmp2_;
		GUPnPDIDLLiteResource* _tmp3_;
		char* _tmp4_;
#line 125 "rygel-music-item.vala"
		uri = g_strdup (((RygelIconInfo*) self->album_art)->uri);
#line 127 "rygel-music-item.vala"
		((RygelIconInfo*) self->album_art)->uri = (_tmp1_ = rygel_transcode_manager_create_uri_for_item ((RygelTranscodeManager*) server, (RygelMediaItem*) self, 0, -1, NULL), _g_free0 (((RygelIconInfo*) self->album_art)->uri), _tmp1_);
#line 128 "rygel-music-item.vala"
		_tmp3_ = rygel_thumbnail_add_resource (self->album_art, didl_item, _tmp2_ = rygel_transcode_manager_get_protocol ((RygelTranscodeManager*) server));
#line 610 "rygel-music-item.c"
		_g_object_unref0 (_tmp3_);
		_g_free0 (_tmp2_);
#line 131 "rygel-music-item.vala"
		((RygelIconInfo*) self->album_art)->uri = (_tmp4_ = g_strdup (uri), _g_free0 (((RygelIconInfo*) self->album_art)->uri), _tmp4_);
#line 615 "rygel-music-item.c"
		_g_free0 (uri);
	}
}


static void rygel_music_item_class_init (RygelMusicItemClass * klass) {
	rygel_music_item_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_resources = rygel_music_item_real_add_resources;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->compare_by_property = rygel_music_item_real_compare_by_property;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->serialize = rygel_music_item_real_serialize;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_proxy_resources = rygel_music_item_real_add_proxy_resources;
	G_OBJECT_CLASS (klass)->finalize = rygel_music_item_finalize;
}


static void rygel_music_item_instance_init (RygelMusicItem * self) {
	self->track_number = -1;
}


static void rygel_music_item_finalize (GObject* obj) {
	RygelMusicItem * self;
	self = RYGEL_MUSIC_ITEM (obj);
	_g_free0 (self->artist);
	_g_free0 (self->album);
	_g_free0 (self->genre);
	_rygel_icon_info_unref0 (self->album_art);
	G_OBJECT_CLASS (rygel_music_item_parent_class)->finalize (obj);
}


/**
 * Represents a music item.
 */
GType rygel_music_item_get_type (void) {
	static volatile gsize rygel_music_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_music_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMusicItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_music_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMusicItem), 0, (GInstanceInitFunc) rygel_music_item_instance_init, NULL };
		GType rygel_music_item_type_id;
		rygel_music_item_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_ITEM, "RygelMusicItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_music_item_type_id__volatile, rygel_music_item_type_id);
	}
	return rygel_music_item_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




