/* rygel-media-export-database.c generated by valac 0.9.6, the Vala compiler
 * generated from rygel-media-export-database.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define RYGEL_MEDIA_EXPORT_TYPE_DATABASE (rygel_media_export_database_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabase))
#define RYGEL_MEDIA_EXPORT_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))

typedef struct _RygelMediaExportDatabase RygelMediaExportDatabase;
typedef struct _RygelMediaExportDatabaseClass RygelMediaExportDatabaseClass;
typedef struct _RygelMediaExportDatabasePrivate RygelMediaExportDatabasePrivate;
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
struct _RygelMediaExportDatabase {
	GObject parent_instance;
	RygelMediaExportDatabasePrivate * priv;
};

struct _RygelMediaExportDatabaseClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportDatabasePrivate {
	sqlite3* db;
};

typedef gboolean (*RygelMediaExportDatabaseRowCallback) (sqlite3_stmt* stmt, void* user_data);

static gpointer rygel_media_export_database_parent_class = NULL;

GQuark rygel_media_export_database_error_quark (void);
GType rygel_media_export_database_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_DATABASE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabasePrivate))
enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_DUMMY_PROPERTY
};
static void rygel_media_export_database_utf8_has_prefix (sqlite3_context* context, sqlite3_value** args, int args_length1);
static void rygel_media_export_database_utf8_like (sqlite3_context* context, sqlite3_value** args, int args_length1);
static gint rygel_media_export_database_utf8_collate (gint alen, void* a, gint blen, void* b);
RygelMediaExportDatabase* rygel_media_export_database_new (const char* name, GError** error);
RygelMediaExportDatabase* rygel_media_export_database_construct (GType object_type, const char* name, GError** error);
static void _rygel_media_export_database_utf8_like_sqlite_user_func_callback (sqlite3_context* context, int values_length1, sqlite3_value** values);
static void _rygel_media_export_database_utf8_has_prefix_sqlite_user_func_callback (sqlite3_context* context, int values_length1, sqlite3_value** values);
static gint _rygel_media_export_database_utf8_collate_sqlite_compare_callback (gpointer self, gint alen, void* a, gint blen, void* b);
gint rygel_media_export_database_exec (RygelMediaExportDatabase* self, const char* sql, GValue* values, int values_length1, RygelMediaExportDatabaseRowCallback callback, void* callback_target, GCancellable* cancellable, GError** error);
static sqlite3_stmt* rygel_media_export_database_prepare_statement (RygelMediaExportDatabase* self, const char* sql, GValue* values, int values_length1, GError** error);
void rygel_media_export_database_analyze (RygelMediaExportDatabase* self);
void rygel_media_export_database_null (GValue* result);
void rygel_media_export_database_begin (RygelMediaExportDatabase* self, GError** error);
static void rygel_media_export_database_single_statement (RygelMediaExportDatabase* self, const char* sql, GError** error);
void rygel_media_export_database_commit (RygelMediaExportDatabase* self, GError** error);
void rygel_media_export_database_rollback (RygelMediaExportDatabase* self);
static void rygel_media_export_database_finalize (GObject* obj);



GQuark rygel_media_export_database_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_export_database_error-quark");
}


#line 46 "rygel-media-export-database.vala"
static void rygel_media_export_database_utf8_has_prefix (sqlite3_context* context, sqlite3_value** args, int args_length1) {
#line 108 "rygel-media-export-database.c"
	gboolean _tmp0_ = FALSE;
	char* stra;
	char* strb;
#line 46 "rygel-media-export-database.vala"
	g_return_if_fail (context != NULL);
#line 114 "rygel-media-export-database.c"
	g_return_if_fail (args_length1 == 2);
#line 49 "rygel-media-export-database.vala"
	if (sqlite3_value_text (args[0]) == NULL) {
#line 49 "rygel-media-export-database.vala"
		_tmp0_ = TRUE;
#line 120 "rygel-media-export-database.c"
	} else {
#line 50 "rygel-media-export-database.vala"
		_tmp0_ = sqlite3_value_text (args[1]) == NULL;
#line 124 "rygel-media-export-database.c"
	}
#line 49 "rygel-media-export-database.vala"
	if (_tmp0_) {
#line 51 "rygel-media-export-database.vala"
		sqlite3_result_int (context, 0);
#line 53 "rygel-media-export-database.vala"
		return;
#line 132 "rygel-media-export-database.c"
	}
#line 56 "rygel-media-export-database.vala"
	stra = g_utf8_casefold (sqlite3_value_text (args[0]), -1);
#line 57 "rygel-media-export-database.vala"
	strb = g_utf8_casefold (sqlite3_value_text (args[1]), -1);
#line 59 "rygel-media-export-database.vala"
	if (g_str_has_prefix (stra, strb)) {
#line 60 "rygel-media-export-database.vala"
		sqlite3_result_int (context, 1);
#line 142 "rygel-media-export-database.c"
	} else {
#line 62 "rygel-media-export-database.vala"
		sqlite3_result_int (context, 0);
#line 146 "rygel-media-export-database.c"
	}
	_g_free0 (strb);
	_g_free0 (stra);
}


#line 1156 "glib-2.0.vapi"
static char* string_replace (const char* self, const char* old, const char* replacement) {
#line 155 "rygel-media-export-database.c"
	char* result = NULL;
	GError * _inner_error_ = NULL;
#line 1156 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1156 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1156 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 164 "rygel-media-export-database.c"
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
#line 1158 "glib-2.0.vapi"
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
#line 172 "rygel-media-export-database.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 1159 "glib-2.0.vapi"
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
#line 183 "rygel-media-export-database.c"
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
#line 1159 "glib-2.0.vapi"
		return result;
#line 198 "rygel-media-export-database.c"
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 1161 "glib-2.0.vapi"
			g_assert_not_reached ();
#line 209 "rygel-media-export-database.c"
			_g_error_free0 (e);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


#line 66 "rygel-media-export-database.vala"
static void rygel_media_export_database_utf8_like (sqlite3_context* context, sqlite3_value** args, int args_length1) {
#line 224 "rygel-media-export-database.c"
	char* pattern;
	char* _tmp0_;
	char* _tmp1_;
#line 66 "rygel-media-export-database.vala"
	g_return_if_fail (context != NULL);
#line 230 "rygel-media-export-database.c"
	g_return_if_fail (args_length1 == 2);
#line 69 "rygel-media-export-database.vala"
	if (sqlite3_value_text (args[1]) == NULL) {
#line 70 "rygel-media-export-database.vala"
		sqlite3_result_int (context, 0);
#line 72 "rygel-media-export-database.vala"
		return;
#line 238 "rygel-media-export-database.c"
	}
#line 75 "rygel-media-export-database.vala"
	pattern = g_regex_escape_string (sqlite3_value_text (args[0]), -1);
#line 76 "rygel-media-export-database.vala"
	pattern = (_tmp1_ = string_replace (_tmp0_ = string_replace (pattern, "%", ".*"), "_", "."), _g_free0 (pattern), _tmp1_);
#line 244 "rygel-media-export-database.c"
	_g_free0 (_tmp0_);
#line 77 "rygel-media-export-database.vala"
	if (g_regex_match_simple (pattern, sqlite3_value_text (args[1]), G_REGEX_CASELESS, 0)) {
#line 80 "rygel-media-export-database.vala"
		sqlite3_result_int (context, 1);
#line 250 "rygel-media-export-database.c"
	} else {
#line 82 "rygel-media-export-database.vala"
		sqlite3_result_int (context, 0);
#line 254 "rygel-media-export-database.c"
	}
	_g_free0 (pattern);
}


#line 86 "rygel-media-export-database.vala"
static gint rygel_media_export_database_utf8_collate (gint alen, void* a, gint blen, void* b) {
#line 262 "rygel-media-export-database.c"
	gint result = 0;
	gint _a_length1;
	gint __a_size_;
	guint8* _tmp0_;
	guint8* _a;
	gint _b_length1;
	gint __b_size_;
	guint8* _tmp1_;
	guint8* _b;
	char* str_a;
	char* str_b;
	_a = (_tmp0_ = (guint8*) a, _a_length1 = -1, __a_size_ = _a_length1, _tmp0_);
#line 89 "rygel-media-export-database.vala"
	_a_length1 = alen;
#line 277 "rygel-media-export-database.c"
	_b = (_tmp1_ = (guint8*) b, _b_length1 = -1, __b_size_ = _b_length1, _tmp1_);
#line 92 "rygel-media-export-database.vala"
	_b_length1 = blen;
#line 94 "rygel-media-export-database.vala"
	str_a = g_utf8_casefold ((const char*) _a, -1);
#line 95 "rygel-media-export-database.vala"
	str_b = g_utf8_casefold ((const char*) _b, -1);
#line 285 "rygel-media-export-database.c"
	result = g_utf8_collate (str_a, str_b);
	_g_free0 (str_b);
	_g_free0 (str_a);
#line 97 "rygel-media-export-database.vala"
	return result;
#line 291 "rygel-media-export-database.c"
}


/**
     * Open a database in the user's cache directory as defined by XDG
     *
     * @param name of the database, used to build full path
     * (<cache-dir>/rygel/<name>.db)
     */
#line 34 "sqlite3.vapi"
static gint _sqlite3_exec (sqlite3* self, const char* sql, sqlite3_callback sqlite3_callback, void* sqlite3_callback_target, char** errmsg) {
#line 303 "rygel-media-export-database.c"
	gint result = 0;
	const char* sqlite_errmsg;
	gint ec;
#line 34 "sqlite3.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 34 "sqlite3.vapi"
	g_return_val_if_fail (sql != NULL, 0);
#line 311 "rygel-media-export-database.c"
	if (errmsg != NULL) {
		*errmsg = NULL;
	}
	sqlite_errmsg = NULL;
#line 36 "sqlite3.vapi"
	ec = sqlite3_exec (self, sql, sqlite3_callback, sqlite3_callback_target, (char**) (&sqlite_errmsg));
#line 37 "sqlite3.vapi"
	if ((errmsg) != NULL) {
#line 320 "rygel-media-export-database.c"
		char* _tmp0_;
#line 38 "sqlite3.vapi"
		*errmsg = (_tmp0_ = g_strdup (sqlite_errmsg), _g_free0 (*errmsg), _tmp0_);
#line 324 "rygel-media-export-database.c"
	}
#line 40 "sqlite3.vapi"
	sqlite3_free ((void*) sqlite_errmsg);
#line 328 "rygel-media-export-database.c"
	result = ec;
#line 41 "sqlite3.vapi"
	return result;
#line 332 "rygel-media-export-database.c"
}


#line 66 "rygel-media-export-database.vala"
static void _rygel_media_export_database_utf8_like_sqlite_user_func_callback (sqlite3_context* context, int values_length1, sqlite3_value** values) {
#line 338 "rygel-media-export-database.c"
	rygel_media_export_database_utf8_like (context, values, values_length1);
}


#line 46 "rygel-media-export-database.vala"
static void _rygel_media_export_database_utf8_has_prefix_sqlite_user_func_callback (sqlite3_context* context, int values_length1, sqlite3_value** values) {
#line 345 "rygel-media-export-database.c"
	rygel_media_export_database_utf8_has_prefix (context, values, values_length1);
}


#line 86 "rygel-media-export-database.vala"
static gint _rygel_media_export_database_utf8_collate_sqlite_compare_callback (gpointer self, gint alen, void* a, gint blen, void* b) {
#line 352 "rygel-media-export-database.c"
	gint result;
	result = rygel_media_export_database_utf8_collate (alen, a, blen, b);
	return result;
}


#line 106 "rygel-media-export-database.vala"
RygelMediaExportDatabase* rygel_media_export_database_construct (GType object_type, const char* name, GError** error) {
#line 361 "rygel-media-export-database.c"
	RygelMediaExportDatabase * self;
	char* dirname;
	char* _tmp0_;
	char* _tmp1_;
	char* db_file;
	sqlite3* _tmp2_ = NULL;
	gint _tmp3_;
	sqlite3* _tmp4_;
	gint rc;
	GError * _inner_error_ = NULL;
#line 106 "rygel-media-export-database.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 106 "rygel-media-export-database.vala"
	self = (RygelMediaExportDatabase*) g_object_new (object_type, NULL);
#line 107 "rygel-media-export-database.vala"
	dirname = g_build_filename (g_get_user_cache_dir (), "rygel", NULL);
#line 109 "rygel-media-export-database.vala"
	g_mkdir_with_parents (dirname, 0750);
#line 110 "rygel-media-export-database.vala"
	db_file = (_tmp1_ = g_build_filename (dirname, _tmp0_ = g_strdup_printf ("%s.db", name), NULL), _g_free0 (_tmp0_), _tmp1_);
#line 111 "rygel-media-export-database.vala"
	g_debug ("rygel-media-export-database.vala:111: Using database file %s", db_file);
#line 112 "rygel-media-export-database.vala"
	rc = (_tmp3_ = sqlite3_open (db_file, &_tmp2_), self->priv->db = (_tmp4_ = _tmp2_, _sqlite3_close0 (self->priv->db), _tmp4_), _tmp3_);
#line 113 "rygel-media-export-database.vala"
	if (rc != SQLITE_OK) {
#line 388 "rygel-media-export-database.c"
		_inner_error_ = g_error_new (RYGEL_MEDIA_EXPORT_DATABASE_ERROR, RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR, _ ("Failed to open database: %d (%s)"), rc, sqlite3_errmsg (self->priv->db));
		{
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (db_file);
				_g_free0 (dirname);
				_g_object_unref0 (self);
				return NULL;
			} else {
				_g_free0 (db_file);
				_g_free0 (dirname);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
#line 120 "rygel-media-export-database.vala"
	_sqlite3_exec (self->priv->db, "PRAGMA cache_size = 32768", NULL, NULL, NULL);
#line 121 "rygel-media-export-database.vala"
	_sqlite3_exec (self->priv->db, "PRAGMA synchronous = OFF", NULL, NULL, NULL);
#line 122 "rygel-media-export-database.vala"
	_sqlite3_exec (self->priv->db, "PRAGMA temp_store = MEMORY", NULL, NULL, NULL);
#line 123 "rygel-media-export-database.vala"
	_sqlite3_exec (self->priv->db, "PRAGMA count_changes = OFF", NULL, NULL, NULL);
#line 124 "rygel-media-export-database.vala"
	sqlite3_create_function (self->priv->db, "like", 2, SQLITE_UTF8, NULL, _rygel_media_export_database_utf8_like_sqlite_user_func_callback, NULL, NULL);
#line 132 "rygel-media-export-database.vala"
	sqlite3_create_function (self->priv->db, "has_prefix", 2, SQLITE_UTF8, NULL, _rygel_media_export_database_utf8_has_prefix_sqlite_user_func_callback, NULL, NULL);
#line 140 "rygel-media-export-database.vala"
	sqlite3_create_collation (self->priv->db, "CASEFOLD", SQLITE_UTF8, NULL, (int (*)(void *, int,  const void *, int,  const void *)) _rygel_media_export_database_utf8_collate_sqlite_compare_callback);
#line 420 "rygel-media-export-database.c"
	_g_free0 (db_file);
	_g_free0 (dirname);
	return self;
}


#line 106 "rygel-media-export-database.vala"
RygelMediaExportDatabase* rygel_media_export_database_new (const char* name, GError** error) {
#line 106 "rygel-media-export-database.vala"
	return rygel_media_export_database_construct (RYGEL_MEDIA_EXPORT_TYPE_DATABASE, name, error);
#line 431 "rygel-media-export-database.c"
}


/**
     * Execute a cancellable SQL statement.
     *
     * The supplied values are bound to the SQL statement and the RowCallback
     * is called on every row of the resultset.
     *
     * @param sql statement to execute
     * @param values array of values to bind to the SQL statement or null if
     * none
     * @param callback to call on each row of the result set or null if none
     * necessary
     * @param cancellable to cancel the running query or null if none
     * necessary
     */
#line 159 "rygel-media-export-database.vala"
gint rygel_media_export_database_exec (RygelMediaExportDatabase* self, const char* sql, GValue* values, int values_length1, RygelMediaExportDatabaseRowCallback callback, void* callback_target, GCancellable* cancellable, GError** error) {
#line 451 "rygel-media-export-database.c"
	gint result = 0;
	gint rc = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GError * _inner_error_ = NULL;
#line 159 "rygel-media-export-database.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 159 "rygel-media-export-database.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 168 "rygel-media-export-database.vala"
	if (values == NULL) {
#line 168 "rygel-media-export-database.vala"
		_tmp1_ = callback == NULL;
#line 466 "rygel-media-export-database.c"
	} else {
#line 168 "rygel-media-export-database.vala"
		_tmp1_ = FALSE;
#line 470 "rygel-media-export-database.c"
	}
#line 168 "rygel-media-export-database.vala"
	if (_tmp1_) {
#line 168 "rygel-media-export-database.vala"
		_tmp0_ = cancellable == NULL;
#line 476 "rygel-media-export-database.c"
	} else {
#line 168 "rygel-media-export-database.vala"
		_tmp0_ = FALSE;
#line 480 "rygel-media-export-database.c"
	}
#line 168 "rygel-media-export-database.vala"
	if (_tmp0_) {
#line 169 "rygel-media-export-database.vala"
		rc = _sqlite3_exec (self->priv->db, sql, NULL, NULL, NULL);
#line 486 "rygel-media-export-database.c"
	} else {
		sqlite3_stmt* statement;
#line 171 "rygel-media-export-database.vala"
		statement = rygel_media_export_database_prepare_statement (self, sql, values, values_length1, &_inner_error_);
#line 491 "rygel-media-export-database.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
#line 172 "rygel-media-export-database.vala"
		while (TRUE) {
#line 504 "rygel-media-export-database.c"
			gboolean _tmp2_ = FALSE;
#line 172 "rygel-media-export-database.vala"
			if (!((rc = sqlite3_step (statement)) == SQLITE_ROW)) {
#line 172 "rygel-media-export-database.vala"
				break;
#line 510 "rygel-media-export-database.c"
			}
#line 173 "rygel-media-export-database.vala"
			if (cancellable != NULL) {
#line 173 "rygel-media-export-database.vala"
				_tmp2_ = g_cancellable_is_cancelled (cancellable);
#line 516 "rygel-media-export-database.c"
			} else {
#line 173 "rygel-media-export-database.vala"
				_tmp2_ = FALSE;
#line 520 "rygel-media-export-database.c"
			}
#line 173 "rygel-media-export-database.vala"
			if (_tmp2_) {
#line 174 "rygel-media-export-database.vala"
				break;
#line 526 "rygel-media-export-database.c"
			}
#line 177 "rygel-media-export-database.vala"
			if (callback != NULL) {
#line 178 "rygel-media-export-database.vala"
				if (!callback (statement, callback_target)) {
#line 179 "rygel-media-export-database.vala"
					rc = SQLITE_DONE;
#line 181 "rygel-media-export-database.vala"
					break;
#line 536 "rygel-media-export-database.c"
				}
			}
		}
		_sqlite3_finalize0 (statement);
	}
#line 187 "rygel-media-export-database.vala"
	if (rc != SQLITE_DONE) {
#line 187 "rygel-media-export-database.vala"
		_tmp3_ = rc != SQLITE_OK;
#line 546 "rygel-media-export-database.c"
	} else {
#line 187 "rygel-media-export-database.vala"
		_tmp3_ = FALSE;
#line 550 "rygel-media-export-database.c"
	}
#line 187 "rygel-media-export-database.vala"
	if (_tmp3_) {
#line 554 "rygel-media-export-database.c"
		_inner_error_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_DATABASE_ERROR, RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR, sqlite3_errmsg (self->priv->db));
		{
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
	}
	result = rc;
#line 194 "rygel-media-export-database.vala"
	return result;
#line 570 "rygel-media-export-database.c"
}


/**
     * Analyze triggers of database
     */
#line 200 "rygel-media-export-database.vala"
void rygel_media_export_database_analyze (RygelMediaExportDatabase* self) {
#line 200 "rygel-media-export-database.vala"
	g_return_if_fail (self != NULL);
#line 201 "rygel-media-export-database.vala"
	_sqlite3_exec (self->priv->db, "ANALYZE", NULL, NULL, NULL);
#line 583 "rygel-media-export-database.c"
}


/**
     * Special GValue to pass to exec or prepare_statement to bind a column to
     * NULL
     */
#line 208 "rygel-media-export-database.vala"
void rygel_media_export_database_null (GValue* result) {
#line 593 "rygel-media-export-database.c"
	GValue v = {0};
	g_value_init (&v, G_TYPE_POINTER);
#line 210 "rygel-media-export-database.vala"
	g_value_set_pointer (&v, NULL);
#line 598 "rygel-media-export-database.c"
	*result = v;
#line 212 "rygel-media-export-database.vala"
	return;
#line 602 "rygel-media-export-database.c"
}


/**
     * Start a transaction
     */
#line 218 "rygel-media-export-database.vala"
void rygel_media_export_database_begin (RygelMediaExportDatabase* self, GError** error) {
#line 611 "rygel-media-export-database.c"
	GError * _inner_error_ = NULL;
#line 218 "rygel-media-export-database.vala"
	g_return_if_fail (self != NULL);
#line 219 "rygel-media-export-database.vala"
	rygel_media_export_database_single_statement (self, "BEGIN", &_inner_error_);
#line 617 "rygel-media-export-database.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Commit a transaction
     */
#line 225 "rygel-media-export-database.vala"
void rygel_media_export_database_commit (RygelMediaExportDatabase* self, GError** error) {
#line 636 "rygel-media-export-database.c"
	GError * _inner_error_ = NULL;
#line 225 "rygel-media-export-database.vala"
	g_return_if_fail (self != NULL);
#line 226 "rygel-media-export-database.vala"
	rygel_media_export_database_single_statement (self, "COMMIT", &_inner_error_);
#line 642 "rygel-media-export-database.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Rollback a transaction
     */
#line 232 "rygel-media-export-database.vala"
void rygel_media_export_database_rollback (RygelMediaExportDatabase* self) {
#line 661 "rygel-media-export-database.c"
	GError * _inner_error_ = NULL;
#line 232 "rygel-media-export-database.vala"
	g_return_if_fail (self != NULL);
#line 665 "rygel-media-export-database.c"
	{
#line 234 "rygel-media-export-database.vala"
		rygel_media_export_database_single_statement (self, "ROLLBACK", &_inner_error_);
#line 669 "rygel-media-export-database.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch2_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally2;
	__catch2_rygel_media_export_database_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 236 "rygel-media-export-database.vala"
			g_critical (_ ("Failed to roll back transaction: %s"), _error_->message);
#line 688 "rygel-media-export-database.c"
			_g_error_free0 (_error_);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
     * Execute a single SQL statement and throw an exception on error
     *
     * @param sql SQL statement to execute
     * @throws DatabaseError if SQL statement fails
     */
#line 247 "rygel-media-export-database.vala"
static void rygel_media_export_database_single_statement (RygelMediaExportDatabase* self, const char* sql, GError** error) {
#line 709 "rygel-media-export-database.c"
	GError * _inner_error_ = NULL;
#line 247 "rygel-media-export-database.vala"
	g_return_if_fail (self != NULL);
#line 247 "rygel-media-export-database.vala"
	g_return_if_fail (sql != NULL);
#line 248 "rygel-media-export-database.vala"
	if (_sqlite3_exec (self->priv->db, sql, NULL, NULL, NULL) != SQLITE_OK) {
#line 717 "rygel-media-export-database.c"
		_inner_error_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_DATABASE_ERROR, RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR, sqlite3_errmsg (self->priv->db));
		{
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


/**
     * Prepare a SQLite statement from a SQL string
     *
     * This function uses the type of the GValue passed in values to determine
     * which _bind function to use.
     *
     * Supported types are: int, long, int64, string and pointer.
     * @note the only pointer supported is the null pointer as provided by
     * Database.@null. This is a special value to bind a column to NULL
     *
     * @param sql statement to execute
     * @param values array of values to bind to the SQL statement or null if
     * none
     */
#line 267 "rygel-media-export-database.vala"
static sqlite3_stmt* rygel_media_export_database_prepare_statement (RygelMediaExportDatabase* self, const char* sql, GValue* values, int values_length1, GError** error) {
#line 749 "rygel-media-export-database.c"
	sqlite3_stmt* result = NULL;
	sqlite3_stmt* statement;
	sqlite3_stmt* _tmp0_ = NULL;
	gint _tmp1_;
	sqlite3_stmt* _tmp2_;
	gint rc;
	GError * _inner_error_ = NULL;
#line 267 "rygel-media-export-database.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 267 "rygel-media-export-database.vala"
	g_return_val_if_fail (sql != NULL, NULL);
#line 761 "rygel-media-export-database.c"
	statement = NULL;
#line 271 "rygel-media-export-database.vala"
	rc = (_tmp1_ = sqlite3_prepare_v2 (self->priv->db, sql, -1, &_tmp0_, NULL), statement = (_tmp2_ = _tmp0_, _sqlite3_finalize0 (statement), _tmp2_), _tmp1_);
#line 272 "rygel-media-export-database.vala"
	if (rc != SQLITE_OK) {
#line 767 "rygel-media-export-database.c"
		_inner_error_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_DATABASE_ERROR, RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR, sqlite3_errmsg (self->priv->db));
		{
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_sqlite3_finalize0 (statement);
				return NULL;
			} else {
				_sqlite3_finalize0 (statement);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
#line 276 "rygel-media-export-database.vala"
	if (values != NULL) {
#line 784 "rygel-media-export-database.c"
		{
			gint i;
#line 277 "rygel-media-export-database.vala"
			i = 0;
#line 789 "rygel-media-export-database.c"
			{
				gboolean _tmp3_;
#line 277 "rygel-media-export-database.vala"
				_tmp3_ = TRUE;
#line 277 "rygel-media-export-database.vala"
				while (TRUE) {
#line 796 "rygel-media-export-database.c"
					GValue _tmp4_;
#line 277 "rygel-media-export-database.vala"
					if (!_tmp3_) {
#line 277 "rygel-media-export-database.vala"
						i++;
#line 802 "rygel-media-export-database.c"
					}
#line 277 "rygel-media-export-database.vala"
					_tmp3_ = FALSE;
#line 277 "rygel-media-export-database.vala"
					if (!(i < values_length1)) {
#line 277 "rygel-media-export-database.vala"
						break;
#line 810 "rygel-media-export-database.c"
					}
#line 278 "rygel-media-export-database.vala"
					if (G_VALUE_HOLDS ((_tmp4_ = values[i], &_tmp4_), G_TYPE_INT)) {
#line 814 "rygel-media-export-database.c"
						GValue _tmp5_;
#line 279 "rygel-media-export-database.vala"
						rc = sqlite3_bind_int (statement, i + 1, g_value_get_int ((_tmp5_ = values[i], &_tmp5_)));
#line 818 "rygel-media-export-database.c"
					} else {
						GValue _tmp6_;
#line 280 "rygel-media-export-database.vala"
						if (G_VALUE_HOLDS ((_tmp6_ = values[i], &_tmp6_), G_TYPE_INT64)) {
#line 823 "rygel-media-export-database.c"
							GValue _tmp7_;
#line 281 "rygel-media-export-database.vala"
							rc = sqlite3_bind_int64 (statement, i + 1, g_value_get_int64 ((_tmp7_ = values[i], &_tmp7_)));
#line 827 "rygel-media-export-database.c"
						} else {
							GValue _tmp8_;
#line 282 "rygel-media-export-database.vala"
							if (G_VALUE_HOLDS ((_tmp8_ = values[i], &_tmp8_), G_TYPE_LONG)) {
#line 832 "rygel-media-export-database.c"
								GValue _tmp9_;
#line 283 "rygel-media-export-database.vala"
								rc = sqlite3_bind_int64 (statement, i + 1, (gint64) g_value_get_long ((_tmp9_ = values[i], &_tmp9_)));
#line 836 "rygel-media-export-database.c"
							} else {
								GValue _tmp10_;
#line 284 "rygel-media-export-database.vala"
								if (G_VALUE_HOLDS ((_tmp10_ = values[i], &_tmp10_), G_TYPE_STRING)) {
#line 841 "rygel-media-export-database.c"
									GValue _tmp11_;
#line 285 "rygel-media-export-database.vala"
									rc = sqlite3_bind_text (statement, i + 1, g_strdup (g_value_get_string ((_tmp11_ = values[i], &_tmp11_))), -1, g_free);
#line 845 "rygel-media-export-database.c"
								} else {
									GValue _tmp12_;
#line 286 "rygel-media-export-database.vala"
									if (G_VALUE_HOLDS ((_tmp12_ = values[i], &_tmp12_), G_TYPE_POINTER)) {
#line 850 "rygel-media-export-database.c"
										GValue _tmp13_;
#line 287 "rygel-media-export-database.vala"
										if (g_value_peek_pointer ((_tmp13_ = values[i], &_tmp13_)) == NULL) {
#line 288 "rygel-media-export-database.vala"
											rc = sqlite3_bind_null (statement, i + 1);
#line 856 "rygel-media-export-database.c"
										} else {
#line 290 "rygel-media-export-database.vala"
											g_assert_not_reached ();
#line 860 "rygel-media-export-database.c"
										}
									} else {
										GValue _tmp14_;
										GType t;
#line 293 "rygel-media-export-database.vala"
										t = G_VALUE_TYPE ((_tmp14_ = values[i], &_tmp14_));
#line 294 "rygel-media-export-database.vala"
										g_warning (_ ("Unsupported type %s"), g_type_name (t));
#line 295 "rygel-media-export-database.vala"
										g_assert_not_reached ();
#line 871 "rygel-media-export-database.c"
									}
								}
							}
						}
					}
#line 297 "rygel-media-export-database.vala"
					if (rc != SQLITE_OK) {
#line 879 "rygel-media-export-database.c"
						_inner_error_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_DATABASE_ERROR, RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR, sqlite3_errmsg (self->priv->db));
						{
							if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
								g_propagate_error (error, _inner_error_);
								_sqlite3_finalize0 (statement);
								return NULL;
							} else {
								_sqlite3_finalize0 (statement);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
					}
				}
			}
		}
	}
	result = statement;
#line 303 "rygel-media-export-database.vala"
	return result;
#line 901 "rygel-media-export-database.c"
}


static void rygel_media_export_database_class_init (RygelMediaExportDatabaseClass * klass) {
	rygel_media_export_database_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportDatabasePrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_database_finalize;
}


static void rygel_media_export_database_instance_init (RygelMediaExportDatabase * self) {
	self->priv = RYGEL_MEDIA_EXPORT_DATABASE_GET_PRIVATE (self);
}


static void rygel_media_export_database_finalize (GObject* obj) {
	RygelMediaExportDatabase * self;
	self = RYGEL_MEDIA_EXPORT_DATABASE (obj);
	_sqlite3_close0 (self->priv->db);
	G_OBJECT_CLASS (rygel_media_export_database_parent_class)->finalize (obj);
}


/**
 * This class is a thin wrapper around SQLite's database object.
 *
 * It adds statement preparation based on GValue and a cancellable exec
 * function.
 */
GType rygel_media_export_database_get_type (void) {
	static volatile gsize rygel_media_export_database_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_database_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportDatabase), 0, (GInstanceInitFunc) rygel_media_export_database_instance_init, NULL };
		GType rygel_media_export_database_type_id;
		rygel_media_export_database_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportDatabase", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_database_type_id__volatile, rygel_media_export_database_type_id);
	}
	return rygel_media_export_database_type_id__volatile;
}




