/* rygel-http-request_http-post.c generated by valac 0.9.6, the Vala compiler
 * generated from rygel-http-request_http-post.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2006, 2007, 2008 OpenedHand Ltd.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jorn Baayen <jorn.baayen@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _rygel_media_object_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_object_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelHttpRequestRunData RygelHttpRequestRunData;
typedef struct _RygelHTTPItemURIPrivate RygelHTTPItemURIPrivate;
typedef struct _RygelHttpRequestFindItemData RygelHttpRequestFindItemData;

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaItem* item;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPRequestPrivate {
	RygelMediaContainer* root_container;
	GCancellable* _cancellable;
};

struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};

struct _RygelHttpRequestRunData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPRequest* self;
	RygelHTTPItemURI* _tmp0_;
	RygelHTTPItemURI* _tmp1_;
	GError * _error_;
	GError * _inner_error_;
};

struct _RygelHTTPItemURI {
	GObject parent_instance;
	RygelHTTPItemURIPrivate * priv;
	char* item_id;
	gint thumbnail_index;
	gint subtitle_index;
	char* transcode_target;
	RygelHTTPServer* http_server;
};

struct _RygelHTTPItemURIClass {
	GObjectClass parent_class;
};

struct _RygelHttpRequestFindItemData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPRequest* self;
	RygelMediaObject* media_object;
	gboolean _tmp0_;
	RygelMediaItem* _tmp1_;
	GError * _inner_error_;
};


static gpointer rygel_http_request_parent_class = NULL;
static RygelStateMachineIface* rygel_http_request_rygel_state_machine_parent_iface = NULL;

GQuark rygel_http_request_error_quark (void);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
gpointer rygel_media_object_ref (gpointer instance);
void rygel_media_object_unref (gpointer instance);
GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_media_object (GValue* value, gpointer v_object);
void rygel_value_take_media_object (GValue* value, gpointer v_object);
gpointer rygel_value_get_media_object (const GValue* value);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_REQUEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestPrivate))
enum  {
	RYGEL_HTTP_REQUEST_DUMMY_PROPERTY,
	RYGEL_HTTP_REQUEST_CANCELLABLE
};
RygelHTTPRequest* rygel_http_request_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void rygel_http_request_real_run_data_free (gpointer _data);
static void rygel_http_request_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_request_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_http_request_real_run_co (RygelHttpRequestRunData* data);
RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const char* uri, RygelHTTPServer* http_server, GError** error);
RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const char* uri, RygelHTTPServer* http_server, GError** error);
void rygel_http_request_find_item (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_http_request_find_item_finish (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
void rygel_http_request_handle (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_http_request_handle_finish (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
void rygel_http_request_handle_error (RygelHTTPRequest* self, GError* _error_);
static void rygel_http_request_real_find_item_data_free (gpointer _data);
static void rygel_http_request_real_find_item (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_request_find_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_http_request_real_find_item_co (RygelHttpRequestFindItemData* data);
void rygel_media_container_find_object (RygelMediaContainer* self, const char* item_id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
void rygel_http_request_end (RygelHTTPRequest* self, guint status);
static void rygel_http_request_finalize (GObject* obj);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_http_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_http_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



GQuark rygel_http_request_error_quark (void) {
	return g_quark_from_static_string ("rygel_http_request_error-quark");
}


static gpointer _rygel_media_object_ref0 (gpointer self) {
	return self ? rygel_media_object_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 46 "rygel-http-request_http-post.vala"
RygelHTTPRequest* rygel_http_request_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
#line 267 "rygel-http-request_http-post.c"
	RygelHTTPRequest * self;
	GCancellable* _tmp0_;
	RygelMediaContainer* _tmp1_;
	SoupServer* _tmp2_;
	SoupMessage* _tmp3_;
#line 46 "rygel-http-request_http-post.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 46 "rygel-http-request_http-post.vala"
	g_return_val_if_fail (server != NULL, NULL);
#line 46 "rygel-http-request_http-post.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 46 "rygel-http-request_http-post.vala"
	self = (RygelHTTPRequest*) g_object_new (object_type, NULL);
#line 49 "rygel-http-request_http-post.vala"
	self->http_server = http_server;
#line 50 "rygel-http-request_http-post.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp0_ = g_cancellable_new ());
#line 285 "rygel-http-request_http-post.c"
	_g_object_unref0 (_tmp0_);
#line 51 "rygel-http-request_http-post.vala"
	self->priv->root_container = (_tmp1_ = _rygel_media_object_ref0 (http_server->root_container), _rygel_media_object_unref0 (self->priv->root_container), _tmp1_);
#line 52 "rygel-http-request_http-post.vala"
	self->server = (_tmp2_ = _g_object_ref0 (server), _g_object_unref0 (self->server), _tmp2_);
#line 53 "rygel-http-request_http-post.vala"
	self->msg = (_tmp3_ = _g_object_ref0 (msg), _g_object_unref0 (self->msg), _tmp3_);
#line 293 "rygel-http-request_http-post.c"
	return self;
}


static void rygel_http_request_real_run_data_free (gpointer _data) {
	RygelHttpRequestRunData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (RygelHttpRequestRunData, data);
}


static void rygel_http_request_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPRequest * self;
	RygelHttpRequestRunData* _data_;
	self = (RygelHTTPRequest*) base;
	_data_ = g_slice_new0 (RygelHttpRequestRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_request_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_request_real_run_data_free);
	_data_->self = g_object_ref (self);
	rygel_http_request_real_run_co (_data_);
}


static void rygel_http_request_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpRequestRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_request_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpRequestRunData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_http_request_real_run_co (data);
}


static gboolean rygel_http_request_real_run_co (RygelHttpRequestRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 11:
		goto _state_11;
		case 12:
		goto _state_12;
	}
	_state_0:
#line 57 "rygel-http-request_http-post.vala"
	soup_server_pause_message (data->self->server, data->self->msg);
#line 346 "rygel-http-request_http-post.c"
	{
		data->_tmp0_ = rygel_http_item_uri_new_from_string (soup_message_get_uri (data->self->msg)->path, data->self->http_server, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
#line 60 "rygel-http-request_http-post.vala"
		data->self->uri = (data->_tmp1_ = data->_tmp0_, _g_object_unref0 (data->self->uri), data->_tmp1_);
#line 354 "rygel-http-request_http-post.c"
		data->_state_ = 11;
		rygel_http_request_find_item (data->self, rygel_http_request_run_ready, data);
		return FALSE;
		_state_11:
#line 63 "rygel-http-request_http-post.vala"
		rygel_http_request_find_item_finish (data->self, data->_res_, &data->_inner_error_);
#line 361 "rygel-http-request_http-post.c"
		if (data->_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		data->_state_ = 12;
		rygel_http_request_handle (data->self, rygel_http_request_run_ready, data);
		return FALSE;
		_state_12:
#line 65 "rygel-http-request_http-post.vala"
		rygel_http_request_handle_finish (data->self, data->_res_, &data->_inner_error_);
#line 371 "rygel-http-request_http-post.c"
		if (data->_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		data->_error_ = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
#line 67 "rygel-http-request_http-post.vala"
			rygel_http_request_handle_error (data->self, data->_error_);
#line 384 "rygel-http-request_http-post.c"
			_g_error_free0 (data->_error_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_error_free0 (data->_error_);
		}
	}
	__finally7:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 46 "rygel-http-request_http-post.vala"
void rygel_http_request_handle (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 46 "rygel-http-request_http-post.vala"
	RYGEL_HTTP_REQUEST_GET_CLASS (self)->handle (self, _callback_, _user_data_);
#line 420 "rygel-http-request_http-post.c"
}


#line 46 "rygel-http-request_http-post.vala"
void rygel_http_request_handle_finish (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error) {
#line 46 "rygel-http-request_http-post.vala"
	RYGEL_HTTP_REQUEST_GET_CLASS (self)->handle_finish (self, _res_, error);
#line 428 "rygel-http-request_http-post.c"
}


static void rygel_http_request_real_find_item_data_free (gpointer _data) {
	RygelHttpRequestFindItemData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (RygelHttpRequestFindItemData, data);
}


static void rygel_http_request_real_find_item (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpRequestFindItemData* _data_;
	_data_ = g_slice_new0 (RygelHttpRequestFindItemData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_request_real_find_item);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_request_real_find_item_data_free);
	_data_->self = g_object_ref (self);
	rygel_http_request_real_find_item_co (_data_);
}


static void rygel_http_request_real_find_item_finish (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error) {
	RygelHttpRequestFindItemData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_request_find_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpRequestFindItemData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_http_request_real_find_item_co (data);
}


static gboolean rygel_http_request_real_find_item_co (RygelHttpRequestFindItemData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 13:
		goto _state_13;
	}
	_state_0:
	data->_state_ = 13;
	rygel_media_container_find_object (data->self->priv->root_container, data->self->uri->item_id, NULL, rygel_http_request_find_item_ready, data);
	return FALSE;
	_state_13:
	data->media_object = rygel_media_container_find_object_finish (data->self->priv->root_container, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
#line 81 "rygel-http-request_http-post.vala"
	if (data->media_object == NULL) {
#line 81 "rygel-http-request_http-post.vala"
		data->_tmp0_ = TRUE;
#line 499 "rygel-http-request_http-post.c"
	} else {
#line 81 "rygel-http-request_http-post.vala"
		data->_tmp0_ = !RYGEL_IS_MEDIA_ITEM (data->media_object);
#line 503 "rygel-http-request_http-post.c"
	}
#line 81 "rygel-http-request_http-post.vala"
	if (data->_tmp0_) {
#line 507 "rygel-http-request_http-post.c"
		data->_inner_error_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _ ("Requested item '%s' not found"), data->self->uri->item_id);
		{
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_rygel_media_object_unref0 (data->media_object);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
	}
#line 87 "rygel-http-request_http-post.vala"
	data->self->item = (data->_tmp1_ = _rygel_media_object_ref0 (RYGEL_MEDIA_ITEM (data->media_object)), _rygel_media_object_unref0 (data->self->item), data->_tmp1_);
#line 526 "rygel-http-request_http-post.c"
	_rygel_media_object_unref0 (data->media_object);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 46 "rygel-http-request_http-post.vala"
void rygel_http_request_find_item (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 46 "rygel-http-request_http-post.vala"
	RYGEL_HTTP_REQUEST_GET_CLASS (self)->find_item (self, _callback_, _user_data_);
#line 544 "rygel-http-request_http-post.c"
}


#line 46 "rygel-http-request_http-post.vala"
void rygel_http_request_find_item_finish (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error) {
#line 46 "rygel-http-request_http-post.vala"
	RYGEL_HTTP_REQUEST_GET_CLASS (self)->find_item_finish (self, _res_, error);
#line 552 "rygel-http-request_http-post.c"
}


#line 90 "rygel-http-request_http-post.vala"
void rygel_http_request_handle_error (RygelHTTPRequest* self, GError* _error_) {
#line 558 "rygel-http-request_http-post.c"
	guint status = 0U;
#line 90 "rygel-http-request_http-post.vala"
	g_return_if_fail (self != NULL);
#line 91 "rygel-http-request_http-post.vala"
	g_warning ("rygel-http-request_http-post.vala:91: %s", _error_->message);
#line 92 "rygel-http-request_http-post.vala"
	soup_server_unpause_message (self->server, self->msg);
#line 95 "rygel-http-request_http-post.vala"
	if (_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 96 "rygel-http-request_http-post.vala"
		status = (guint) _error_->code;
#line 570 "rygel-http-request_http-post.c"
	} else {
#line 98 "rygel-http-request_http-post.vala"
		status = (guint) SOUP_STATUS_NOT_FOUND;
#line 574 "rygel-http-request_http-post.c"
	}
#line 101 "rygel-http-request_http-post.vala"
	rygel_http_request_end (self, status);
#line 578 "rygel-http-request_http-post.c"
}


#line 104 "rygel-http-request_http-post.vala"
void rygel_http_request_end (RygelHTTPRequest* self, guint status) {
#line 104 "rygel-http-request_http-post.vala"
	g_return_if_fail (self != NULL);
#line 105 "rygel-http-request_http-post.vala"
	if (status != SOUP_STATUS_NONE) {
#line 106 "rygel-http-request_http-post.vala"
		soup_message_set_status (self->msg, status);
#line 590 "rygel-http-request_http-post.c"
	}
#line 109 "rygel-http-request_http-post.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 594 "rygel-http-request_http-post.c"
}


static GCancellable* rygel_http_request_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPRequest* self;
	self = (RygelHTTPRequest*) base;
	result = self->priv->_cancellable;
#line 41 "rygel-http-request_http-post.vala"
	return result;
#line 605 "rygel-http-request_http-post.c"
}


static void rygel_http_request_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPRequest* self;
	GCancellable* _tmp0_;
	self = (RygelHTTPRequest*) base;
	self->priv->_cancellable = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_cancellable), _tmp0_);
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_http_request_class_init (RygelHTTPRequestClass * klass) {
	rygel_http_request_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPRequestPrivate));
	RYGEL_HTTP_REQUEST_CLASS (klass)->find_item = rygel_http_request_real_find_item;
	RYGEL_HTTP_REQUEST_CLASS (klass)->find_item_finish = rygel_http_request_real_find_item_finish;
	G_OBJECT_CLASS (klass)->get_property = rygel_http_request_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_http_request_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_request_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_REQUEST_CANCELLABLE, "cancellable");
}


static void rygel_http_request_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_http_request_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = rygel_http_request_real_run;
	iface->run_finish = rygel_http_request_real_run_finish;
	iface->get_cancellable = rygel_http_request_real_get_cancellable;
	iface->set_cancellable = rygel_http_request_real_set_cancellable;
}


static void rygel_http_request_instance_init (RygelHTTPRequest * self) {
	self->priv = RYGEL_HTTP_REQUEST_GET_PRIVATE (self);
}


static void rygel_http_request_finalize (GObject* obj) {
	RygelHTTPRequest * self;
	self = RYGEL_HTTP_REQUEST (obj);
	_rygel_media_object_unref0 (self->priv->root_container);
	_g_object_unref0 (self->server);
	_g_object_unref0 (self->msg);
	_g_object_unref0 (self->priv->_cancellable);
	_g_object_unref0 (self->uri);
	_rygel_media_object_unref0 (self->item);
	G_OBJECT_CLASS (rygel_http_request_parent_class)->finalize (obj);
}


/**
 * Base class for HTTP client requests.
 */
GType rygel_http_request_get_type (void) {
	static volatile gsize rygel_http_request_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_request_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPRequest), 0, (GInstanceInitFunc) rygel_http_request_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_request_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_request_type_id;
		rygel_http_request_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPRequest", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (rygel_http_request_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_request_type_id__volatile, rygel_http_request_type_id);
	}
	return rygel_http_request_type_id__volatile;
}


static void rygel_http_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPRequest * self;
	self = RYGEL_HTTP_REQUEST (object);
	switch (property_id) {
		case RYGEL_HTTP_REQUEST_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_http_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPRequest * self;
	self = RYGEL_HTTP_REQUEST (object);
	switch (property_id) {
		case RYGEL_HTTP_REQUEST_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




