/* rygel-seekable-response-test.c generated by valac, the Vala compiler
 * generated from rygel-seekable-response-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>


#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;
typedef struct _RygelHTTPSeekPrivate RygelHTTPSeekPrivate;

#define RYGEL_TYPE_HTTP_RESPONSE_TEST (rygel_http_response_test_get_type ())
#define RYGEL_HTTP_RESPONSE_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_TEST, RygelHTTPResponseTest))
#define RYGEL_HTTP_RESPONSE_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_TEST, RygelHTTPResponseTestClass))
#define RYGEL_IS_HTTP_RESPONSE_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_TEST))
#define RYGEL_IS_HTTP_RESPONSE_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_TEST))
#define RYGEL_HTTP_RESPONSE_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_TEST, RygelHTTPResponseTestClass))

typedef struct _RygelHTTPResponseTest RygelHTTPResponseTest;
typedef struct _RygelHTTPResponseTestClass RygelHTTPResponseTestClass;
typedef struct _RygelHTTPResponseTestPrivate RygelHTTPResponseTestPrivate;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_CLIENT (rygel_http_client_get_type ())
#define RYGEL_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient))
#define RYGEL_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))
#define RYGEL_IS_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_IS_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_HTTP_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))

typedef struct _RygelHTTPClient RygelHTTPClient;
typedef struct _RygelHTTPClientClass RygelHTTPClientClass;

#define RYGEL_TYPE_SEEKABLE_RESPONSE_TEST (rygel_seekable_response_test_get_type ())
#define RYGEL_SEEKABLE_RESPONSE_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEEKABLE_RESPONSE_TEST, RygelSeekableResponseTest))
#define RYGEL_SEEKABLE_RESPONSE_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEEKABLE_RESPONSE_TEST, RygelSeekableResponseTestClass))
#define RYGEL_IS_SEEKABLE_RESPONSE_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEEKABLE_RESPONSE_TEST))
#define RYGEL_IS_SEEKABLE_RESPONSE_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEEKABLE_RESPONSE_TEST))
#define RYGEL_SEEKABLE_RESPONSE_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEEKABLE_RESPONSE_TEST, RygelSeekableResponseTestClass))

typedef struct _RygelSeekableResponseTest RygelSeekableResponseTest;
typedef struct _RygelSeekableResponseTestClass RygelSeekableResponseTestClass;
typedef struct _RygelSeekableResponseTestPrivate RygelSeekableResponseTestPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

#define RYGEL_TYPE_SEEKABLE_RESPONSE (rygel_seekable_response_get_type ())
#define RYGEL_SEEKABLE_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEEKABLE_RESPONSE, RygelSeekableResponse))
#define RYGEL_SEEKABLE_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEEKABLE_RESPONSE, RygelSeekableResponseClass))
#define RYGEL_IS_SEEKABLE_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEEKABLE_RESPONSE))
#define RYGEL_IS_SEEKABLE_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEEKABLE_RESPONSE))
#define RYGEL_SEEKABLE_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEEKABLE_RESPONSE, RygelSeekableResponseClass))

typedef struct _RygelSeekableResponse RygelSeekableResponse;
typedef struct _RygelSeekableResponseClass RygelSeekableResponseClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelHTTPSeek {
	GObject parent_instance;
	RygelHTTPSeekPrivate * priv;
};

struct _RygelHTTPSeekClass {
	GObjectClass parent_class;
};

struct _RygelHTTPSeekPrivate {
	gint64 _start;
	gint64 _stop;
	gint64 _length;
};

struct _RygelHTTPResponseTest {
	GObject parent_instance;
	RygelHTTPResponseTestPrivate * priv;
	RygelHTTPServer* server;
	RygelHTTPClient* client;
	GCancellable* cancellable;
};

struct _RygelHTTPResponseTestClass {
	GObjectClass parent_class;
	void (*run) (RygelHTTPResponseTest* self, GError** error);
	RygelHTTPResponse* (*create_response) (RygelHTTPResponseTest* self, SoupMessage* msg, GError** error);
};

struct _RygelSeekableResponseTest {
	RygelHTTPResponseTest parent_instance;
	RygelSeekableResponseTestPrivate * priv;
};

struct _RygelSeekableResponseTestClass {
	RygelHTTPResponseTestClass parent_class;
};

struct _RygelSeekableResponseTestPrivate {
	GFile* dummy_file;
};

typedef enum  {
	RYGEL_TEST_ERROR_SKIP = 77,
	RYGEL_TEST_ERROR_TIMEOUT
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};


static gpointer rygel_http_seek_parent_class = NULL;
static char* rygel_seekable_response_test_URI;
static char* rygel_seekable_response_test_URI = NULL;
static gpointer rygel_seekable_response_test_parent_class = NULL;

GType rygel_http_seek_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_SEEK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekPrivate))
enum  {
	RYGEL_HTTP_SEEK_DUMMY_PROPERTY,
	RYGEL_HTTP_SEEK_START,
	RYGEL_HTTP_SEEK_STOP,
	RYGEL_HTTP_SEEK_LENGTH
};
static void rygel_http_seek_set_start (RygelHTTPSeek* self, gint64 value);
static void rygel_http_seek_set_stop (RygelHTTPSeek* self, gint64 value);
static void rygel_http_seek_set_length (RygelHTTPSeek* self, gint64 value);
RygelHTTPSeek* rygel_http_seek_new (gint64 start, gint64 stop);
RygelHTTPSeek* rygel_http_seek_construct (GType object_type, gint64 start, gint64 stop);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_length (RygelHTTPSeek* self);
static void rygel_http_seek_finalize (GObject* obj);
static void rygel_http_seek_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_http_seek_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType rygel_http_response_test_get_type (void) G_GNUC_CONST;
GType rygel_http_response_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_client_get_type (void) G_GNUC_CONST;
GType rygel_seekable_response_test_get_type (void) G_GNUC_CONST;
#define RYGEL_SEEKABLE_RESPONSE_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_SEEKABLE_RESPONSE_TEST, RygelSeekableResponseTestPrivate))
enum  {
	RYGEL_SEEKABLE_RESPONSE_TEST_DUMMY_PROPERTY
};
static RygelSeekableResponseTest* rygel_seekable_response_test_new_complete (GError** error);
static RygelSeekableResponseTest* rygel_seekable_response_test_construct_complete (GType object_type, GError** error);
void rygel_http_response_test_run (RygelHTTPResponseTest* self, GError** error);
static RygelSeekableResponseTest* rygel_seekable_response_test_new_abort (GError** error);
static RygelSeekableResponseTest* rygel_seekable_response_test_construct_abort (GType object_type, GError** error);
GQuark rygel_test_error_quark (void);
gint rygel_seekable_response_test_main (char** args, int args_length1);
RygelHTTPResponseTest* rygel_http_response_test_construct (GType object_type, GCancellable* cancellable, GError** error);
static RygelSeekableResponseTest* rygel_seekable_response_test_new (GCancellable* cancellable, GError** error);
static RygelSeekableResponseTest* rygel_seekable_response_test_construct (GType object_type, GCancellable* cancellable, GError** error);
RygelHTTPResponseTest* rygel_http_response_test_construct_complete (GType object_type, GError** error);
RygelHTTPResponseTest* rygel_http_response_test_construct_abort (GType object_type, GError** error);
static void rygel_seekable_response_test_create_dummy_file (RygelSeekableResponseTest* self, GError** error);
static void rygel_seekable_response_test_real_run (RygelHTTPResponseTest* base, GError** error);
RygelSeekableResponse* rygel_seekable_response_new (SoupServer* server, SoupMessage* msg, const char* uri, RygelHTTPSeek* seek, gsize file_length, GCancellable* cancellable);
RygelSeekableResponse* rygel_seekable_response_construct (GType object_type, SoupServer* server, SoupMessage* msg, const char* uri, RygelHTTPSeek* seek, gsize file_length, GCancellable* cancellable);
GType rygel_seekable_response_get_type (void) G_GNUC_CONST;
static RygelHTTPResponse* rygel_seekable_response_test_real_create_response (RygelHTTPResponseTest* base, SoupMessage* msg, GError** error);
static void rygel_seekable_response_test_finalize (GObject* obj);



#line 32 "rygel-seekable-response-test.vala"
RygelHTTPSeek* rygel_http_seek_construct (GType object_type, gint64 start, gint64 stop) {
#line 229 "rygel-seekable-response-test.c"
	RygelHTTPSeek * self;
#line 32 "rygel-seekable-response-test.vala"
	self = (RygelHTTPSeek*) g_object_new (object_type, NULL);
#line 33 "rygel-seekable-response-test.vala"
	rygel_http_seek_set_start (self, start);
#line 34 "rygel-seekable-response-test.vala"
	rygel_http_seek_set_stop (self, stop);
#line 36 "rygel-seekable-response-test.vala"
	rygel_http_seek_set_length (self, (stop - start) + 1);
#line 239 "rygel-seekable-response-test.c"
	return self;
}


#line 32 "rygel-seekable-response-test.vala"
RygelHTTPSeek* rygel_http_seek_new (gint64 start, gint64 stop) {
#line 32 "rygel-seekable-response-test.vala"
	return rygel_http_seek_construct (RYGEL_TYPE_HTTP_SEEK, start, stop);
#line 248 "rygel-seekable-response-test.c"
}


gint64 rygel_http_seek_get_start (RygelHTTPSeek* self) {
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_start;
#line 28 "rygel-seekable-response-test.vala"
	return result;
#line 258 "rygel-seekable-response-test.c"
}


static void rygel_http_seek_set_start (RygelHTTPSeek* self, gint64 value) {
	g_return_if_fail (self != NULL);
	self->priv->_start = value;
	g_object_notify ((GObject *) self, "start");
}


gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self) {
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_stop;
#line 29 "rygel-seekable-response-test.vala"
	return result;
#line 275 "rygel-seekable-response-test.c"
}


static void rygel_http_seek_set_stop (RygelHTTPSeek* self, gint64 value) {
	g_return_if_fail (self != NULL);
	self->priv->_stop = value;
	g_object_notify ((GObject *) self, "stop");
}


gint64 rygel_http_seek_get_length (RygelHTTPSeek* self) {
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_length;
#line 30 "rygel-seekable-response-test.vala"
	return result;
#line 292 "rygel-seekable-response-test.c"
}


static void rygel_http_seek_set_length (RygelHTTPSeek* self, gint64 value) {
	g_return_if_fail (self != NULL);
	self->priv->_length = value;
	g_object_notify ((GObject *) self, "length");
}


static void rygel_http_seek_class_init (RygelHTTPSeekClass * klass) {
	rygel_http_seek_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPSeekPrivate));
	G_OBJECT_CLASS (klass)->get_property = rygel_http_seek_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_http_seek_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_seek_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SEEK_START, g_param_spec_int64 ("start", "start", "start", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SEEK_STOP, g_param_spec_int64 ("stop", "stop", "stop", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SEEK_LENGTH, g_param_spec_int64 ("length", "length", "length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void rygel_http_seek_instance_init (RygelHTTPSeek * self) {
	self->priv = RYGEL_HTTP_SEEK_GET_PRIVATE (self);
}


static void rygel_http_seek_finalize (GObject* obj) {
	RygelHTTPSeek * self;
	self = RYGEL_HTTP_SEEK (obj);
	G_OBJECT_CLASS (rygel_http_seek_parent_class)->finalize (obj);
}


GType rygel_http_seek_get_type (void) {
	static volatile gsize rygel_http_seek_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_seek_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPSeekClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_seek_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPSeek), 0, (GInstanceInitFunc) rygel_http_seek_instance_init, NULL };
		GType rygel_http_seek_type_id;
		rygel_http_seek_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPSeek", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_seek_type_id__volatile, rygel_http_seek_type_id);
	}
	return rygel_http_seek_type_id__volatile;
}


static void rygel_http_seek_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPSeek * self;
	self = RYGEL_HTTP_SEEK (object);
	switch (property_id) {
		case RYGEL_HTTP_SEEK_START:
		g_value_set_int64 (value, rygel_http_seek_get_start (self));
		break;
		case RYGEL_HTTP_SEEK_STOP:
		g_value_set_int64 (value, rygel_http_seek_get_stop (self));
		break;
		case RYGEL_HTTP_SEEK_LENGTH:
		g_value_set_int64 (value, rygel_http_seek_get_length (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_http_seek_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPSeek * self;
	self = RYGEL_HTTP_SEEK (object);
	switch (property_id) {
		case RYGEL_HTTP_SEEK_START:
		rygel_http_seek_set_start (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_SEEK_STOP:
		rygel_http_seek_set_stop (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_SEEK_LENGTH:
		rygel_http_seek_set_length (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


#line 45 "rygel-seekable-response-test.vala"
gint rygel_seekable_response_test_main (char** args, int args_length1) {
#line 381 "rygel-seekable-response-test.c"
	gint result = 0;
	GError * _inner_error_;
	_inner_error_ = NULL;
	{
		RygelSeekableResponseTest* test;
		RygelSeekableResponseTest* _tmp0_;
		RygelSeekableResponseTest* _tmp1_;
#line 47 "rygel-seekable-response-test.vala"
		test = rygel_seekable_response_test_new_complete (&_inner_error_);
#line 391 "rygel-seekable-response-test.c"
		if (_inner_error_ != NULL) {
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
#line 48 "rygel-seekable-response-test.vala"
		rygel_http_response_test_run ((RygelHTTPResponseTest*) test, &_inner_error_);
#line 400 "rygel-seekable-response-test.c"
		if (_inner_error_ != NULL) {
			_g_object_unref0 (test);
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
#line 50 "rygel-seekable-response-test.vala"
		_tmp0_ = rygel_seekable_response_test_new_abort (&_inner_error_);
#line 410 "rygel-seekable-response-test.c"
		if (_inner_error_ != NULL) {
			_g_object_unref0 (test);
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
#line 50 "rygel-seekable-response-test.vala"
		test = (_tmp1_ = _tmp0_, _g_object_unref0 (test), _tmp1_);
#line 51 "rygel-seekable-response-test.vala"
		rygel_http_response_test_run ((RygelHTTPResponseTest*) test, &_inner_error_);
#line 422 "rygel-seekable-response-test.c"
		if (_inner_error_ != NULL) {
			_g_object_unref0 (test);
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
		_g_object_unref0 (test);
	}
	goto __finally0;
	__catch0_rygel_test_error_skip:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			result = _error_->code;
			_g_error_free0 (_error_);
#line 53 "rygel-seekable-response-test.vala"
			return result;
#line 443 "rygel-seekable-response-test.c"
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 55 "rygel-seekable-response-test.vala"
			g_critical ("rygel-seekable-response-test.vala:55: %s", _error_->message);
#line 455 "rygel-seekable-response-test.c"
			result = -1;
			_g_error_free0 (_error_);
#line 57 "rygel-seekable-response-test.vala"
			return result;
#line 460 "rygel-seekable-response-test.c"
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
#line 60 "rygel-seekable-response-test.vala"
	return result;
#line 472 "rygel-seekable-response-test.c"
}


#line 45 "rygel-seekable-response-test.vala"
int main (int argc, char ** argv) {
#line 478 "rygel-seekable-response-test.c"
	g_thread_init (NULL);
#line 45 "rygel-seekable-response-test.vala"
	g_type_init ();
#line 45 "rygel-seekable-response-test.vala"
	return rygel_seekable_response_test_main (argv, argc);
#line 484 "rygel-seekable-response-test.c"
}


#line 63 "rygel-seekable-response-test.vala"
static RygelSeekableResponseTest* rygel_seekable_response_test_construct (GType object_type, GCancellable* cancellable, GError** error) {
#line 490 "rygel-seekable-response-test.c"
	GError * _inner_error_;
	RygelSeekableResponseTest * self;
	_inner_error_ = NULL;
#line 65 "rygel-seekable-response-test.vala"
	self = (RygelSeekableResponseTest*) rygel_http_response_test_construct (object_type, cancellable, &_inner_error_);
#line 496 "rygel-seekable-response-test.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


#line 63 "rygel-seekable-response-test.vala"
static RygelSeekableResponseTest* rygel_seekable_response_test_new (GCancellable* cancellable, GError** error) {
#line 63 "rygel-seekable-response-test.vala"
	return rygel_seekable_response_test_construct (RYGEL_TYPE_SEEKABLE_RESPONSE_TEST, cancellable, error);
#line 510 "rygel-seekable-response-test.c"
}


#line 68 "rygel-seekable-response-test.vala"
static RygelSeekableResponseTest* rygel_seekable_response_test_construct_complete (GType object_type, GError** error) {
#line 516 "rygel-seekable-response-test.c"
	GError * _inner_error_;
	RygelSeekableResponseTest * self;
	_inner_error_ = NULL;
#line 69 "rygel-seekable-response-test.vala"
	self = (RygelSeekableResponseTest*) rygel_http_response_test_construct_complete (object_type, &_inner_error_);
#line 522 "rygel-seekable-response-test.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


#line 68 "rygel-seekable-response-test.vala"
static RygelSeekableResponseTest* rygel_seekable_response_test_new_complete (GError** error) {
#line 68 "rygel-seekable-response-test.vala"
	return rygel_seekable_response_test_construct_complete (RYGEL_TYPE_SEEKABLE_RESPONSE_TEST, error);
#line 536 "rygel-seekable-response-test.c"
}


#line 72 "rygel-seekable-response-test.vala"
static RygelSeekableResponseTest* rygel_seekable_response_test_construct_abort (GType object_type, GError** error) {
#line 542 "rygel-seekable-response-test.c"
	GError * _inner_error_;
	RygelSeekableResponseTest * self;
	_inner_error_ = NULL;
#line 73 "rygel-seekable-response-test.vala"
	self = (RygelSeekableResponseTest*) rygel_http_response_test_construct_abort (object_type, &_inner_error_);
#line 548 "rygel-seekable-response-test.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


#line 72 "rygel-seekable-response-test.vala"
static RygelSeekableResponseTest* rygel_seekable_response_test_new_abort (GError** error) {
#line 72 "rygel-seekable-response-test.vala"
	return rygel_seekable_response_test_construct_abort (RYGEL_TYPE_SEEKABLE_RESPONSE_TEST, error);
#line 562 "rygel-seekable-response-test.c"
}


#line 76 "rygel-seekable-response-test.vala"
static void rygel_seekable_response_test_real_run (RygelHTTPResponseTest* base, GError** error) {
#line 568 "rygel-seekable-response-test.c"
	RygelSeekableResponseTest * self;
	GError * _inner_error_;
	self = (RygelSeekableResponseTest*) base;
	_inner_error_ = NULL;
#line 77 "rygel-seekable-response-test.vala"
	rygel_seekable_response_test_create_dummy_file (self, &_inner_error_);
#line 575 "rygel-seekable-response-test.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
#line 79 "rygel-seekable-response-test.vala"
	RYGEL_HTTP_RESPONSE_TEST_CLASS (rygel_seekable_response_test_parent_class)->run (RYGEL_HTTP_RESPONSE_TEST (self), &_inner_error_);
#line 582 "rygel-seekable-response-test.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
#line 81 "rygel-seekable-response-test.vala"
	g_file_delete (self->priv->dummy_file, NULL, &_inner_error_);
#line 589 "rygel-seekable-response-test.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


#line 84 "rygel-seekable-response-test.vala"
static void rygel_seekable_response_test_create_dummy_file (RygelSeekableResponseTest* self, GError** error) {
#line 599 "rygel-seekable-response-test.c"
	GError * _inner_error_;
	GFile* _tmp0_;
	GFileOutputStream* stream;
	gint _tmp1__length1;
	gchar* _tmp1_;
#line 84 "rygel-seekable-response-test.vala"
	g_return_if_fail (self != NULL);
#line 607 "rygel-seekable-response-test.c"
	_inner_error_ = NULL;
#line 85 "rygel-seekable-response-test.vala"
	self->priv->dummy_file = (_tmp0_ = g_file_new_for_uri (rygel_seekable_response_test_URI), _g_object_unref0 (self->priv->dummy_file), _tmp0_);
#line 86 "rygel-seekable-response-test.vala"
	stream = g_file_replace (self->priv->dummy_file, NULL, FALSE, 0, NULL, &_inner_error_);
#line 613 "rygel-seekable-response-test.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
#line 89 "rygel-seekable-response-test.vala"
	g_output_stream_write ((GOutputStream*) stream, (_tmp1_ = g_new0 (gchar, 1024), _tmp1__length1 = 1024, _tmp1_), (gsize) 1024, NULL, &_inner_error_);
#line 620 "rygel-seekable-response-test.c"
	_tmp1_ = (g_free (_tmp1_), NULL);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (stream);
		return;
	}
	_g_object_unref0 (stream);
}


#line 92 "rygel-seekable-response-test.vala"
static RygelHTTPResponse* rygel_seekable_response_test_real_create_response (RygelHTTPResponseTest* base, SoupMessage* msg, GError** error) {
#line 633 "rygel-seekable-response-test.c"
	RygelSeekableResponseTest * self;
	RygelHTTPResponse* result = NULL;
	RygelHTTPSeek* seek;
	char* _tmp0_;
	RygelHTTPResponse* _tmp1_;
	self = (RygelSeekableResponseTest*) base;
#line 92 "rygel-seekable-response-test.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 94 "rygel-seekable-response-test.vala"
	seek = rygel_http_seek_new ((gint64) 0, (gint64) 1025);
#line 644 "rygel-seekable-response-test.c"
	result = (_tmp1_ = (RygelHTTPResponse*) rygel_seekable_response_new (gupnp_context_get_server (((RygelHTTPResponseTest*) self)->server->context), msg, _tmp0_ = g_file_get_uri (self->priv->dummy_file), seek, (gsize) 1024, ((RygelHTTPResponseTest*) self)->cancellable), _g_free0 (_tmp0_), _tmp1_);
	_g_object_unref0 (seek);
#line 96 "rygel-seekable-response-test.vala"
	return result;
#line 649 "rygel-seekable-response-test.c"
	_g_object_unref0 (seek);
}


static void rygel_seekable_response_test_class_init (RygelSeekableResponseTestClass * klass) {
	rygel_seekable_response_test_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelSeekableResponseTestPrivate));
	RYGEL_HTTP_RESPONSE_TEST_CLASS (klass)->run = rygel_seekable_response_test_real_run;
	RYGEL_HTTP_RESPONSE_TEST_CLASS (klass)->create_response = rygel_seekable_response_test_real_create_response;
	G_OBJECT_CLASS (klass)->finalize = rygel_seekable_response_test_finalize;
	rygel_seekable_response_test_URI = g_strdup ("file:///tmp/rygel-dummy-test-file");
}


static void rygel_seekable_response_test_instance_init (RygelSeekableResponseTest * self) {
	self->priv = RYGEL_SEEKABLE_RESPONSE_TEST_GET_PRIVATE (self);
}


static void rygel_seekable_response_test_finalize (GObject* obj) {
	RygelSeekableResponseTest * self;
	self = RYGEL_SEEKABLE_RESPONSE_TEST (obj);
	_g_object_unref0 (self->priv->dummy_file);
	G_OBJECT_CLASS (rygel_seekable_response_test_parent_class)->finalize (obj);
}


GType rygel_seekable_response_test_get_type (void) {
	static volatile gsize rygel_seekable_response_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_seekable_response_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSeekableResponseTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_seekable_response_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSeekableResponseTest), 0, (GInstanceInitFunc) rygel_seekable_response_test_instance_init, NULL };
		GType rygel_seekable_response_test_type_id;
		rygel_seekable_response_test_type_id = g_type_register_static (RYGEL_TYPE_HTTP_RESPONSE_TEST, "RygelSeekableResponseTest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_seekable_response_test_type_id__volatile, rygel_seekable_response_test_type_id);
	}
	return rygel_seekable_response_test_type_id__volatile;
}




