/* rygel-search-criteria-parser.c generated by valac, the Vala compiler
 * generated from rygel-search-criteria-parser.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define RYGEL_TYPE_SEARCH_CRITERIA_SYMBOL (rygel_search_criteria_symbol_get_type ())

#define RYGEL_TYPE_SEARCH_CRITERIA_TOKEN (rygel_search_criteria_token_get_type ())
typedef struct _RygelSearchCriteriaToken RygelSearchCriteriaToken;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_SEARCH_CRITERIA_PARSER (rygel_search_criteria_parser_get_type ())
#define RYGEL_SEARCH_CRITERIA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParser))
#define RYGEL_SEARCH_CRITERIA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserClass))
#define RYGEL_IS_SEARCH_CRITERIA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER))
#define RYGEL_IS_SEARCH_CRITERIA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_CRITERIA_PARSER))
#define RYGEL_SEARCH_CRITERIA_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserClass))

typedef struct _RygelSearchCriteriaParser RygelSearchCriteriaParser;
typedef struct _RygelSearchCriteriaParserClass RygelSearchCriteriaParserClass;
typedef struct _RygelSearchCriteriaParserPrivate RygelSearchCriteriaParserPrivate;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_scanner_destroy0(var) ((var == NULL) ? NULL : (var = (g_scanner_destroy (var), NULL)))
typedef struct _RygelSearchCriteriaParserRunData RygelSearchCriteriaParserRunData;

#define RYGEL_TYPE_LOGICAL_EXPRESSION (rygel_logical_expression_get_type ())
#define RYGEL_LOGICAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpression))
#define RYGEL_LOGICAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpressionClass))
#define RYGEL_IS_LOGICAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION))
#define RYGEL_IS_LOGICAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LOGICAL_EXPRESSION))
#define RYGEL_LOGICAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpressionClass))

typedef struct _RygelLogicalExpression RygelLogicalExpression;
typedef struct _RygelLogicalExpressionClass RygelLogicalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_LOGICAL_OPERATOR (rygel_logical_operator_get_type ())

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;

typedef enum  {
	RYGEL_SEARCH_CRITERIA_ERROR_SYNTAX_ERROR
} RygelSearchCriteriaError;
#define RYGEL_SEARCH_CRITERIA_ERROR rygel_search_criteria_error_quark ()
typedef enum  {
	RYGEL_SEARCH_CRITERIA_SYMBOL_EQ = GUPNP_SEARCH_CRITERIA_OP_EQ,
	RYGEL_SEARCH_CRITERIA_SYMBOL_NEQ,
	RYGEL_SEARCH_CRITERIA_SYMBOL_LESS,
	RYGEL_SEARCH_CRITERIA_SYMBOL_LEQ,
	RYGEL_SEARCH_CRITERIA_SYMBOL_GREATER,
	RYGEL_SEARCH_CRITERIA_SYMBOL_GEQ,
	RYGEL_SEARCH_CRITERIA_SYMBOL_CONTAINS,
	RYGEL_SEARCH_CRITERIA_SYMBOL_DOES_NOT_CONTAIN,
	RYGEL_SEARCH_CRITERIA_SYMBOL_DERIVED_FROM,
	RYGEL_SEARCH_CRITERIA_SYMBOL_EXISTS,
	RYGEL_SEARCH_CRITERIA_SYMBOL_ASTERISK,
	RYGEL_SEARCH_CRITERIA_SYMBOL_AND,
	RYGEL_SEARCH_CRITERIA_SYMBOL_OR,
	RYGEL_SEARCH_CRITERIA_SYMBOL_TRUE,
	RYGEL_SEARCH_CRITERIA_SYMBOL_FALSE
} RygelSearchCriteriaSymbol;

struct _RygelSearchCriteriaToken {
	char* str_symbol;
	RygelSearchCriteriaSymbol symbol;
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelSearchCriteriaParser {
	GObject parent_instance;
	RygelSearchCriteriaParserPrivate * priv;
	char* str;
	RygelSearchExpression* expression;
	GError* err;
};

struct _RygelSearchCriteriaParserClass {
	GObjectClass parent_class;
};

struct _RygelSearchCriteriaParserPrivate {
	GCancellable* _cancellable;
	GScanner* scanner;
};

struct _RygelSearchCriteriaParserRunData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchCriteriaParser* self;
	RygelSearchExpression* _tmp0_;
	RygelSearchExpression* _tmp1_;
	GError* _tmp2_;
	GError * err;
	GError * _inner_error_;
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	char* (*to_string) (RygelSearchExpression* self);
};

typedef enum  {
	RYGEL_LOGICAL_OPERATOR_AND,
	RYGEL_LOGICAL_OPERATOR_OR
} RygelLogicalOperator;


static gpointer rygel_search_criteria_parser_parent_class = NULL;
static RygelStateMachineIface* rygel_search_criteria_parser_rygel_state_machine_parent_iface = NULL;

GQuark rygel_search_criteria_error_quark (void);
GType rygel_search_criteria_symbol_get_type (void) G_GNUC_CONST;
GType rygel_search_criteria_token_get_type (void) G_GNUC_CONST;
RygelSearchCriteriaToken* rygel_search_criteria_token_dup (const RygelSearchCriteriaToken* self);
void rygel_search_criteria_token_free (RygelSearchCriteriaToken* self);
void rygel_search_criteria_token_copy (const RygelSearchCriteriaToken* self, RygelSearchCriteriaToken* dest);
void rygel_search_criteria_token_destroy (RygelSearchCriteriaToken* self);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_search_criteria_parser_get_type (void) G_GNUC_CONST;
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
#define RYGEL_SEARCH_CRITERIA_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserPrivate))
enum  {
	RYGEL_SEARCH_CRITERIA_PARSER_DUMMY_PROPERTY,
	RYGEL_SEARCH_CRITERIA_PARSER_CANCELLABLE
};
RygelSearchCriteriaParser* rygel_search_criteria_parser_new (const char* str, GError** error);
RygelSearchCriteriaParser* rygel_search_criteria_parser_construct (GType object_type, const char* str, GError** error);
static void rygel_search_criteria_parser_real_run_data_free (gpointer _data);
static void rygel_search_criteria_parser_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_search_criteria_parser_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static RygelSearchExpression* rygel_search_criteria_parser_parse_or_expression (RygelSearchCriteriaParser* self, GError** error);
static gboolean rygel_search_criteria_parser_real_run_co (RygelSearchCriteriaParserRunData* data);
static RygelSearchExpression* rygel_search_criteria_parser_parse_rel_expression (RygelSearchCriteriaParser* self, GError** error);
static RygelSearchCriteriaSymbol rygel_search_criteria_parser_get_token (RygelSearchCriteriaParser* self);
RygelLogicalExpression* rygel_logical_expression_new (void);
RygelLogicalExpression* rygel_logical_expression_construct (GType object_type);
GType rygel_logical_expression_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_logical_operator_get_type (void) G_GNUC_CONST;
static RygelSearchExpression* rygel_search_criteria_parser_parse_and_expression (RygelSearchCriteriaParser* self, GError** error);
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
static char* rygel_search_criteria_parser_get_context (RygelSearchCriteriaParser* self);
static void rygel_search_criteria_parser_finalize (GObject* obj);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_search_criteria_parser_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void rygel_search_criteria_parser_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const RygelSearchCriteriaToken RYGEL_SEARCH_CRITERIA_PARSER_tokens[15] = {{"=", RYGEL_SEARCH_CRITERIA_SYMBOL_EQ}, {"!=", RYGEL_SEARCH_CRITERIA_SYMBOL_NEQ}, {"<", RYGEL_SEARCH_CRITERIA_SYMBOL_LESS}, {"<=", RYGEL_SEARCH_CRITERIA_SYMBOL_LEQ}, {">", RYGEL_SEARCH_CRITERIA_SYMBOL_GREATER}, {">=", RYGEL_SEARCH_CRITERIA_SYMBOL_GEQ}, {"contains", RYGEL_SEARCH_CRITERIA_SYMBOL_CONTAINS}, {"doesNotContain", RYGEL_SEARCH_CRITERIA_SYMBOL_DOES_NOT_CONTAIN}, {"derivedfrom", RYGEL_SEARCH_CRITERIA_SYMBOL_DERIVED_FROM}, {"exists", RYGEL_SEARCH_CRITERIA_SYMBOL_EXISTS}, {"*", RYGEL_SEARCH_CRITERIA_SYMBOL_ASTERISK}, {"and", RYGEL_SEARCH_CRITERIA_SYMBOL_AND}, {"or", RYGEL_SEARCH_CRITERIA_SYMBOL_OR}, {"true", RYGEL_SEARCH_CRITERIA_SYMBOL_TRUE}, {"false", RYGEL_SEARCH_CRITERIA_SYMBOL_FALSE}};


GQuark rygel_search_criteria_error_quark (void) {
	return g_quark_from_static_string ("rygel_search_criteria_error-quark");
}


GType rygel_search_criteria_symbol_get_type (void) {
	static volatile gsize rygel_search_criteria_symbol_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_search_criteria_symbol_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_SEARCH_CRITERIA_SYMBOL_EQ, "RYGEL_SEARCH_CRITERIA_SYMBOL_EQ", "eq"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_NEQ, "RYGEL_SEARCH_CRITERIA_SYMBOL_NEQ", "neq"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_LESS, "RYGEL_SEARCH_CRITERIA_SYMBOL_LESS", "less"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_LEQ, "RYGEL_SEARCH_CRITERIA_SYMBOL_LEQ", "leq"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_GREATER, "RYGEL_SEARCH_CRITERIA_SYMBOL_GREATER", "greater"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_GEQ, "RYGEL_SEARCH_CRITERIA_SYMBOL_GEQ", "geq"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_CONTAINS, "RYGEL_SEARCH_CRITERIA_SYMBOL_CONTAINS", "contains"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_DOES_NOT_CONTAIN, "RYGEL_SEARCH_CRITERIA_SYMBOL_DOES_NOT_CONTAIN", "does-not-contain"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_DERIVED_FROM, "RYGEL_SEARCH_CRITERIA_SYMBOL_DERIVED_FROM", "derived-from"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_EXISTS, "RYGEL_SEARCH_CRITERIA_SYMBOL_EXISTS", "exists"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_ASTERISK, "RYGEL_SEARCH_CRITERIA_SYMBOL_ASTERISK", "asterisk"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_AND, "RYGEL_SEARCH_CRITERIA_SYMBOL_AND", "and"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_OR, "RYGEL_SEARCH_CRITERIA_SYMBOL_OR", "or"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_TRUE, "RYGEL_SEARCH_CRITERIA_SYMBOL_TRUE", "true"}, {RYGEL_SEARCH_CRITERIA_SYMBOL_FALSE, "RYGEL_SEARCH_CRITERIA_SYMBOL_FALSE", "false"}, {0, NULL, NULL}};
		GType rygel_search_criteria_symbol_type_id;
		rygel_search_criteria_symbol_type_id = g_enum_register_static ("RygelSearchCriteriaSymbol", values);
		g_once_init_leave (&rygel_search_criteria_symbol_type_id__volatile, rygel_search_criteria_symbol_type_id);
	}
	return rygel_search_criteria_symbol_type_id__volatile;
}


void rygel_search_criteria_token_copy (const RygelSearchCriteriaToken* self, RygelSearchCriteriaToken* dest) {
	dest->str_symbol = g_strdup (self->str_symbol);
	dest->symbol = self->symbol;
}


void rygel_search_criteria_token_destroy (RygelSearchCriteriaToken* self) {
	_g_free0 (self->str_symbol);
}


RygelSearchCriteriaToken* rygel_search_criteria_token_dup (const RygelSearchCriteriaToken* self) {
	RygelSearchCriteriaToken* dup;
	dup = g_new0 (RygelSearchCriteriaToken, 1);
	rygel_search_criteria_token_copy (self, dup);
	return dup;
}


void rygel_search_criteria_token_free (RygelSearchCriteriaToken* self) {
	rygel_search_criteria_token_destroy (self);
	g_free (self);
}


GType rygel_search_criteria_token_get_type (void) {
	static volatile gsize rygel_search_criteria_token_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_search_criteria_token_type_id__volatile)) {
		GType rygel_search_criteria_token_type_id;
		rygel_search_criteria_token_type_id = g_boxed_type_register_static ("RygelSearchCriteriaToken", (GBoxedCopyFunc) rygel_search_criteria_token_dup, (GBoxedFreeFunc) rygel_search_criteria_token_free);
		g_once_init_leave (&rygel_search_criteria_token_type_id__volatile, rygel_search_criteria_token_type_id);
	}
	return rygel_search_criteria_token_type_id__volatile;
}


#line 98 "rygel-search-criteria-parser.vala"
RygelSearchCriteriaParser* rygel_search_criteria_parser_construct (GType object_type, const char* str, GError** error) {
#line 302 "rygel-search-criteria-parser.c"
	RygelSearchCriteriaParser * self;
	char* _tmp0_;
	GScanner* _tmp1_;
#line 98 "rygel-search-criteria-parser.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 98 "rygel-search-criteria-parser.vala"
	self = (RygelSearchCriteriaParser*) g_object_new (object_type, NULL);
#line 99 "rygel-search-criteria-parser.vala"
	self->str = (_tmp0_ = g_strdup (str), _g_free0 (self->str), _tmp0_);
#line 100 "rygel-search-criteria-parser.vala"
	self->priv->scanner = (_tmp1_ = g_scanner_new (NULL), _g_scanner_destroy0 (self->priv->scanner), _tmp1_);
#line 101 "rygel-search-criteria-parser.vala"
	(*self->priv->scanner->config).cset_skip_characters = " \t\n\r\012" "\013\014\015";
#line 103 "rygel-search-criteria-parser.vala"
	(*self->priv->scanner->config).scan_identifier_1char = TRUE;
#line 104 "rygel-search-criteria-parser.vala"
	(*self->priv->scanner->config).cset_identifier_first = G_CSET_a_2_z "_*<>=!@" G_CSET_A_2_Z;
#line 107 "rygel-search-criteria-parser.vala"
	(*self->priv->scanner->config).cset_identifier_nth = G_CSET_a_2_z "_" G_CSET_DIGITS "=:@" G_CSET_A_2_Z G_CSET_LATINS G_CSET_LATINC;
#line 112 "rygel-search-criteria-parser.vala"
	(*self->priv->scanner->config).symbol_2_token = TRUE;
#line 324 "rygel-search-criteria-parser.c"
	{
		RygelSearchCriteriaToken* token_collection;
		int token_collection_length1;
		int token_it;
#line 114 "rygel-search-criteria-parser.vala"
		token_collection = RYGEL_SEARCH_CRITERIA_PARSER_tokens;
#line 331 "rygel-search-criteria-parser.c"
		token_collection_length1 = G_N_ELEMENTS (RYGEL_SEARCH_CRITERIA_PARSER_tokens);
		for (token_it = 0; token_it < G_N_ELEMENTS (RYGEL_SEARCH_CRITERIA_PARSER_tokens); token_it = token_it + 1) {
			RygelSearchCriteriaToken token;
			token = token_collection[token_it];
			{
#line 115 "rygel-search-criteria-parser.vala"
				g_scanner_scope_add_symbol (self->priv->scanner, (guint) 0, token.str_symbol, GINT_TO_POINTER ((gint) token.symbol));
#line 339 "rygel-search-criteria-parser.c"
			}
		}
	}
	return self;
}


#line 98 "rygel-search-criteria-parser.vala"
RygelSearchCriteriaParser* rygel_search_criteria_parser_new (const char* str, GError** error) {
#line 98 "rygel-search-criteria-parser.vala"
	return rygel_search_criteria_parser_construct (RYGEL_TYPE_SEARCH_CRITERIA_PARSER, str, error);
#line 351 "rygel-search-criteria-parser.c"
}


static void rygel_search_criteria_parser_real_run_data_free (gpointer _data) {
	RygelSearchCriteriaParserRunData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (RygelSearchCriteriaParserRunData, data);
}


static void rygel_search_criteria_parser_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchCriteriaParser * self;
	RygelSearchCriteriaParserRunData* _data_;
	self = (RygelSearchCriteriaParser*) base;
	_data_ = g_slice_new0 (RygelSearchCriteriaParserRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_search_criteria_parser_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_search_criteria_parser_real_run_data_free);
	_data_->self = g_object_ref (self);
	rygel_search_criteria_parser_real_run_co (_data_);
}


static void rygel_search_criteria_parser_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelSearchCriteriaParserRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_search_criteria_parser_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchCriteriaParserRunData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_search_criteria_parser_real_run_co (data);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gboolean rygel_search_criteria_parser_real_run_co (RygelSearchCriteriaParserRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
#line 123 "rygel-search-criteria-parser.vala"
		if (_vala_strcmp0 (data->self->str, "*") == 0) {
#line 125 "rygel-search-criteria-parser.vala"
			g_signal_emit_by_name ((RygelStateMachine*) data->self, "completed");
#line 407 "rygel-search-criteria-parser.c"
		}
#line 128 "rygel-search-criteria-parser.vala"
		g_scanner_input_text (data->self->priv->scanner, data->self->str, (guint) strlen (data->self->str));
#line 129 "rygel-search-criteria-parser.vala"
		g_scanner_get_next_token (data->self->priv->scanner);
#line 413 "rygel-search-criteria-parser.c"
		{
			data->_tmp0_ = rygel_search_criteria_parser_parse_or_expression (data->self, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch53_g_error;
			}
#line 131 "rygel-search-criteria-parser.vala"
			data->self->expression = (data->_tmp1_ = data->_tmp0_, _rygel_search_expression_unref0 (data->self->expression), data->_tmp1_);
#line 421 "rygel-search-criteria-parser.c"
		}
		goto __finally53;
		__catch53_g_error:
		{
			data->err = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
#line 133 "rygel-search-criteria-parser.vala"
				data->self->err = (data->_tmp2_ = _g_error_copy0 (data->err), _g_error_free0 (data->self->err), data->_tmp2_);
#line 431 "rygel-search-criteria-parser.c"
				_g_error_free0 (data->err);
			}
		}
		__finally53:
		if (data->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
#line 135 "rygel-search-criteria-parser.vala"
		g_signal_emit_by_name ((RygelStateMachine*) data->self, "completed");
#line 443 "rygel-search-criteria-parser.c"
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


#line 138 "rygel-search-criteria-parser.vala"
static RygelSearchExpression* rygel_search_criteria_parser_parse_and_expression (RygelSearchCriteriaParser* self, GError** error) {
#line 464 "rygel-search-criteria-parser.c"
	RygelSearchExpression* result = NULL;
	GError * _inner_error_;
	RygelSearchExpression* exp;
#line 138 "rygel-search-criteria-parser.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 470 "rygel-search-criteria-parser.c"
	_inner_error_ = NULL;
#line 139 "rygel-search-criteria-parser.vala"
	exp = rygel_search_criteria_parser_parse_rel_expression (self, &_inner_error_);
#line 474 "rygel-search-criteria-parser.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
#line 140 "rygel-search-criteria-parser.vala"
	while (TRUE) {
#line 481 "rygel-search-criteria-parser.c"
		RygelLogicalExpression* exp2;
		RygelSearchExpression* _tmp0_;
		RygelSearchExpression* _tmp1_;
		RygelSearchExpression* _tmp2_;
		RygelSearchExpression* _tmp3_;
#line 140 "rygel-search-criteria-parser.vala"
		if (!(rygel_search_criteria_parser_get_token (self) == RYGEL_SEARCH_CRITERIA_SYMBOL_AND)) {
#line 140 "rygel-search-criteria-parser.vala"
			break;
#line 491 "rygel-search-criteria-parser.c"
		}
#line 141 "rygel-search-criteria-parser.vala"
		g_scanner_get_next_token (self->priv->scanner);
#line 142 "rygel-search-criteria-parser.vala"
		exp2 = rygel_logical_expression_new ();
#line 143 "rygel-search-criteria-parser.vala"
		((RygelSearchExpression*) exp2)->operand1 = (_tmp0_ = _rygel_search_expression_ref0 (exp), _rygel_search_expression_unref0 (((RygelSearchExpression*) exp2)->operand1), _tmp0_);
#line 144 "rygel-search-criteria-parser.vala"
		((RygelSearchExpression*) exp2)->op = GINT_TO_POINTER (RYGEL_LOGICAL_OPERATOR_AND);
#line 145 "rygel-search-criteria-parser.vala"
		_tmp1_ = rygel_search_criteria_parser_parse_rel_expression (self, &_inner_error_);
#line 503 "rygel-search-criteria-parser.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_rygel_search_expression_unref0 (exp2);
			_rygel_search_expression_unref0 (exp);
			return NULL;
		}
#line 145 "rygel-search-criteria-parser.vala"
		((RygelSearchExpression*) exp2)->operand2 = (_tmp2_ = _tmp1_, _rygel_search_expression_unref0 (((RygelSearchExpression*) exp2)->operand2), _tmp2_);
#line 146 "rygel-search-criteria-parser.vala"
		exp = (_tmp3_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) exp2), _rygel_search_expression_unref0 (exp), _tmp3_);
#line 514 "rygel-search-criteria-parser.c"
		_rygel_search_expression_unref0 (exp2);
	}
	result = exp;
#line 149 "rygel-search-criteria-parser.vala"
	return result;
#line 520 "rygel-search-criteria-parser.c"
}


#line 152 "rygel-search-criteria-parser.vala"
static RygelSearchExpression* rygel_search_criteria_parser_parse_rel_expression (RygelSearchCriteriaParser* self, GError** error) {
#line 526 "rygel-search-criteria-parser.c"
	RygelSearchExpression* result = NULL;
	GError * _inner_error_;
	RygelRelationalExpression* exp;
#line 152 "rygel-search-criteria-parser.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 532 "rygel-search-criteria-parser.c"
	_inner_error_ = NULL;
#line 153 "rygel-search-criteria-parser.vala"
	exp = rygel_relational_expression_new ();
#line 154 "rygel-search-criteria-parser.vala"
	if (self->priv->scanner->token == G_TOKEN_IDENTIFIER) {
#line 538 "rygel-search-criteria-parser.c"
		char* _tmp0_;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
#line 155 "rygel-search-criteria-parser.vala"
		((RygelSearchExpression*) exp)->operand1 = (_tmp0_ = g_strdup (self->priv->scanner->value.v_identifier), _g_free0 (((RygelSearchExpression*) exp)->operand1), _tmp0_);
#line 156 "rygel-search-criteria-parser.vala"
		g_scanner_get_next_token (self->priv->scanner);
#line 158 "rygel-search-criteria-parser.vala"
		if (rygel_search_criteria_parser_get_token (self) == RYGEL_SEARCH_CRITERIA_SYMBOL_EQ) {
#line 158 "rygel-search-criteria-parser.vala"
			_tmp8_ = TRUE;
#line 556 "rygel-search-criteria-parser.c"
		} else {
#line 159 "rygel-search-criteria-parser.vala"
			_tmp8_ = rygel_search_criteria_parser_get_token (self) == RYGEL_SEARCH_CRITERIA_SYMBOL_NEQ;
#line 560 "rygel-search-criteria-parser.c"
		}
#line 158 "rygel-search-criteria-parser.vala"
		if (_tmp8_) {
#line 158 "rygel-search-criteria-parser.vala"
			_tmp7_ = TRUE;
#line 566 "rygel-search-criteria-parser.c"
		} else {
#line 160 "rygel-search-criteria-parser.vala"
			_tmp7_ = rygel_search_criteria_parser_get_token (self) == RYGEL_SEARCH_CRITERIA_SYMBOL_LESS;
#line 570 "rygel-search-criteria-parser.c"
		}
#line 158 "rygel-search-criteria-parser.vala"
		if (_tmp7_) {
#line 158 "rygel-search-criteria-parser.vala"
			_tmp6_ = TRUE;
#line 576 "rygel-search-criteria-parser.c"
		} else {
#line 161 "rygel-search-criteria-parser.vala"
			_tmp6_ = rygel_search_criteria_parser_get_token (self) == RYGEL_SEARCH_CRITERIA_SYMBOL_LEQ;
#line 580 "rygel-search-criteria-parser.c"
		}
#line 158 "rygel-search-criteria-parser.vala"
		if (_tmp6_) {
#line 158 "rygel-search-criteria-parser.vala"
			_tmp5_ = TRUE;
#line 586 "rygel-search-criteria-parser.c"
		} else {
#line 162 "rygel-search-criteria-parser.vala"
			_tmp5_ = rygel_search_criteria_parser_get_token (self) == RYGEL_SEARCH_CRITERIA_SYMBOL_GREATER;
#line 590 "rygel-search-criteria-parser.c"
		}
#line 158 "rygel-search-criteria-parser.vala"
		if (_tmp5_) {
#line 158 "rygel-search-criteria-parser.vala"
			_tmp4_ = TRUE;
#line 596 "rygel-search-criteria-parser.c"
		} else {
#line 163 "rygel-search-criteria-parser.vala"
			_tmp4_ = rygel_search_criteria_parser_get_token (self) == RYGEL_SEARCH_CRITERIA_SYMBOL_GEQ;
#line 600 "rygel-search-criteria-parser.c"
		}
#line 158 "rygel-search-criteria-parser.vala"
		if (_tmp4_) {
#line 158 "rygel-search-criteria-parser.vala"
			_tmp3_ = TRUE;
#line 606 "rygel-search-criteria-parser.c"
		} else {
#line 164 "rygel-search-criteria-parser.vala"
			_tmp3_ = rygel_search_criteria_parser_get_token (self) == RYGEL_SEARCH_CRITERIA_SYMBOL_CONTAINS;
#line 610 "rygel-search-criteria-parser.c"
		}
#line 158 "rygel-search-criteria-parser.vala"
		if (_tmp3_) {
#line 158 "rygel-search-criteria-parser.vala"
			_tmp2_ = TRUE;
#line 616 "rygel-search-criteria-parser.c"
		} else {
#line 165 "rygel-search-criteria-parser.vala"
			_tmp2_ = rygel_search_criteria_parser_get_token (self) == RYGEL_SEARCH_CRITERIA_SYMBOL_DOES_NOT_CONTAIN;
#line 620 "rygel-search-criteria-parser.c"
		}
#line 158 "rygel-search-criteria-parser.vala"
		if (_tmp2_) {
#line 158 "rygel-search-criteria-parser.vala"
			_tmp1_ = TRUE;
#line 626 "rygel-search-criteria-parser.c"
		} else {
#line 166 "rygel-search-criteria-parser.vala"
			_tmp1_ = rygel_search_criteria_parser_get_token (self) == RYGEL_SEARCH_CRITERIA_SYMBOL_DERIVED_FROM;
#line 630 "rygel-search-criteria-parser.c"
		}
#line 158 "rygel-search-criteria-parser.vala"
		if (_tmp1_) {
#line 167 "rygel-search-criteria-parser.vala"
			((RygelSearchExpression*) exp)->op = GINT_TO_POINTER ((GUPnPSearchCriteriaOp) self->priv->scanner->token);
#line 168 "rygel-search-criteria-parser.vala"
			g_scanner_get_next_token (self->priv->scanner);
#line 169 "rygel-search-criteria-parser.vala"
			if (self->priv->scanner->token == G_TOKEN_STRING) {
#line 640 "rygel-search-criteria-parser.c"
				char* _tmp9_;
#line 170 "rygel-search-criteria-parser.vala"
				((RygelSearchExpression*) exp)->operand2 = (_tmp9_ = g_strdup (self->priv->scanner->value.v_string), _g_free0 (((RygelSearchExpression*) exp)->operand2), _tmp9_);
#line 171 "rygel-search-criteria-parser.vala"
				g_scanner_get_next_token (self->priv->scanner);
#line 646 "rygel-search-criteria-parser.c"
				result = (RygelSearchExpression*) exp;
#line 173 "rygel-search-criteria-parser.vala"
				return result;
#line 650 "rygel-search-criteria-parser.c"
			} else {
				char* _tmp12_;
				char* _tmp11_;
				char* _tmp10_;
				GError* _tmp13_;
				_inner_error_ = (_tmp13_ = g_error_new_literal (RYGEL_SEARCH_CRITERIA_ERROR, RYGEL_SEARCH_CRITERIA_ERROR_SYNTAX_ERROR, _tmp12_ = g_strconcat (_tmp11_ = g_strconcat (_tmp10_ = rygel_search_criteria_parser_get_context (self), ": expected ", NULL), "\"STRING\"", NULL)), _g_free0 (_tmp12_), _g_free0 (_tmp11_), _g_free0 (_tmp10_), _tmp13_);
				{
					g_propagate_error (error, _inner_error_);
					_rygel_search_expression_unref0 (exp);
					return NULL;
				}
			}
		} else {
#line 179 "rygel-search-criteria-parser.vala"
			if (rygel_search_criteria_parser_get_token (self) == RYGEL_SEARCH_CRITERIA_SYMBOL_EXISTS) {
#line 180 "rygel-search-criteria-parser.vala"
				((RygelSearchExpression*) exp)->op = GINT_TO_POINTER ((GUPnPSearchCriteriaOp) self->priv->scanner->token);
#line 181 "rygel-search-criteria-parser.vala"
				g_scanner_get_next_token (self->priv->scanner);
#line 182 "rygel-search-criteria-parser.vala"
				if (rygel_search_criteria_parser_get_token (self) == RYGEL_SEARCH_CRITERIA_SYMBOL_TRUE) {
#line 672 "rygel-search-criteria-parser.c"
					char* _tmp14_;
#line 183 "rygel-search-criteria-parser.vala"
					((RygelSearchExpression*) exp)->operand2 = (_tmp14_ = g_strdup ("true"), _g_free0 (((RygelSearchExpression*) exp)->operand2), _tmp14_);
#line 184 "rygel-search-criteria-parser.vala"
					g_scanner_get_next_token (self->priv->scanner);
#line 678 "rygel-search-criteria-parser.c"
					result = (RygelSearchExpression*) exp;
#line 186 "rygel-search-criteria-parser.vala"
					return result;
#line 682 "rygel-search-criteria-parser.c"
				} else {
#line 187 "rygel-search-criteria-parser.vala"
					if (rygel_search_criteria_parser_get_token (self) == RYGEL_SEARCH_CRITERIA_SYMBOL_FALSE) {
#line 686 "rygel-search-criteria-parser.c"
						char* _tmp15_;
#line 188 "rygel-search-criteria-parser.vala"
						((RygelSearchExpression*) exp)->operand2 = (_tmp15_ = g_strdup ("false"), _g_free0 (((RygelSearchExpression*) exp)->operand2), _tmp15_);
#line 189 "rygel-search-criteria-parser.vala"
						g_scanner_get_next_token (self->priv->scanner);
#line 692 "rygel-search-criteria-parser.c"
						result = (RygelSearchExpression*) exp;
#line 191 "rygel-search-criteria-parser.vala"
						return result;
#line 696 "rygel-search-criteria-parser.c"
					} else {
						char* _tmp19_;
						char* _tmp18_;
						char* _tmp17_;
						char* _tmp16_;
						GError* _tmp20_;
						_inner_error_ = (_tmp20_ = g_error_new_literal (RYGEL_SEARCH_CRITERIA_ERROR, RYGEL_SEARCH_CRITERIA_ERROR_SYNTAX_ERROR, _tmp19_ = g_strconcat (_tmp18_ = g_strconcat (_tmp17_ = g_strconcat (_tmp16_ = rygel_search_criteria_parser_get_context (self), ": expected ", NULL), "\"true\"|\"", NULL), "false\"", NULL)), _g_free0 (_tmp19_), _g_free0 (_tmp18_), _g_free0 (_tmp17_), _g_free0 (_tmp16_), _tmp20_);
						{
							g_propagate_error (error, _inner_error_);
							_rygel_search_expression_unref0 (exp);
							return NULL;
						}
					}
				}
			} else {
				char* _tmp23_;
				char* _tmp22_;
				char* _tmp21_;
				GError* _tmp24_;
				_inner_error_ = (_tmp24_ = g_error_new_literal (RYGEL_SEARCH_CRITERIA_ERROR, RYGEL_SEARCH_CRITERIA_ERROR_SYNTAX_ERROR, _tmp23_ = g_strconcat (_tmp22_ = g_strconcat (_tmp21_ = rygel_search_criteria_parser_get_context (self), ": expected ", NULL), "operator", NULL)), _g_free0 (_tmp23_), _g_free0 (_tmp22_), _g_free0 (_tmp21_), _tmp24_);
				{
					g_propagate_error (error, _inner_error_);
					_rygel_search_expression_unref0 (exp);
					return NULL;
				}
			}
		}
	} else {
#line 203 "rygel-search-criteria-parser.vala"
		if (self->priv->scanner->token == G_TOKEN_LEFT_PAREN) {
#line 727 "rygel-search-criteria-parser.c"
			RygelSearchExpression* exp2;
#line 204 "rygel-search-criteria-parser.vala"
			g_scanner_get_next_token (self->priv->scanner);
#line 205 "rygel-search-criteria-parser.vala"
			exp2 = rygel_search_criteria_parser_parse_or_expression (self, &_inner_error_);
#line 733 "rygel-search-criteria-parser.c"
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_rygel_search_expression_unref0 (exp);
				return NULL;
			}
#line 206 "rygel-search-criteria-parser.vala"
			if (self->priv->scanner->token != G_TOKEN_RIGHT_PAREN) {
#line 741 "rygel-search-criteria-parser.c"
				char* _tmp26_;
				char* _tmp25_;
				GError* _tmp27_;
				_inner_error_ = (_tmp27_ = g_error_new_literal (RYGEL_SEARCH_CRITERIA_ERROR, RYGEL_SEARCH_CRITERIA_ERROR_SYNTAX_ERROR, _tmp26_ = g_strconcat (_tmp25_ = rygel_search_criteria_parser_get_context (self), ": expected ')'", NULL)), _g_free0 (_tmp26_), _g_free0 (_tmp25_), _tmp27_);
				{
					g_propagate_error (error, _inner_error_);
					_rygel_search_expression_unref0 (exp2);
					_rygel_search_expression_unref0 (exp);
					return NULL;
				}
			} else {
#line 210 "rygel-search-criteria-parser.vala"
				g_scanner_get_next_token (self->priv->scanner);
#line 755 "rygel-search-criteria-parser.c"
				result = exp2;
				_rygel_search_expression_unref0 (exp);
#line 212 "rygel-search-criteria-parser.vala"
				return result;
#line 760 "rygel-search-criteria-parser.c"
			}
			_rygel_search_expression_unref0 (exp2);
		} else {
			char* _tmp30_;
			char* _tmp29_;
			char* _tmp28_;
			GError* _tmp31_;
			_inner_error_ = (_tmp31_ = g_error_new_literal (RYGEL_SEARCH_CRITERIA_ERROR, RYGEL_SEARCH_CRITERIA_ERROR_SYNTAX_ERROR, _tmp30_ = g_strconcat (_tmp29_ = g_strconcat (_tmp28_ = rygel_search_criteria_parser_get_context (self), ": expected ", NULL), "identifier or '('", NULL)), _g_free0 (_tmp30_), _g_free0 (_tmp29_), _g_free0 (_tmp28_), _tmp31_);
			{
				g_propagate_error (error, _inner_error_);
				_rygel_search_expression_unref0 (exp);
				return NULL;
			}
		}
	}
	_rygel_search_expression_unref0 (exp);
}


#line 222 "rygel-search-criteria-parser.vala"
static RygelSearchExpression* rygel_search_criteria_parser_parse_or_expression (RygelSearchCriteriaParser* self, GError** error) {
#line 782 "rygel-search-criteria-parser.c"
	RygelSearchExpression* result = NULL;
	GError * _inner_error_;
	RygelSearchExpression* exp;
#line 222 "rygel-search-criteria-parser.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 788 "rygel-search-criteria-parser.c"
	_inner_error_ = NULL;
#line 223 "rygel-search-criteria-parser.vala"
	exp = rygel_search_criteria_parser_parse_and_expression (self, &_inner_error_);
#line 792 "rygel-search-criteria-parser.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
#line 224 "rygel-search-criteria-parser.vala"
	while (TRUE) {
#line 799 "rygel-search-criteria-parser.c"
		RygelLogicalExpression* exp2;
		RygelSearchExpression* _tmp0_;
		RygelSearchExpression* _tmp1_;
		RygelSearchExpression* _tmp2_;
		RygelSearchExpression* _tmp3_;
#line 224 "rygel-search-criteria-parser.vala"
		if (!(rygel_search_criteria_parser_get_token (self) == RYGEL_SEARCH_CRITERIA_SYMBOL_OR)) {
#line 224 "rygel-search-criteria-parser.vala"
			break;
#line 809 "rygel-search-criteria-parser.c"
		}
#line 225 "rygel-search-criteria-parser.vala"
		g_scanner_get_next_token (self->priv->scanner);
#line 226 "rygel-search-criteria-parser.vala"
		exp2 = rygel_logical_expression_new ();
#line 227 "rygel-search-criteria-parser.vala"
		((RygelSearchExpression*) exp2)->operand1 = (_tmp0_ = _rygel_search_expression_ref0 (exp), _rygel_search_expression_unref0 (((RygelSearchExpression*) exp2)->operand1), _tmp0_);
#line 228 "rygel-search-criteria-parser.vala"
		((RygelSearchExpression*) exp2)->op = GINT_TO_POINTER (RYGEL_LOGICAL_OPERATOR_OR);
#line 229 "rygel-search-criteria-parser.vala"
		_tmp1_ = rygel_search_criteria_parser_parse_and_expression (self, &_inner_error_);
#line 821 "rygel-search-criteria-parser.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_rygel_search_expression_unref0 (exp2);
			_rygel_search_expression_unref0 (exp);
			return NULL;
		}
#line 229 "rygel-search-criteria-parser.vala"
		((RygelSearchExpression*) exp2)->operand2 = (_tmp2_ = _tmp1_, _rygel_search_expression_unref0 (((RygelSearchExpression*) exp2)->operand2), _tmp2_);
#line 230 "rygel-search-criteria-parser.vala"
		exp = (_tmp3_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) exp2), _rygel_search_expression_unref0 (exp), _tmp3_);
#line 832 "rygel-search-criteria-parser.c"
		_rygel_search_expression_unref0 (exp2);
	}
	result = exp;
#line 233 "rygel-search-criteria-parser.vala"
	return result;
#line 838 "rygel-search-criteria-parser.c"
}


static GCancellable* rygel_search_criteria_parser_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelSearchCriteriaParser* self;
	self = (RygelSearchCriteriaParser*) base;
	result = self->priv->_cancellable;
#line 63 "rygel-search-criteria-parser.vala"
	return result;
#line 849 "rygel-search-criteria-parser.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_search_criteria_parser_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelSearchCriteriaParser* self;
	GCancellable* _tmp0_;
	self = (RygelSearchCriteriaParser*) base;
	self->priv->_cancellable = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_cancellable), _tmp0_);
	g_object_notify ((GObject *) self, "cancellable");
}


static RygelSearchCriteriaSymbol rygel_search_criteria_parser_get_token (RygelSearchCriteriaParser* self) {
	RygelSearchCriteriaSymbol result;
	g_return_val_if_fail (self != NULL, 0);
	result = (RygelSearchCriteriaSymbol) self->priv->scanner->token;
#line 67 "rygel-search-criteria-parser.vala"
	return result;
#line 873 "rygel-search-criteria-parser.c"
}


static char* rygel_search_criteria_parser_get_context (RygelSearchCriteriaParser* self) {
	char* result;
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	result = (_tmp3_ = g_strconcat (_tmp1_ = g_strconcat (_tmp0_ = g_strdup_printf ("%u", self->priv->scanner->line), ".", NULL), _tmp2_ = g_strdup_printf ("%u", self->priv->scanner->position), NULL), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp3_);
#line 73 "rygel-search-criteria-parser.vala"
	return result;
#line 887 "rygel-search-criteria-parser.c"
}


static void rygel_search_criteria_parser_class_init (RygelSearchCriteriaParserClass * klass) {
	rygel_search_criteria_parser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelSearchCriteriaParserPrivate));
	G_OBJECT_CLASS (klass)->get_property = rygel_search_criteria_parser_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_search_criteria_parser_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_search_criteria_parser_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_SEARCH_CRITERIA_PARSER_CANCELLABLE, "cancellable");
}


static void rygel_search_criteria_parser_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_search_criteria_parser_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = rygel_search_criteria_parser_real_run;
	iface->run_finish = rygel_search_criteria_parser_real_run_finish;
	iface->get_cancellable = rygel_search_criteria_parser_real_get_cancellable;
	iface->set_cancellable = rygel_search_criteria_parser_real_set_cancellable;
}


static void rygel_search_criteria_parser_instance_init (RygelSearchCriteriaParser * self) {
	self->priv = RYGEL_SEARCH_CRITERIA_PARSER_GET_PRIVATE (self);
}


static void rygel_search_criteria_parser_finalize (GObject* obj) {
	RygelSearchCriteriaParser * self;
	self = RYGEL_SEARCH_CRITERIA_PARSER (obj);
	_g_free0 (self->str);
	_rygel_search_expression_unref0 (self->expression);
	_g_error_free0 (self->err);
	_g_object_unref0 (self->priv->_cancellable);
	_g_scanner_destroy0 (self->priv->scanner);
	G_OBJECT_CLASS (rygel_search_criteria_parser_parent_class)->finalize (obj);
}


GType rygel_search_criteria_parser_get_type (void) {
	static volatile gsize rygel_search_criteria_parser_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_search_criteria_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSearchCriteriaParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_search_criteria_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSearchCriteriaParser), 0, (GInstanceInitFunc) rygel_search_criteria_parser_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_search_criteria_parser_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_search_criteria_parser_type_id;
		rygel_search_criteria_parser_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSearchCriteriaParser", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_search_criteria_parser_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_search_criteria_parser_type_id__volatile, rygel_search_criteria_parser_type_id);
	}
	return rygel_search_criteria_parser_type_id__volatile;
}


static void rygel_search_criteria_parser_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelSearchCriteriaParser * self;
	self = RYGEL_SEARCH_CRITERIA_PARSER (object);
	switch (property_id) {
		case RYGEL_SEARCH_CRITERIA_PARSER_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_search_criteria_parser_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelSearchCriteriaParser * self;
	self = RYGEL_SEARCH_CRITERIA_PARSER (object);
	switch (property_id) {
		case RYGEL_SEARCH_CRITERIA_PARSER_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




