/* rygel-media-export-root-container.c generated by valac, the Vala compiler
 * generated from rygel-media-export-root-container.vala, do not modify */

/*
 * Copyright (C) 2009,2010 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;
typedef struct _RygelMediaExportDBContainerPrivate RygelMediaExportDBContainerPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;

#define RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER (rygel_media_export_root_container_get_type ())
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainer))
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerClass))

typedef struct _RygelMediaExportRootContainer RygelMediaExportRootContainer;
typedef struct _RygelMediaExportRootContainerClass RygelMediaExportRootContainerClass;
typedef struct _RygelMediaExportRootContainerPrivate RygelMediaExportRootContainerPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR (rygel_media_export_metadata_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractor))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))

typedef struct _RygelMediaExportMetadataExtractor RygelMediaExportMetadataExtractor;
typedef struct _RygelMediaExportMetadataExtractorClass RygelMediaExportMetadataExtractorClass;

#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTER (rygel_media_export_harvester_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester))
#define RYGEL_MEDIA_EXPORT_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))

typedef struct _RygelMediaExportHarvester RygelMediaExportHarvester;
typedef struct _RygelMediaExportHarvesterClass RygelMediaExportHarvesterClass;

#define RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR (rygel_media_export_recursive_file_monitor_get_type ())
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitor))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))

typedef struct _RygelMediaExportRecursiveFileMonitor RygelMediaExportRecursiveFileMonitor;
typedef struct _RygelMediaExportRecursiveFileMonitorClass RygelMediaExportRecursiveFileMonitorClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE (rygel_media_export_dbus_service_get_type ())
#define RYGEL_MEDIA_EXPORT_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE, RygelMediaExportDBusService))
#define RYGEL_MEDIA_EXPORT_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE, RygelMediaExportDBusServiceClass))
#define RYGEL_MEDIA_EXPORT_IS_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE))
#define RYGEL_MEDIA_EXPORT_IS_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE))
#define RYGEL_MEDIA_EXPORT_DBUS_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE, RygelMediaExportDBusServiceClass))

typedef struct _RygelMediaExportDBusService RygelMediaExportDBusService;
typedef struct _RygelMediaExportDBusServiceClass RygelMediaExportDBusServiceClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_NULL_CONTAINER (rygel_null_container_get_type ())
#define RYGEL_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainer))
#define RYGEL_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))
#define RYGEL_IS_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_IS_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_NULL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))

typedef struct _RygelNullContainer RygelNullContainer;
typedef struct _RygelNullContainerClass RygelNullContainerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER (rygel_media_export_query_container_get_type ())
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainer))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))

typedef struct _RygelMediaExportQueryContainer RygelMediaExportQueryContainer;
typedef struct _RygelMediaExportQueryContainerClass RygelMediaExportQueryContainerClass;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelMediaExportQueryContainerPrivate RygelMediaExportQueryContainerPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _RygelMediaExportRootContainerFindObjectData RygelMediaExportRootContainerFindObjectData;
typedef struct _RygelMediaExportRootContainerSearchData RygelMediaExportRootContainerSearchData;

#define RYGEL_MEDIA_EXPORT_TYPE_DB_OBJECT_FACTORY (rygel_media_export_db_object_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_OBJECT_FACTORY, RygelMediaExportDBObjectFactory))
#define RYGEL_MEDIA_EXPORT_DB_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_OBJECT_FACTORY, RygelMediaExportDBObjectFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_DB_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_DB_OBJECT_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_OBJECT_FACTORY, RygelMediaExportDBObjectFactoryClass))

typedef struct _RygelMediaExportDBObjectFactory RygelMediaExportDBObjectFactory;
typedef struct _RygelMediaExportDBObjectFactoryClass RygelMediaExportDBObjectFactoryClass;

#define RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY (rygel_media_export_object_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactory))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))

typedef struct _RygelMediaExportObjectFactory RygelMediaExportObjectFactory;
typedef struct _RygelMediaExportObjectFactoryClass RygelMediaExportObjectFactoryClass;
typedef struct _RygelMediaExportHarvesterPrivate RygelMediaExportHarvesterPrivate;

struct _RygelMediaExportDBContainer {
	RygelMediaContainer parent_instance;
	RygelMediaExportDBContainerPrivate * priv;
	RygelMediaExportMediaCache* media_db;
};

struct _RygelMediaExportDBContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelMediaExportRootContainer {
	RygelMediaExportDBContainer parent_instance;
	RygelMediaExportRootContainerPrivate * priv;
};

struct _RygelMediaExportRootContainerClass {
	RygelMediaExportDBContainerClass parent_class;
};

struct _RygelMediaExportRootContainerPrivate {
	RygelMediaExportMetadataExtractor* extractor;
	GeeHashMap* harvester;
	RygelMediaExportRecursiveFileMonitor* monitor;
	RygelMediaExportDBusService* service;
	GeeList* harvester_trash;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
struct _RygelMediaExportQueryContainer {
	RygelMediaExportDBContainer parent_instance;
	RygelMediaExportQueryContainerPrivate * priv;
	char* plaintext_id;
};

struct _RygelMediaExportQueryContainerClass {
	RygelMediaExportDBContainerClass parent_class;
};

struct _RygelMediaExportRootContainerFindObjectData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportRootContainer* self;
	char* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	RygelMediaObject* object;
	gboolean _tmp0_;
	RygelMediaExportQueryContainer* container;
	GError * _inner_error_;
};

struct _RygelMediaExportRootContainerSearchData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportRootContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* list;
	RygelMediaContainer* query_container;
	char* upnp_class;
	RygelRelationalExpression* relational_expression;
	RygelSearchExpression* _tmp0_;
	RygelMediaContainer* _tmp1_;
	char* _tmp2_;
	RygelMediaContainer* _tmp5_;
	gboolean _tmp4_;
	RygelMediaContainer* _tmp3_;
	RygelMediaObjects* _tmp6_;
	RygelMediaObjects* _tmp7_;
	GeeIterator* _object_it;
	RygelMediaObject* object;
	char* _tmp8_;
	RygelMediaObjects* _tmp9_;
	GError * _inner_error_;
};

struct _RygelMediaExportHarvester {
	GObject parent_instance;
	RygelMediaExportHarvesterPrivate * priv;
	GCancellable* cancellable;
};

struct _RygelMediaExportHarvesterClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_MEDIA_DB_ERROR_SQLITE_ERROR,
	RYGEL_MEDIA_DB_ERROR_GENERAL_ERROR,
	RYGEL_MEDIA_DB_ERROR_INVALID_TYPE,
	RYGEL_MEDIA_DB_ERROR_UNSUPPORTED_SEARCH
} RygelMediaDBError;
#define RYGEL_MEDIA_DB_ERROR rygel_media_db_error_quark ()

static RygelMediaContainer* rygel_media_export_root_container_instance;
static RygelMediaContainer* rygel_media_export_root_container_instance = NULL;
static gpointer rygel_media_export_root_container_parent_class = NULL;

GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_root_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_metadata_extractor_get_type (void) G_GNUC_CONST;
GType rygel_media_export_harvester_get_type (void) G_GNUC_CONST;
GType rygel_media_export_recursive_file_monitor_get_type (void) G_GNUC_CONST;
GType rygel_media_export_dbus_service_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_DUMMY_PROPERTY
};
GeeList* rygel_media_export_media_cache_get_flagged_uris (RygelMediaExportMediaCache* self, const char* flag, GError** error);
static GeeArrayList* rygel_media_export_root_container_get_uris (RygelMediaExportRootContainer* self);
static RygelMediaExportRootContainer* rygel_media_export_root_container_new (GError** error);
static RygelMediaExportRootContainer* rygel_media_export_root_container_construct (GType object_type, GError** error);
RygelNullContainer* rygel_null_container_new (void);
RygelNullContainer* rygel_null_container_construct (GType object_type);
GType rygel_null_container_get_type (void) G_GNUC_CONST;
RygelMediaContainer* rygel_media_export_root_container_get_instance (void);
static void rygel_media_export_root_container_harvest (RygelMediaExportRootContainer* self, GFile* file, RygelMediaContainer* parent, const char* flag);
void rygel_media_export_root_container_add_uri (RygelMediaExportRootContainer* self, const char* uri);
GQuark rygel_media_export_database_error_quark (void);
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const char* id, GError** error);
void rygel_media_export_root_container_remove_uri (RygelMediaExportRootContainer* self, const char* uri);
void rygel_media_export_query_container_register_id (char** id);
RygelMediaExportQueryContainer* rygel_media_export_query_container_new (RygelMediaExportMediaCache* media_db, const char* id, const char* name);
RygelMediaExportQueryContainer* rygel_media_export_query_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const char* id, const char* name);
GType rygel_media_export_query_container_get_type (void) G_GNUC_CONST;
static RygelMediaExportQueryContainer* rygel_media_export_root_container_search_to_virtual_container (RygelMediaExportRootContainer* self, RygelRelationalExpression* expression);
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "virtual-container:"
static gboolean rygel_media_export_root_container_is_search_in_virtual_container (RygelMediaExportRootContainer* self, RygelSearchExpression* expression, RygelMediaContainer** container);
static void rygel_media_export_root_container_real_find_object_data_free (gpointer _data);
static void rygel_media_export_root_container_real_find_object (RygelMediaContainer* base, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_media_export_root_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_media_export_root_container_real_find_object_co (RygelMediaExportRootContainerFindObjectData* data);
static void rygel_media_export_root_container_real_search_data_free (gpointer _data);
static void rygel_media_export_root_container_real_search (RygelMediaContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_media_export_root_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_media_export_root_container_real_search_co (RygelMediaExportRootContainerSearchData* data);
char** rygel_media_export_root_container_get_dynamic_uris (RygelMediaExportRootContainer* self, int* result_length1);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_new (void);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_construct (GType object_type);
GType rygel_media_export_db_object_factory_get_type (void) G_GNUC_CONST;
GType rygel_media_export_object_factory_get_type (void) G_GNUC_CONST;
RygelMediaExportMediaCache* rygel_media_export_media_cache_new_with_factory (const char* name, RygelMediaExportDBObjectFactory* factory, GError** error);
RygelMediaExportMediaCache* rygel_media_export_media_cache_construct_with_factory (GType object_type, const char* name, RygelMediaExportDBObjectFactory* factory, GError** error);
RygelMediaExportDBContainer* rygel_media_export_db_container_new (RygelMediaExportMediaCache* media_db, const char* id, const char* title);
RygelMediaExportDBContainer* rygel_media_export_db_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const char* id, const char* title);
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_new (void);
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_construct (GType object_type);
RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_new (GCancellable* cancellable);
RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_construct (GType object_type, GCancellable* cancellable);
static void rygel_media_export_root_container_on_file_changed (RygelMediaExportRootContainer* self, GFile* file, GFile* other, GFileMonitorEvent event);
static void _rygel_media_export_root_container_on_file_changed_rygel_media_export_recursive_file_monitor_changed (RygelMediaExportRecursiveFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
RygelMediaExportDBusService* rygel_media_export_dbus_service_new (RygelMediaExportRootContainer* root_container, GError** error);
RygelMediaExportDBusService* rygel_media_export_dbus_service_construct (GType object_type, RygelMediaExportRootContainer* root_container, GError** error);
gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, const char* object_id, gint64* timestamp, GError** error);
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error);
GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self, const char* container_id, GError** error);
gboolean rygel_media_export_query_container_validate_virtual_id (const char* id);
static void rygel_media_export_root_container_on_file_harvested (RygelMediaExportRootContainer* self, RygelMediaExportHarvester* harvester, GFile* file);
static void rygel_media_export_root_container_on_remove_cancelled_harvester (RygelMediaExportRootContainer* self, RygelMediaExportHarvester* harvester, GFile* file);
static void _rygel_media_export_root_container_on_file_harvested_rygel_media_export_harvester_harvested (RygelMediaExportHarvester* _sender, GFile* file, gpointer self);
static void _rygel_media_export_root_container_on_remove_cancelled_harvester_rygel_media_export_harvester_harvested (RygelMediaExportHarvester* _sender, GFile* file, gpointer self);
RygelMediaExportHarvester* rygel_media_export_harvester_new (RygelMediaContainer* parent, RygelMediaExportMediaCache* media_db, RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, const char* flag);
RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type, RygelMediaContainer* parent, RygelMediaExportMediaCache* media_db, RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, const char* flag);
void rygel_media_export_harvester_harvest (RygelMediaExportHarvester* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_media_export_harvester_harvest_finish (RygelMediaExportHarvester* self, GAsyncResult* _res_);
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const char* object_id, GError** error);
GQuark rygel_media_db_error_quark (void);
void rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error);
static void rygel_media_export_root_container_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



#line 36 "rygel-media-export-root-container.vala"
static GeeArrayList* rygel_media_export_root_container_get_uris (RygelMediaExportRootContainer* self) {
#line 346 "rygel-media-export-root-container.c"
	GeeArrayList* result = NULL;
	GError * _inner_error_;
	GeeArrayList* uris;
	RygelMetaConfig* config;
#line 36 "rygel-media-export-root-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 353 "rygel-media-export-root-container.c"
	_inner_error_ = NULL;
	uris = NULL;
#line 39 "rygel-media-export-root-container.vala"
	config = rygel_meta_config_get_default ();
#line 358 "rygel-media-export-root-container.c"
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
#line 42 "rygel-media-export-root-container.vala"
		_tmp0_ = rygel_configuration_get_string_list ((RygelConfiguration*) config, "MediaExport", "uris", &_inner_error_);
#line 364 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			goto __catch19_g_error;
		}
#line 42 "rygel-media-export-root-container.vala"
		uris = (_tmp1_ = _tmp0_, _g_object_unref0 (uris), _tmp1_);
#line 370 "rygel-media-export-root-container.c"
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			GeeArrayList* _tmp2_;
#line 44 "rygel-media-export-root-container.vala"
			uris = (_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL), _g_object_unref0 (uris), _tmp2_);
#line 382 "rygel-media-export-root-container.c"
			_g_error_free0 (_error_);
		}
	}
	__finally19:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (config);
		_g_object_unref0 (uris);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		GeeList* _tmp3_;
		GeeList* _tmp4_;
#line 48 "rygel-media-export-root-container.vala"
		_tmp3_ = rygel_media_export_media_cache_get_flagged_uris (((RygelMediaExportDBContainer*) self)->media_db, "DBUS", &_inner_error_);
#line 399 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			goto __catch20_g_error;
		}
#line 48 "rygel-media-export-root-container.vala"
		gee_abstract_collection_add_all ((GeeAbstractCollection*) uris, (GeeCollection*) (_tmp4_ = _tmp3_));
#line 405 "rygel-media-export-root-container.c"
		_g_object_unref0 (_tmp4_);
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (_error_);
		}
	}
	__finally20:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (config);
		_g_object_unref0 (uris);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = uris;
	_g_object_unref0 (config);
#line 51 "rygel-media-export-root-container.vala"
	return result;
#line 430 "rygel-media-export-root-container.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 54 "rygel-media-export-root-container.vala"
RygelMediaContainer* rygel_media_export_root_container_get_instance (void) {
#line 441 "rygel-media-export-root-container.c"
	RygelMediaContainer* result = NULL;
	GError * _inner_error_;
	_inner_error_ = NULL;
#line 55 "rygel-media-export-root-container.vala"
	if (rygel_media_export_root_container_instance == NULL) {
#line 447 "rygel-media-export-root-container.c"
		{
			RygelMediaExportRootContainer* _tmp0_;
			RygelMediaContainer* _tmp1_;
#line 57 "rygel-media-export-root-container.vala"
			_tmp0_ = rygel_media_export_root_container_new (&_inner_error_);
#line 453 "rygel-media-export-root-container.c"
			if (_inner_error_ != NULL) {
				goto __catch21_g_error;
			}
#line 57 "rygel-media-export-root-container.vala"
			rygel_media_export_root_container_instance = (_tmp1_ = (RygelMediaContainer*) _tmp0_, _g_object_unref0 (rygel_media_export_root_container_instance), _tmp1_);
#line 459 "rygel-media-export-root-container.c"
		}
		goto __finally21;
		__catch21_g_error:
		{
			GError * _error_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			{
				RygelMediaContainer* _tmp2_;
#line 59 "rygel-media-export-root-container.vala"
				g_warning ("rygel-media-export-root-container.vala:59: %s", _ ("Failed to create instance of database"));
#line 60 "rygel-media-export-root-container.vala"
				rygel_media_export_root_container_instance = (_tmp2_ = (RygelMediaContainer*) rygel_null_container_new (), _g_object_unref0 (rygel_media_export_root_container_instance), _tmp2_);
#line 473 "rygel-media-export-root-container.c"
				_g_error_free0 (_error_);
			}
		}
		__finally21:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _g_object_ref0 (rygel_media_export_root_container_instance);
#line 64 "rygel-media-export-root-container.vala"
	return result;
#line 487 "rygel-media-export-root-container.c"
}


#line 67 "rygel-media-export-root-container.vala"
void rygel_media_export_root_container_add_uri (RygelMediaExportRootContainer* self, const char* uri) {
#line 493 "rygel-media-export-root-container.c"
	GFile* file;
#line 67 "rygel-media-export-root-container.vala"
	g_return_if_fail (self != NULL);
#line 67 "rygel-media-export-root-container.vala"
	g_return_if_fail (uri != NULL);
#line 68 "rygel-media-export-root-container.vala"
	file = g_file_new_for_commandline_arg (uri);
#line 69 "rygel-media-export-root-container.vala"
	rygel_media_export_root_container_harvest (self, file, (RygelMediaContainer*) self, "DBUS");
#line 503 "rygel-media-export-root-container.c"
	_g_object_unref0 (file);
}


#line 72 "rygel-media-export-root-container.vala"
void rygel_media_export_root_container_remove_uri (RygelMediaExportRootContainer* self, const char* uri) {
#line 510 "rygel-media-export-root-container.c"
	GError * _inner_error_;
	GFile* file;
	char* _tmp0_;
	char* _tmp1_;
	char* id;
#line 72 "rygel-media-export-root-container.vala"
	g_return_if_fail (self != NULL);
#line 72 "rygel-media-export-root-container.vala"
	g_return_if_fail (uri != NULL);
#line 520 "rygel-media-export-root-container.c"
	_inner_error_ = NULL;
#line 73 "rygel-media-export-root-container.vala"
	file = g_file_new_for_commandline_arg (uri);
#line 74 "rygel-media-export-root-container.vala"
	id = (_tmp1_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp0_ = g_file_get_uri (file), -1), _g_free0 (_tmp0_), _tmp1_);
#line 526 "rygel-media-export-root-container.c"
	{
#line 78 "rygel-media-export-root-container.vala"
		rygel_media_export_media_cache_remove_by_id (((RygelMediaExportDBContainer*) self)->media_db, id, &_inner_error_);
#line 530 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			goto __catch22_g_error;
		}
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 80 "rygel-media-export-root-container.vala"
			g_warning (_ ("Failed to remove URI: %s"), _error_->message);
#line 544 "rygel-media-export-root-container.c"
			_g_error_free0 (_error_);
		}
	}
	__finally22:
	if (_inner_error_ != NULL) {
		_g_free0 (id);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (id);
	_g_object_unref0 (file);
}


#line 84 "rygel-media-export-root-container.vala"
static RygelMediaExportQueryContainer* rygel_media_export_root_container_search_to_virtual_container (RygelMediaExportRootContainer* self, RygelRelationalExpression* expression) {
#line 563 "rygel-media-export-root-container.c"
	RygelMediaExportQueryContainer* result = NULL;
	gboolean _tmp0_ = FALSE;
#line 84 "rygel-media-export-root-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 84 "rygel-media-export-root-container.vala"
	g_return_val_if_fail (expression != NULL, NULL);
#line 86 "rygel-media-export-root-container.vala"
	if (_vala_strcmp0 ((const char*) ((RygelSearchExpression*) expression)->operand1, "upnp:class") == 0) {
#line 87 "rygel-media-export-root-container.vala"
		_tmp0_ = GPOINTER_TO_INT (((RygelSearchExpression*) expression)->op) == GUPNP_SEARCH_CRITERIA_OP_EQ;
#line 574 "rygel-media-export-root-container.c"
	} else {
#line 86 "rygel-media-export-root-container.vala"
		_tmp0_ = FALSE;
#line 578 "rygel-media-export-root-container.c"
	}
#line 86 "rygel-media-export-root-container.vala"
	if (_tmp0_) {
#line 582 "rygel-media-export-root-container.c"
		GQuark _tmp2_;
		const char* _tmp1_;
		static GQuark _tmp2__label0 = 0;
		static GQuark _tmp2__label1 = 0;
		_tmp1_ = (const char*) ((RygelSearchExpression*) expression)->operand2;
		_tmp2_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
		if (_tmp2_ == ((0 != _tmp2__label0) ? _tmp2__label0 : (_tmp2__label0 = g_quark_from_static_string ("object.container.album.musicAlbum"))))
		switch (0) {
			default:
			{
				char* id;
#line 90 "rygel-media-export-root-container.vala"
				id = g_strdup ("virtual-container:upnp:album,?");
#line 91 "rygel-media-export-root-container.vala"
				rygel_media_export_query_container_register_id (&id);
#line 598 "rygel-media-export-root-container.c"
				result = rygel_media_export_query_container_new (((RygelMediaExportDBContainer*) self)->media_db, id, _ ("Albums"));
				_g_free0 (id);
#line 93 "rygel-media-export-root-container.vala"
				return result;
#line 603 "rygel-media-export-root-container.c"
			}
		} else if (_tmp2_ == ((0 != _tmp2__label1) ? _tmp2__label1 : (_tmp2__label1 = g_quark_from_static_string ("object.container.person.musicArtist"))))
		switch (0) {
			default:
			{
				char* id;
#line 98 "rygel-media-export-root-container.vala"
				id = g_strdup ("virtual-container:dc:creator,?,upnp:album,?");
#line 99 "rygel-media-export-root-container.vala"
				rygel_media_export_query_container_register_id (&id);
#line 614 "rygel-media-export-root-container.c"
				result = rygel_media_export_query_container_new (((RygelMediaExportDBContainer*) self)->media_db, id, _ ("Artists"));
				_g_free0 (id);
#line 101 "rygel-media-export-root-container.vala"
				return result;
#line 619 "rygel-media-export-root-container.c"
			}
		} else
		switch (0) {
			default:
			{
				result = NULL;
#line 105 "rygel-media-export-root-container.vala"
				return result;
#line 628 "rygel-media-export-root-container.c"
			}
		}
	}
	result = NULL;
#line 109 "rygel-media-export-root-container.vala"
	return result;
#line 635 "rygel-media-export-root-container.c"
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


#line 1156 "glib-2.0.vapi"
static char* string_replace (const char* self, const char* old, const char* replacement) {
#line 646 "rygel-media-export-root-container.c"
	char* result = NULL;
	GError * _inner_error_;
#line 1156 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1156 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1156 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 655 "rygel-media-export-root-container.c"
	_inner_error_ = NULL;
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
#line 1158 "glib-2.0.vapi"
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
#line 664 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch23_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 1159 "glib-2.0.vapi"
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
#line 675 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch23_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
#line 1159 "glib-2.0.vapi"
		return result;
#line 690 "rygel-media-export-root-container.c"
	}
	goto __finally23;
	__catch23_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 1161 "glib-2.0.vapi"
			g_assert_not_reached ();
#line 701 "rygel-media-export-root-container.c"
			_g_error_free0 (e);
		}
	}
	__finally23:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


#line 125 "rygel-media-export-root-container.vala"
static gboolean rygel_media_export_root_container_is_search_in_virtual_container (RygelMediaExportRootContainer* self, RygelSearchExpression* expression, RygelMediaContainer** container) {
#line 716 "rygel-media-export-root-container.c"
	gboolean result = FALSE;
	RygelRelationalExpression* virtual_expression;
	RygelMediaExportQueryContainer* query_container;
	RygelSearchExpression* _tmp0_;
	RygelLogicalExpression* logical_expression;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	RygelSearchExpression* _tmp3_;
	RygelRelationalExpression* left_expression;
	RygelSearchExpression* _tmp4_;
	RygelRelationalExpression* right_expression;
	RygelMediaExportQueryContainer* _tmp5_;
	char* last_argument;
	char* escaped_detail;
	char* new_id;
	RygelMediaContainer* _tmp9_;
#line 125 "rygel-media-export-root-container.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 125 "rygel-media-export-root-container.vala"
	g_return_val_if_fail (expression != NULL, FALSE);
#line 737 "rygel-media-export-root-container.c"
	if (container != NULL) {
		*container = NULL;
	}
#line 128 "rygel-media-export-root-container.vala"
	virtual_expression = NULL;
#line 743 "rygel-media-export-root-container.c"
	query_container = NULL;
#line 131 "rygel-media-export-root-container.vala"
	if (!RYGEL_IS_LOGICAL_EXPRESSION (expression)) {
#line 747 "rygel-media-export-root-container.c"
		result = FALSE;
		_g_object_unref0 (query_container);
		_rygel_search_expression_unref0 (virtual_expression);
#line 132 "rygel-media-export-root-container.vala"
		return result;
#line 753 "rygel-media-export-root-container.c"
	}
#line 135 "rygel-media-export-root-container.vala"
	logical_expression = _rygel_search_expression_ref0 ((_tmp0_ = expression, RYGEL_IS_LOGICAL_EXPRESSION (_tmp0_) ? ((RygelLogicalExpression*) _tmp0_) : NULL));
#line 137 "rygel-media-export-root-container.vala"
	if (RYGEL_IS_RELATIONAL_EXPRESSION ((RygelSearchExpression*) ((RygelSearchExpression*) logical_expression)->operand1)) {
#line 138 "rygel-media-export-root-container.vala"
		_tmp2_ = RYGEL_IS_RELATIONAL_EXPRESSION ((RygelSearchExpression*) ((RygelSearchExpression*) logical_expression)->operand2);
#line 761 "rygel-media-export-root-container.c"
	} else {
#line 137 "rygel-media-export-root-container.vala"
		_tmp2_ = FALSE;
#line 765 "rygel-media-export-root-container.c"
	}
#line 137 "rygel-media-export-root-container.vala"
	if (_tmp2_) {
#line 139 "rygel-media-export-root-container.vala"
		_tmp1_ = GPOINTER_TO_INT (((RygelSearchExpression*) logical_expression)->op) == RYGEL_LOGICAL_OPERATOR_AND;
#line 771 "rygel-media-export-root-container.c"
	} else {
#line 137 "rygel-media-export-root-container.vala"
		_tmp1_ = FALSE;
#line 775 "rygel-media-export-root-container.c"
	}
#line 137 "rygel-media-export-root-container.vala"
	if (!_tmp1_) {
#line 779 "rygel-media-export-root-container.c"
		result = FALSE;
		_rygel_search_expression_unref0 (logical_expression);
		_g_object_unref0 (query_container);
		_rygel_search_expression_unref0 (virtual_expression);
#line 141 "rygel-media-export-root-container.vala"
		return result;
#line 786 "rygel-media-export-root-container.c"
	}
#line 144 "rygel-media-export-root-container.vala"
	left_expression = _rygel_search_expression_ref0 ((_tmp3_ = (RygelSearchExpression*) ((RygelSearchExpression*) logical_expression)->operand1, RYGEL_IS_RELATIONAL_EXPRESSION (_tmp3_) ? ((RygelRelationalExpression*) _tmp3_) : NULL));
#line 145 "rygel-media-export-root-container.vala"
	right_expression = _rygel_search_expression_ref0 ((_tmp4_ = (RygelSearchExpression*) ((RygelSearchExpression*) logical_expression)->operand2, RYGEL_IS_RELATIONAL_EXPRESSION (_tmp4_) ? ((RygelRelationalExpression*) _tmp4_) : NULL));
#line 147 "rygel-media-export-root-container.vala"
	query_container = (_tmp5_ = rygel_media_export_root_container_search_to_virtual_container (self, left_expression), _g_object_unref0 (query_container), _tmp5_);
#line 148 "rygel-media-export-root-container.vala"
	if (query_container == NULL) {
#line 796 "rygel-media-export-root-container.c"
		RygelMediaExportQueryContainer* _tmp6_;
#line 149 "rygel-media-export-root-container.vala"
		query_container = (_tmp6_ = rygel_media_export_root_container_search_to_virtual_container (self, right_expression), _g_object_unref0 (query_container), _tmp6_);
#line 150 "rygel-media-export-root-container.vala"
		if (query_container != NULL) {
#line 802 "rygel-media-export-root-container.c"
			RygelRelationalExpression* _tmp7_;
#line 151 "rygel-media-export-root-container.vala"
			virtual_expression = (_tmp7_ = _rygel_search_expression_ref0 (left_expression), _rygel_search_expression_unref0 (virtual_expression), _tmp7_);
#line 806 "rygel-media-export-root-container.c"
		} else {
			result = FALSE;
			_rygel_search_expression_unref0 (right_expression);
			_rygel_search_expression_unref0 (left_expression);
			_rygel_search_expression_unref0 (logical_expression);
			_g_object_unref0 (query_container);
			_rygel_search_expression_unref0 (virtual_expression);
#line 153 "rygel-media-export-root-container.vala"
			return result;
#line 816 "rygel-media-export-root-container.c"
		}
	} else {
		RygelRelationalExpression* _tmp8_;
#line 156 "rygel-media-export-root-container.vala"
		virtual_expression = (_tmp8_ = _rygel_search_expression_ref0 (right_expression), _rygel_search_expression_unref0 (virtual_expression), _tmp8_);
#line 822 "rygel-media-export-root-container.c"
	}
#line 159 "rygel-media-export-root-container.vala"
	last_argument = string_replace (query_container->plaintext_id, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
#line 163 "rygel-media-export-root-container.vala"
	escaped_detail = g_uri_escape_string ((const char*) ((RygelSearchExpression*) virtual_expression)->operand2, "", TRUE);
#line 166 "rygel-media-export-root-container.vala"
	new_id = g_strdup_printf ("%s%s,%s,%s", RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, (const char*) ((RygelSearchExpression*) virtual_expression)->operand1, escaped_detail, last_argument);
#line 171 "rygel-media-export-root-container.vala"
	rygel_media_export_query_container_register_id (&new_id);
#line 172 "rygel-media-export-root-container.vala"
	*container = (_tmp9_ = (RygelMediaContainer*) rygel_media_export_query_container_new (((RygelMediaExportDBContainer*) self)->media_db, new_id, ""), _g_object_unref0 (*container), _tmp9_);
#line 834 "rygel-media-export-root-container.c"
	result = TRUE;
	_g_free0 (new_id);
	_g_free0 (escaped_detail);
	_g_free0 (last_argument);
	_rygel_search_expression_unref0 (right_expression);
	_rygel_search_expression_unref0 (left_expression);
	_rygel_search_expression_unref0 (logical_expression);
	_g_object_unref0 (query_container);
	_rygel_search_expression_unref0 (virtual_expression);
#line 174 "rygel-media-export-root-container.vala"
	return result;
#line 846 "rygel-media-export-root-container.c"
}


static void rygel_media_export_root_container_real_find_object_data_free (gpointer _data) {
	RygelMediaExportRootContainerFindObjectData* data;
	data = _data;
	_g_free0 (data->id);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (RygelMediaExportRootContainerFindObjectData, data);
}


static void rygel_media_export_root_container_real_find_object (RygelMediaContainer* base, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportRootContainer * self;
	RygelMediaExportRootContainerFindObjectData* _data_;
	self = (RygelMediaExportRootContainer*) base;
	_data_ = g_slice_new0 (RygelMediaExportRootContainerFindObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_root_container_real_find_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_root_container_real_find_object_data_free);
	_data_->self = g_object_ref (self);
	_data_->id = g_strdup (id);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_export_root_container_real_find_object_co (_data_);
}


static RygelMediaObject* rygel_media_export_root_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelMediaExportRootContainerFindObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_export_root_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportRootContainerFindObjectData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_media_export_root_container_real_find_object_co (data);
}


static gboolean rygel_media_export_root_container_real_find_object_co (RygelMediaExportRootContainerFindObjectData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_state_ = 2;
		RYGEL_MEDIA_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->find_object ((RygelMediaContainer*) RYGEL_MEDIA_EXPORT_DB_CONTAINER (data->self), data->id, data->cancellable, rygel_media_export_root_container_find_object_ready, data);
		return FALSE;
		_state_2:
		data->object = RYGEL_MEDIA_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->find_object_finish ((RygelMediaContainer*) RYGEL_MEDIA_EXPORT_DB_CONTAINER (data->self), data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
#line 182 "rygel-media-export-root-container.vala"
		if (data->object == NULL) {
#line 182 "rygel-media-export-root-container.vala"
			data->_tmp0_ = g_str_has_prefix (data->id, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX);
#line 929 "rygel-media-export-root-container.c"
		} else {
#line 182 "rygel-media-export-root-container.vala"
			data->_tmp0_ = FALSE;
#line 933 "rygel-media-export-root-container.c"
		}
#line 182 "rygel-media-export-root-container.vala"
		if (data->_tmp0_) {
#line 937 "rygel-media-export-root-container.c"
			data->container = rygel_media_export_query_container_new (((RygelMediaExportDBContainer*) data->self)->media_db, data->id, "");
#line 184 "rygel-media-export-root-container.vala"
			((RygelMediaObject*) data->container)->parent = (RygelMediaContainer*) data->self;
#line 941 "rygel-media-export-root-container.c"
			data->result = (RygelMediaObject*) data->container;
			_g_object_unref0 (data->object);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_object_unref0 (data->container);
		}
		data->result = data->object;
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		_g_object_unref0 (data->object);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_media_export_root_container_real_search_data_free (gpointer _data) {
	RygelMediaExportRootContainerSearchData* data;
	data = _data;
	_rygel_search_expression_unref0 (data->expression);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (RygelMediaExportRootContainerSearchData, data);
}


static void rygel_media_export_root_container_real_search (RygelMediaContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportRootContainer * self;
	RygelMediaExportRootContainerSearchData* _data_;
	self = (RygelMediaExportRootContainer*) base;
	_data_ = g_slice_new0 (RygelMediaExportRootContainerSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_root_container_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_root_container_real_search_data_free);
	_data_->self = g_object_ref (self);
	_data_->expression = _rygel_search_expression_ref0 (expression);
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_export_root_container_real_search_co (_data_);
}


static RygelMediaObjects* rygel_media_export_root_container_real_search_finish (RygelMediaContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelMediaExportRootContainerSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	*total_matches = _data_->total_matches;
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_export_root_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportRootContainerSearchData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_media_export_root_container_real_search_co (data);
}


static gboolean rygel_media_export_root_container_real_search_co (RygelMediaExportRootContainerSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->query_container = NULL;
		data->upnp_class = NULL;
#line 202 "rygel-media-export-root-container.vala"
		if (RYGEL_IS_RELATIONAL_EXPRESSION (data->expression)) {
#line 1045 "rygel-media-export-root-container.c"
			data->relational_expression = _rygel_search_expression_ref0 ((data->_tmp0_ = data->expression, RYGEL_IS_RELATIONAL_EXPRESSION (data->_tmp0_) ? ((RygelRelationalExpression*) data->_tmp0_) : NULL));
#line 205 "rygel-media-export-root-container.vala"
			data->query_container = (data->_tmp1_ = (RygelMediaContainer*) rygel_media_export_root_container_search_to_virtual_container (data->self, data->relational_expression), _g_object_unref0 (data->query_container), data->_tmp1_);
#line 207 "rygel-media-export-root-container.vala"
			data->upnp_class = (data->_tmp2_ = g_strdup ((const char*) ((RygelSearchExpression*) data->relational_expression)->operand2), _g_free0 (data->upnp_class), data->_tmp2_);
#line 1051 "rygel-media-export-root-container.c"
			_rygel_search_expression_unref0 (data->relational_expression);
		} else {
			data->_tmp3_ = NULL;
#line 208 "rygel-media-export-root-container.vala"
			if ((data->_tmp4_ = rygel_media_export_root_container_is_search_in_virtual_container (data->self, data->expression, &data->_tmp3_), data->query_container = (data->_tmp5_ = data->_tmp3_, _g_object_unref0 (data->query_container), data->_tmp5_), data->_tmp4_)) {
#line 1057 "rygel-media-export-root-container.c"
			}
		}
#line 213 "rygel-media-export-root-container.vala"
		if (data->query_container != NULL) {
#line 1062 "rygel-media-export-root-container.c"
			data->_state_ = 3;
			rygel_media_container_get_children (data->query_container, data->offset, data->max_count, data->cancellable, rygel_media_export_root_container_search_ready, data);
			return FALSE;
			_state_3:
			data->_tmp6_ = rygel_media_container_get_children_finish (data->query_container, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_free0 (data->upnp_class);
				_g_object_unref0 (data->query_container);
				_g_object_unref0 (data->list);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
#line 214 "rygel-media-export-root-container.vala"
			data->list = (data->_tmp7_ = data->_tmp6_, _g_object_unref0 (data->list), data->_tmp7_);
#line 217 "rygel-media-export-root-container.vala"
			data->total_matches = (guint) gee_collection_get_size ((GeeCollection*) data->list);
#line 219 "rygel-media-export-root-container.vala"
			if (data->upnp_class != NULL) {
#line 1090 "rygel-media-export-root-container.c"
				{
					data->_object_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) data->list);
#line 220 "rygel-media-export-root-container.vala"
					while (TRUE) {
#line 220 "rygel-media-export-root-container.vala"
						if (!gee_iterator_next (data->_object_it)) {
#line 220 "rygel-media-export-root-container.vala"
							break;
#line 1099 "rygel-media-export-root-container.c"
						}
						data->object = (RygelMediaObject*) gee_iterator_get (data->_object_it);
#line 221 "rygel-media-export-root-container.vala"
						data->object->upnp_class = (data->_tmp8_ = g_strdup (data->upnp_class), _g_free0 (data->object->upnp_class), data->_tmp8_);
#line 1104 "rygel-media-export-root-container.c"
						_g_object_unref0 (data->object);
					}
					_g_object_unref0 (data->_object_it);
				}
			}
			data->result = data->list;
			_g_free0 (data->upnp_class);
			_g_object_unref0 (data->query_container);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			data->_state_ = 4;
			RYGEL_MEDIA_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->search ((RygelMediaContainer*) RYGEL_MEDIA_EXPORT_DB_CONTAINER (data->self), data->expression, data->offset, data->max_count, data->cancellable, rygel_media_export_root_container_search_ready, data);
			return FALSE;
			_state_4:
			data->_tmp9_ = RYGEL_MEDIA_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->search_finish ((RygelMediaContainer*) RYGEL_MEDIA_EXPORT_DB_CONTAINER (data->self), data->_res_, &data->total_matches, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_free0 (data->upnp_class);
				_g_object_unref0 (data->query_container);
				_g_object_unref0 (data->list);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			data->result = data->_tmp9_;
			_g_free0 (data->upnp_class);
			_g_object_unref0 (data->query_container);
			_g_object_unref0 (data->list);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		_g_free0 (data->upnp_class);
		_g_object_unref0 (data->query_container);
		_g_object_unref0 (data->list);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 236 "rygel-media-export-root-container.vala"
char** rygel_media_export_root_container_get_dynamic_uris (RygelMediaExportRootContainer* self, int* result_length1) {
#line 1176 "rygel-media-export-root-container.c"
	char** result = NULL;
	GError * _inner_error_;
	char** _tmp2_;
#line 236 "rygel-media-export-root-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1182 "rygel-media-export-root-container.c"
	_inner_error_ = NULL;
	{
		GeeList* uris;
		gint _tmp0_;
		char** _tmp1_;
#line 238 "rygel-media-export-root-container.vala"
		uris = rygel_media_export_media_cache_get_flagged_uris (((RygelMediaExportDBContainer*) self)->media_db, "DBUS", &_inner_error_);
#line 1190 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			goto __catch24_g_error;
		}
		result = (_tmp1_ = gee_collection_to_array ((GeeCollection*) uris, &_tmp0_), *result_length1 = _tmp0_, _tmp1_);
		_g_object_unref0 (uris);
#line 240 "rygel-media-export-root-container.vala"
		return result;
#line 1198 "rygel-media-export-root-container.c"
		_g_object_unref0 (uris);
	}
	goto __finally24;
	__catch24_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (_error_);
		}
	}
	__finally24:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = (_tmp2_ = g_new0 (char*, 0 + 1), *result_length1 = 0, _tmp2_);
#line 243 "rygel-media-export-root-container.vala"
	return result;
#line 1220 "rygel-media-export-root-container.c"
}


#line 379 "rygel-media-export-root-container.vala"
static void _rygel_media_export_root_container_on_file_changed_rygel_media_export_recursive_file_monitor_changed (RygelMediaExportRecursiveFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
#line 1226 "rygel-media-export-root-container.c"
	rygel_media_export_root_container_on_file_changed (self, file, other_file, event_type);
}


#line 250 "rygel-media-export-root-container.vala"
static RygelMediaExportRootContainer* rygel_media_export_root_container_construct (GType object_type, GError** error) {
#line 1233 "rygel-media-export-root-container.c"
	GError * _inner_error_;
	RygelMediaExportRootContainer * self;
	RygelMediaExportObjectFactory* object_factory;
	RygelMediaExportMediaCache* db;
	RygelMediaExportMetadataExtractor* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeList* _tmp2_;
	RygelMediaExportRecursiveFileMonitor* _tmp3_;
	GeeArrayList* ids;
	GeeArrayList* uris;
	_inner_error_ = NULL;
#line 251 "rygel-media-export-root-container.vala"
	object_factory = rygel_media_export_object_factory_new ();
#line 252 "rygel-media-export-root-container.vala"
	db = rygel_media_export_media_cache_new_with_factory ("media-export", (RygelMediaExportDBObjectFactory*) object_factory, &_inner_error_);
#line 1249 "rygel-media-export-root-container.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (object_factory);
		_g_object_unref0 (self);
		return NULL;
	}
#line 254 "rygel-media-export-root-container.vala"
	self = (RygelMediaExportRootContainer*) rygel_media_export_db_container_construct (object_type, db, "0", "MediaExportRoot");
#line 256 "rygel-media-export-root-container.vala"
	self->priv->extractor = (_tmp0_ = rygel_media_export_metadata_extractor_new (), _g_object_unref0 (self->priv->extractor), _tmp0_);
#line 258 "rygel-media-export-root-container.vala"
	self->priv->harvester = (_tmp1_ = gee_hash_map_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_file_hash, g_file_equal, NULL), _g_object_unref0 (self->priv->harvester), _tmp1_);
#line 259 "rygel-media-export-root-container.vala"
	self->priv->harvester_trash = (_tmp2_ = (GeeList*) gee_array_list_new (RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL), _g_object_unref0 (self->priv->harvester_trash), _tmp2_);
#line 261 "rygel-media-export-root-container.vala"
	self->priv->monitor = (_tmp3_ = rygel_media_export_recursive_file_monitor_new (NULL), _g_object_unref0 (self->priv->monitor), _tmp3_);
#line 262 "rygel-media-export-root-container.vala"
	g_signal_connect_object (self->priv->monitor, "changed", (GCallback) _rygel_media_export_root_container_on_file_changed_rygel_media_export_recursive_file_monitor_changed, self, 0);
#line 1268 "rygel-media-export-root-container.c"
	{
		RygelMediaExportDBusService* _tmp4_;
		RygelMediaExportDBusService* _tmp5_;
#line 265 "rygel-media-export-root-container.vala"
		_tmp4_ = rygel_media_export_dbus_service_new (self, &_inner_error_);
#line 1274 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			goto __catch25_g_error;
		}
#line 265 "rygel-media-export-root-container.vala"
		self->priv->service = (_tmp5_ = _tmp4_, _g_object_unref0 (self->priv->service), _tmp5_);
#line 1280 "rygel-media-export-root-container.c"
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
#line 267 "rygel-media-export-root-container.vala"
			g_warning (_ ("Failed to create MediaExport DBus service: %s"), err->message);
#line 1291 "rygel-media-export-root-container.c"
			_g_error_free0 (err);
		}
	}
	__finally25:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (db);
		_g_object_unref0 (object_factory);
		_g_object_unref0 (self);
		return NULL;
	}
	{
		gint64 timestamp = 0LL;
		gboolean _tmp6_;
#line 273 "rygel-media-export-root-container.vala"
		_tmp6_ = rygel_media_export_media_cache_exists (((RygelMediaExportDBContainer*) self)->media_db, "0", &timestamp, &_inner_error_);
#line 1308 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			goto __catch26_g_error;
		}
#line 273 "rygel-media-export-root-container.vala"
		if (!_tmp6_) {
#line 274 "rygel-media-export-root-container.vala"
			rygel_media_export_media_cache_save_container (((RygelMediaExportDBContainer*) self)->media_db, (RygelMediaContainer*) self, &_inner_error_);
#line 1316 "rygel-media-export-root-container.c"
			if (_inner_error_ != NULL) {
				goto __catch26_g_error;
			}
		}
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (_error_);
		}
	}
	__finally26:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (db);
		_g_object_unref0 (object_factory);
		_g_object_unref0 (self);
		return NULL;
	}
	ids = NULL;
	{
		GeeArrayList* _tmp7_;
		GeeArrayList* _tmp8_;
#line 280 "rygel-media-export-root-container.vala"
		_tmp7_ = rygel_media_export_media_cache_get_child_ids (((RygelMediaExportDBContainer*) self)->media_db, "0", &_inner_error_);
#line 1346 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch27_rygel_media_export_database_error;
			}
			_g_object_unref0 (ids);
			_g_object_unref0 (db);
			_g_object_unref0 (object_factory);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 280 "rygel-media-export-root-container.vala"
		ids = (_tmp8_ = _tmp7_, _g_object_unref0 (ids), _tmp8_);
#line 1360 "rygel-media-export-root-container.c"
	}
	goto __finally27;
	__catch27_rygel_media_export_database_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GeeArrayList* _tmp9_;
#line 282 "rygel-media-export-root-container.vala"
			ids = (_tmp9_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL), _g_object_unref0 (ids), _tmp9_);
#line 1372 "rygel-media-export-root-container.c"
			_g_error_free0 (e);
		}
	}
	__finally27:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (ids);
		_g_object_unref0 (db);
		_g_object_unref0 (object_factory);
		_g_object_unref0 (self);
		return NULL;
	}
#line 285 "rygel-media-export-root-container.vala"
	uris = rygel_media_export_root_container_get_uris (self);
#line 1387 "rygel-media-export-root-container.c"
	{
		GeeIterator* _uri_it;
#line 286 "rygel-media-export-root-container.vala"
		_uri_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) uris);
#line 286 "rygel-media-export-root-container.vala"
		while (TRUE) {
#line 1394 "rygel-media-export-root-container.c"
			char* uri;
			GFile* file;
#line 286 "rygel-media-export-root-container.vala"
			if (!gee_iterator_next (_uri_it)) {
#line 286 "rygel-media-export-root-container.vala"
				break;
#line 1401 "rygel-media-export-root-container.c"
			}
#line 286 "rygel-media-export-root-container.vala"
			uri = (char*) gee_iterator_get (_uri_it);
#line 287 "rygel-media-export-root-container.vala"
			file = g_file_new_for_commandline_arg (uri);
#line 288 "rygel-media-export-root-container.vala"
			if (g_file_query_exists (file, NULL)) {
#line 1409 "rygel-media-export-root-container.c"
				char* _tmp10_;
				char* _tmp11_;
				char* id;
#line 289 "rygel-media-export-root-container.vala"
				id = (_tmp11_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp10_ = g_file_get_uri (file), -1), _g_free0 (_tmp10_), _tmp11_);
#line 291 "rygel-media-export-root-container.vala"
				gee_abstract_collection_remove ((GeeAbstractCollection*) ids, id);
#line 292 "rygel-media-export-root-container.vala"
				rygel_media_export_root_container_harvest (self, file, self, NULL);
#line 1419 "rygel-media-export-root-container.c"
				_g_free0 (id);
			}
			_g_object_unref0 (file);
			_g_free0 (uri);
		}
		_g_object_unref0 (_uri_it);
	}
	{
		RygelMetaConfig* config;
		GeeArrayList* virtual_containers;
#line 297 "rygel-media-export-root-container.vala"
		config = rygel_meta_config_get_default ();
#line 298 "rygel-media-export-root-container.vala"
		virtual_containers = rygel_configuration_get_string_list ((RygelConfiguration*) config, "MediaExport", "virtual-folders", &_inner_error_);
#line 1434 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			_g_object_unref0 (config);
			goto __catch28_g_error;
		}
		{
			GeeIterator* _container_it;
#line 301 "rygel-media-export-root-container.vala"
			_container_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) virtual_containers);
#line 301 "rygel-media-export-root-container.vala"
			while (TRUE) {
#line 1445 "rygel-media-export-root-container.c"
				char* container;
				char** _tmp13_;
				gint _info_size_;
				gint info_length1;
				char** _tmp12_;
				char** info;
				char* id;
				RygelMediaExportQueryContainer* virtual_container;
#line 301 "rygel-media-export-root-container.vala"
				if (!gee_iterator_next (_container_it)) {
#line 301 "rygel-media-export-root-container.vala"
					break;
#line 1458 "rygel-media-export-root-container.c"
				}
#line 301 "rygel-media-export-root-container.vala"
				container = (char*) gee_iterator_get (_container_it);
#line 1462 "rygel-media-export-root-container.c"
				info = (_tmp13_ = _tmp12_ = g_strsplit (container, "=", 0), info_length1 = _vala_array_length (_tmp12_), _info_size_ = info_length1, _tmp13_);
#line 303 "rygel-media-export-root-container.vala"
				id = g_strconcat (RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, info[1], NULL);
#line 304 "rygel-media-export-root-container.vala"
				if (!rygel_media_export_query_container_validate_virtual_id (id)) {
#line 305 "rygel-media-export-root-container.vala"
					g_warning (_ ("%s is not a valid virtual ID"), id);
#line 1470 "rygel-media-export-root-container.c"
					_g_free0 (id);
					info = (_vala_array_free (info, info_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (container);
#line 307 "rygel-media-export-root-container.vala"
					continue;
#line 1476 "rygel-media-export-root-container.c"
				}
#line 309 "rygel-media-export-root-container.vala"
				rygel_media_export_query_container_register_id (&id);
#line 311 "rygel-media-export-root-container.vala"
				virtual_container = rygel_media_export_query_container_new (((RygelMediaExportDBContainer*) self)->media_db, id, info[0]);
#line 315 "rygel-media-export-root-container.vala"
				((RygelMediaObject*) virtual_container)->parent = (RygelMediaContainer*) self;
#line 1484 "rygel-media-export-root-container.c"
				{
#line 317 "rygel-media-export-root-container.vala"
					rygel_media_export_media_cache_save_container (((RygelMediaExportDBContainer*) self)->media_db, (RygelMediaContainer*) virtual_container, &_inner_error_);
#line 1488 "rygel-media-export-root-container.c"
					if (_inner_error_ != NULL) {
						goto __catch29_g_error;
					}
				}
				goto __finally29;
				__catch29_g_error:
				{
					GError * _error_;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					{
						_g_error_free0 (_error_);
					}
				}
				__finally29:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (virtual_container);
					_g_free0 (id);
					info = (_vala_array_free (info, info_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (container);
					_g_object_unref0 (_container_it);
					_g_object_unref0 (virtual_containers);
					_g_object_unref0 (config);
					goto __catch28_g_error;
				}
#line 320 "rygel-media-export-root-container.vala"
				gee_abstract_collection_remove ((GeeAbstractCollection*) ids, id);
#line 1516 "rygel-media-export-root-container.c"
				_g_object_unref0 (virtual_container);
				_g_free0 (id);
				info = (_vala_array_free (info, info_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (container);
			}
			_g_object_unref0 (_container_it);
		}
		_g_object_unref0 (virtual_containers);
		_g_object_unref0 (config);
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 323 "rygel-media-export-root-container.vala"
			g_warning (_ ("Got error while trying to find virtual folders: %s"), _error_->message);
#line 1536 "rygel-media-export-root-container.c"
			_g_error_free0 (_error_);
		}
	}
	__finally28:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (uris);
		_g_object_unref0 (ids);
		_g_object_unref0 (db);
		_g_object_unref0 (object_factory);
		_g_object_unref0 (self);
		return NULL;
	}
	{
		GeeIterator* _id_it;
#line 327 "rygel-media-export-root-container.vala"
		_id_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) ids);
#line 327 "rygel-media-export-root-container.vala"
		while (TRUE) {
#line 1556 "rygel-media-export-root-container.c"
			char* id;
#line 327 "rygel-media-export-root-container.vala"
			if (!gee_iterator_next (_id_it)) {
#line 327 "rygel-media-export-root-container.vala"
				break;
#line 1562 "rygel-media-export-root-container.c"
			}
#line 327 "rygel-media-export-root-container.vala"
			id = (char*) gee_iterator_get (_id_it);
#line 328 "rygel-media-export-root-container.vala"
			g_debug (_ ("ID %s no longer in config, deleting..."), id);
#line 1568 "rygel-media-export-root-container.c"
			{
#line 330 "rygel-media-export-root-container.vala"
				rygel_media_export_media_cache_remove_by_id (((RygelMediaExportDBContainer*) self)->media_db, id, &_inner_error_);
#line 1572 "rygel-media-export-root-container.c"
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
						goto __catch30_rygel_media_export_database_error;
					}
					_g_free0 (id);
					_g_object_unref0 (_id_it);
					_g_object_unref0 (uris);
					_g_object_unref0 (ids);
					_g_object_unref0 (db);
					_g_object_unref0 (object_factory);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			goto __finally30;
			__catch30_rygel_media_export_database_error:
			{
				GError * _error_;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				{
#line 332 "rygel-media-export-root-container.vala"
					g_warning (_ ("Failed to remove entry: %s"), _error_->message);
#line 1597 "rygel-media-export-root-container.c"
					_g_error_free0 (_error_);
				}
			}
			__finally30:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (id);
				_g_object_unref0 (_id_it);
				_g_object_unref0 (uris);
				_g_object_unref0 (ids);
				_g_object_unref0 (db);
				_g_object_unref0 (object_factory);
				_g_object_unref0 (self);
				return NULL;
			}
			_g_free0 (id);
		}
		_g_object_unref0 (_id_it);
	}
#line 336 "rygel-media-export-root-container.vala"
	rygel_media_container_updated ((RygelMediaContainer*) self);
#line 1619 "rygel-media-export-root-container.c"
	_g_object_unref0 (uris);
	_g_object_unref0 (ids);
	_g_object_unref0 (db);
	_g_object_unref0 (object_factory);
	return self;
}


#line 250 "rygel-media-export-root-container.vala"
static RygelMediaExportRootContainer* rygel_media_export_root_container_new (GError** error) {
#line 250 "rygel-media-export-root-container.vala"
	return rygel_media_export_root_container_construct (RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, error);
#line 1632 "rygel-media-export-root-container.c"
}


#line 339 "rygel-media-export-root-container.vala"
static void rygel_media_export_root_container_on_file_harvested (RygelMediaExportRootContainer* self, RygelMediaExportHarvester* harvester, GFile* file) {
#line 1638 "rygel-media-export-root-container.c"
	char* _tmp0_;
#line 339 "rygel-media-export-root-container.vala"
	g_return_if_fail (self != NULL);
#line 339 "rygel-media-export-root-container.vala"
	g_return_if_fail (harvester != NULL);
#line 339 "rygel-media-export-root-container.vala"
	g_return_if_fail (file != NULL);
#line 341 "rygel-media-export-root-container.vala"
	g_message (_ ("'%s' harvested"), _tmp0_ = g_file_get_uri (file));
#line 1648 "rygel-media-export-root-container.c"
	_g_free0 (_tmp0_);
#line 343 "rygel-media-export-root-container.vala"
	gee_map_remove ((GeeMap*) self->priv->harvester, file, NULL);
#line 1652 "rygel-media-export-root-container.c"
}


#line 346 "rygel-media-export-root-container.vala"
static void rygel_media_export_root_container_on_remove_cancelled_harvester (RygelMediaExportRootContainer* self, RygelMediaExportHarvester* harvester, GFile* file) {
#line 346 "rygel-media-export-root-container.vala"
	g_return_if_fail (self != NULL);
#line 346 "rygel-media-export-root-container.vala"
	g_return_if_fail (harvester != NULL);
#line 346 "rygel-media-export-root-container.vala"
	g_return_if_fail (file != NULL);
#line 348 "rygel-media-export-root-container.vala"
	gee_collection_remove ((GeeCollection*) self->priv->harvester_trash, harvester);
#line 1666 "rygel-media-export-root-container.c"
}


#line 339 "rygel-media-export-root-container.vala"
static void _rygel_media_export_root_container_on_file_harvested_rygel_media_export_harvester_harvested (RygelMediaExportHarvester* _sender, GFile* file, gpointer self) {
#line 1672 "rygel-media-export-root-container.c"
	rygel_media_export_root_container_on_file_harvested (self, _sender, file);
}


#line 346 "rygel-media-export-root-container.vala"
static void _rygel_media_export_root_container_on_remove_cancelled_harvester_rygel_media_export_harvester_harvested (RygelMediaExportHarvester* _sender, GFile* file, gpointer self) {
#line 1679 "rygel-media-export-root-container.c"
	rygel_media_export_root_container_on_remove_cancelled_harvester (self, _sender, file);
}


#line 351 "rygel-media-export-root-container.vala"
static void rygel_media_export_root_container_harvest (RygelMediaExportRootContainer* self, GFile* file, RygelMediaContainer* parent, const char* flag) {
#line 1686 "rygel-media-export-root-container.c"
	RygelMediaExportHarvester* harvester;
#line 351 "rygel-media-export-root-container.vala"
	g_return_if_fail (self != NULL);
#line 351 "rygel-media-export-root-container.vala"
	g_return_if_fail (file != NULL);
#line 351 "rygel-media-export-root-container.vala"
	g_return_if_fail (parent != NULL);
#line 354 "rygel-media-export-root-container.vala"
	if (self->priv->extractor == NULL) {
#line 355 "rygel-media-export-root-container.vala"
		g_warning ("rygel-media-export-root-container.vala:355: %s", _ ("No Metadata extractor available. Will not crawl"));
#line 357 "rygel-media-export-root-container.vala"
		return;
#line 1700 "rygel-media-export-root-container.c"
	}
#line 360 "rygel-media-export-root-container.vala"
	if (gee_map_contains ((GeeMap*) self->priv->harvester, file)) {
#line 1704 "rygel-media-export-root-container.c"
		RygelMediaExportHarvester* harvester;
		guint _tmp0_;
#line 361 "rygel-media-export-root-container.vala"
		g_debug ("rygel-media-export-root-container.vala:361: %s", _ ("Already harvesting; cancelling"));
#line 1709 "rygel-media-export-root-container.c"
		harvester = (RygelMediaExportHarvester*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->harvester, file);
#line 363 "rygel-media-export-root-container.vala"
		g_signal_parse_name ("harvested", RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, &_tmp0_, NULL, FALSE);
#line 363 "rygel-media-export-root-container.vala"
		g_signal_handlers_disconnect_matched (harvester, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _rygel_media_export_root_container_on_file_harvested_rygel_media_export_harvester_harvested, self);
#line 364 "rygel-media-export-root-container.vala"
		g_cancellable_cancel (harvester->cancellable);
#line 365 "rygel-media-export-root-container.vala"
		g_signal_connect_object (harvester, "harvested", (GCallback) _rygel_media_export_root_container_on_remove_cancelled_harvester_rygel_media_export_harvester_harvested, self, 0);
#line 366 "rygel-media-export-root-container.vala"
		gee_collection_add ((GeeCollection*) self->priv->harvester_trash, harvester);
#line 1721 "rygel-media-export-root-container.c"
		_g_object_unref0 (harvester);
	}
#line 369 "rygel-media-export-root-container.vala"
	harvester = rygel_media_export_harvester_new (parent, ((RygelMediaExportDBContainer*) self)->media_db, self->priv->extractor, self->priv->monitor, flag);
#line 374 "rygel-media-export-root-container.vala"
	g_signal_connect_object (harvester, "harvested", (GCallback) _rygel_media_export_root_container_on_file_harvested_rygel_media_export_harvester_harvested, self, 0);
#line 375 "rygel-media-export-root-container.vala"
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->harvester, file, harvester);
#line 376 "rygel-media-export-root-container.vala"
	rygel_media_export_harvester_harvest (harvester, file, NULL, NULL);
#line 1732 "rygel-media-export-root-container.c"
	_g_object_unref0 (harvester);
}


#line 379 "rygel-media-export-root-container.vala"
static void rygel_media_export_root_container_on_file_changed (RygelMediaExportRootContainer* self, GFile* file, GFile* other, GFileMonitorEvent event) {
#line 1739 "rygel-media-export-root-container.c"
	GError * _inner_error_;
#line 379 "rygel-media-export-root-container.vala"
	g_return_if_fail (self != NULL);
#line 379 "rygel-media-export-root-container.vala"
	g_return_if_fail (file != NULL);
#line 1745 "rygel-media-export-root-container.c"
	_inner_error_ = NULL;
#line 382 "rygel-media-export-root-container.vala"
	switch (event) {
#line 1749 "rygel-media-export-root-container.c"
		case G_FILE_MONITOR_EVENT_CREATED:
		case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
		{
			char* _tmp0_;
			GFile* parent;
			char* _tmp1_;
			char* _tmp2_;
			char* id;
#line 385 "rygel-media-export-root-container.vala"
			g_debug (_ ("Trying to harvest %s because of %d"), _tmp0_ = g_file_get_uri (file), event);
#line 1760 "rygel-media-export-root-container.c"
			_g_free0 (_tmp0_);
#line 388 "rygel-media-export-root-container.vala"
			parent = g_file_get_parent (file);
#line 389 "rygel-media-export-root-container.vala"
			id = (_tmp2_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp1_ = g_file_get_uri (parent), -1), _g_free0 (_tmp1_), _tmp2_);
#line 1766 "rygel-media-export-root-container.c"
			{
				RygelMediaObject* _tmp3_;
				RygelMediaObject* _tmp4_;
				RygelMediaContainer* parent_container;
#line 392 "rygel-media-export-root-container.vala"
				_tmp3_ = rygel_media_export_media_cache_get_object (((RygelMediaExportDBContainer*) self)->media_db, id, &_inner_error_);
#line 1773 "rygel-media-export-root-container.c"
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
						goto __catch31_rygel_media_export_database_error;
					}
					_g_free0 (id);
					_g_object_unref0 (parent);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
#line 392 "rygel-media-export-root-container.vala"
				parent_container = (_tmp4_ = _tmp3_, RYGEL_IS_MEDIA_CONTAINER (_tmp4_) ? ((RygelMediaContainer*) _tmp4_) : NULL);
#line 394 "rygel-media-export-root-container.vala"
				g_assert (parent_container != NULL);
#line 396 "rygel-media-export-root-container.vala"
				rygel_media_export_root_container_harvest (self, file, parent_container, NULL);
#line 1790 "rygel-media-export-root-container.c"
				_g_object_unref0 (parent_container);
			}
			goto __finally31;
			__catch31_rygel_media_export_database_error:
			{
				GError * _error_;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				{
#line 398 "rygel-media-export-root-container.vala"
					g_warning (_ ("Error fetching object '%s' from database: %s"), id, _error_->message);
#line 1802 "rygel-media-export-root-container.c"
					_g_error_free0 (_error_);
				}
			}
			__finally31:
			if (_inner_error_ != NULL) {
				_g_free0 (id);
				_g_object_unref0 (parent);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_free0 (id);
			_g_object_unref0 (parent);
#line 402 "rygel-media-export-root-container.vala"
			break;
#line 1818 "rygel-media-export-root-container.c"
		}
		case G_FILE_MONITOR_EVENT_DELETED:
		{
			char* _tmp5_;
			char* _tmp6_;
			char* id;
#line 404 "rygel-media-export-root-container.vala"
			id = (_tmp6_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp5_ = g_file_get_uri (file), -1), _g_free0 (_tmp5_), _tmp6_);
#line 1827 "rygel-media-export-root-container.c"
			{
				RygelMediaObject* obj;
#line 411 "rygel-media-export-root-container.vala"
				obj = rygel_media_export_media_cache_get_object (((RygelMediaExportDBContainer*) self)->media_db, id, &_inner_error_);
#line 1832 "rygel-media-export-root-container.c"
				if (_inner_error_ != NULL) {
					goto __catch32_g_error;
				}
#line 415 "rygel-media-export-root-container.vala"
				if (obj != NULL) {
#line 416 "rygel-media-export-root-container.vala"
					rygel_media_export_media_cache_remove_object (((RygelMediaExportDBContainer*) self)->media_db, obj, &_inner_error_);
#line 1840 "rygel-media-export-root-container.c"
					if (_inner_error_ != NULL) {
						_g_object_unref0 (obj);
						goto __catch32_g_error;
					}
#line 417 "rygel-media-export-root-container.vala"
					if (obj->parent != NULL) {
#line 418 "rygel-media-export-root-container.vala"
						rygel_media_container_updated (obj->parent);
#line 1849 "rygel-media-export-root-container.c"
					}
				}
				_g_object_unref0 (obj);
			}
			goto __finally32;
			__catch32_g_error:
			{
				GError * _error_;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				{
#line 422 "rygel-media-export-root-container.vala"
					g_warning (_ ("Error removing object from database: %s"), _error_->message);
#line 1863 "rygel-media-export-root-container.c"
					_g_error_free0 (_error_);
				}
			}
			__finally32:
			if (_inner_error_ != NULL) {
				_g_free0 (id);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_free0 (id);
#line 425 "rygel-media-export-root-container.vala"
			break;
#line 1877 "rygel-media-export-root-container.c"
		}
		default:
		{
#line 427 "rygel-media-export-root-container.vala"
			break;
#line 1883 "rygel-media-export-root-container.c"
		}
	}
}


static void rygel_media_export_root_container_class_init (RygelMediaExportRootContainerClass * klass) {
	rygel_media_export_root_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportRootContainerPrivate));
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object = rygel_media_export_root_container_real_find_object;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object_finish = rygel_media_export_root_container_real_find_object_finish;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->search = rygel_media_export_root_container_real_search;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->search_finish = rygel_media_export_root_container_real_search_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_root_container_finalize;
}


static void rygel_media_export_root_container_instance_init (RygelMediaExportRootContainer * self) {
	self->priv = RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_GET_PRIVATE (self);
}


static void rygel_media_export_root_container_finalize (GObject* obj) {
	RygelMediaExportRootContainer * self;
	self = RYGEL_MEDIA_EXPORT_ROOT_CONTAINER (obj);
	_g_object_unref0 (self->priv->extractor);
	_g_object_unref0 (self->priv->harvester);
	_g_object_unref0 (self->priv->monitor);
	_g_object_unref0 (self->priv->service);
	_g_object_unref0 (self->priv->harvester_trash);
	G_OBJECT_CLASS (rygel_media_export_root_container_parent_class)->finalize (obj);
}


GType rygel_media_export_root_container_get_type (void) {
	static volatile gsize rygel_media_export_root_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_root_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportRootContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_root_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportRootContainer), 0, (GInstanceInitFunc) rygel_media_export_root_container_instance_init, NULL };
		GType rygel_media_export_root_container_type_id;
		rygel_media_export_root_container_type_id = g_type_register_static (RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, "RygelMediaExportRootContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_root_container_type_id__volatile, rygel_media_export_root_container_type_id);
	}
	return rygel_media_export_root_container_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




