/* rygel-wmv-transcoder.c generated by valac, the Vala compiler
 * generated from rygel-wmv-transcoder.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
typedef struct _RygelTranscoderPrivate RygelTranscoderPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_WMV_TRANSCODER (rygel_wmv_transcoder_get_type ())
#define RYGEL_WMV_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WMV_TRANSCODER, RygelWMVTranscoder))
#define RYGEL_WMV_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_WMV_TRANSCODER, RygelWMVTranscoderClass))
#define RYGEL_IS_WMV_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WMV_TRANSCODER))
#define RYGEL_IS_WMV_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_WMV_TRANSCODER))
#define RYGEL_WMV_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_WMV_TRANSCODER, RygelWMVTranscoderClass))

typedef struct _RygelWMVTranscoder RygelWMVTranscoder;
typedef struct _RygelWMVTranscoderClass RygelWMVTranscoderClass;
typedef struct _RygelWMVTranscoderPrivate RygelWMVTranscoderPrivate;

#define RYGEL_TYPE_WMV_TRANSCODER_BIN (rygel_wmv_transcoder_bin_get_type ())
#define RYGEL_WMV_TRANSCODER_BIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WMV_TRANSCODER_BIN, RygelWMVTranscoderBin))
#define RYGEL_WMV_TRANSCODER_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_WMV_TRANSCODER_BIN, RygelWMVTranscoderBinClass))
#define RYGEL_IS_WMV_TRANSCODER_BIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WMV_TRANSCODER_BIN))
#define RYGEL_IS_WMV_TRANSCODER_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_WMV_TRANSCODER_BIN))
#define RYGEL_WMV_TRANSCODER_BIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_WMV_TRANSCODER_BIN, RygelWMVTranscoderBinClass))

typedef struct _RygelWMVTranscoderBin RygelWMVTranscoderBin;
typedef struct _RygelWMVTranscoderBinClass RygelWMVTranscoderBinClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

struct _RygelTranscoder {
	GObject parent_instance;
	RygelTranscoderPrivate * priv;
};

struct _RygelTranscoderClass {
	GObjectClass parent_class;
	GstElement* (*create_source) (RygelTranscoder* self, RygelMediaItem* item, GstElement* src, GError** error);
	GUPnPDIDLLiteResource* (*add_resource) (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
	guint (*get_distance) (RygelTranscoder* self, RygelMediaItem* item);
};

struct _RygelWMVTranscoder {
	RygelTranscoder parent_instance;
	RygelWMVTranscoderPrivate * priv;
};

struct _RygelWMVTranscoderClass {
	RygelTranscoderClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	char* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const char* property);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	char* author;
	char* album;
	char* date;
	char* mime_type;
	char* dlna_profile;
	glong size;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint n_audio_channels;
	gint track_number;
	gint width;
	gint height;
	gint pixel_width;
	gint pixel_height;
	gint color_depth;
	GeeArrayList* thumbnails;
	GeeArrayList* subtitles;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*should_stream) (RygelMediaItem* self);
};


static gpointer rygel_wmv_transcoder_parent_class = NULL;

GType rygel_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_wmv_transcoder_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_WMV_TRANSCODER_DUMMY_PROPERTY
};
#define RYGEL_WMV_TRANSCODER_VIDEO_BITRATE 1200
#define RYGEL_WMV_TRANSCODER_BITRATE 1200000
#define RYGEL_WMV_TRANSCODER_VIDEO_ENCODER "ffenc_wmv1"
#define RYGEL_WMV_TRANSCODER_COLORSPACE_CONVERT "ffmpegcolorspace"
#define RYGEL_WMV_TRANSCODER_VIDEO_RATE "videorate"
#define RYGEL_WMV_TRANSCODER_VIDEO_SCALE "videoscale"
#define RYGEL_MEDIA_ITEM_VIDEO_CLASS "object.item.videoItem"
RygelTranscoder* rygel_transcoder_construct (GType object_type, const char* mime_type, const char* dlna_profile, const char* upnp_class);
RygelWMVTranscoder* rygel_wmv_transcoder_new (void);
RygelWMVTranscoder* rygel_wmv_transcoder_construct (GType object_type);
RygelWMVTranscoderBin* rygel_wmv_transcoder_bin_new (RygelMediaItem* item, GstElement* src, RygelWMVTranscoder* transcoder, GError** error);
RygelWMVTranscoderBin* rygel_wmv_transcoder_bin_construct (GType object_type, RygelMediaItem* item, GstElement* src, RygelWMVTranscoder* transcoder, GError** error);
GType rygel_wmv_transcoder_bin_get_type (void) G_GNUC_CONST;
static GstElement* rygel_wmv_transcoder_real_create_source (RygelTranscoder* base, RygelMediaItem* item, GstElement* src, GError** error);
GUPnPDIDLLiteResource* rygel_transcoder_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
#define RYGEL_WMA_TRANSCODER_BITRATE 64
static GUPnPDIDLLiteResource* rygel_wmv_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
#define RYGEL_MEDIA_ITEM_IMAGE_CLASS "object.item.imageItem"
static guint rygel_wmv_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item);
GstElement* rygel_gst_utils_create_element (const char* factoryname, const char* name, GError** error);
static inline void _dynamic_set_bitrate8 (GstElement* obj, gint value);
GstElement* rygel_wmv_transcoder_create_encoder (RygelWMVTranscoder* self, RygelMediaItem* item, const char* src_pad_name, const char* sink_pad_name, GError** error);



#line 34 "rygel-wmv-transcoder.vala"
RygelWMVTranscoder* rygel_wmv_transcoder_construct (GType object_type) {
#line 263 "rygel-wmv-transcoder.c"
	RygelWMVTranscoder * self;
#line 35 "rygel-wmv-transcoder.vala"
	self = (RygelWMVTranscoder*) rygel_transcoder_construct (object_type, "video/x-ms-wmv", "WMV", RYGEL_MEDIA_ITEM_VIDEO_CLASS);
#line 267 "rygel-wmv-transcoder.c"
	return self;
}


#line 34 "rygel-wmv-transcoder.vala"
RygelWMVTranscoder* rygel_wmv_transcoder_new (void) {
#line 34 "rygel-wmv-transcoder.vala"
	return rygel_wmv_transcoder_construct (RYGEL_TYPE_WMV_TRANSCODER);
#line 276 "rygel-wmv-transcoder.c"
}


#line 38 "rygel-wmv-transcoder.vala"
static GstElement* rygel_wmv_transcoder_real_create_source (RygelTranscoder* base, RygelMediaItem* item, GstElement* src, GError** error) {
#line 282 "rygel-wmv-transcoder.c"
	RygelWMVTranscoder * self;
	GstElement* result = NULL;
	GError * _inner_error_;
	RygelWMVTranscoderBin* _tmp0_;
	self = (RygelWMVTranscoder*) base;
#line 38 "rygel-wmv-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 38 "rygel-wmv-transcoder.vala"
	g_return_val_if_fail (src != NULL, NULL);
#line 292 "rygel-wmv-transcoder.c"
	_inner_error_ = NULL;
#line 41 "rygel-wmv-transcoder.vala"
	_tmp0_ = rygel_wmv_transcoder_bin_new (item, src, self, &_inner_error_);
#line 296 "rygel-wmv-transcoder.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = (GstElement*) _tmp0_;
#line 41 "rygel-wmv-transcoder.vala"
	return result;
#line 304 "rygel-wmv-transcoder.c"
}


#line 44 "rygel-wmv-transcoder.vala"
static GUPnPDIDLLiteResource* rygel_wmv_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error) {
#line 310 "rygel-wmv-transcoder.c"
	RygelWMVTranscoder * self;
	GUPnPDIDLLiteResource* result = NULL;
	GError * _inner_error_;
	GUPnPDIDLLiteResource* resource;
	self = (RygelWMVTranscoder*) base;
#line 44 "rygel-wmv-transcoder.vala"
	g_return_val_if_fail (didl_item != NULL, NULL);
#line 44 "rygel-wmv-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 44 "rygel-wmv-transcoder.vala"
	g_return_val_if_fail (manager != NULL, NULL);
#line 322 "rygel-wmv-transcoder.c"
	_inner_error_ = NULL;
#line 48 "rygel-wmv-transcoder.vala"
	resource = RYGEL_TRANSCODER_CLASS (rygel_wmv_transcoder_parent_class)->add_resource (RYGEL_TRANSCODER (self), didl_item, item, manager, &_inner_error_);
#line 326 "rygel-wmv-transcoder.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
#line 49 "rygel-wmv-transcoder.vala"
	if (resource == NULL) {
#line 333 "rygel-wmv-transcoder.c"
		result = NULL;
		_g_object_unref0 (resource);
#line 50 "rygel-wmv-transcoder.vala"
		return result;
#line 338 "rygel-wmv-transcoder.c"
	}
#line 52 "rygel-wmv-transcoder.vala"
	gupnp_didl_lite_resource_set_width (resource, item->width);
#line 53 "rygel-wmv-transcoder.vala"
	gupnp_didl_lite_resource_set_height (resource, item->height);
#line 54 "rygel-wmv-transcoder.vala"
	gupnp_didl_lite_resource_set_bitrate (resource, ((RYGEL_WMV_TRANSCODER_VIDEO_BITRATE + RYGEL_WMA_TRANSCODER_BITRATE) * 1000) / 8);
#line 346 "rygel-wmv-transcoder.c"
	result = resource;
#line 56 "rygel-wmv-transcoder.vala"
	return result;
#line 350 "rygel-wmv-transcoder.c"
}


#line 59 "rygel-wmv-transcoder.vala"
static guint rygel_wmv_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item) {
#line 356 "rygel-wmv-transcoder.c"
	RygelWMVTranscoder * self;
	guint result = 0U;
	guint distance = 0U;
	self = (RygelWMVTranscoder*) base;
#line 59 "rygel-wmv-transcoder.vala"
	g_return_val_if_fail (item != NULL, 0U);
#line 60 "rygel-wmv-transcoder.vala"
	if (g_str_has_prefix (((RygelMediaObject*) item)->upnp_class, RYGEL_MEDIA_ITEM_IMAGE_CLASS)) {
#line 365 "rygel-wmv-transcoder.c"
		result = G_MAXUINT;
#line 61 "rygel-wmv-transcoder.vala"
		return result;
#line 369 "rygel-wmv-transcoder.c"
	}
#line 66 "rygel-wmv-transcoder.vala"
	if (g_str_has_prefix (((RygelMediaObject*) item)->upnp_class, RYGEL_MEDIA_ITEM_VIDEO_CLASS)) {
#line 67 "rygel-wmv-transcoder.vala"
		distance = 0;
#line 69 "rygel-wmv-transcoder.vala"
		if (item->bitrate > 0) {
#line 70 "rygel-wmv-transcoder.vala"
			distance = distance + ((guint) abs (item->bitrate - RYGEL_WMV_TRANSCODER_BITRATE));
#line 379 "rygel-wmv-transcoder.c"
		}
	} else {
#line 73 "rygel-wmv-transcoder.vala"
		distance = G_MAXUINT / 2;
#line 384 "rygel-wmv-transcoder.c"
	}
	result = distance;
#line 76 "rygel-wmv-transcoder.vala"
	return result;
#line 389 "rygel-wmv-transcoder.c"
}


static inline void _dynamic_set_bitrate8 (GstElement* obj, gint value) {
	g_object_set (obj, "bitrate", value, NULL);
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


#line 79 "rygel-wmv-transcoder.vala"
GstElement* rygel_wmv_transcoder_create_encoder (RygelWMVTranscoder* self, RygelMediaItem* item, const char* src_pad_name, const char* sink_pad_name, GError** error) {
#line 405 "rygel-wmv-transcoder.c"
	GstElement* result = NULL;
	GError * _inner_error_;
	GstElement* convert;
	GstElement* encoder;
	GstBin* bin;
	GstPad* pad;
	GstGhostPad* ghost;
	GstPad* _tmp0_;
	GstGhostPad* _tmp1_;
#line 79 "rygel-wmv-transcoder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 79 "rygel-wmv-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 419 "rygel-wmv-transcoder.c"
	_inner_error_ = NULL;
#line 83 "rygel-wmv-transcoder.vala"
	convert = rygel_gst_utils_create_element (RYGEL_WMV_TRANSCODER_COLORSPACE_CONVERT, RYGEL_WMV_TRANSCODER_COLORSPACE_CONVERT, &_inner_error_);
#line 423 "rygel-wmv-transcoder.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
#line 85 "rygel-wmv-transcoder.vala"
	encoder = rygel_gst_utils_create_element (RYGEL_WMV_TRANSCODER_VIDEO_ENCODER, RYGEL_WMV_TRANSCODER_VIDEO_ENCODER, &_inner_error_);
#line 430 "rygel-wmv-transcoder.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_gst_object_unref0 (convert);
		return NULL;
	}
#line 88 "rygel-wmv-transcoder.vala"
	_dynamic_set_bitrate8 (encoder, ((gint) RYGEL_WMV_TRANSCODER_VIDEO_BITRATE) * 1000);
#line 90 "rygel-wmv-transcoder.vala"
	bin = (GstBin*) gst_bin_new ("video-encoder-bin");
#line 91 "rygel-wmv-transcoder.vala"
	gst_bin_add_many (bin, _gst_object_ref0 (convert), _gst_object_ref0 (encoder), NULL);
#line 92 "rygel-wmv-transcoder.vala"
	gst_element_link (convert, encoder);
#line 94 "rygel-wmv-transcoder.vala"
	pad = gst_element_get_static_pad (convert, "sink");
#line 95 "rygel-wmv-transcoder.vala"
	ghost = (GstGhostPad*) gst_ghost_pad_new (sink_pad_name, pad);
#line 96 "rygel-wmv-transcoder.vala"
	gst_element_add_pad ((GstElement*) bin, _gst_object_ref0 ((GstPad*) ghost));
#line 98 "rygel-wmv-transcoder.vala"
	pad = (_tmp0_ = gst_element_get_static_pad (encoder, "src"), _gst_object_unref0 (pad), _tmp0_);
#line 99 "rygel-wmv-transcoder.vala"
	ghost = (_tmp1_ = (GstGhostPad*) gst_ghost_pad_new (src_pad_name, pad), _gst_object_unref0 (ghost), _tmp1_);
#line 100 "rygel-wmv-transcoder.vala"
	gst_element_add_pad ((GstElement*) bin, _gst_object_ref0 ((GstPad*) ghost));
#line 456 "rygel-wmv-transcoder.c"
	result = (GstElement*) bin;
	_gst_object_unref0 (ghost);
	_gst_object_unref0 (pad);
	_gst_object_unref0 (encoder);
	_gst_object_unref0 (convert);
#line 102 "rygel-wmv-transcoder.vala"
	return result;
#line 464 "rygel-wmv-transcoder.c"
}


static void rygel_wmv_transcoder_class_init (RygelWMVTranscoderClass * klass) {
	rygel_wmv_transcoder_parent_class = g_type_class_peek_parent (klass);
	RYGEL_TRANSCODER_CLASS (klass)->create_source = rygel_wmv_transcoder_real_create_source;
	RYGEL_TRANSCODER_CLASS (klass)->add_resource = rygel_wmv_transcoder_real_add_resource;
	RYGEL_TRANSCODER_CLASS (klass)->get_distance = rygel_wmv_transcoder_real_get_distance;
}


static void rygel_wmv_transcoder_instance_init (RygelWMVTranscoder * self) {
}


GType rygel_wmv_transcoder_get_type (void) {
	static volatile gsize rygel_wmv_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_wmv_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelWMVTranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_wmv_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelWMVTranscoder), 0, (GInstanceInitFunc) rygel_wmv_transcoder_instance_init, NULL };
		GType rygel_wmv_transcoder_type_id;
		rygel_wmv_transcoder_type_id = g_type_register_static (RYGEL_TYPE_TRANSCODER, "RygelWMVTranscoder", &g_define_type_info, 0);
		g_once_init_leave (&rygel_wmv_transcoder_type_id__volatile, rygel_wmv_transcoder_type_id);
	}
	return rygel_wmv_transcoder_type_id__volatile;
}




