/* rygel-gst-launch-root-container.c generated by valac, the Vala compiler
 * generated from rygel-gst-launch-root-container.vala, do not modify */

/*
 * Copyright (C) 2009 Thijs Vermeir <thijsvermeir@gmail.com>
 *
 * Author: Thijs Vermeir <thijsvermeir@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define RYGEL_GST_LAUNCH_TYPE_ROOT_CONTAINER (rygel_gst_launch_root_container_get_type ())
#define RYGEL_GST_LAUNCH_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_GST_LAUNCH_TYPE_ROOT_CONTAINER, RygelGstLaunchRootContainer))
#define RYGEL_GST_LAUNCH_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_GST_LAUNCH_TYPE_ROOT_CONTAINER, RygelGstLaunchRootContainerClass))
#define RYGEL_GST_LAUNCH_IS_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_GST_LAUNCH_TYPE_ROOT_CONTAINER))
#define RYGEL_GST_LAUNCH_IS_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_GST_LAUNCH_TYPE_ROOT_CONTAINER))
#define RYGEL_GST_LAUNCH_ROOT_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_GST_LAUNCH_TYPE_ROOT_CONTAINER, RygelGstLaunchRootContainerClass))

typedef struct _RygelGstLaunchRootContainer RygelGstLaunchRootContainer;
typedef struct _RygelGstLaunchRootContainerClass RygelGstLaunchRootContainerClass;
typedef struct _RygelGstLaunchRootContainerPrivate RygelGstLaunchRootContainerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_GST_LAUNCH_TYPE_ITEM (rygel_gst_launch_item_get_type ())
#define RYGEL_GST_LAUNCH_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_GST_LAUNCH_TYPE_ITEM, RygelGstLaunchItem))
#define RYGEL_GST_LAUNCH_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_GST_LAUNCH_TYPE_ITEM, RygelGstLaunchItemClass))
#define RYGEL_GST_LAUNCH_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_GST_LAUNCH_TYPE_ITEM))
#define RYGEL_GST_LAUNCH_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_GST_LAUNCH_TYPE_ITEM))
#define RYGEL_GST_LAUNCH_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_GST_LAUNCH_TYPE_ITEM, RygelGstLaunchItemClass))

typedef struct _RygelGstLaunchItem RygelGstLaunchItem;
typedef struct _RygelGstLaunchItemClass RygelGstLaunchItemClass;

struct _RygelGstLaunchRootContainer {
	RygelSimpleContainer parent_instance;
	RygelGstLaunchRootContainerPrivate * priv;
};

struct _RygelGstLaunchRootContainerClass {
	RygelSimpleContainerClass parent_class;
};

struct _RygelGstLaunchRootContainerPrivate {
	RygelMetaConfig* config;
};


static gpointer rygel_gst_launch_root_container_parent_class = NULL;

GType rygel_gst_launch_root_container_get_type (void) G_GNUC_CONST;
#define RYGEL_GST_LAUNCH_ROOT_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_GST_LAUNCH_TYPE_ROOT_CONTAINER, RygelGstLaunchRootContainerPrivate))
enum  {
	RYGEL_GST_LAUNCH_ROOT_CONTAINER_DUMMY_PROPERTY
};
#define RYGEL_GST_LAUNCH_ROOT_CONTAINER_CONFIG_GROUP "GstLaunch"
#define RYGEL_GST_LAUNCH_ROOT_CONTAINER_ITEM_NAMES "launch_items"
static void rygel_gst_launch_root_container_add_launch_item (RygelGstLaunchRootContainer* self, const char* name);
RygelGstLaunchRootContainer* rygel_gst_launch_root_container_new (const char* title);
RygelGstLaunchRootContainer* rygel_gst_launch_root_container_construct (GType object_type, const char* title);
RygelGstLaunchItem* rygel_gst_launch_item_new (const char* id, RygelMediaContainer* parent, const char* title, const char* mime_type, const char* launch_line);
RygelGstLaunchItem* rygel_gst_launch_item_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* mime_type, const char* launch_line);
GType rygel_gst_launch_item_get_type (void) G_GNUC_CONST;
static void rygel_gst_launch_root_container_finalize (GObject* obj);



#line 37 "rygel-gst-launch-root-container.vala"
RygelGstLaunchRootContainer* rygel_gst_launch_root_container_construct (GType object_type, const char* title) {
#line 94 "rygel-gst-launch-root-container.c"
	GError * _inner_error_;
	RygelGstLaunchRootContainer * self;
#line 37 "rygel-gst-launch-root-container.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 99 "rygel-gst-launch-root-container.c"
	_inner_error_ = NULL;
#line 38 "rygel-gst-launch-root-container.vala"
	self = (RygelGstLaunchRootContainer*) rygel_simple_container_construct_root (object_type, title);
#line 103 "rygel-gst-launch-root-container.c"
	{
		RygelMetaConfig* _tmp0_;
		GeeArrayList* item_names;
#line 41 "rygel-gst-launch-root-container.vala"
		self->priv->config = (_tmp0_ = rygel_meta_config_get_default (), _g_object_unref0 (self->priv->config), _tmp0_);
#line 43 "rygel-gst-launch-root-container.vala"
		item_names = rygel_configuration_get_string_list ((RygelConfiguration*) self->priv->config, RYGEL_GST_LAUNCH_ROOT_CONTAINER_CONFIG_GROUP, RYGEL_GST_LAUNCH_ROOT_CONTAINER_ITEM_NAMES, &_inner_error_);
#line 111 "rygel-gst-launch-root-container.c"
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		{
			GeeIterator* _name_it;
#line 44 "rygel-gst-launch-root-container.vala"
			_name_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) item_names);
#line 44 "rygel-gst-launch-root-container.vala"
			while (TRUE) {
#line 121 "rygel-gst-launch-root-container.c"
				char* name;
#line 44 "rygel-gst-launch-root-container.vala"
				if (!gee_iterator_next (_name_it)) {
#line 44 "rygel-gst-launch-root-container.vala"
					break;
#line 127 "rygel-gst-launch-root-container.c"
				}
#line 44 "rygel-gst-launch-root-container.vala"
				name = (char*) gee_iterator_get (_name_it);
#line 45 "rygel-gst-launch-root-container.vala"
				rygel_gst_launch_root_container_add_launch_item (self, name);
#line 133 "rygel-gst-launch-root-container.c"
				_g_free0 (name);
			}
			_g_object_unref0 (_name_it);
		}
		_g_object_unref0 (item_names);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
#line 48 "rygel-gst-launch-root-container.vala"
			g_debug ("rygel-gst-launch-root-container.vala:48: GstLaunch init failed: %s", err->message);
#line 149 "rygel-gst-launch-root-container.c"
			_g_error_free0 (err);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


#line 37 "rygel-gst-launch-root-container.vala"
RygelGstLaunchRootContainer* rygel_gst_launch_root_container_new (const char* title) {
#line 37 "rygel-gst-launch-root-container.vala"
	return rygel_gst_launch_root_container_construct (RYGEL_GST_LAUNCH_TYPE_ROOT_CONTAINER, title);
#line 167 "rygel-gst-launch-root-container.c"
}


#line 52 "rygel-gst-launch-root-container.vala"
static void rygel_gst_launch_root_container_add_launch_item (RygelGstLaunchRootContainer* self, const char* name) {
#line 173 "rygel-gst-launch-root-container.c"
	GError * _inner_error_;
#line 52 "rygel-gst-launch-root-container.vala"
	g_return_if_fail (self != NULL);
#line 52 "rygel-gst-launch-root-container.vala"
	g_return_if_fail (name != NULL);
#line 179 "rygel-gst-launch-root-container.c"
	_inner_error_ = NULL;
	{
		char* _tmp0_;
		char* _tmp1_;
		char* title;
		char* _tmp2_;
		char* _tmp3_;
		char* mime_type;
		char* _tmp4_;
		char* _tmp5_;
		char* launch_line;
		RygelGstLaunchItem* _tmp6_;
#line 54 "rygel-gst-launch-root-container.vala"
		title = (_tmp1_ = rygel_configuration_get_string ((RygelConfiguration*) self->priv->config, RYGEL_GST_LAUNCH_ROOT_CONTAINER_CONFIG_GROUP, _tmp0_ = g_strdup_printf ("%s_title", name), &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
#line 194 "rygel-gst-launch-root-container.c"
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
#line 56 "rygel-gst-launch-root-container.vala"
		mime_type = (_tmp3_ = rygel_configuration_get_string ((RygelConfiguration*) self->priv->config, RYGEL_GST_LAUNCH_ROOT_CONTAINER_CONFIG_GROUP, _tmp2_ = g_strdup_printf ("%s_mime", name), &_inner_error_), _g_free0 (_tmp2_), _tmp3_);
#line 200 "rygel-gst-launch-root-container.c"
		if (_inner_error_ != NULL) {
			_g_free0 (title);
			goto __catch1_g_error;
		}
#line 58 "rygel-gst-launch-root-container.vala"
		launch_line = (_tmp5_ = rygel_configuration_get_string ((RygelConfiguration*) self->priv->config, RYGEL_GST_LAUNCH_ROOT_CONTAINER_CONFIG_GROUP, _tmp4_ = g_strdup_printf ("%s_launch", name), &_inner_error_), _g_free0 (_tmp4_), _tmp5_);
#line 207 "rygel-gst-launch-root-container.c"
		if (_inner_error_ != NULL) {
			_g_free0 (mime_type);
			_g_free0 (title);
			goto __catch1_g_error;
		}
#line 61 "rygel-gst-launch-root-container.vala"
		rygel_simple_container_add_child ((RygelSimpleContainer*) self, (RygelMediaObject*) (_tmp6_ = rygel_gst_launch_item_new (name, (RygelMediaContainer*) self, title, mime_type, launch_line)));
#line 215 "rygel-gst-launch-root-container.c"
		_g_object_unref0 (_tmp6_);
		_g_free0 (launch_line);
		_g_free0 (mime_type);
		_g_free0 (title);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
#line 67 "rygel-gst-launch-root-container.vala"
			g_debug ("rygel-gst-launch-root-container.vala:67: GstLaunch failed item '%s': %" \
"s", name, err->message);
#line 230 "rygel-gst-launch-root-container.c"
			_g_error_free0 (err);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_gst_launch_root_container_class_init (RygelGstLaunchRootContainerClass * klass) {
	rygel_gst_launch_root_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelGstLaunchRootContainerPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_gst_launch_root_container_finalize;
}


static void rygel_gst_launch_root_container_instance_init (RygelGstLaunchRootContainer * self) {
	self->priv = RYGEL_GST_LAUNCH_ROOT_CONTAINER_GET_PRIVATE (self);
}


static void rygel_gst_launch_root_container_finalize (GObject* obj) {
	RygelGstLaunchRootContainer * self;
	self = RYGEL_GST_LAUNCH_ROOT_CONTAINER (obj);
	_g_object_unref0 (self->priv->config);
	G_OBJECT_CLASS (rygel_gst_launch_root_container_parent_class)->finalize (obj);
}


GType rygel_gst_launch_root_container_get_type (void) {
	static volatile gsize rygel_gst_launch_root_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_gst_launch_root_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelGstLaunchRootContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_launch_root_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstLaunchRootContainer), 0, (GInstanceInitFunc) rygel_gst_launch_root_container_instance_init, NULL };
		GType rygel_gst_launch_root_container_type_id;
		rygel_gst_launch_root_container_type_id = g_type_register_static (RYGEL_TYPE_SIMPLE_CONTAINER, "RygelGstLaunchRootContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_gst_launch_root_container_type_id__volatile, rygel_gst_launch_root_container_type_id);
	}
	return rygel_gst_launch_root_container_type_id__volatile;
}




