/* rygel-gst-renderer-time.c generated by valac, the Vala compiler
 * generated from rygel-gst-renderer-time.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdio.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_GST_RENDERER_TYPE_TIME (rygel_gst_renderer_time_get_type ())
#define RYGEL_GST_RENDERER_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_GST_RENDERER_TYPE_TIME, RygelGstRendererTime))
#define RYGEL_GST_RENDERER_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_GST_RENDERER_TYPE_TIME, RygelGstRendererTimeClass))
#define RYGEL_GST_RENDERER_IS_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_GST_RENDERER_TYPE_TIME))
#define RYGEL_GST_RENDERER_IS_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_GST_RENDERER_TYPE_TIME))
#define RYGEL_GST_RENDERER_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_GST_RENDERER_TYPE_TIME, RygelGstRendererTimeClass))

typedef struct _RygelGstRendererTime RygelGstRendererTime;
typedef struct _RygelGstRendererTimeClass RygelGstRendererTimeClass;
typedef struct _RygelGstRendererTimePrivate RygelGstRendererTimePrivate;
typedef struct _RygelGstRendererParamSpecTime RygelGstRendererParamSpecTime;

struct _RygelGstRendererTime {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelGstRendererTimePrivate * priv;
};

struct _RygelGstRendererTimeClass {
	GTypeClass parent_class;
	void (*finalize) (RygelGstRendererTime *self);
};

struct _RygelGstRendererParamSpecTime {
	GParamSpec parent_instance;
};


static gpointer rygel_gst_renderer_time_parent_class = NULL;

gpointer rygel_gst_renderer_time_ref (gpointer instance);
void rygel_gst_renderer_time_unref (gpointer instance);
GParamSpec* rygel_gst_renderer_param_spec_time (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_gst_renderer_value_set_time (GValue* value, gpointer v_object);
void rygel_gst_renderer_value_take_time (GValue* value, gpointer v_object);
gpointer rygel_gst_renderer_value_get_time (const GValue* value);
GType rygel_gst_renderer_time_get_type (void);
enum  {
	RYGEL_GST_RENDERER_TIME_DUMMY_PROPERTY
};
GstClockTime rygel_gst_renderer_time_from_string (const char* str);
char* rygel_gst_renderer_time_to_string (GstClockTime time);
RygelGstRendererTime* rygel_gst_renderer_time_new (void);
RygelGstRendererTime* rygel_gst_renderer_time_construct (GType object_type);
static void rygel_gst_renderer_time_finalize (RygelGstRendererTime* obj);



#line 29 "rygel-gst-renderer-time.vala"
GstClockTime rygel_gst_renderer_time_from_string (const char* str) {
#line 87 "rygel-gst-renderer-time.c"
	GstClockTime result = 0ULL;
	guint64 hours = 0ULL;
	guint64 minutes = 0ULL;
	guint64 seconds = 0ULL;
#line 29 "rygel-gst-renderer-time.vala"
	g_return_val_if_fail (str != NULL, 0ULL);
#line 32 "rygel-gst-renderer-time.vala"
	sscanf (str, "%llu:%2llu:%2llu%*s", &hours, &minutes, &seconds);
#line 96 "rygel-gst-renderer-time.c"
	result = (GstClockTime) ((((hours * 3600) + (minutes * 60)) + seconds) * GST_SECOND);
#line 34 "rygel-gst-renderer-time.vala"
	return result;
#line 100 "rygel-gst-renderer-time.c"
}


#line 38 "rygel-gst-renderer-time.vala"
char* rygel_gst_renderer_time_to_string (GstClockTime time) {
#line 106 "rygel-gst-renderer-time.c"
	char* result = NULL;
	guint64 hours = 0ULL;
	guint64 minutes = 0ULL;
	guint64 seconds = 0ULL;
#line 41 "rygel-gst-renderer-time.vala"
	hours = (guint64) ((time / GST_SECOND) / 3600);
#line 42 "rygel-gst-renderer-time.vala"
	seconds = (guint64) ((time / GST_SECOND) % 3600);
#line 43 "rygel-gst-renderer-time.vala"
	minutes = seconds / 60;
#line 44 "rygel-gst-renderer-time.vala"
	seconds = seconds % 60;
#line 119 "rygel-gst-renderer-time.c"
	result = g_strdup_printf ("%llu:%.2llu:%.2llu", hours, minutes, seconds);
#line 46 "rygel-gst-renderer-time.vala"
	return result;
#line 123 "rygel-gst-renderer-time.c"
}


#line 28 "rygel-gst-renderer-time.vala"
RygelGstRendererTime* rygel_gst_renderer_time_construct (GType object_type) {
#line 129 "rygel-gst-renderer-time.c"
	RygelGstRendererTime* self;
	self = (RygelGstRendererTime*) g_type_create_instance (object_type);
	return self;
}


#line 28 "rygel-gst-renderer-time.vala"
RygelGstRendererTime* rygel_gst_renderer_time_new (void) {
#line 28 "rygel-gst-renderer-time.vala"
	return rygel_gst_renderer_time_construct (RYGEL_GST_RENDERER_TYPE_TIME);
#line 140 "rygel-gst-renderer-time.c"
}


static void rygel_gst_renderer_value_time_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_gst_renderer_value_time_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_gst_renderer_time_unref (value->data[0].v_pointer);
	}
}


static void rygel_gst_renderer_value_time_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_gst_renderer_time_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_gst_renderer_value_time_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_gst_renderer_value_time_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelGstRendererTime* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_gst_renderer_time_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_gst_renderer_value_time_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelGstRendererTime** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_gst_renderer_time_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_gst_renderer_param_spec_time (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelGstRendererParamSpecTime* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_GST_RENDERER_TYPE_TIME), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_gst_renderer_value_get_time (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_GST_RENDERER_TYPE_TIME), NULL);
	return value->data[0].v_pointer;
}


void rygel_gst_renderer_value_set_time (GValue* value, gpointer v_object) {
	RygelGstRendererTime* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_GST_RENDERER_TYPE_TIME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_GST_RENDERER_TYPE_TIME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_gst_renderer_time_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_gst_renderer_time_unref (old);
	}
}


void rygel_gst_renderer_value_take_time (GValue* value, gpointer v_object) {
	RygelGstRendererTime* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_GST_RENDERER_TYPE_TIME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_GST_RENDERER_TYPE_TIME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_gst_renderer_time_unref (old);
	}
}


static void rygel_gst_renderer_time_class_init (RygelGstRendererTimeClass * klass) {
	rygel_gst_renderer_time_parent_class = g_type_class_peek_parent (klass);
	RYGEL_GST_RENDERER_TIME_CLASS (klass)->finalize = rygel_gst_renderer_time_finalize;
}


static void rygel_gst_renderer_time_instance_init (RygelGstRendererTime * self) {
	self->ref_count = 1;
}


static void rygel_gst_renderer_time_finalize (RygelGstRendererTime* obj) {
	RygelGstRendererTime * self;
	self = RYGEL_GST_RENDERER_TIME (obj);
}


GType rygel_gst_renderer_time_get_type (void) {
	static volatile gsize rygel_gst_renderer_time_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_gst_renderer_time_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_gst_renderer_value_time_init, rygel_gst_renderer_value_time_free_value, rygel_gst_renderer_value_time_copy_value, rygel_gst_renderer_value_time_peek_pointer, "p", rygel_gst_renderer_value_time_collect_value, "p", rygel_gst_renderer_value_time_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelGstRendererTimeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_renderer_time_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstRendererTime), 0, (GInstanceInitFunc) rygel_gst_renderer_time_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_gst_renderer_time_type_id;
		rygel_gst_renderer_time_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelGstRendererTime", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_gst_renderer_time_type_id__volatile, rygel_gst_renderer_time_type_id);
	}
	return rygel_gst_renderer_time_type_id__volatile;
}


gpointer rygel_gst_renderer_time_ref (gpointer instance) {
	RygelGstRendererTime* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_gst_renderer_time_unref (gpointer instance) {
	RygelGstRendererTime* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_GST_RENDERER_TIME_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}




